/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.dialogs.saveFiles.ContainerSelectionGroup;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ResourceAndContainerGroup
implements Listener {
    public static final int PROBLEM_NONE = 0;
    public static final int PROBLEM_RESOURCE_EMPTY = 1;
    public static final int PROBLEM_RESOURCE_EXIST = 2;
    public static final int PROBLEM_PATH_INVALID = 4;
    public static final int PROBLEM_CONTAINER_EMPTY = 5;
    public static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
    public static final int PROBLEM_NAME_INVALID = 7;
    public static final int PROBLEM_PATH_OCCUPIED = 8;
    private Listener client;
    private boolean allowExistingResources = false;
    private String resourceType = IDEWorkbenchMessages.ResourceGroup_resource;
    private boolean showClosedProjects = true;
    private String problemMessage = "";
    private int problemType = 0;
    protected ContainerSelectionGroup containerGroup;
    protected Text resourceNameField;
    private String resourceExtension;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType) {
        this(parent, client, resourceFieldLabel, resourceType, true);
    }

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, boolean showClosedProjects) {
        this(parent, client, resourceFieldLabel, resourceType, showClosedProjects, -1);
    }

    public ResourceAndContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, boolean showClosedProjects, int heightHint) {
        this.resourceType = resourceType;
        this.showClosedProjects = showClosedProjects;
        this.createContents(parent, resourceFieldLabel, heightHint);
        this.client = client;
    }

    public boolean areAllValuesValid() {
        return this.problemType == 0;
    }

    protected void createContents(Composite parent, String resourceLabelString, int heightHint) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(font);
        this.containerGroup = heightHint == -1 ? new ContainerSelectionGroup(composite, this, true, null, this.showClosedProjects) : new ContainerSelectionGroup(composite, this, true, null, this.showClosedProjects, heightHint, 250);
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setFont(font);
        Label label = new Label(nameGroup, 0);
        label.setText(resourceLabelString);
        label.setFont(font);
        this.resourceNameField = new Text(nameGroup, 2048);
        this.resourceNameField.addListener(24, (Listener)this);
        this.resourceNameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ResourceAndContainerGroup.this.handleResourceNameFocusLostEvent();
            }
        });
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.resourceNameField.setLayoutData((Object)data);
        this.resourceNameField.setFont(font);
        this.validateControls();
    }

    public IPath getContainerFullPath() {
        return this.containerGroup.getContainerFullPath();
    }

    public String getProblemMessage() {
        return this.problemMessage;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public String getResource() {
        String resource = this.resourceNameField.getText();
        if (this.useResourceExtension()) {
            return resource + "." + this.resourceExtension;
        }
        return resource;
    }

    public String getResourceExtension() {
        return this.resourceExtension;
    }

    private boolean useResourceExtension() {
        String resource = this.resourceNameField.getText();
        return this.resourceExtension != null && this.resourceExtension.length() > 0 && resource.length() > 0 && !resource.endsWith("." + this.resourceExtension);
    }

    private void handleResourceNameFocusLostEvent() {
        if (this.useResourceExtension()) {
            this.setResource(this.resourceNameField.getText() + "." + this.resourceExtension);
        }
    }

    public void handleEvent(Event e) {
        this.validateControls();
        if (this.client != null) {
            this.client.handleEvent(e);
        }
    }

    public void setAllowExistingResources(boolean value) {
        this.allowExistingResources = value;
    }

    public void setContainerFullPath(IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            this.containerGroup.setSelectedContainer((IContainer)initial);
        }
        this.validateControls();
    }

    public void setFocus() {
        this.resourceNameField.setSelection(0, this.resourceNameField.getText().length());
        this.resourceNameField.setFocus();
    }

    public void setResource(String value) {
        this.resourceNameField.setText(value);
        this.validateControls();
    }

    public void setResourceExtension(String value) {
        this.resourceExtension = value;
        this.validateControls();
    }

    protected boolean validateContainer() {
        IPath path = this.containerGroup.getContainerFullPath();
        if (path == null) {
            this.problemType = 5;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_folderEmpty;
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = path.segment(0);
        if (projectName == null || !workspace.getRoot().getProject(projectName).exists()) {
            this.problemType = 6;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_noProject;
            return false;
        }
        IWorkspaceRoot root = workspace.getRoot();
        while (path.segmentCount() > 1) {
            if (root.getFile(path).exists()) {
                this.problemType = 8;
                this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_pathOccupied, (Object)path.makeRelative());
                return false;
            }
            path = path.removeLastSegments(1);
        }
        return true;
    }

    protected boolean validateControls() {
        if (this.containerGroup == null) {
            return false;
        }
        this.problemType = 0;
        this.problemMessage = "";
        if (!this.validateContainer() || !this.validateResourceName()) {
            return false;
        }
        IPath path = this.containerGroup.getContainerFullPath().append(this.getResource());
        return this.validateFullResourcePath(path);
    }

    protected boolean validateFullResourcePath(IPath resourcePath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(resourcePath.toString(), 2);
        if (!result.isOK()) {
            this.problemType = 4;
            this.problemMessage = result.getMessage();
            return false;
        }
        if (!this.allowExistingResources && (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists())) {
            this.problemType = 2;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getResource());
            return false;
        }
        return true;
    }

    protected boolean validateResourceName() {
        String resourceName = this.getResource();
        if (resourceName.length() == 0) {
            this.problemType = 1;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_emptyName, (Object)this.resourceType);
            return false;
        }
        if (!Path.ROOT.isValidPath(resourceName)) {
            this.problemType = 7;
            this.problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_invalidFilename, (Object)resourceName);
            return false;
        }
        return true;
    }

    public void refresh() {
        this.containerGroup.refreshResources();
    }
}

