"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Disposable = exports.MultiDisposeError = void 0;
exports.disposeAll = disposeAll;
class MultiDisposeError extends Error {
    errors;
    constructor(errors) {
        super(`Encountered errors while disposing of store. Errors: [${errors.join(', ')}]`);
        this.errors = errors;
    }
}
exports.MultiDisposeError = MultiDisposeError;
function disposeAll(disposables) {
    const errors = [];
    for (const disposable of disposables) {
        try {
            disposable.dispose();
        }
        catch (e) {
            errors.push(e);
        }
    }
    if (errors.length === 1) {
        throw errors[0];
    }
    else if (errors.length > 1) {
        throw new MultiDisposeError(errors);
    }
}
class Disposable {
    #isDisposed = false;
    _disposables = [];
    dispose() {
        if (this.#isDisposed) {
            return;
        }
        this.#isDisposed = true;
        disposeAll(this._disposables);
    }
    _register(value) {
        if (this.#isDisposed) {
            value.dispose();
        }
        else {
            this._disposables.push(value);
        }
        return value;
    }
    get isDisposed() {
        return this.#isDisposed;
    }
}
exports.Disposable = Disposable;
//# sourceMappingURL=dispose.js.map