/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;

public enum TraceJulLogLevel implements ITraceLogLevel
{
    JUL_OFF("Off"),
    JUL_SEVERE("Severe"),
    JUL_WARNING("Warning"),
    JUL_INFO("Info"),
    JUL_CONFIG("Config"),
    JUL_FINE("Fine"),
    JUL_FINER("Finer"),
    JUL_FINEST("Finest"),
    JUL_ALL("All"),
    LEVEL_UNKNOWN("LEVEL_UNKNOWN");

    private final String fInName;

    private TraceJulLogLevel(String name) {
        this.fInName = name;
    }

    @Override
    public String getInName() {
        return this.fInName;
    }

    public static TraceJulLogLevel valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        TraceJulLogLevel[] traceJulLogLevelArray = TraceJulLogLevel.values();
        int n = traceJulLogLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceJulLogLevel tllevel = traceJulLogLevelArray[n2];
            if (tllevel.name().equals(name) || tllevel.getInName().equals(name)) {
                return tllevel;
            }
            ++n2;
        }
        return LEVEL_UNKNOWN;
    }
}

