/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.text;

import java.util.List;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEventContent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogEventType;
import org.junit.Assert;
import org.junit.Test;

public class TextTraceEventContentTest {
    private static final String[] LABELS = new String[]{"Host", "Logger", "File", "Line", "Message"};
    private TextTraceEventContent fEventContent1 = new TextTraceEventContent(LABELS);
    private TextTraceEventContent fEventContent1Clone;
    private TextTraceEventContent fEventContent2;
    private TextTraceEventContent fEventContent2Clone;

    public TextTraceEventContentTest() {
        this.fEventContent1.setValue((Object)"CONTENT");
        this.fEventContent1.setFieldValue(0, (Object)"HostA");
        this.fEventContent1.setFieldValue(1, (Object)"LoggerA");
        this.fEventContent1.setFieldValue(2, (Object)"SourceFileA");
        this.fEventContent1.setFieldValue(3, (Object)"0");
        this.fEventContent1.setFieldValue(4, (Object)"MessageA");
        this.fEventContent1Clone = new TextTraceEventContent(LABELS);
        this.fEventContent1Clone.setValue((Object)"CONTENT");
        this.fEventContent1Clone.setFieldValue(0, (Object)"HostA");
        this.fEventContent1Clone.setFieldValue(1, (Object)"LoggerA");
        this.fEventContent1Clone.setFieldValue(2, (Object)"SourceFileA");
        this.fEventContent1Clone.setFieldValue(3, (Object)"0");
        this.fEventContent1Clone.setFieldValue(4, (Object)"MessageA");
        this.fEventContent2 = new TextTraceEventContent(LABELS.length);
        this.fEventContent2.setFieldValue(LABELS[0], (Object)"HostB");
        this.fEventContent2.setFieldValue(LABELS[1], (Object)"LoggerB");
        this.fEventContent2.setFieldValue(LABELS[2], (Object)"SourceFileB");
        this.fEventContent2.setFieldValue(LABELS[3], (Object)"2");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Message B");
        this.fEventContent2.setFieldValue(LABELS[4], (Object)buffer);
        this.fEventContent2Clone = new TextTraceEventContent(LABELS);
        this.fEventContent2Clone.setFieldValue(LABELS[0], (Object)"HostB");
        this.fEventContent2Clone.setFieldValue(LABELS[1], (Object)"LoggerB");
        this.fEventContent2Clone.setFieldValue(LABELS[2], (Object)"SourceFileB");
        this.fEventContent2Clone.setFieldValue(LABELS[3], (Object)"2");
        buffer = new StringBuffer();
        buffer.append("Message B");
        this.fEventContent2Clone.setFieldValue(LABELS[4], (Object)buffer);
    }

    public void testConstructorConstructor() {
        Assert.assertEquals((String)"getField:HOST", (Object)"HostA", (Object)this.fEventContent1.getFieldValue(0));
        Assert.assertEquals((String)"getField:LOGGER", (Object)"LoggerA", (Object)this.fEventContent1.getFieldValue(1));
        Assert.assertEquals((String)"getField:FILE", (Object)"SourceFileA", (Object)this.fEventContent1.getFieldValue(2));
        Assert.assertEquals((String)"getField:LINE", (Object)"0", (Object)this.fEventContent1.getFieldValue(3));
        Assert.assertEquals((String)"getField:MESSAGE", (Object)"MessageA", (Object)this.fEventContent1.getFieldValue(4).toString());
    }

    @Test
    public void testEventTypeInstance() {
        SyslogEventType eventType = SyslogEventType.INSTANCE;
        Assert.assertEquals((String)"getTypeId", (Object)"Syslog", (Object)eventType.getName());
        Assert.assertNotNull((String)"instance", (Object)((Object)eventType));
        Assert.assertEquals((String)"getFieldNames", (long)0L, (long)eventType.getFieldNames().size());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((String)"equals", (Object)this.fEventContent1, (Object)this.fEventContent1);
        Assert.assertEquals((String)"equals", (Object)this.fEventContent2, (Object)this.fEventContent2);
        Assert.assertTrue((String)"equals", (!this.fEventContent1.equals((Object)this.fEventContent2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventContent2.equals((Object)this.fEventContent1) ? 1 : 0) != 0);
        Assert.assertEquals((String)"equals", (Object)this.fEventContent1, (Object)this.fEventContent1Clone);
        Assert.assertEquals((String)"equals", (Object)this.fEventContent2, (Object)this.fEventContent2Clone);
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fEventContent1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventContent2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((String)"hashCode", (long)this.fEventContent1.hashCode(), (long)this.fEventContent1Clone.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.fEventContent2.hashCode(), (long)this.fEventContent2Clone.hashCode());
        Assert.assertNotEquals((String)"hashCode", (long)this.fEventContent1.hashCode(), (long)this.fEventContent2.hashCode());
        Assert.assertNotEquals((String)"hashCode", (long)this.fEventContent2.hashCode(), (long)this.fEventContent1.hashCode());
    }

    @Test
    public void testGetFieldValueWithIndex() {
        Assert.assertEquals((String)"getFieldValue:HOST", (Object)"HostA", (Object)this.fEventContent1.getFieldValue(0));
        Assert.assertEquals((String)"getFieldValue:LOGGER", (Object)"LoggerA", (Object)this.fEventContent1.getFieldValue(1));
        Assert.assertEquals((String)"getFieldValue:FILE", (Object)"SourceFileA", (Object)this.fEventContent1.getFieldValue(2));
        Assert.assertEquals((String)"getFieldValue:LINE", (Object)"0", (Object)this.fEventContent1.getFieldValue(3));
        Assert.assertEquals((String)"getFieldValue:MESSAGE", (Object)"MessageA", (Object)this.fEventContent1.getFieldValue(4));
        Assert.assertNull((Object)this.fEventContent1.getFieldValue(5));
    }

    @Test
    public void testGetFieldValueWithName() {
        Assert.assertEquals((String)"getFieldValue:HOST", (Object)"HostA", (Object)this.fEventContent1.getFieldValue("Host"));
        Assert.assertEquals((String)"getFieldValue:LOGGER", (Object)"LoggerA", (Object)this.fEventContent1.getFieldValue("Logger"));
        Assert.assertEquals((String)"getFieldValue:FILE", (Object)"SourceFileA", (Object)this.fEventContent1.getFieldValue("File"));
        Assert.assertEquals((String)"getFieldValue:LINE", (Object)"0", (Object)this.fEventContent1.getFieldValue("Line"));
        Assert.assertEquals((String)"getFieldValue:MESSAGE", (Object)"MessageA", (Object)this.fEventContent1.getFieldValue("Message"));
        Assert.assertNull((Object)this.fEventContent1.getFieldValue("BlaBla"));
    }

    @Test
    public void testGetFieldNameWithIndex() {
        Assert.assertEquals((String)"getFieldName:HOST", (Object)LABELS[0], (Object)this.fEventContent1.getFieldName(0));
        Assert.assertEquals((String)"getFieldName:LOGGER", (Object)LABELS[1], (Object)this.fEventContent1.getFieldName(1));
        Assert.assertEquals((String)"getFieldName:FILE", (Object)LABELS[2], (Object)this.fEventContent1.getFieldName(2));
        Assert.assertEquals((String)"getFieldName:LINE", (Object)LABELS[3], (Object)this.fEventContent1.getFieldName(3));
        Assert.assertEquals((String)"getFieldName:MESSAGE", (Object)LABELS[4], (Object)this.fEventContent1.getFieldName(4));
        Assert.assertNull((Object)this.fEventContent1.getFieldValue(5));
    }

    @Test
    public void testGetFields() {
        List fields = this.fEventContent1.getFields();
        Assert.assertEquals((long)5L, (long)fields.size());
        Assert.assertEquals((String)"getFields:HOST", (Object)LABELS[0], (Object)((TextTraceEventContent)fields.get(0)).getName());
        Assert.assertEquals((String)"getFields:HOST", (Object)"HostA", (Object)((TextTraceEventContent)fields.get(0)).getValue());
        Assert.assertEquals((String)"getFields:LOGGER", (Object)LABELS[1], (Object)((TextTraceEventContent)fields.get(1)).getName());
        Assert.assertEquals((String)"getFields:LOGGER", (Object)"LoggerA", (Object)((TextTraceEventContent)fields.get(1)).getValue());
        Assert.assertEquals((String)"getFields:FILE", (Object)LABELS[2], (Object)((TextTraceEventContent)fields.get(2)).getName());
        Assert.assertEquals((String)"getFields:FILE", (Object)"SourceFileA", (Object)((TextTraceEventContent)fields.get(2)).getValue());
        Assert.assertEquals((String)"getFields:LINE", (Object)LABELS[3], (Object)((TextTraceEventContent)fields.get(3)).getName());
        Assert.assertEquals((String)"getFields:LINE", (Object)"0", (Object)((TextTraceEventContent)fields.get(3)).getValue());
        Assert.assertEquals((String)"getFields:MESSAGE", (Object)LABELS[4], (Object)((TextTraceEventContent)fields.get(4)).getName());
        Assert.assertEquals((String)"getFields:MESSAGE", (Object)"MessageA", (Object)((TextTraceEventContent)fields.get(4)).getValue());
    }

    @Test
    public void testGetFieldWithName() {
        ITmfEventField field = this.fEventContent1.getField(new String[]{LABELS[0]});
        Assert.assertEquals((String)"getFieldName:HOST", (Object)LABELS[0], (Object)field.getName());
        Assert.assertEquals((String)"getFieldName:HOST", (Object)"HostA", (Object)field.getValue());
        field = this.fEventContent1.getField(new String[]{LABELS[1]});
        Assert.assertEquals((String)"getFieldName:LOGGER", (Object)LABELS[1], (Object)field.getName());
        Assert.assertEquals((String)"getFieldName:LOGGER", (Object)"LoggerA", (Object)field.getValue());
        field = this.fEventContent1.getField(new String[]{LABELS[2]});
        Assert.assertEquals((String)"getFieldName:FILE", (Object)LABELS[2], (Object)field.getName());
        Assert.assertEquals((String)"getFieldName:FILE", (Object)"SourceFileA", (Object)field.getValue());
        field = this.fEventContent1.getField(new String[]{LABELS[3]});
        Assert.assertEquals((String)"getFieldName:LINE", (Object)LABELS[3], (Object)field.getName());
        Assert.assertEquals((String)"getFieldName:LINE", (Object)"0", (Object)field.getValue());
        field = this.fEventContent1.getField(new String[]{LABELS[4]});
        Assert.assertEquals((String)"getFieldName:Message", (Object)LABELS[4], (Object)field.getName());
        Assert.assertEquals((String)"getFieldName:Message", (Object)"MessageA", (Object)field.getValue());
        field = this.fEventContent1.getField(new String[]{"BlaBla"});
        Assert.assertNull((Object)field);
    }

    @Test
    public void testGetFieldWithPath() {
        String[] path = new String[]{"Host"};
        ITmfEventField field = this.fEventContent1.getField(path);
        Assert.assertEquals((String)"getFieldPath:HOST", (Object)LABELS[0], (Object)field.getName());
        Assert.assertEquals((String)"getFieldPath:HOST", (Object)"HostA", (Object)field.getValue());
        String[] path2 = new String[]{"Host", "subField"};
        field = this.fEventContent1.getField(path2);
        Assert.assertNull((Object)field);
    }

    @Test
    public void testGetFormattedValue() {
        Assert.assertEquals((Object)"CONTENT", (Object)this.fEventContent1.getFormattedValue());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"Host=HostA, Logger=LoggerA, File=SourceFileA, Line=0, Message=MessageA", (Object)this.fEventContent1.toString());
    }

    @Test
    public void testGetFieldNames() {
        Object[] labels = new String[]{"Host", "Logger", "File", "Line", "Message"};
        List names = this.fEventContent1.getFieldNames();
        Assert.assertArrayEquals((Object[])labels, (Object[])names.toArray(new String[names.size()]));
    }

    private static interface Index {
        public static final int HOST = 0;
        public static final int LOGGER = 1;
        public static final int FILE = 2;
        public static final int LINE = 3;
        public static final int MESSAGE = 4;
    }
}

