/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.tests.experiment.type.TmfEventsEditorStub;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TraceAndExperimentTypeTest {
    public static final String TEST_EXPERIMENT_TYPE = "org.eclipse.linuxtools.tmf.core.tests.experimenttype";
    private List<ITmfTrace> fTraces;
    private TmfProjectElement fixture;
    private TmfExperimentElement fExperiment;
    private static final String EXPERIMENT_NAME = "exp_test";

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
            this.fExperiment = ProjectModelTestData.addExperiment(this.fixture, EXPERIMENT_NAME);
            Assert.assertNotNull((Object)this.fExperiment);
            this.fTraces = new ArrayList<ITmfTrace>();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
        for (ITmfTrace trace : this.fTraces) {
            trace.dispose();
        }
    }

    @Test
    public void testDefaultExperimentType() {
        TmfExperimentElement experimentElement = ProjectModelTestData.addExperiment(this.fixture, "testDefaultExpType");
        Assert.assertNotNull((Object)experimentElement);
        TmfExperiment experiment = experimentElement.instantiateTrace();
        Assert.assertNotNull((Object)experiment);
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.experiment.generic", (Object)experimentElement.getTraceType());
        experiment.dispose();
    }

    @Test
    public void testSelectExperimentTypeWithHint() {
        this.fTraces.add(TmfTestTrace.A_TEST_10K.getTrace());
        this.fTraces.add(TmfTestTrace.A_TEST_10K2.getTrace());
        String expected = "org.eclipse.linuxtools.tmf.core.experiment.generic";
        List types = TmfTraceType.selectExperimentType(this.fTraces, (String)expected);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)expected, (Object)((TraceTypeHelper)types.get(0)).getTraceTypeId());
    }

    @Test
    public void testSelectExperimentTypeWithoutHint() {
        this.fTraces.add(TmfTestTrace.A_TEST_10K.getTrace());
        this.fTraces.add(TmfTestTrace.A_TEST_10K2.getTrace());
        List types = TmfTraceType.selectExperimentType(this.fTraces, null);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)TEST_EXPERIMENT_TYPE, (Object)((TraceTypeHelper)types.get(0)).getTraceTypeId());
    }

    @Test
    public void testSelectExperimentTypeSyslog() {
        this.fTraces.add(TmfTestTrace.SYSLOG_1.getTrace());
        this.fTraces.add(TmfTestTrace.SYSLOG_2.getTrace());
        List types = TmfTraceType.selectExperimentType(this.fTraces, null);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.tests.experimenttype.syslog", (Object)((TraceTypeHelper)types.get(0)).getTraceTypeId());
    }

    @Test
    public void testSelectExperimentTypeMixed() {
        this.fTraces.add(TmfTestTrace.A_TEST_10K.getTrace());
        this.fTraces.add(TmfTestTrace.SYSLOG_1.getTrace());
        List types = TmfTraceType.selectExperimentType(this.fTraces, null);
        Assert.assertEquals((long)2L, (long)types.size());
    }

    @Test
    public void testSelectExperimentTypeUnknown() {
        this.fTraces.add(TmfTestTrace.O_TEST_10K.getTrace());
        this.fTraces.add(TmfTestTrace.R_TEST_10K.getTrace());
        List types = TmfTraceType.selectExperimentType(this.fTraces, null);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testSelectExperimentTypeError() {
        this.fTraces.add(TmfTestTrace.A_TEST_10K.getTrace());
        this.fTraces.add(TmfTestTrace.E_TEST_10K.getTrace());
        List types = TmfTraceType.selectExperimentType(this.fTraces, null);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.experiment.generic", (Object)((TraceTypeHelper)types.get(0)).getTraceTypeId());
    }

    @Test
    public void testExperimentType() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayUntilTraceOpened((TmfCommonProjectElement)this.fExperiment);
        ITmfTrace trace = this.fExperiment.getTrace();
        Assert.assertTrue((boolean)(trace instanceof TmfExperimentStub));
        this.fExperiment.closeEditors();
    }

    @Test
    public void testNoExperimentTypeChildren() {
        TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayUntilTraceOpened((TmfCommonProjectElement)this.fExperiment);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        Assert.assertNotNull((Object)editor);
        Assert.assertTrue((boolean)editor.getClass().equals(TmfEventsEditor.class));
        this.fExperiment.closeEditors();
    }

    @Test
    public void testExperimentTypeChildren() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)this.fExperiment);
        ProjectModelTestData.delayThread(500L);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        Assert.assertNotNull((Object)editor);
        Assert.assertTrue((boolean)editor.getClass().equals(TmfEventsEditorStub.class));
        TmfEventsEditorStub editorStub = (TmfEventsEditorStub)editor;
        TmfEventsTable table = editorStub.getNewEventsTable();
        Assert.assertNotNull((Object)table);
        Assert.assertTrue((boolean)table.getClass().equals(TmfEventsTable.class));
        this.fExperiment.closeEditors();
    }

    @Test
    public void testExperimentTypeAnalysis() {
        IFolder resource = this.fExperiment.getResource();
        try {
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, TEST_EXPERIMENT_TYPE);
            this.fExperiment.refreshTraceType();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        this.fExperiment.getParent().refresh();
        Assert.assertFalse((boolean)this.fExperiment.getAvailableAnalysis().isEmpty());
    }
}

