/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.ctftestsuite;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CtfTestSuiteTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private static final Path BASE_PATH = Paths.get("traces", "ctf-testsuite", "tests", "1.8");
    private static final Path[] IGNORED_TESTS = new Path[]{BASE_PATH.resolve(Paths.get("regression", "metadata", "pass", "sequence-typedef-length")), BASE_PATH.resolve(Paths.get("regression", "stream", "pass", "integer-large-size"))};
    private final String fTracePath;
    private final boolean fExpectSuccess;
    private static final DirectoryStream.Filter<Path> DIR_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) {
            if (!Files.isDirectory(entry, new LinkOption[0])) {
                return false;
            }
            Path[] pathArray = IGNORED_TESTS;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Path ignoredTestPath = pathArray[n2];
                if (entry.equals(ignoredTestPath)) {
                    System.err.println("Skipping test " + entry.toString() + " as requested.");
                    return false;
                }
                ++n2;
            }
            return true;
        }
    };

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getTracePaths() {
        LinkedList<Object[]> dirs = new LinkedList<Object[]>();
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("fuzzing", "metadata", "fail")), false);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("fuzzing", "metadata", "pass")), true);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("fuzzing", "stream", "fail")), false);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("fuzzing", "stream", "pass")), true);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("regression", "metadata", "fail")), false);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("regression", "metadata", "pass")), true);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("regression", "stream", "fail")), false);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("regression", "stream", "pass")), true);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("stress", "metadata", "fail")), false);
        CtfTestSuiteTest.addDirsOneLevelDeepFrom(dirs, BASE_PATH.resolve(Paths.get("stress", "metadata", "pass")), true);
        CtfTestSuiteTest.addDirsFrom(dirs, BASE_PATH.resolve(Paths.get("stress", "stream", "fail")), false);
        CtfTestSuiteTest.addDirsOneLevelDeepFrom(dirs, BASE_PATH.resolve(Paths.get("stress", "stream", "pass")), true);
        return dirs;
    }

    private static void addDirsFrom(List<Object[]> dirs, Path path, boolean expectSuccess) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path, DIR_FILTER);){
                for (Path p : ds) {
                    Object[] array = new Object[]{p.toString(), expectSuccess};
                    dirs.add(array);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addDirsOneLevelDeepFrom(List<Object[]> dirs, Path path, boolean expectSuccess) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path, DIR_FILTER);){
                for (Path p : ds) {
                    CtfTestSuiteTest.addDirsFrom(dirs, p, expectSuccess);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CtfTestSuiteTest(String tracePath, boolean expectSuccess) {
        this.fTracePath = tracePath;
        this.fExpectSuccess = expectSuccess;
    }

    @Test
    public void testTrace() {
        try {
            CTFTrace trace = new CTFTrace(this.fTracePath);
            Throwable throwable = null;
            Object var3_6 = null;
            try (CTFTraceReader reader = new CTFTraceReader(trace);){
                reader.getCurrentEventDef();
                while (reader.advance()) {
                    Assert.assertNotNull((Object)reader.getCurrentEventDef());
                }
                this.checkIfWeShoudlSucceed();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CTFException e) {
            this.checkIfWeShouldFail(e);
        }
        catch (OutOfMemoryError e) {
            this.checkIfWeShouldFail(e);
        }
    }

    private void checkIfWeShoudlSucceed() {
        if (!this.fExpectSuccess) {
            Assert.fail((String)("Trace was expected to fail parsing: " + this.fTracePath));
        }
    }

    private void checkIfWeShouldFail(Throwable e) {
        if (this.fExpectSuccess) {
            Assert.fail((String)("Trace was expected to succeed, but failed parsing: " + this.fTracePath + " (" + e.getMessage() + ")"));
        }
    }
}

