/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.component;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.tests.stubs.component.TmfEventProviderStub;
import org.eclipse.tracecompass.tmf.tests.stubs.component.TmfSyntheticEventProviderStub;
import org.eclipse.tracecompass.tmf.tests.stubs.event.TmfSyntheticEventStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfEventProviderTest {
    private TmfEventProviderStub fEventProvider;
    private TmfSyntheticEventProviderStub fSyntheticEventProvider;

    @Before
    public void setUp() throws IOException {
        this.fEventProvider = new TmfEventProviderStub();
        this.fSyntheticEventProvider = new TmfSyntheticEventProviderStub();
    }

    @After
    public void tearDown() {
        this.fEventProvider.dispose();
        this.fSyntheticEventProvider.dispose();
    }

    @Test
    public void testGetProviders() {
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)2L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfEventProviderStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(TmfSyntheticEventStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
    }

    @Test
    public void testGetPlainEvents() {
        int NB_EVENTS = 1000;
        final Vector requestedEvents = new Vector();
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfEventProviderStub.class);
        TmfEventProvider provider = eventProviders[0];
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        provider.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
            Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
            Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
            Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
            int i = 0;
            while (i < 1000) {
                Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
                ++i;
            }
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testCancelRequests() {
        int NB_EVENTS = 1000;
        int NUMBER_EVENTS_BEFORE_CANCEL_REQ1 = 10;
        int NUMBER_EVENTS_BEFORE_CANCEL_REQ2 = 800;
        final Vector requestedEventsReq1 = new Vector();
        final Vector requestedEventsReq2 = new Vector();
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfEventProviderStub.class);
        TmfEventProvider provider = eventProviders[0];
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request1 = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEventsReq1.add(event);
                if (this.getNbRead() == 10) {
                    this.cancel();
                }
            }
        };
        ((TmfEventProviderStub)provider).startSynch(new TmfStartSynchSignal(0));
        provider.notifyPendingRequest(true);
        provider.sendRequest((ITmfEventRequest)request1);
        Assert.assertFalse((String)"isRunning", (boolean)request1.isRunning());
        TmfEventRequest request2 = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEventsReq2.add(event);
                if (this.getNbRead() == 800) {
                    this.cancel();
                }
            }
        };
        provider.sendRequest((ITmfEventRequest)request2);
        Assert.assertFalse((String)"isRunning", (boolean)request1.isRunning());
        Assert.assertFalse((String)"isRunning", (boolean)request2.isRunning());
        ((TmfEventProviderStub)provider).endSynch(new TmfEndSynchSignal(0));
        Assert.assertFalse((String)"isRunning", (boolean)request1.isRunning());
        Assert.assertFalse((String)"isRunning", (boolean)request2.isRunning());
        provider.notifyPendingRequest(false);
        try {
            request1.waitForStart();
            request2.waitForStart();
            request1.waitForCompletion();
            Assert.assertEquals((String)"nbEvents", (long)10L, (long)requestedEventsReq1.size());
            Assert.assertTrue((String)"isCompleted", (boolean)request1.isCompleted());
            Assert.assertTrue((String)"isCancelled", (boolean)request1.isCancelled());
            request2.waitForCompletion();
            Assert.assertEquals((String)"nbEvents", (long)800L, (long)requestedEventsReq2.size());
            Assert.assertTrue((String)"isCompleted", (boolean)request2.isCompleted());
            Assert.assertTrue((String)"isCancelled", (boolean)request2.isCancelled());
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private static void getSyntheticData(TmfTimeRange range, int nbEvents) throws InterruptedException {
        final Vector requestedEvents = new Vector();
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(TmfSyntheticEventStub.class);
        TmfEventProvider provider = eventProviders[0];
        TmfEventRequest request = new TmfEventRequest(TmfSyntheticEventStub.class, range, 0L, nbEvents, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        provider.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        if (nbEvents != -1) {
            Assert.assertEquals((String)"nbEvents", (long)nbEvents, (long)requestedEvents.size());
        }
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < nbEvents / 2) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(2 * i + 0)).getTimestamp().getValue());
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(2 * i + 1)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testGetSyntheticEvents_EqualBlockSizes() {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        try {
            TmfEventProviderTest.getSyntheticData(range, 1000);
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetSyntheticEvents_TimeRange() {
        ITmfTimestamp start = TmfTimestamp.create((long)1L, (int)-3);
        ITmfTimestamp end = TmfTimestamp.create((long)1000L, (int)-3);
        TmfTimeRange range = new TmfTimeRange(start, end);
        try {
            TmfEventProviderTest.getSyntheticData(range, -1);
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetProviders2() {
        TmfEventProvider[] eventProviders = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)2L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfTraceStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(ITmfEvent.class, TmfEventProviderStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
        eventProviders = TmfProviderManager.getProviders(TmfSyntheticEventStub.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)eventProviders.length);
    }
}

