/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.perf.trace;

import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Test;

public class TraceReadBenchmark {
    private static final String TEST_SUITE_NAME = "CTF Read Benchmark";
    private static final String TEST_ID = "org.eclipse.linuxtools#CTF Read Benchmark";
    private static final int LOOP_COUNT = 100;

    @Test
    public void testKernelTrace() {
        TraceReadBenchmark.readTrace(CtfTestTrace.KERNEL, "trace-kernel", true);
    }

    @Test
    public void testKernelVmTrace() {
        TraceReadBenchmark.readTrace(CtfTestTrace.KERNEL_VM, "trace-kernel-vm", false);
    }

    private static void readTrace(CtfTestTrace testTrace, String testName, boolean inGlobalSummary) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#CTF Read Benchmark#" + testName);
        perf.tagAsSummary(pm, "CTF Read Benchmark:" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "CTF Read Benchmark:" + testName, Dimension.CPU_TIME);
        }
        int loop = 0;
        while (loop < 100) {
            pm.start();
            try {
                CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
                Throwable throwable = null;
                Object var8_10 = null;
                try (CTFTraceReader traceReader = new CTFTraceReader(trace);){
                    while (traceReader.hasMoreEvents()) {
                        IEventDefinition ed = traceReader.getCurrentEventDef();
                        ed.getCPU();
                        traceReader.advance();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CTFException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ':' + e.getMessage()));
            }
            pm.stop();
            ++loop;
        }
        pm.commit();
    }
}

