/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnumDefinitionTest {
    private EnumDefinition fixtureA;
    private EnumDefinition fixtureB;

    @Before
    public void setUp() {
        IntegerDeclaration integerDeclaration = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        EnumDeclaration declaration = new EnumDeclaration(integerDeclaration);
        declaration.add(0L, 10L, "a");
        declaration.add(11L, 20L, "b");
        String fieldName = "";
        this.fixtureA = new EnumDefinition(declaration, null, fieldName, new IntegerDefinition(integerDeclaration, null, fieldName, 4L));
        this.fixtureB = new EnumDefinition(declaration, null, fieldName, new IntegerDefinition(integerDeclaration, null, fieldName, 12L));
    }

    @Test
    public void testEnumDefinition() {
        Assert.assertNotNull((Object)this.fixtureA);
        Assert.assertNotNull((Object)this.fixtureB);
    }

    @Test
    public void testGetValue() {
        String result = this.fixtureA.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"a", (Object)result);
    }

    @Test
    public void testGetIntegerValue_one() {
        long result = this.fixtureA.getIntegerValue();
        Assert.assertEquals((long)4L, (long)result);
    }

    @Test
    public void testToString() {
        String result = this.fixtureB.toString();
        Assert.assertEquals((Object)"{ value = b, container = 12 }", (Object)result);
    }

    @Test
    public void testUnknownEnum() {
        IntegerDeclaration integerDeclaration = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        EnumDeclaration declaration = new EnumDeclaration(integerDeclaration);
        declaration.add(0L, 10L, "a");
        declaration.add(11L, 20L, "b");
        String fieldName = "unknownValue";
        EnumDefinition fixture = new EnumDefinition(declaration, null, fieldName, new IntegerDefinition(integerDeclaration, null, fieldName, 22L));
        Assert.assertEquals((Object)"<unknown> (22)", (Object)fixture.getValue());
        Assert.assertEquals((Object)"{ value = <unknown> (22), container = 22 }", (Object)fixture.toString());
    }
}

