/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.fsm.compile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionSegment;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueTypedWrapper;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TmfXmlActionCuTest {
    private static final @NonNull String ACTION_START = "<action id=\"%s\">";
    private static final @NonNull String ACTION_END = "</action>";
    private static final @NonNull String SEGMENT_TYPE = "<segType>   <segName>        <stateValue type=\"string\" value=\"seg1\"/>   </segName></segType> ";
    private static final @NonNull String SEGMENT_START = "<begin type=\"eventField\" value=\"timestamp\"/>";
    private static final @NonNull String SEGMENT_END = "<end type=\"eventField\" value=\"testField\" />";
    private static final @NonNull String SEGMENT_DURATION = "<duration type=\"eventField\" value=\"testField\" />";
    private static final @NonNull DataDrivenValue SEGMENT_START_VALUE = new DataDrivenValueTypedWrapper((DataDrivenValue)new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "timestamp"), ITmfStateValue.Type.LONG);
    private static final @NonNull DataDrivenValue SEGMENT_TIME_VALUE = new DataDrivenValueTypedWrapper((DataDrivenValue)new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "testField"), ITmfStateValue.Type.LONG);
    private static final @NonNull CompilationResult SEGMENT_TYPE_WITH_END = new CompilationResult(){

        @Override
        public String getName() {
            return "type_and_end";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlActionCuTest.ACTION_START, this.getName())) + "   <segment>" + TmfXmlActionCuTest.SEGMENT_TYPE + "       <segTime>" + TmfXmlActionCuTest.SEGMENT_START + TmfXmlActionCuTest.SEGMENT_END + "</segTime>" + "   </segment>" + TmfXmlActionCuTest.ACTION_END;
        }

        @Override
        public DataDrivenAction getResult() {
            return new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"seg1"), SEGMENT_START_VALUE, null, SEGMENT_TIME_VALUE, Collections.emptyMap());
        }
    };
    private static final @NonNull CompilationResult SEGMENT_TYPE_NO_TIME = new CompilationResult(){

        @Override
        public String getName() {
            return "just_type";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlActionCuTest.ACTION_START, this.getName())) + "   <segment>" + TmfXmlActionCuTest.SEGMENT_TYPE + "</segment>" + TmfXmlActionCuTest.ACTION_END;
        }

        @Override
        public DataDrivenAction getResult() {
            return new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"seg1"), null, null, null, Collections.emptyMap());
        }
    };
    private static final @NonNull CompilationResult SEGMENT_TYPE_WITH_DURATION = new CompilationResult(){

        @Override
        public String getName() {
            return "type_and_duration";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlActionCuTest.ACTION_START, this.getName())) + "   <segment>" + TmfXmlActionCuTest.SEGMENT_TYPE + "       <segTime>" + TmfXmlActionCuTest.SEGMENT_START + TmfXmlActionCuTest.SEGMENT_DURATION + "</segTime>" + "   </segment>" + TmfXmlActionCuTest.ACTION_END;
        }

        @Override
        public DataDrivenAction getResult() {
            return new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"seg1"), SEGMENT_START_VALUE, SEGMENT_TIME_VALUE, null, Collections.emptyMap());
        }
    };
    private static final @NonNull CompilationResult SEGMENT_INLINE_TYPE = new CompilationResult(){

        @Override
        public String getName() {
            return "inline_name";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlActionCuTest.ACTION_START, this.getName())) + "<segment><segType segName=\"seg2\" /></segment>" + TmfXmlActionCuTest.ACTION_END;
        }

        @Override
        public DataDrivenAction getResult() {
            return new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"seg2"), null, null, null, Collections.emptyMap());
        }
    };
    private static final @NonNull CompilationResult SEGMENT_END_AND_DURATION = new CompilationResult(){

        @Override
        public String getName() {
            return "invalid_segment_and_duration";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlActionCuTest.ACTION_START, this.getName())) + "   <segment>" + TmfXmlActionCuTest.SEGMENT_TYPE + "       <segTime>" + TmfXmlActionCuTest.SEGMENT_START + TmfXmlActionCuTest.SEGMENT_DURATION + TmfXmlActionCuTest.SEGMENT_END + "</segTime>" + "   </segment>" + TmfXmlActionCuTest.ACTION_END;
        }

        @Override
        public DataDrivenAction getResult() {
            return null;
        }
    };
    private final CompilationResult fExpected;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({SEGMENT_TYPE_WITH_END}, {SEGMENT_TYPE_NO_TIME}, {SEGMENT_TYPE_WITH_DURATION}, {SEGMENT_INLINE_TYPE}, {SEGMENT_END_AND_DURATION});
    }

    public TmfXmlActionCuTest(CompilationResult expected) {
        this.fExpected = expected;
    }

    @Test
    public void testAction() throws SAXException, IOException, ParserConfigurationException {
        AnalysisCompilationData data = new AnalysisCompilationData();
        Element xmlElement = TmfXmlTestUtils.getXmlElement("action", this.fExpected.getXmlString());
        Assert.assertNotNull((Object)xmlElement);
        TmfXmlActionCu compiledAction = TmfXmlActionCu.compileNamedAction((AnalysisCompilationData)data, (Element)xmlElement);
        if (this.fExpected.getResult() == null) {
            Assert.assertNull((String)("Expected null action" + this.fExpected.getName()), (Object)compiledAction);
        } else {
            Assert.assertNotNull((String)("Expected non null " + this.fExpected.getName()), (Object)compiledAction);
            Assert.assertEquals((String)(String.valueOf(this.fExpected.getName()) + " generated"), (Object)this.fExpected.getResult(), (Object)compiledAction.generate());
        }
    }

    private static abstract class CompilationResult {
        private CompilationResult() {
        }

        public abstract @NonNull String getName();

        public abstract @NonNull String getXmlString();

        public abstract @Nullable DataDrivenAction getResult();

        public String toString() {
            return this.getName();
        }
    }
}

