/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.core.tests;

import com.google.common.collect.Iterables;
import org.eclipse.tracecompass.analysis.counters.core.CounterStateProvider;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CounterStateProviderTest {
    private static final String COUNTER_FILE = "traces/counter_testTrace.xml";
    private TmfXmlTraceStubNs fTrace;
    private ITmfStateSystemBuilder fSsb;
    private CounterStateProvider fStateProvider;

    @Before
    public void setup() throws TmfTraceException {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        trace.initTrace(null, COUNTER_FILE, ITmfEvent.class);
        trace.addEventAspect((ITmfEventAspect)new TmfContentFieldAspect("aspect", new String[0]));
        trace.addEventAspect((ITmfEventAspect)new CounterAspect("counter", "counter", new Class[0]));
        trace.addEventAspect((ITmfEventAspect)new CounterAspect("counter", "counter", new Class[]{TmfCpuAspect.class}));
        trace.addEventAspect((ITmfEventAspect)new CounterAspect("counter", "counter", new Class[]{TmfCpuAspect.class}){

            public boolean isCumulative() {
                return true;
            }
        });
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)trace.getEventAspects()));
        this.fStateProvider = CounterStateProvider.create((ITmfTrace)trace);
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"CounterStateSystem", (long)0L);
        this.fSsb = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        this.fStateProvider.assignTargetStateSystem(this.fSsb);
        this.fTrace = trace;
    }

    @After
    public void teardown() {
        this.fTrace.dispose();
        this.fStateProvider.dispose();
    }

    @Test
    public void testGetNewInstance() {
        ITmfStateProvider clone = this.fStateProvider.getNewInstance();
        Assert.assertNotSame((String)"The original CounterStateProvider and its clone do not share the same reference.", (Object)this.fStateProvider, (Object)clone);
        Assert.assertEquals((long)this.fStateProvider.getVersion(), (long)clone.getVersion());
        Assert.assertEquals((Object)this.fStateProvider.getTrace(), (Object)clone.getTrace());
    }

    @Test
    public void testEventHandle() {
        ITmfEvent event;
        ITmfContext ctx = this.fTrace.seekEvent(0L);
        while ((event = this.fTrace.getNext(ctx)) != null) {
            this.fStateProvider.processEvent(event);
        }
        this.fStateProvider.waitForEmptyQueue();
        ITmfStateSystem ss = this.fStateProvider.getAssignedStateSystem();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((long)8L, (long)ss.getNbAttributes());
        Assert.assertEquals((Object)"Ungrouped", (Object)ss.getAttributeName(0));
        Assert.assertEquals((Object)"counter", (Object)ss.getAttributeName(1));
        Assert.assertEquals((Object)"Grouped", (Object)ss.getAttributeName(2));
        Assert.assertEquals((Object)"CPU", (Object)ss.getAttributeName(3));
        Assert.assertEquals((Object)"0", (Object)ss.getAttributeName(4));
        Assert.assertEquals((Object)"counter", (Object)ss.getAttributeName(5));
        Assert.assertEquals((Object)"1", (Object)ss.getAttributeName(6));
        Assert.assertEquals((Object)"counter", (Object)ss.getAttributeName(7));
    }
}

