/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ProcessStatusInterval;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack.CallStackHostUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class CallStack {
    private static final String CALLSTACK_DEPTH = "CallStack depth ";
    private static final String IS_TOO_LARGE = " is too large";
    private final @Nullable ICallStackElement fSymbolKeyElement;
    private final @Nullable CallStackSeries.IThreadIdProvider fThreadIdProvider;
    private final ITmfStateSystem fStateSystem;
    private final List<Integer> fQuarks;
    private final CallStackHostUtils.IHostIdProvider fHostProvider;

    public CallStack(ITmfStateSystem ss, List<Integer> quarks, ICallStackElement element, CallStackHostUtils.IHostIdProvider hostIdProvider, @Nullable CallStackSeries.IThreadIdProvider threadIdProvider) {
        this.fSymbolKeyElement = element;
        this.fThreadIdProvider = threadIdProvider;
        this.fStateSystem = ss;
        this.fQuarks = quarks;
        this.fHostProvider = hostIdProvider;
    }

    public int getMaxDepth() {
        return this.fQuarks.size();
    }

    public List<ICalledFunction> getCallListAtDepth(int depth, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (depth > this.getMaxDepth()) {
            throw new ArrayIndexOutOfBoundsException(CALLSTACK_DEPTH + depth + IS_TOO_LARGE);
        }
        try {
            Integer quark = this.fQuarks.get(depth - 1);
            long start = Math.max(this.fStateSystem.getStartTime(), startTime - 1L);
            long end = Math.min(this.fStateSystem.getCurrentEndTime(), endTime);
            if (start > end) {
                return Collections.emptyList();
            }
            List stackIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)this.fStateSystem, (int)quark, (long)start, (long)end, (long)resolution, (IProgressMonitor)monitor);
            ArrayList<ICalledFunction> callList = new ArrayList<ICalledFunction>(stackIntervals.size());
            for (ITmfStateInterval callInterval : stackIntervals) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (callInterval.getStateValue().isNull()) continue;
                int threadId = this.getThreadId(callInterval.getStartTime());
                callList.add(CalledFunctionFactory.create(callInterval.getStartTime(), callInterval.getEndTime() + 1L, callInterval.getValue(), this.getSymbolKeyAt(callInterval.getStartTime()), threadId, null, ModelManager.getModelFor(this.getHostId(callInterval.getStartTime()))));
            }
            return callList;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            return Collections.emptyList();
        }
    }

    public Integer getQuarkAtDepth(int depth) {
        return this.fQuarks.get(depth - 1);
    }

    private String getHostId(long time) {
        return (String)this.fHostProvider.apply(time);
    }

    public @Nullable ICalledFunction getNextFunction(long time, int depth) {
        if (depth > this.getMaxDepth()) {
            throw new ArrayIndexOutOfBoundsException(CALLSTACK_DEPTH + depth + IS_TOO_LARGE);
        }
        if (time > this.fStateSystem.getCurrentEndTime()) {
            return null;
        }
        try {
            ITmfStateInterval interval = this.fStateSystem.querySingleState(time, this.fQuarks.get(depth - 1).intValue());
            while ((interval.getStateValue().isNull() || interval.getStartTime() < time) && interval.getEndTime() + 1L < this.fStateSystem.getCurrentEndTime()) {
                interval = this.fStateSystem.querySingleState(interval.getEndTime() + 1L, this.fQuarks.get(depth - 1).intValue());
            }
            if (!interval.getStateValue().isNull() && interval.getStartTime() >= time) {
                return CalledFunctionFactory.create(interval.getStartTime(), interval.getEndTime() + 1L, interval.getValue(), this.getSymbolKeyAt(interval.getStartTime()), this.getThreadId(interval.getStartTime()), null, ModelManager.getModelFor(this.getHostId(time)));
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    public @Nullable ICalledFunction getNextFunction(long time, int depth, @Nullable ICalledFunction parent, IHostModel model, long start, long end) {
        long endTime;
        if (depth > this.getMaxDepth()) {
            throw new ArrayIndexOutOfBoundsException(CALLSTACK_DEPTH + depth + IS_TOO_LARGE);
        }
        long l = endTime = parent == null ? this.fStateSystem.getCurrentEndTime() : parent.getEnd();
        if (time > endTime || time >= end) {
            return null;
        }
        try {
            ITmfStateInterval interval = this.fStateSystem.querySingleState(time, this.fQuarks.get(depth - 1).intValue());
            while ((interval.getStateValue().isNull() || interval.getEndTime() < start) && interval.getEndTime() + 1L < endTime) {
                interval = this.fStateSystem.querySingleState(interval.getEndTime() + 1L, this.fQuarks.get(depth - 1).intValue());
            }
            if (!interval.getStateValue().isNull() && interval.getStartTime() < end) {
                return CalledFunctionFactory.create(Math.max(start, interval.getStartTime()), Math.min(end, interval.getEndTime() + 1L), interval.getValue(), this.getSymbolKeyAt(interval.getStartTime()), this.getThreadId(interval.getStartTime()), parent, model);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    public @Nullable ITmfStateInterval getNextDepth(long time, boolean forward) {
        Integer oneQuark = this.fQuarks.get(0);
        int parent = this.fStateSystem.getParentAttributeQuark(oneQuark.intValue());
        long queryTime = Long.max(this.fStateSystem.getStartTime(), Long.min(time, this.fStateSystem.getCurrentEndTime()));
        try {
            ITmfStateInterval currentDepth = this.fStateSystem.querySingleState(queryTime, parent);
            ITmfStateInterval interval = null;
            if (forward && currentDepth.getEndTime() + 1L <= this.fStateSystem.getCurrentEndTime()) {
                interval = this.fStateSystem.querySingleState(currentDepth.getEndTime() + 1L, parent);
            } else if (!forward && currentDepth.getStartTime() - 1L >= this.fStateSystem.getStartTime()) {
                interval = this.fStateSystem.querySingleState(currentDepth.getStartTime() - 1L, parent);
            }
            if (interval != null) {
                return interval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    public int getCurrentDepth(long time) {
        Object value;
        block4: {
            if (time < this.fStateSystem.getStartTime() || time > this.fStateSystem.getCurrentEndTime()) {
                return 0;
            }
            Integer oneQuark = this.fQuarks.get(0);
            int parent = this.fStateSystem.getParentAttributeQuark(oneQuark.intValue());
            try {
                ITmfStateInterval currentDepth = this.fStateSystem.querySingleState(time, parent);
                value = currentDepth.getValue();
                if (value instanceof Integer) break block4;
                return 0;
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                return 0;
            }
        }
        return (Integer)value;
    }

    public void iterateOverCallStack(long startTime, long endTime, Consumer<ICalledFunction> consumer) {
    }

    public int getSymbolKeyAt(long time) {
        if (this.fSymbolKeyElement != null) {
            return this.fSymbolKeyElement.getSymbolKeyAt(time);
        }
        return -1;
    }

    public void updateAttributes(List<Integer> subAttributes) {
        this.fQuarks.addAll(this.fQuarks.size(), subAttributes.subList(this.fQuarks.size(), subAttributes.size()));
    }

    public int getThreadId(long time) {
        if (this.fThreadIdProvider != null) {
            return this.fThreadIdProvider.getThreadId(time);
        }
        return -1;
    }

    public @Nullable HostThread getHostThread(long time) {
        int tid = this.getThreadId(time);
        if (tid < 0) {
            return null;
        }
        return new HostThread(this.getHostId(time), Integer.valueOf(tid));
    }

    public @Nullable HostThread getHostThread() {
        if (!this.isTidVariable()) {
            return this.getHostThread(this.fStateSystem.getStartTime());
        }
        return null;
    }

    public boolean isTidVariable() {
        if (this.fThreadIdProvider != null) {
            return this.fThreadIdProvider.variesInTime();
        }
        return false;
    }

    public long getStartTime() {
        return this.fStateSystem.getStartTime();
    }

    public long getEndTime() {
        return this.fStateSystem.getCurrentEndTime();
    }

    public @Nullable Object getExtraAttribute(String name, long time) {
        if (time < this.getStartTime() || time > this.getEndTime()) {
            return null;
        }
        int parentQuark = this.fStateSystem.getParentAttributeQuark(this.fQuarks.get(0).intValue());
        if (parentQuark < 0) {
            return null;
        }
        if ((parentQuark = this.fStateSystem.getParentAttributeQuark(parentQuark)) < 0) {
            return null;
        }
        try {
            int quark = this.fStateSystem.optQuarkRelative(parentQuark, new String[]{name});
            if (quark != -2) {
                ITmfStateInterval state = this.fStateSystem.querySingleState(time, quark);
                switch (state.getStateValue().getType()) {
                    case INTEGER: {
                        return state.getStateValue().unboxInt();
                    }
                    case LONG: {
                        return state.getStateValue().unboxLong();
                    }
                    case STRING: {
                        return state.getStateValue().unboxStr();
                    }
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasKernelStatuses() {
        IHostModel model = ModelManager.getModelFor(this.getHostId(this.getEndTime()));
        return model.isThreadStatusAvailable();
    }

    public Iterable<ProcessStatusInterval> getKernelStatuses(ICalledFunction function, Collection<Long> times) {
        IHostModel model = ModelManager.getModelFor(this.getHostId(function.getStart()));
        int resolution = 1;
        if (!times.isEmpty()) {
            ArrayList<Long> filtered = new ArrayList<Long>();
            for (Long time : times) {
                if (!function.intersects(time)) continue;
                filtered.add(time);
            }
            Collections.sort(filtered);
            resolution = !filtered.isEmpty() ? (int)((Long)filtered.get(filtered.size() - 1) - (Long)filtered.get(0) / (long)filtered.size()) : resolution;
            return model.getThreadStatusIntervals(function.getThreadId(), function.getStart(), function.getEnd(), resolution);
        }
        return model.getThreadStatusIntervals(function.getThreadId(), function.getStart(), function.getEnd(), resolution);
    }

    public ICalledFunction getFunctionFromInterval(ITmfStateInterval callInterval) {
        int threadId = this.getThreadId(callInterval.getStartTime());
        return CalledFunctionFactory.create(callInterval.getStartTime(), callInterval.getEndTime() + 1L, callInterval.getValue(), this.getSymbolKeyAt(callInterval.getStartTime()), threadId, null, ModelManager.getModelFor(this.getHostId(callInterval.getStartTime())));
    }

    public int hashCode() {
        return Objects.hash(this.fSymbolKeyElement, this.fThreadIdProvider, this.fStateSystem, this.fQuarks, this.fHostProvider);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CallStack)) {
            return false;
        }
        CallStack other = (CallStack)obj;
        return Objects.equals(this.fSymbolKeyElement, other.fSymbolKeyElement) && Objects.equals(this.fThreadIdProvider, other.fThreadIdProvider) && Objects.equals(this.fStateSystem, other.fStateSystem) && Objects.equals(this.fQuarks, other.fQuarks) && Objects.equals(this.fHostProvider, other.fHostProvider);
    }

    public String toString() {
        return "Callstack for quarks " + String.valueOf(this.fQuarks);
    }
}

