/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.util;

public final class EthertypeHelper {
    public static final int ETHERTYPE_IPV4 = 2048;
    public static final int ETHERTYPE_ARP = 2054;
    public static final int ETHERTYPE_WAKE_ON_LAN = 2114;
    public static final int ETHERTYPE_TRILL = 8947;
    public static final int ETHERTYPE_DECNET_PHASE_IV = 24579;

    private EthertypeHelper() {
    }

    public static String toString(int ethertype) {
        switch (ethertype) {
            case 2048: {
                return "Internet Protocol Version 4";
            }
            case 2054: {
                return "Address Resolution Protocol";
            }
            case 2114: {
                return "Wake-on-LAN";
            }
            case 8947: {
                return "IETF TRILL Protocol";
            }
            case 24579: {
                return "DECnet Phase IV";
            }
        }
        return "Unknown";
    }

    public static String toEtherType(int type) {
        return EthertypeHelper.toString(type) + " (0x" + String.format("%04x", type) + ")";
    }
}

