/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToShortFunction;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.ShortIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectByteToShortIterable
        extends AbstractLazyShortIterable
{
    private final ByteIterable iterable;
    private final ByteToShortFunction function;

    public CollectByteToShortIterable(ByteIterable iterable, ByteToShortFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final ShortProcedure procedure)
    {
        this.iterable.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                procedure.value(CollectByteToShortIterable.this.function.valueOf(each));
            }
        });
    }

    public ShortIterator shortIterator()
    {
        return new ShortIterator()
        {
            private final ByteIterator iterator = CollectByteToShortIterable.this.iterable.byteIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public short next()
            {
                return CollectByteToShortIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
