/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.manifest.internal.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestChangeListener;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportBundle;
import org.eclipse.virgo.util.osgi.manifest.ImportLibrary;
import org.eclipse.virgo.util.osgi.manifest.ImportPackage;
import org.eclipse.virgo.util.osgi.manifest.RequireBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleManifestDiffer {
    BundleManifestDiffer() {
    }

    static Set<IBundleManifestChangeListener.Type> diff(BundleManifest bundleManifest1, BundleManifest bundleManifest2) {
        if (bundleManifest1 == null && bundleManifest2 == null) {
            return Collections.emptySet();
        }
        if (bundleManifest1 == null && bundleManifest2 != null || bundleManifest1 != null && bundleManifest2 == null) {
            return BundleManifestManager.IMPORTS_CHANGED;
        }
        ImportPackage importPackageHeader1 = bundleManifest1.getImportPackage();
        ImportPackage importPackageHeader2 = bundleManifest2.getImportPackage();
        ExportPackage exportPackageHeader1 = bundleManifest1.getExportPackage();
        ExportPackage exportPackageHeader2 = bundleManifest2.getExportPackage();
        ImportLibrary importLibraryHeader1 = bundleManifest1.getImportLibrary();
        ImportLibrary importLibraryHeader2 = bundleManifest2.getImportLibrary();
        ImportBundle importBundleHeader1 = bundleManifest1.getImportBundle();
        ImportBundle importBundleHeader2 = bundleManifest2.getImportBundle();
        RequireBundle requireBundleHeader1 = bundleManifest1.getRequireBundle();
        RequireBundle requireBundleHeader2 = bundleManifest2.getRequireBundle();
        String execEnvironment1 = (String)bundleManifest1.toDictionary().get("Bundle-RequiredExecutionEnvironment");
        String execEnvironment2 = (String)bundleManifest2.toDictionary().get("Bundle-RequiredExecutionEnvironment");
        HashSet<IBundleManifestChangeListener.Type> differences = new HashSet<IBundleManifestChangeListener.Type>();
        if (!ObjectUtils.equals((Object)importPackageHeader1.getImportedPackages(), (Object)importPackageHeader2.getImportedPackages())) {
            differences.add(IBundleManifestChangeListener.Type.IMPORT_PACKAGE);
        }
        if (!ObjectUtils.equals((Object)execEnvironment1, (Object)execEnvironment2)) {
            differences.add(IBundleManifestChangeListener.Type.IMPORT_PACKAGE);
        }
        if (!ObjectUtils.equals((Object)exportPackageHeader1.getExportedPackages(), (Object)exportPackageHeader2.getExportedPackages())) {
            differences.add(IBundleManifestChangeListener.Type.EXPORT_PACKAGE);
        }
        if (!ObjectUtils.equals((Object)importLibraryHeader1.getImportedLibraries(), (Object)importLibraryHeader2.getImportedLibraries())) {
            differences.add(IBundleManifestChangeListener.Type.IMPORT_LIBRARY);
        }
        if (!ObjectUtils.equals((Object)importBundleHeader1.getImportedBundles(), (Object)importBundleHeader2.getImportedBundles())) {
            differences.add(IBundleManifestChangeListener.Type.IMPORT_BUNDLE);
        }
        if (!ObjectUtils.equals((Object)requireBundleHeader1.getRequiredBundles(), (Object)requireBundleHeader2.getRequiredBundles())) {
            differences.add(IBundleManifestChangeListener.Type.REQUIRE_BUNDLE);
        }
        return differences;
    }
}

