/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.pde.core.internal.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.virgo.ide.facet.core.AbstractOperation;
import org.eclipse.virgo.ide.pde.core.internal.Helper;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class SetupProjectOperation
extends AbstractOperation
implements IWorkspaceRunnable {
    private static final String WST_FACET_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String WEB_CONTENT_FOLDER = "WebContent";
    private static final String WEB_INF_FOLDER = "WEB-INF";
    private static final String BIN_WEB_INF_CLASSES = "bin/WEB-INF/classes";
    private static final String SRC = "src";
    private static final String BIN = "bin";
    private static final String WEB_XML = "web.xml";
    private static final String INDEX_HTML = "index.html";
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String CLASS_PATH_VALUE = ".,WEB-INF/classes";
    private static final String SLASH = "/";
    private static final String HEADER_BUNDLE_CLASS_PATH = "Bundle-ClassPath";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private final IProject project;
    private final String contextRoot;
    private final IBundleProjectService service;

    public SetupProjectOperation(IProject project, String contextRoot, IBundleProjectService service) {
        Assert.isNotNull((Object)project, (String)"project cannot be null");
        Assert.isNotNull((Object)service, (String)"service cannot be null");
        this.project = project;
        this.contextRoot = this.sanitizeContextRoot(contextRoot);
        this.service = service;
    }

    private String sanitizeContextRoot(String contextRoot2) {
        if (contextRoot2 != null && contextRoot2.startsWith(SLASH)) {
            contextRoot2 = contextRoot2.substring(1);
        }
        return contextRoot2;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 4);
        Helper.forcePDEEditor(this.project);
        monitor.worked(1);
        this.addNatures(this.project);
        monitor.worked(1);
        if (this.contextRoot != null && this.contextRoot.length() > 0) {
            IPath webContentPath = this.configureWABClasspath(this.project);
            IPath WebXMLPath = webContentPath.append(WEB_INF_FOLDER);
            this.createWebXML(this.contextRoot, WebXMLPath);
            this.createIndexHTML(this.contextRoot, webContentPath);
            this.createBuildProperties();
            IBundleProjectDescription bundleDescription = this.service.getDescription(this.project);
            bundleDescription.setHeader(HEADER_WEB_CONTEXT_PATH, SLASH + this.contextRoot);
            bundleDescription.setHeader(HEADER_BUNDLE_CLASS_PATH, CLASS_PATH_VALUE);
            bundleDescription.apply(null);
        }
        monitor.worked(1);
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)this.project.getProject(), (boolean)true, null);
        fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.bundle").getDefaultVersion(), null, null);
        monitor.worked(1);
        monitor.done();
    }

    private void createBuildProperties() throws CoreException {
        String template = this.readResourceFromClassPath(BUILD_PROPERTIES, ISO_8859_1);
        IFile file = this.project.getFile(BUILD_PROPERTIES);
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(template.getBytes(ISO_8859_1)), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(template.getBytes(ISO_8859_1)), true, false, null);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", e.getMessage(), (Throwable)e));
        }
    }

    private void createIndexHTML(String contextRoot, IPath webContentPath) throws CoreException {
        this.createFileFromTemplate(contextRoot, webContentPath, INDEX_HTML, UTF_8);
    }

    private void createWebXML(String contextRoot, IPath webContentPath) throws CoreException {
        this.createFileFromTemplate(contextRoot, webContentPath, WEB_XML, UTF_8);
    }

    private void createFileFromTemplate(String contextRoot, IPath webContentPath, String fileNane, String charset) throws CoreException {
        IFolder webContentFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(webContentPath);
        ArrayList<IFolder> toBeCreated = new ArrayList<IFolder>();
        IFolder tmp = webContentFolder;
        while (!tmp.exists()) {
            toBeCreated.add(0, tmp);
            if (!(tmp.getParent() instanceof IFolder)) break;
            tmp = (IFolder)tmp.getParent();
        }
        for (IFolder iFolder : toBeCreated) {
            iFolder.create(true, false, null);
        }
        IFile file = webContentFolder.getFile(fileNane);
        if (!file.exists()) {
            String template = this.readResourceFromClassPath(fileNane, charset);
            String newWab = MessageFormat.format(template, contextRoot);
            try {
                file.create((InputStream)new ByteArrayInputStream(newWab.getBytes(charset)), true, null);
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.pde.core", e.getMessage(), (Throwable)e));
            }
        }
    }

    private IPath configureWABClasspath(IProject project) throws CoreException, JavaModelException {
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        javaProject.setOutputLocation(project.getFullPath().append(BIN), null);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry iClasspathEntry = entries[i];
            if (iClasspathEntry.getEntryKind() == 3 && iClasspathEntry.getPath().lastSegment().equals(SRC)) {
                IClasspathEntry newEntry;
                newEntries[i] = newEntry = JavaCore.newSourceEntry((IPath)iClasspathEntry.getPath(), (IPath[])iClasspathEntry.getInclusionPatterns(), (IPath[])iClasspathEntry.getExclusionPatterns(), (IPath)project.getFullPath().append(BIN_WEB_INF_CLASSES));
                break;
            }
            newEntries[i] = entries[i];
            ++i;
        }
        IPath webContentPath = project.getFullPath().append(WEB_CONTENT_FOLDER);
        newEntries[entries.length] = JavaCore.newLibraryEntry((IPath)webContentPath, null, null);
        javaProject.setRawClasspath(newEntries, null);
        return webContentPath;
    }

    private IProjectDescription addNatures(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 3];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length + 0] = WST_FACET_NATURE;
        newNatures[natures.length + 1] = "org.eclipse.virgo.ide.facet.core.bundlenature";
        newNatures[natures.length + 2] = "org.eclipse.virgo.ide.pde.core.nature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        return description;
    }
}

