/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.DeploymentOptions;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactTreeFactory;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactTreeInclosure;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.common.Tree;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardInstallArtifactTreeInclosure
implements InstallArtifactTreeInclosure {
    private final Logger logger;
    private final EventLogger eventLogger;
    private final BundleContext bundleContext;
    private final Repository repository;
    private final ArtifactStorageFactory artifactStorageFactory;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public StandardInstallArtifactTreeInclosure(@NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull BundleContext bundleContext, @NonNull Repository repository, @NonNull EventLogger eventLogger, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer) {
        ArtifactIdentityDeterminer artifactIdentityDeterminer2 = artifactIdentityDeterminer;
        EventLogger eventLogger2 = eventLogger;
        Repository repository2 = repository;
        BundleContext bundleContext2 = bundleContext;
        ArtifactStorageFactory artifactStorageFactory2 = artifactStorageFactory;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactStorageFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)repository2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)eventLogger2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)artifactIdentityDeterminer2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.repository = repository;
            this.artifactStorageFactory = artifactStorageFactory;
            this.eventLogger = eventLogger;
            this.bundleContext = bundleContext;
            this.artifactIdentityDeterminer = artifactIdentityDeterminer;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Tree<InstallArtifact> createInstallTree(ArtifactSpecification specification) throws DeploymentException {
        try {
            try {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Tree<InstallArtifact> tree = this.createInstallTree(specification, null);
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return tree;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Tree<InstallArtifact> createInstallTree(ArtifactSpecification specification, String scopeName) throws DeploymentException {
        try {
            try {
                Tree<InstallArtifact> installArtifactTree;
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                String type = specification.getType();
                String name = specification.getName();
                VersionRange versionRange = specification.getVersionRange();
                RepositoryAwareArtifactDescriptor artifactDescriptor = this.repository.get(type, name, versionRange);
                if (artifactDescriptor == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.ARTIFACT_NOT_FOUND, new Object[]{type, name, versionRange, this.repository.getName()});
                    throw new DeploymentException(String.valueOf(type) + " '" + name + "' version '" + versionRange + "' not found");
                }
                URI artifactURI = artifactDescriptor.getUri();
                ArtifactIdentity identity = new ArtifactIdentity(type, name, artifactDescriptor.getVersion(), scopeName);
                identity = ArtifactIdentityScoper.scopeArtifactIdentity(identity);
                ArtifactStorage artifactStorage = this.artifactStorageFactory.create(new File(artifactURI), identity);
                Tree<InstallArtifact> tree = installArtifactTree = this.constructInstallArtifactTree(identity, specification.getProperties(), artifactStorage, artifactDescriptor.getRepositoryName());
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return tree;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Tree<InstallArtifact> createInstallTree(File sourceFile) throws DeploymentException {
        try {
            try {
                Tree<InstallArtifact> tree;
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                if (!sourceFile.exists()) {
                    throw new DeploymentException(sourceFile + " does not exist");
                }
                ArtifactStorage artifactStorage = null;
                try {
                    Tree<InstallArtifact> installArtifactTree;
                    ArtifactIdentity artifactIdentity = this.determineIdentity(sourceFile);
                    artifactStorage = this.artifactStorageFactory.create(sourceFile, artifactIdentity);
                    tree = installArtifactTree = this.constructInstallArtifactTree(artifactIdentity, null, artifactStorage, null);
                }
                catch (DeploymentException e) {
                    if (artifactStorage != null) {
                        artifactStorage.delete();
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException(e.getMessage(), e);
                }
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return tree;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentity(File file) throws DeploymentException {
        try {
            try {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(file, null);
                if (artifactIdentity == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.INDETERMINATE_ARTIFACT_TYPE, new Object[]{file});
                    throw new DeploymentException("Cannot determine the artifact identity of the file '" + file + "'");
                }
                ArtifactIdentity artifactIdentity2 = artifactIdentity;
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return artifactIdentity2;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Tree<InstallArtifact> constructInstallArtifactTree(ArtifactIdentity identity, Map<String, String> deploymentProperties, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        try {
            try {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                Tree<InstallArtifact> tree = null;
                List iatfHolders = OsgiFrameworkUtils.getServices((BundleContext)this.bundleContext, InstallArtifactTreeFactory.class);
                for (OsgiServiceHolder iatfHolder : iatfHolders) {
                    InstallArtifactTreeFactory iatf = (InstallArtifactTreeFactory)iatfHolder.getService();
                    try {
                        if (iatf == null || (tree = iatf.constructInstallArtifactTree(identity, artifactStorage, deploymentProperties, repositoryName)) == null) continue;
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(iatfHolder.getServiceReference());
                    }
                }
                if (tree == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.MISSING_ARTIFACT_FACTORY, new Object[]{identity.getType(), identity.getName(), identity.getVersion()});
                    throw new DeploymentException("Cannot create InstallArtifact for '" + identity + "'");
                }
                Tree<InstallArtifact> tree2 = tree;
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return tree2;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Tree<InstallArtifact> recoverInstallTree(File sourceFile, DeploymentOptions deploymentOptions) {
        try {
            try {
                Tree<InstallArtifact> tree;
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
                ArtifactStorage artifactStorage = null;
                if (deploymentOptions.getRecoverable() && (!deploymentOptions.getDeployerOwned() || sourceFile.exists())) {
                    try {
                        Tree<InstallArtifact> installArtifactTree;
                        ArtifactIdentity artifactIdentity = this.determineIdentity(sourceFile);
                        artifactStorage = this.artifactStorageFactory.create(sourceFile, artifactIdentity);
                        tree = installArtifactTree = this.constructInstallArtifactTree(artifactIdentity, null, artifactStorage, null);
                    }
                    catch (RuntimeException e) {
                        if (artifactStorage != null) {
                            artifactStorage.delete();
                        }
                        this.logger.error(String.format("An error occurred during recovery of artefact '%s'", sourceFile), (Throwable)e);
                        throw e;
                    }
                    catch (DeploymentException e) {
                        artifactStorage.delete();
                        this.logger.warn(String.format("An error occurred during recovery of artefact '%s'", sourceFile), (Throwable)e);
                        tree = null;
                    }
                } else {
                    tree = null;
                }
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
                return tree;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void updateStagingArea(File sourceFile, ArtifactIdentity identity) throws DeploymentException {
        try {
            try {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
                this.artifactStorageFactory.create(sourceFile, identity).synchronize();
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                StandardInstallArtifactTreeInclosure.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("StandardInstallArtifactTreeInclosure.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createInstallTree", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "org.eclipse.virgo.kernel.artifact.ArtifactSpecification:", "specification:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.Tree"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createInstallTree", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "org.eclipse.virgo.kernel.artifact.ArtifactSpecification:java.lang.String:", "specification:scopeName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.Tree"), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createInstallTree", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "java.io.File:", "sourceFile:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.Tree"), 114);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentity", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "java.io.File:", "file:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 136);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "constructInstallArtifactTree", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:java.util.Map:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:java.lang.String:", "identity:deploymentProperties:artifactStorage:repositoryName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.Tree"), 148);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "recoverInstallTree", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "java.io.File:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "sourceFile:deploymentOptions:", "", "org.eclipse.virgo.util.common.Tree"), 178);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateStagingArea", "org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure", "java.io.File:org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:", "sourceFile:identity:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 205);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.StandardInstallArtifactTreeInclosure");
    }
}

