/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.helper;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ClassLoadingHelper {
    public static boolean isPackageExported(BundleContext bundleContext, String classPackage, Bundle testBundle) {
        ExportPackageDescription[] exportDescriptions;
        ServiceReference reference = bundleContext.getServiceReference(PlatformAdmin.class);
        PlatformAdmin platformAdmin = (PlatformAdmin)bundleContext.getService(reference);
        BundleDescription bundleDescription = platformAdmin.getState(false).getBundle(testBundle.getBundleId());
        ExportPackageDescription[] exportPackageDescriptionArray = exportDescriptions = bundleDescription.getSelectedExports();
        int n = exportDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exportDescription = exportPackageDescriptionArray[n2];
            if (exportDescription.getName().equals(ClassLoadingHelper.convertToClassName(classPackage))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Map<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className) {
        Bundle[] bundles = bundleContext.getBundles();
        HashMap<Bundle, Bundle> foundBundles = new HashMap<Bundle, Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, bundle);
            if (originBundle != null) {
                foundBundles.put(bundle, originBundle);
            }
            ++n2;
        }
        return foundBundles;
    }

    public static Bundle getOriginBundleOfClass(String className, BundleContext bundleContext, Bundle loadingBundle) {
        Class<?> clasz = ClassLoadingHelper.tryToLoadClass(className, loadingBundle);
        Bundle originBundle = null;
        if (clasz != null && (originBundle = FrameworkUtil.getBundle(clasz)) == null) {
            originBundle = bundleContext.getBundle(0L);
        }
        return originBundle;
    }

    public static Class<?> tryToLoadClass(String className, Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.loadClass(ClassLoadingHelper.convertToClassName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String convertToClassName(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        if ((resourcePath = resourcePath.replace("/", ".")).startsWith(".")) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath.endsWith(".class")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 6);
        }
        return resourcePath;
    }

    public static String convertToResourcePath(String className) {
        if (className == null) {
            return null;
        }
        String result = className;
        if (!className.contains("/") && !className.contains("*")) {
            if (className.endsWith(".class")) {
                result = className.substring(0, className.length() - 6);
            }
            return String.valueOf(result.replace(".", "/")) + ".class";
        }
        return result;
    }

    public static Map<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className, String bundle) throws IllegalArgumentException {
        HashMap<Bundle, Bundle> result = new HashMap<Bundle, Bundle>();
        long id = Long.MIN_VALUE;
        try {
            id = Long.parseLong(bundle);
        }
        catch (NumberFormatException numberFormatException) {}
        if (id >= 0L) {
            Bundle testBundle = bundleContext.getBundle(id);
            if (testBundle == null) {
                throw new IllegalArgumentException("Bundle with ID [" + id + "] not found");
            }
            Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, testBundle);
            if (originBundle != null) {
                result.put(testBundle, originBundle);
            }
        } else {
            ServiceReference reference = bundleContext.getServiceReference(PackageAdmin.class);
            PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(reference);
            Bundle[] bundles = packageAdmin.getBundles(bundle, null);
            if (bundles == null) {
                throw new IllegalArgumentException("Bundle with symbolic name [" + bundle + "] not found");
            }
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle testBundle = bundleArray[n2];
                Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, testBundle);
                if (originBundle != null) {
                    result.put(testBundle, originBundle);
                }
                ++n2;
            }
        }
        return result;
    }

    public static Map<Bundle, List<String>> getBundlesContainingResource(BundleContext bundleContext, String resourcePattern) {
        Bundle[] bundles;
        HashMap<Bundle, List<String>> result = new HashMap<Bundle, List<String>>();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            List<String> entries = ClassLoadingHelper.findEntries(bundle, resourcePattern);
            if (entries != null && entries.size() != 0) {
                result.put(bundle, entries);
            }
            ++n2;
        }
        return result;
    }

    private static List<String> findEntries(Bundle bundle, String resourcePattern) {
        HashSet<String> urls = new HashSet<String>();
        int index = resourcePattern.lastIndexOf("/");
        if (index != -1) {
            String resourcePath = resourcePattern.substring(0, index);
            String resourceEntity = resourcePattern.substring(index + 1);
            ClassLoadingHelper.addURLs(urls, bundle.findEntries("/", resourceEntity, true), resourcePath);
        }
        ClassLoadingHelper.addURLs(urls, bundle.findEntries("/", resourcePattern, true), null);
        return new ArrayList<String>(urls);
    }

    private static void addURLs(HashSet<String> urls, Enumeration<URL> foundURLs, String path) {
        if (foundURLs != null) {
            while (foundURLs.hasMoreElements()) {
                String url = foundURLs.nextElement().getFile();
                if (path != null && !url.contains(path)) continue;
                urls.add(url);
            }
        }
    }
}

