/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.RequestUtil;
import org.eclipse.virgo.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final long serialVersionUID = 7966666229126801978L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            String pathInfo = RequestUtil.filter((String)request.getPathInfo());
            try {
                URL resource = this.getServletContext().getResource(pathInfo);
                if (resource == null) {
                    this.logger.warn("Resource {} not found", (Object)pathInfo);
                    response.sendError(404, "Resource '" + pathInfo + "' not found.");
                    break block8;
                }
                this.logger.info("Resource {} found", (Object)pathInfo);
                BufferedInputStream input = null;
                try {
                    int len;
                    input = new BufferedInputStream(resource.openStream());
                    ServletOutputStream output = response.getOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((len = ((InputStream)input).read(buffer)) > 0) {
                        output.write(buffer, 0, len);
                    }
                    output.flush();
                }
                finally {
                    if (input != null) {
                        IOUtils.closeQuietly((Closeable)input);
                    }
                }
            }
            catch (MalformedURLException e) {
                this.logger.error(String.format("Malformed servlet path %s", pathInfo), (Throwable)e);
                throw new ServletException("Malformed servlet path " + pathInfo, (Throwable)e);
            }
        }
    }
}

