/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.schema;

import java.net.URL;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public abstract class XMLSchemaReference
implements org.eclipse.persistence.platform.xml.XMLSchemaReference {
    protected String resource;
    protected String schemaContext;
    protected int type = 1;
    protected QName schemaContextAsQName;

    protected XMLSchemaReference() {
    }

    protected XMLSchemaReference(String resource) {
        this();
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public abstract URL getURL();

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 1 || type > 3 && type != 5) {
            throw XMLPlatformException.xmlPlatformInvalidTypeException(type);
        }
        this.type = type;
    }

    @Override
    public String getSchemaContext() {
        return this.schemaContext;
    }

    public void setSchemaContext(String schemaContext) {
        this.schemaContext = schemaContext;
    }

    public void setSchemaContextAsQName(QName qname) {
        this.schemaContextAsQName = qname;
    }

    public QName getSchemaContextAsQName() {
        return this.schemaContextAsQName;
    }

    public QName getSchemaContextAsQName(NamespaceResolver nsResolver) {
        if (this.schemaContext == null) {
            return null;
        }
        if (this.schemaContextAsQName == null) {
            int idx = this.schemaContext.lastIndexOf("/");
            String type = this.schemaContext.substring(idx + 1);
            if ((idx = type.indexOf(58)) != -1) {
                String prefix = type.substring(0, idx);
                String localPart = type.substring(idx + 1);
                String uri = nsResolver.resolveNamespacePrefix(prefix);
                this.schemaContextAsQName = new QName(uri, localPart);
            } else {
                this.schemaContextAsQName = nsResolver != null && nsResolver.getDefaultNamespaceURI() != null ? new QName(nsResolver.getDefaultNamespaceURI(), type) : new QName(type);
            }
        }
        return this.schemaContextAsQName;
    }

    public boolean isValid(Document document, ErrorHandler errorHandler) {
        try {
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            return xmlPlatform.validateDocument(document, this.getURL(), errorHandler);
        }
        catch (XMLPlatformException e) {
            if (e.getErrorCode() == 27006) {
                throw XMLMarshalException.errorResolvingXMLSchema(e);
            }
            return false;
        }
    }

    public boolean isGlobalDefinition() {
        return this.schemaContext.lastIndexOf("/") <= 0;
    }

    public void initialize(AbstractSession session) {
    }
}

