/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkReadOnlyAnnotation;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.nosql.eclipselink.core.context.java.JavaEclipseLinkNonEmbeddableTypeMapping;

public class JavaEclipseLinkReadOnly
extends AbstractJavaJpaContextNode
implements EclipseLinkReadOnly {
    protected Boolean specifiedReadOnly = this.buildSpecifiedReadOnly();

    public JavaEclipseLinkReadOnly(JavaEclipseLinkNonEmbeddableTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedReadOnly_(this.buildSpecifiedReadOnly());
    }

    public boolean isReadOnly() {
        return this.specifiedReadOnly != null ? this.specifiedReadOnly.booleanValue() : this.isDefaultReadOnly();
    }

    public Boolean getSpecifiedReadOnly() {
        return this.specifiedReadOnly;
    }

    public void setSpecifiedReadOnly(Boolean readOnly) {
        Boolean bl = readOnly == null ? null : (readOnly = readOnly != false ? readOnly : null);
        if (this.valuesAreDifferent(readOnly, this.specifiedReadOnly)) {
            EclipseLinkReadOnlyAnnotation annotation = this.getReadOnlyAnnotation();
            if (readOnly != null) {
                if (annotation == null) {
                    this.addReadOnlyAnnotation();
                }
            } else if (annotation != null) {
                this.removeReadOnlyAnnotation();
            }
            this.setSpecifiedReadOnly_(readOnly);
        }
    }

    protected void setSpecifiedReadOnly_(Boolean readOnly) {
        Boolean old = this.specifiedReadOnly;
        this.specifiedReadOnly = readOnly;
        this.firePropertyChanged("specifiedReadOnly", old, readOnly);
    }

    private Boolean buildSpecifiedReadOnly() {
        return this.getReadOnlyAnnotation() == null ? null : Boolean.TRUE;
    }

    public boolean isDefaultReadOnly() {
        return false;
    }

    protected EclipseLinkReadOnlyAnnotation getReadOnlyAnnotation() {
        return (EclipseLinkReadOnlyAnnotation)this.getJavaResourceType().getAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void addReadOnlyAnnotation() {
        this.getJavaResourceType().addAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void removeReadOnlyAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getReadOnlyAnnotationName());
    }

    protected String getReadOnlyAnnotationName() {
        return "org.eclipse.persistence.annotations.ReadOnly";
    }

    public JavaEclipseLinkNonEmbeddableTypeMapping getParent() {
        return (JavaEclipseLinkNonEmbeddableTypeMapping)super.getParent();
    }

    protected JavaEclipseLinkNonEmbeddableTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        EclipseLinkReadOnlyAnnotation annotation = this.getReadOnlyAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

