/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmEntity;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCacheableHolder2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlCacheable_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkClassExtractorAnnotation2_1;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkCaching;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConvertibleMapping;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.nosql.eclipselink.core.context.java.JavaEclipseLinkEntity;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.EclipseLinkOrmPersistentType;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.OrmEclipseLinkConverterContainer;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.OrmEclipseLinkEntity;
import org.eclipse.jpt.nosql.eclipselink.core.context.orm.OrmEclipseLinkMultitenancy2_3;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.EclipseLinkJpaPlatformFactory;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.EclipseLinkEntityPrimaryKeyValidator;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.EclipseLinkTypeMappingValidator;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.NullOrmEclipseLinkMultitenancy2_3;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkCachingImpl;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkChangeTracking;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConverterContainerImpl;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkCustomizer;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkMultitenancyImpl2_3;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkReadOnly;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkEntityImpl
extends AbstractOrmEntity<XmlEntity>
implements OrmEclipseLinkEntity,
OrmEclipseLinkConverterContainer.Owner {
    protected final OrmEclipseLinkReadOnly readOnly;
    protected final OrmEclipseLinkCustomizer customizer;
    protected final OrmEclipseLinkChangeTracking changeTracking;
    protected final EclipseLinkCaching caching = this.buildCaching();
    protected final OrmEclipseLinkConverterContainer converterContainer;
    protected final OrmEclipseLinkMultitenancy2_3 multitenancy;

    public OrmEclipseLinkEntityImpl(OrmPersistentType parent, XmlEntity xmlEntity) {
        super(parent, (org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)xmlEntity);
        this.readOnly = this.buildReadOnly();
        this.converterContainer = this.buildConverterContainer();
        this.changeTracking = this.buildChangeTracking();
        this.customizer = this.buildCustomizer();
        this.multitenancy = this.buildMultitenancy();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.caching.synchronizeWithResourceModel();
        this.readOnly.synchronizeWithResourceModel();
        this.converterContainer.synchronizeWithResourceModel();
        this.changeTracking.synchronizeWithResourceModel();
        this.customizer.synchronizeWithResourceModel();
        this.multitenancy.synchronizeWithResourceModel();
    }

    public void update() {
        super.update();
        this.caching.update();
        this.readOnly.update();
        this.converterContainer.update();
        this.changeTracking.update();
        this.customizer.update();
        this.multitenancy.update();
    }

    @Override
    public EclipseLinkCaching getCaching() {
        return this.caching;
    }

    protected EclipseLinkCaching buildCaching() {
        return new OrmEclipseLinkCachingImpl(this);
    }

    @Override
    public OrmEclipseLinkReadOnly getReadOnly() {
        return this.readOnly;
    }

    protected OrmEclipseLinkReadOnly buildReadOnly() {
        return new OrmEclipseLinkReadOnly(this);
    }

    @Override
    public OrmEclipseLinkConverterContainer getConverterContainer() {
        return this.converterContainer;
    }

    protected OrmEclipseLinkConverterContainer buildConverterContainer() {
        return new OrmEclipseLinkConverterContainerImpl((JpaContextNode)this, this, (XmlConverterContainer)this.xmlTypeMapping);
    }

    @Override
    public int getNumberSupportedConverters() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterable<EclipseLinkConverter> getConverters() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.converterContainer.getConverters(), this.getAttributeMappingConverters()});
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters() {
        return IterableTools.removeNulls(this.getAttributeMappingConverters_());
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters_() {
        return IterableTools.children((Iterable)this.getAttributeMappings(), EclipseLinkConvertibleMapping.ATTRIBUTE_MAPPING_CONVERTERS_TRANSFORMER);
    }

    @Override
    public EclipseLinkChangeTracking getChangeTracking() {
        return this.changeTracking;
    }

    protected OrmEclipseLinkChangeTracking buildChangeTracking() {
        return new OrmEclipseLinkChangeTracking(this);
    }

    @Override
    public EclipseLinkCustomizer getCustomizer() {
        return this.customizer;
    }

    protected OrmEclipseLinkCustomizer buildCustomizer() {
        return new OrmEclipseLinkCustomizer(this);
    }

    @Override
    public OrmEclipseLinkMultitenancy2_3 getMultitenancy() {
        return this.multitenancy;
    }

    protected OrmEclipseLinkMultitenancy2_3 buildMultitenancy() {
        return this.isEclipseLink2_3Compatible() ? new OrmEclipseLinkMultitenancyImpl2_3(this) : new NullOrmEclipseLinkMultitenancy2_3(this);
    }

    protected boolean isEclipseLink2_3Compatible() {
        return this.getJpaPlatformVersion().isCompatibleWithEclipseLinkVersion("2.3");
    }

    protected EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion getJpaPlatformVersion() {
        return (EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion)super.getJpaPlatformVersion();
    }

    @Override
    public boolean isMultitenantMetadataAllowed() {
        return this.isRootEntity() || this.isInheritanceStrategyTablePerClass();
    }

    protected boolean isInheritanceStrategyTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected String buildSpecifiedParentClass() {
        return ((XmlEntity)this.xmlTypeMapping).getParentClass();
    }

    public void setSpecifiedParentClassInXml(String parentClass) {
        ((XmlEntity)this.xmlTypeMapping).setParentClass(parentClass);
    }

    @Override
    public JavaEclipseLinkEntity getJavaTypeMapping() {
        return (JavaEclipseLinkEntity)super.getJavaTypeMapping();
    }

    @Override
    public JavaEclipseLinkEntity getJavaTypeMappingForDefaults() {
        return (JavaEclipseLinkEntity)super.getJavaTypeMappingForDefaults();
    }

    public EclipseLinkOrmPersistentType getPersistentType() {
        return (EclipseLinkOrmPersistentType)super.getPersistentType();
    }

    @Override
    public boolean usesPrimaryKeyColumns() {
        return ((XmlEntity)this.getXmlTypeMapping()).getPrimaryKey() != null || this.usesJavaPrimaryKeyColumns();
    }

    protected boolean usesJavaPrimaryKeyColumns() {
        JavaEclipseLinkEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity != null && javaEntity.usesPrimaryKeyColumns();
    }

    @Override
    public boolean usesPrimaryKeyTenantDiscriminatorColumns() {
        return this.getMultitenancy().usesPrimaryKeyTenantDiscriminatorColumns();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return super.buildSpecifiedDiscriminatorColumnIsAllowed() && !this.classExtractorIsUsed();
    }

    protected boolean classExtractorIsUsed() {
        return this.getXmlClassExtractor() != null || this.getClassExtractorAnnotation() != null;
    }

    protected XmlClassReference getXmlClassExtractor() {
        return ((XmlEntity)this.getXmlTypeMapping()).getClassExtractor();
    }

    protected EclipseLinkClassExtractorAnnotation2_1 getClassExtractorAnnotation() {
        if (this.getJavaTypeMappingForDefaults() != null) {
            JavaResourceType jrpt = this.getJavaPersistentType().getJavaResourceType();
            return (EclipseLinkClassExtractorAnnotation2_1)jrpt.getAnnotation("org.eclipse.persistence.annotations.ClassExtractor");
        }
        return null;
    }

    public Cacheable2_0 getCacheable() {
        return this.getCacheableHolder().getCacheable();
    }

    public boolean calculateDefaultCacheable() {
        return this.getCacheableHolder().calculateDefaultCacheable();
    }

    protected OrmCacheableHolder2_0 getCacheableHolder() {
        return (OrmCacheableHolder2_0)this.caching;
    }

    public XmlCacheable_2_0 getXmlCacheable() {
        return (XmlCacheable_2_0)this.getXmlTypeMapping();
    }

    protected JavaResourceAbstractType getResourceClassExtractorType() {
        XmlClassReference classExtractorClassRef = this.getXmlClassExtractor();
        if (classExtractorClassRef == null) {
            return null;
        }
        String className = classExtractorClassRef.getClassName();
        if (className == null) {
            return null;
        }
        return this.getMappingFileRoot().resolveJavaResourceType(className);
    }

    protected boolean classExtractorIsFor(String typeName) {
        JavaResourceAbstractType classExtractorType = this.getResourceClassExtractorType();
        return classExtractorType != null && classExtractorType.getTypeBinding().getQualifiedName().equals(typeName);
    }

    protected boolean classExtractorIsIn(IPackageFragment packageFragment) {
        JavaResourceAbstractType classExtractorType = this.getResourceClassExtractorType();
        return classExtractorType != null && classExtractorType.isIn(packageFragment);
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createCustomizerRenameTypeEdits(originalType, newName), this.createConverterHolderRenameTypeEdits(originalType, newName), this.createClassExtractorRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenameTypeEdits(IType originalType, String newName) {
        return this.customizer.createRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createConverterHolderRenameTypeEdits(IType originalType, String newName) {
        return this.converterContainer.createRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createClassExtractorRenameTypeEdits(IType originalType, String newName) {
        return this.classExtractorIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.getXmlClassExtractor().createRenameEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createCustomizerMoveTypeEdits(originalType, newPackage), this.createConverterHolderMoveTypeEdits(originalType, newPackage), this.createClassExtractorMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createCustomizerMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.customizer.createMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createConverterHolderMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.converterContainer.createMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createClassExtractorMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.classExtractorIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.getXmlClassExtractor().createRenamePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createCustomizerRenamePackageEdits(originalPackage, newName), this.createConverterHolderRenamePackageEdits(originalPackage, newName), this.createClassExtractorRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.customizer.createRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createConverterHolderRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.converterContainer.createRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createClassExtractorRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.classExtractorIsIn(originalPackage) ? IterableTools.singletonIterable((Object)this.getXmlClassExtractor().createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateParentClass(messages, reporter);
        this.caching.validate(messages, reporter);
        this.readOnly.validate(messages, reporter);
        this.converterContainer.validate(messages, reporter);
        this.changeTracking.validate(messages, reporter);
        this.customizer.validate(messages, reporter);
        this.multitenancy.validate(messages, reporter);
    }

    protected JptValidator buildPrimaryKeyValidator() {
        return new EclipseLinkEntityPrimaryKeyValidator(this);
    }

    protected JptValidator buildTypeMappingValidator() {
        return new EclipseLinkTypeMappingValidator(this);
    }

    protected void validateParentClass(List<IMessage> messages, IReporter reporter) {
        IType jdtType;
        if (this.specifiedParentClass == null) {
            return;
        }
        if (this.getResolvedParentClass() == null && (jdtType = JDTTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedParentClass())) == null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "VIRTUAL_TYPE_PARENT_CLASS_DOES_NOT_EXIST", new String[]{this.getFullyQualifiedParentClass()}, (JpaNode)this, this.getParentClassTextRange()));
        }
    }

    protected TextRange getParentClassTextRange() {
        return this.getValidationTextRange(((XmlEntity)this.xmlTypeMapping).getParentClassTextRange());
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.multitenancy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.customizer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converterContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (((XmlEntity)this.xmlTypeMapping).parentClassTouches(pos)) {
            return this.getCandidateParentClassNames();
        }
        if (this.classExtractorTouches(pos)) {
            return this.getCandidateClassNames();
        }
        return null;
    }

    protected Iterable<String> getCandidateParentClassNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getCandidateClassNames(), IterableTools.sort(((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getEclipseLinkDynamicPersistentTypeNames())});
    }

    protected boolean classExtractorTouches(int pos) {
        return this.getXmlClassExtractor() == null ? false : this.getXmlClassExtractor().classNameTouches(pos);
    }
}

