/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.IJ2EEModuleFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

public abstract class J2EEModuleFacetInstallDataModelProvider
extends J2EEFacetInstallDataModelProvider
implements IJ2EEModuleFacetInstallDataModelProperties {
    public static final String PROHIBIT_ADD_TO_EAR = "J2EEModuleFacetInstallDataModelProvider.PROHIBIT_ADD_TO_EAR";
    protected IFacetedProjectWorkingCopy fpjwc = null;
    private IFacetedProjectListener fpjwcListener = null;
    protected JavaFacetInstallConfig javaFacetInstallConfig = null;
    private IEventListener<JavaFacetInstallConfig.ChangeEvent> javaFacetSourceFolderListener = new IEventListener<JavaFacetInstallConfig.ChangeEvent>(){

        public void handleEvent(JavaFacetInstallConfig.ChangeEvent event) {
            J2EEModuleFacetInstallDataModelProvider.this.handleJavaFacetSourceFoldersChanged(event);
        }
    };

    protected void handleJavaFacetSourceFoldersChanged(JavaFacetInstallConfig.ChangeEvent event) {
        List sourceFolders = event.getJavaFacetInstallConfig().getSourceFolders();
        String sourceFolder = sourceFolders.isEmpty() ? null : ((IPath)sourceFolders.get(0)).toPortableString();
        this.getDataModel().setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)sourceFolder);
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR");
        names.add(PROHIBIT_ADD_TO_EAR);
        names.add("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        names.add("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
        names.add("IJ2EEModuleFacetInstallDataModelProperties.LAST_EAR_NAME");
        names.add("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI");
        names.add("IJ2EEFacetInstallDataModelProperties.GENERATE_DD");
        names.add("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(PROHIBIT_ADD_TO_EAR)) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            return new Boolean(J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("addToEarByDefault") && this.isEARSupportedByRuntime());
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME")) {
            DataModelPropertyDescriptor[] descs = this.getValidPropertyDescriptors("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
            if (this.model.isPropertySet("IJ2EEModuleFacetInstallDataModelProperties.LAST_EAR_NAME")) {
                IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.LAST_EAR_NAME"));
                int i = 0;
                while (i < descs.length) {
                    if (project.exists() && project.isAccessible() && project.getName().equals(descs[i].getPropertyDescription()) && this.hasValidRuntime(project)) {
                        return project.getName();
                    }
                    ++i;
                }
                return String.valueOf(this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) + "EAR";
            }
            if (descs.length > 0) {
                DataModelPropertyDescriptor desc = descs[0];
                String eARName = desc.getPropertyDescription();
                IProject project = ProjectUtilities.getProject((String)eARName);
                if (eARName != null && !eARName.equals("") && this.hasValidRuntime(project)) {
                    return eARName;
                }
                return String.valueOf(this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) + "EAR";
            }
            return String.valueOf(this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) + "EAR";
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY")) {
            return J2EEComponentClasspathContainerUtils.getDefaultUseEARLibraries();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals(PROHIBIT_ADD_TO_EAR)) {
            this.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        }
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            if (this.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR") && !this.model.isPropertySet("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME")) {
                this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 2);
            }
        } else if ("IFacetDataModelPropeties.FACET_VERSION".equals(propertyName)) {
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 4);
        } else if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map;
            IDataModel javaModel;
            IDataModel masterModel = (IDataModel)this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
            if (masterModel != null && (javaModel = (map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.java")) != null) {
                javaModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", propertyValue);
            }
        } else if (("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME".equals(propertyName) || "IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName) || "IJ2EEModuleFacetInstallDataModelProperties.LAST_EAR_NAME".equals(propertyName)) && this.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            IProject project;
            IStatus status = this.validateEAR(this.model.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME"));
            if (status.isOK() && (project = ProjectUtilities.getProject((String)this.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME"))).exists() && project.isAccessible() && JavaEEProjectUtilities.isEARProject(project)) {
                try {
                    IFacetedProject facetProj = ProjectFacetsManager.create((IProject)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                    this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", facetProj.getRuntime());
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(e);
                }
            }
            this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 3);
        } else if (propertyName.equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", 4);
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 4);
        } else if (propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            this.fpjwc = (IFacetedProjectWorkingCopy)propertyValue;
            this.fpjwcListener = new IFacetedProjectListener(){

                public void handleEvent(IFacetedProjectEvent event) {
                    J2EEModuleFacetInstallDataModelProvider.this.handleProjectFacetsChanged();
                }
            };
            this.fpjwc.addListener(this.fpjwcListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        }
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            IStatus stat = this.model.validateProperty(propertyName);
            if (stat != OK_STATUS) {
                return true;
            }
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 4);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private boolean hasValidRuntime(IProject project) {
        IRuntime runtime;
        IFacetedProject facetProj = null;
        try {
            facetProj = ProjectFacetsManager.create((IProject)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            J2EEPlugin.logError(e1);
        }
        if (facetProj != null && (runtime = facetProj.getPrimaryRuntime()) != null) {
            for (IProjectFacet facet : this.fpjwc.getFixedProjectFacets()) {
                try {
                    IProjectFacetVersion facetVersion = facet.getLatestSupportedVersion(runtime);
                    if (facetVersion != null) continue;
                    return false;
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    private void handleProjectFacetsChanged() {
        Object config;
        IFacetedProject.Action javaInstallAction = this.fpjwc.getProjectFacetAction(JavaFacetUtils.JAVA_FACET);
        if (javaInstallAction != null && (config = javaInstallAction.getConfig()) != null) {
            if (config instanceof JavaFacetInstallConfig) {
                this.javaFacetInstallConfig = (JavaFacetInstallConfig)config;
                String providerId = this.model.getID();
                if (providerId != "") {
                    if (providerId.indexOf("WebFacetInstallDataModelProvider") != -1) {
                        this.javaFacetInstallConfig.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("dynWebOutput")));
                    } else if (providerId.indexOf("EjbFacetInstallDataModelProvider") != -1) {
                        this.javaFacetInstallConfig.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbOutput")));
                    } else if (providerId.indexOf("AppClientFacetInstallDataModelProvider") != -1) {
                        this.javaFacetInstallConfig.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("appClientOutput")));
                    } else if (providerId.indexOf("ConnectorFacetInstallDataModelProvider") != -1) {
                        this.javaFacetInstallConfig.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("jcaOutput")));
                    } else if (providerId.indexOf("UtilityFacetInstallDataModelProvider") != -1) {
                        this.javaFacetInstallConfig.setDefaultOutputFolder((IPath)new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getUtilityOutputFolderName()));
                    }
                }
            } else {
                this.javaFacetInstallConfig = (JavaFacetInstallConfig)Platform.getAdapterManager().getAdapter(config, JavaFacetInstallConfig.class);
            }
            if (this.javaFacetInstallConfig != null) {
                this.javaFacetInstallConfig.addListener(this.javaFacetSourceFolderListener, new JavaFacetInstallConfig.ChangeEvent.Type[]{JavaFacetInstallConfig.ChangeEvent.Type.SOURCE_FOLDERS_CHANGED});
            }
        }
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            return !this.getBooleanProperty(PROHIBIT_ADD_TO_EAR) && this.isEARSupportedByRuntime();
        }
        if ("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME".equals(propertyName)) {
            return !this.getBooleanProperty(PROHIBIT_ADD_TO_EAR) && this.isEARSupportedByRuntime() && this.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME".equals(propertyName)) {
            int j2eeVersion = this.getJ2EEVersion();
            return this.getEARPropertyDescriptors(j2eeVersion);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected DataModelPropertyDescriptor[] getEARPropertyDescriptors(int j2eeVersion) {
        ArrayList<DataModelPropertyDescriptor> earDescriptorList = new ArrayList<DataModelPropertyDescriptor>();
        IProject[] projs = ProjectUtilities.getAllProjects();
        int index = 0;
        while (index < projs.length) {
            String sVer;
            int ver;
            IVirtualComponent comp;
            IProject flexProject = projs[index];
            if (flexProject != null && ModuleCoreNature.isFlexibleProject((IProject)flexProject) && JavaEEProjectUtilities.isEARProject((comp = ComponentCore.createComponent((IProject)flexProject)).getProject()) && j2eeVersion <= (ver = J2EEVersionUtil.convertVersionStringToInt(sVer = J2EEProjectUtilities.getJ2EEProjectVersion(comp.getProject())))) {
                DataModelPropertyDescriptor desc = new DataModelPropertyDescriptor((Object)comp.getProject().getName());
                earDescriptorList.add(desc);
            }
            ++index;
        }
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[earDescriptorList.size()];
        int i = 0;
        while (i < descriptors.length) {
            DataModelPropertyDescriptor desc = (DataModelPropertyDescriptor)earDescriptorList.get(i);
            descriptors[i] = new DataModelPropertyDescriptor((Object)desc.getPropertyDescription(), desc.getPropertyDescription());
            ++i;
        }
        return descriptors;
    }

    public IStatus validate(String name) {
        if (name.equals("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME") && this.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            IStatus status = this.validateEAR(this.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME"));
            if (!status.isOK()) {
                return status;
            }
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            String fpjwcName = fpjwc.getProjectName();
            if (fpjwcName != null && fpjwcName.equals(this.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME"))) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"4", (Object[])new Object[]{this.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME")});
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
        } else {
            if (name.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                String folderName = this.model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                if (folderName == null || folderName.length() == 0 || folderName.equals("/") || folderName.equals("\\")) {
                    String errorMessage = WTPCommonPlugin.getResourceString((String)"39");
                    return WTPCommonPlugin.createErrorStatus((String)errorMessage);
                }
                IStatus status = this.validateFolderName(folderName);
                if (status.isOK() && folderName.indexOf(35) != -1) {
                    String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)"#", (Object)folderName);
                    status = new ResourceStatus(77, null, message);
                }
                return status;
            }
            if (name.equals("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR") && !this.isEARSupportedByRuntime()) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"37");
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
        }
        return super.validate(name);
    }

    protected IStatus validateEAR(String earName) {
        if (earName == null || earName.equals("")) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"34");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        if (earName.indexOf("#") != -1 || earName.indexOf("/") != -1) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"35");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        return ProjectCreationDataModelProviderNew.validateProjectName((String)earName);
    }

    private boolean isEARSupportedByRuntime() {
        boolean ret = true;
        IRuntime rt = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (rt != null) {
            ret = rt.supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET);
        }
        return ret;
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return 0;
    }

    public void dispose() {
        if (this.fpjwc != null) {
            this.fpjwc.removeListener(this.fpjwcListener);
        }
    }
}

