/* wptContext.h - Internal file to store private contexts
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef WPT_CONTEXT_H
#define WPT_CONTEXT_H

struct subclass_s {
    HWND    dlg;
    WNDPROC old;
    WNDPROC current;
    void * opaque;
};

struct winpt_key_s {
    const char * uid;
    const char * keyid;
    unsigned int key_pair:1;
    unsigned int is_protected:1;
    unsigned int flags;
    struct {
	listview_ctrl_t ctl;
	int idx;
	int new_val;
    } callback;
};
typedef struct winpt_key_s * winpt_key_t;

struct text_input_s {
    char * data;
    size_t length;
    int    type;
};

struct date_s {
    int          cancel;
    const char * text;
    SYSTEMTIME   st;
};

struct md_file_s {
    int             mdalgo;
    listview_ctrl_t lv;
};

struct secdel_confirm_s {
    unsigned int       yes:1;
    gpgme_recipients_t rset;
};

struct import_status_s {
    int          import_res[14];
    unsigned int rev_cert:1;
};

struct progress_filter_s {
    HWND     hwnd;
    HWND     dlg;
    HANDLE   thread_hd;
    int	     error;
    const char * what;
    int	     type;
    unsigned curr;
    unsigned total;
};


struct http_file_s {
    char url[256];
    char proxy[64];
    int  port;
    int  cancel;
};

struct key_wizard_s {
    int interactive;
};

#endif /* WPT_CONTEXT_H */