#!/bin/bash

version="eselect-python-${1#eselect-python-}" || exit
distdir=$(portageq envvar DISTDIR) || exit
output=${distdir%/}/${version}.tar.bz2

exclude=(
	--exclude-vcs
)
for exclude_file in .git/info/exclude .gitignore; do
	[[ -e ${exclude_file} ]] && exclude+=("--exclude-from=${exclude_file}")
done

printf 'Writing tarball of current directory to %s\n' "${output}"
tar ca --owner=root --group=root --sort=name "${exclude[@]}" . --transform="s:^.[/]*:${version}/:" -f "${output}" || exit
tar tvf "${output}" || exit
