/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-symbol
 * @title: IAnjutaSymbol
 * @short_description: Source code symbol interface
 * @see_also: #IAnjutaSymbolManager
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol.h
 * 
 */

#include "ianjuta-symbol.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-quark");
	}
	
	return quark;
}

gchar
ianjuta_symbol_access (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->access (obj, err);
}

const gchar *
ianjuta_symbol_args (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->args (obj, err);
}

const gchar *
ianjuta_symbol_file (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->file (obj, err);
}

GdkPixbuf *
ianjuta_symbol_icon (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->icon (obj, err);
}

gchar
ianjuta_symbol_impl (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->impl (obj, err);
}

const gchar *
ianjuta_symbol_inheritance (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->inheritance (obj, err);
}

gboolean
ianjuta_symbol_is_local (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), FALSE);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->is_local (obj, err);
}

gulong
ianjuta_symbol_line (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->line (obj, err);
}

const gchar *
ianjuta_symbol_name (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->name (obj, err);
}

guint
ianjuta_symbol_pointer_order (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->pointer_order (obj, err);
}

const gchar *
ianjuta_symbol_scope (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->scope (obj, err);
}

IAnjutaSymbolType
ianjuta_symbol_type (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->type (obj, err);
}

const gchar *
ianjuta_symbol_var_type (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->var_type (obj, err);
}

static void
ianjuta_symbol_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_symbol_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolIface),
			ianjuta_symbol_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbol", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_symbol_field_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_FIELD_NONE, "IANJUTA_SYMBOL_FIELD_NONE", "field-none" }, 
		{ IANJUTA_SYMBOL_FIELD_NAME, "IANJUTA_SYMBOL_FIELD_NAME", "field-name" }, 
		{ IANJUTA_SYMBOL_FIELD_TYPE, "IANJUTA_SYMBOL_FIELD_TYPE", "field-type" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE, "IANJUTA_SYMBOL_FIELD_FILE", "field-file" }, 
		{ IANJUTA_SYMBOL_FIELD_LINE, "IANJUTA_SYMBOL_FIELD_LINE", "field-line" }, 
		{ IANJUTA_SYMBOL_FIELD_POSITION, "IANJUTA_SYMBOL_FIELD_POSITION", "field-position" }, 
		{ IANJUTA_SYMBOL_FIELD_SCOPE, "IANJUTA_SYMBOL_FIELD_SCOPE", "field-scope" }, 
		{ IANJUTA_SYMBOL_FIELD_INHERITANCE, "IANJUTA_SYMBOL_FIELD_INHERITANCE", "field-inheritance" }, 
		{ IANJUTA_SYMBOL_FIELD_ARGUMENTS, "IANJUTA_SYMBOL_FIELD_ARGUMENTS", "field-arguments" }, 
		{ IANJUTA_SYMBOL_FIELD_LOCAL, "IANJUTA_SYMBOL_FIELD_LOCAL", "field-local" }, 
		{ IANJUTA_SYMBOL_FIELD_TIME, "IANJUTA_SYMBOL_FIELD_TIME", "field-time" }, 
		{ IANJUTA_SYMBOL_FIELD_VARTYPE, "IANJUTA_SYMBOL_FIELD_VARTYPE", "field-vartype" }, 
		{ IANJUTA_SYMBOL_FIELD_ACCESS, "IANJUTA_SYMBOL_FIELD_ACCESS", "field-access" }, 
		{ IANJUTA_SYMBOL_FIELD_IMPLEMENTATION, "IANJUTA_SYMBOL_FIELD_IMPLEMENTATION", "field-implementation" }, 
		{ IANJUTA_SYMBOL_FIELD_LANGUAGE, "IANJUTA_SYMBOL_FIELD_LANGUAGE", "field-language" }, 
		{ IANJUTA_SYMBOL_FIELD_INACTIVE, "IANJUTA_SYMBOL_FIELD_INACTIVE", "field-inactive" }, 
		{ IANJUTA_SYMBOL_FIELD_POINTER, "IANJUTA_SYMBOL_FIELD_POINTER", "field-pointer" }, 
		{ IANJUTA_SYMBOL_FIELD_MAX, "IANJUTA_SYMBOL_FIELD_MAX", "field-max" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolField", values);
	}

	return type;
}

GType
ianjuta_symbol_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_TYPE_UNDEF, "IANJUTA_SYMBOL_TYPE_UNDEF", "type-undef" }, 
		{ IANJUTA_SYMBOL_TYPE_CLASS, "IANJUTA_SYMBOL_TYPE_CLASS", "type-class" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUM, "IANJUTA_SYMBOL_TYPE_ENUM", "type-enum" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUMERATOR, "IANJUTA_SYMBOL_TYPE_ENUMERATOR", "type-enumerator" }, 
		{ IANJUTA_SYMBOL_TYPE_FIELD, "IANJUTA_SYMBOL_TYPE_FIELD", "type-field" }, 
		{ IANJUTA_SYMBOL_TYPE_FUNCTION, "IANJUTA_SYMBOL_TYPE_FUNCTION", "type-function" }, 
		{ IANJUTA_SYMBOL_TYPE_INTERFACE, "IANJUTA_SYMBOL_TYPE_INTERFACE", "type-interface" }, 
		{ IANJUTA_SYMBOL_TYPE_MEMBER, "IANJUTA_SYMBOL_TYPE_MEMBER", "type-member" }, 
		{ IANJUTA_SYMBOL_TYPE_METHOD, "IANJUTA_SYMBOL_TYPE_METHOD", "type-method" }, 
		{ IANJUTA_SYMBOL_TYPE_NAMESPACE, "IANJUTA_SYMBOL_TYPE_NAMESPACE", "type-namespace" }, 
		{ IANJUTA_SYMBOL_TYPE_PACKAGE, "IANJUTA_SYMBOL_TYPE_PACKAGE", "type-package" }, 
		{ IANJUTA_SYMBOL_TYPE_PROTOTYPE, "IANJUTA_SYMBOL_TYPE_PROTOTYPE", "type-prototype" }, 
		{ IANJUTA_SYMBOL_TYPE_STRUCT, "IANJUTA_SYMBOL_TYPE_STRUCT", "type-struct" }, 
		{ IANJUTA_SYMBOL_TYPE_TYPEDEF, "IANJUTA_SYMBOL_TYPE_TYPEDEF", "type-typedef" }, 
		{ IANJUTA_SYMBOL_TYPE_UNION, "IANJUTA_SYMBOL_TYPE_UNION", "type-union" }, 
		{ IANJUTA_SYMBOL_TYPE_VARIABLE, "IANJUTA_SYMBOL_TYPE_VARIABLE", "type-variable" }, 
		{ IANJUTA_SYMBOL_TYPE_EXTERNVAR, "IANJUTA_SYMBOL_TYPE_EXTERNVAR", "type-externvar" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO, "IANJUTA_SYMBOL_TYPE_MACRO", "type-macro" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG, "IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG", "type-macro-with-arg" }, 
		{ IANJUTA_SYMBOL_TYPE_FILE, "IANJUTA_SYMBOL_TYPE_FILE", "type-file" }, 
		{ IANJUTA_SYMBOL_TYPE_OTHER, "IANJUTA_SYMBOL_TYPE_OTHER", "type-other" }, 
		{ IANJUTA_SYMBOL_TYPE_MAX, "IANJUTA_SYMBOL_TYPE_MAX", "type-max" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolType", values);
	}

	return type;
}
