/* contacts-contact-pane.c generated by valac 0.12.0.305-a4eb, the Vala compiler
 * generated from contacts-contact-pane.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_DETAILS_LAYOUT (details_layout_get_type ())
#define DETAILS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETAILS_LAYOUT, DetailsLayout))
#define DETAILS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETAILS_LAYOUT, DetailsLayoutClass))
#define IS_DETAILS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETAILS_LAYOUT))
#define IS_DETAILS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETAILS_LAYOUT))
#define DETAILS_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETAILS_LAYOUT, DetailsLayoutClass))

typedef struct _DetailsLayout DetailsLayout;
typedef struct _DetailsLayoutClass DetailsLayoutClass;
typedef struct _DetailsLayoutPrivate DetailsLayoutPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_CONTACT_PANE_TYPE_DISPLAY_MODE (contacts_contact_pane_display_mode_get_type ())
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CONTACTS_TYPE_MENU_BUTTON (contacts_menu_button_get_type ())
#define CONTACTS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButton))
#define CONTACTS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))
#define CONTACTS_IS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_IS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))

typedef struct _ContactsMenuButton ContactsMenuButton;
typedef struct _ContactsMenuButtonClass ContactsMenuButtonClass;

struct _DetailsLayout {
	GObject parent_instance;
	DetailsLayoutPrivate * priv;
	GtkGrid* current_row;
};

struct _DetailsLayoutClass {
	GObjectClass parent_class;
};

struct _DetailsLayoutPrivate {
	GtkGrid* fields_grid;
	GtkSizeGroup* label_size_group;
	GtkWidget* last_label;
};

struct _ContactsContactPane {
	GtkEventBox parent_instance;
	ContactsContactPanePrivate * priv;
};

struct _ContactsContactPaneClass {
	GtkEventBoxClass parent_class;
};

typedef enum  {
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES,
	CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT
} ContactsContactPaneDisplayMode;

struct _ContactsContactPanePrivate {
	ContactsContact* selected_contact;
	ContactsContactPaneDisplayMode display_mode;
	GtkGrid* fields_grid;
	gboolean has_notes;
	GtkWidget* notes_dot;
	GtkButtonBox* normal_buttons;
	GtkButtonBox* editing_buttons;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	ContactsContactPane * self;
	ContactsContact* contact;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	gchar* email_addr;
};

struct _Block5Data {
	int _ref_count_;
	Block3Data * _data3_;
	gchar* protocol;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gchar* id;
};


static gpointer details_layout_parent_class = NULL;
static gpointer contacts_contact_pane_parent_class = NULL;

GType details_layout_get_type (void) G_GNUC_CONST;
#define DETAILS_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DETAILS_LAYOUT, DetailsLayoutPrivate))
enum  {
	DETAILS_LAYOUT_DUMMY_PROPERTY
};
DetailsLayout* details_layout_new (GtkGrid* fields_grid);
DetailsLayout* details_layout_construct (GType object_type, GtkGrid* fields_grid);
static void details_layout_new_row (DetailsLayout* self);
void details_layout_add_widget_label (DetailsLayout* self, GtkWidget* w);
void details_layout_add_label (DetailsLayout* self, const gchar* label);
void details_layout_add_detail (DetailsLayout* self, const gchar* val);
void details_layout_add_label_detail (DetailsLayout* self, const gchar* label, const gchar* val);
gboolean details_layout_add_string_property (DetailsLayout* self, const gchar* label, GObject* object, const gchar* pname);
void details_layout_add_link (DetailsLayout* self, const gchar* uri, const gchar* text);
GtkButton* details_layout_add_button (DetailsLayout* self, const gchar* icon);
static void details_layout_finalize (GObject* obj);
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
static GType contacts_contact_pane_display_mode_get_type (void) G_GNUC_UNUSED;
#define CONTACTS_CONTACT_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPanePrivate))
enum  {
	CONTACTS_CONTACT_PANE_DUMMY_PROPERTY
};
static void contacts_contact_pane_display_card (ContactsContactPane* self, DetailsLayout* layout, ContactsContact* contact);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
static void contacts_contact_pane_display_notes (ContactsContactPane* self);
static void contacts_contact_pane_set_display_mode (ContactsContactPane* self, ContactsContactPaneDisplayMode mode);
static void contacts_contact_pane_display_contact (ContactsContactPane* self, ContactsContact* contact);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void contacts_contact_pane_set_has_notes (ContactsContactPane* self, gboolean has_notes);
GList* contacts_contact_sort_fields (GeeSet* details);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
gchar* contacts_contact_format_email_type (FolksFieldDetails* detail);
static void _lambda14_ (Block4Data* _data4_);
void contacts_utils_compose_mail (const gchar* email);
static void __lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id);
GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _lambda15_ (Block6Data* _data6_);
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
gchar* contacts_contact_format_phone_type (FolksFieldDetails* detail);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
static void contacts_contact_pane_selected_contact_changed (ContactsContactPane* self);
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact);
static void _contacts_contact_pane_selected_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self);
ContactsContactPane* contacts_contact_pane_new (void);
ContactsContactPane* contacts_contact_pane_construct (GType object_type);
static gboolean _lambda16_ (GtkWidget* widget, cairo_t* cr, ContactsContactPane* self);
static gboolean __lambda16__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void _lambda17_ (GtkButton* button, ContactsContactPane* self);
static void __lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
ContactsMenuButton* contacts_menu_button_new (const gchar* label);
ContactsMenuButton* contacts_menu_button_construct (GType object_type, const gchar* label);
GType contacts_menu_button_get_type (void) G_GNUC_CONST;
static void _lambda18_ (GtkButton* button, ContactsContactPane* self);
static void __lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
void contacts_menu_button_set_menu (ContactsMenuButton* self, GtkMenu* menu);
static void contacts_contact_pane_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DetailsLayout* details_layout_construct (GType object_type, GtkGrid* fields_grid) {
	DetailsLayout * self = NULL;
	GtkGrid* _tmp0_;
	GtkSizeGroup* _tmp1_ = NULL;
	g_return_val_if_fail (fields_grid != NULL, NULL);
	self = (DetailsLayout*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (fields_grid);
	_g_object_unref0 (self->priv->fields_grid);
	self->priv->fields_grid = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->label_size_group);
	self->priv->label_size_group = _tmp1_;
	return self;
}


DetailsLayout* details_layout_new (GtkGrid* fields_grid) {
	return details_layout_construct (TYPE_DETAILS_LAYOUT, fields_grid);
}


static void details_layout_new_row (DetailsLayout* self) {
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* grid;
	GtkGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp0_);
	_tmp1_ = _g_object_ref0 (grid);
	_g_object_unref0 (self->current_row);
	self->current_row = _tmp1_;
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = NULL;
	gtk_grid_set_row_spacing (grid, (guint) 8);
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_container_add ((GtkContainer*) self->priv->fields_grid, (GtkWidget*) grid);
	_g_object_unref0 (grid);
}


void details_layout_add_widget_label (DetailsLayout* self, GtkWidget* w) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	details_layout_new_row (self);
	gtk_size_group_add_widget (self->priv->label_size_group, w);
	gtk_container_add ((GtkContainer*) self->current_row, w);
}


void details_layout_add_label (DetailsLayout* self, const gchar* label) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* l;
	GtkStyleContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	l = g_object_ref_sink (_tmp0_);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) l);
	gtk_style_context_add_class (_tmp1_, "dim-label");
	gtk_misc_set_alignment ((GtkMisc*) l, (gfloat) 1, 0.5f);
	details_layout_add_widget_label (self, (GtkWidget*) l);
	_g_object_unref0 (l);
}


void details_layout_add_detail (DetailsLayout* self, const gchar* val) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* label;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (val);
	label = g_object_ref_sink (_tmp0_);
	gtk_label_set_selectable (label, TRUE);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	if (self->priv->last_label != NULL) {
		gtk_grid_attach_next_to (self->current_row, (GtkWidget*) label, self->priv->last_label, GTK_POS_BOTTOM, 1, 1);
	} else {
		gtk_container_add ((GtkContainer*) self->current_row, (GtkWidget*) label);
	}
	gtk_widget_show ((GtkWidget*) label);
	_tmp1_ = _g_object_ref0 ((GtkWidget*) label);
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = _tmp1_;
	_g_object_unref0 (label);
}


void details_layout_add_label_detail (DetailsLayout* self, const gchar* label, const gchar* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (val != NULL);
	details_layout_add_label (self, label);
	details_layout_add_detail (self, val);
}


gboolean details_layout_add_string_property (DetailsLayout* self, const gchar* label, GObject* object, const gchar* pname) {
	gboolean result = FALSE;
	GValue prop_value = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* val;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (pname != NULL, FALSE);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
	prop_value = _tmp1_;
	g_object_get_property (object, pname, &prop_value);
	_tmp2_ = g_value_get_string (&prop_value);
	_tmp3_ = g_strdup (_tmp2_);
	val = _tmp3_;
	if (val == NULL) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp5_;
		_tmp5_ = strlen (val);
		_tmp4_ = _tmp5_ == 0;
	}
	if (_tmp4_) {
		result = FALSE;
		_g_free0 (val);
		G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
		return result;
	}
	details_layout_add_label_detail (self, label, val);
	result = TRUE;
	_g_free0 (val);
	G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
	return result;
}


void details_layout_add_link (DetailsLayout* self, const gchar* uri, const gchar* text) {
	GtkLinkButton* _tmp0_ = NULL;
	GtkLinkButton* v;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = (GtkLinkButton*) gtk_link_button_new_with_label (uri, text);
	v = g_object_ref_sink (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) v, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) v, GTK_ALIGN_START);
	gtk_widget_show ((GtkWidget*) v);
	if (self->priv->last_label != NULL) {
		gtk_grid_attach_next_to (self->current_row, (GtkWidget*) v, self->priv->last_label, GTK_POS_BOTTOM, 1, 1);
	} else {
		gtk_container_add ((GtkContainer*) self->current_row, (GtkWidget*) v);
	}
	_tmp1_ = _g_object_ref0 ((GtkWidget*) v);
	_g_object_unref0 (self->priv->last_label);
	self->priv->last_label = _tmp1_;
	_g_object_unref0 (v);
}


GtkButton* details_layout_add_button (DetailsLayout* self, const gchar* icon) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* button;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	button = g_object_ref_sink (_tmp0_);
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) button, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) button, TRUE);
	if (icon != NULL) {
		GtkImage* _tmp1_ = NULL;
		GtkImage* image;
		_tmp1_ = (GtkImage*) gtk_image_new ();
		image = g_object_ref_sink (_tmp1_);
		gtk_image_set_from_icon_name (image, icon, GTK_ICON_SIZE_MENU);
		gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
		gtk_widget_show ((GtkWidget*) image);
		_g_object_unref0 (image);
	}
	gtk_container_add ((GtkContainer*) self->current_row, (GtkWidget*) button);
	result = button;
	return result;
}


static void details_layout_class_init (DetailsLayoutClass * klass) {
	details_layout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DetailsLayoutPrivate));
	G_OBJECT_CLASS (klass)->finalize = details_layout_finalize;
}


static void details_layout_instance_init (DetailsLayout * self) {
	self->priv = DETAILS_LAYOUT_GET_PRIVATE (self);
}


static void details_layout_finalize (GObject* obj) {
	DetailsLayout * self;
	self = DETAILS_LAYOUT (obj);
	_g_object_unref0 (self->priv->fields_grid);
	_g_object_unref0 (self->priv->label_size_group);
	_g_object_unref0 (self->current_row);
	_g_object_unref0 (self->priv->last_label);
	G_OBJECT_CLASS (details_layout_parent_class)->finalize (obj);
}


GType details_layout_get_type (void) {
	static volatile gsize details_layout_type_id__volatile = 0;
	if (g_once_init_enter (&details_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DetailsLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) details_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DetailsLayout), 0, (GInstanceInitFunc) details_layout_instance_init, NULL };
		GType details_layout_type_id;
		details_layout_type_id = g_type_register_static (G_TYPE_OBJECT, "DetailsLayout", &g_define_type_info, 0);
		g_once_init_leave (&details_layout_type_id__volatile, details_layout_type_id);
	}
	return details_layout_type_id__volatile;
}


static GType contacts_contact_pane_display_mode_get_type (void) {
	static volatile gsize contacts_contact_pane_display_mode_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_pane_display_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_INITIAL", "initial"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY", "empty"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS", "details"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES", "notes"}, {CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT, "CONTACTS_CONTACT_PANE_DISPLAY_MODE_EDIT", "edit"}, {0, NULL, NULL}};
		GType contacts_contact_pane_display_mode_type_id;
		contacts_contact_pane_display_mode_type_id = g_enum_register_static ("ContactsContactPaneDisplayMode", values);
		g_once_init_leave (&contacts_contact_pane_display_mode_type_id__volatile, contacts_contact_pane_display_mode_type_id);
	}
	return contacts_contact_pane_display_mode_type_id__volatile;
}


static void contacts_contact_pane_display_card (ContactsContactPane* self, DetailsLayout* layout, ContactsContact* contact) {
	GtkFrame* _tmp0_ = NULL;
	GtkFrame* image_frame;
	GtkStyleContext* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkImage* image;
	GdkPixbuf* pixbuf;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* g;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* l;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* nick;
	gboolean _tmp23_ = FALSE;
	GtkWidget* _tmp30_ = NULL;
	GtkWidget* merged_presence;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = (GtkFrame*) gtk_frame_new (NULL);
	image_frame = g_object_ref_sink (_tmp0_);
	details_layout_add_widget_label (layout, (GtkWidget*) image_frame);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) image_frame);
	gtk_style_context_add_class (_tmp1_, "contact-frame");
	gtk_frame_set_shadow_type (image_frame, GTK_SHADOW_OUT);
	_tmp2_ = (GtkImage*) gtk_image_new ();
	image = g_object_ref_sink (_tmp2_);
	gtk_widget_set_size_request ((GtkWidget*) image, 100, 100);
	gtk_container_add ((GtkContainer*) image_frame, (GtkWidget*) image);
	pixbuf = NULL;
	_tmp4_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) contact->individual);
	if (_tmp4_ != NULL) {
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) contact->individual);
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
		_g_free0 (_tmp7_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		{
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp8_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) contact->individual);
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gdk_pixbuf_new_from_file_at_scale (_tmp10_, 100, 100, TRUE, &_inner_error_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			_tmp13_ = _tmp12_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp13_;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (image);
			_g_object_unref0 (image_frame);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (pixbuf == NULL) {
	}
	if (pixbuf != NULL) {
		gtk_image_set_from_pixbuf (image, pixbuf);
	}
	gtk_widget_set_vexpand ((GtkWidget*) layout->current_row, FALSE);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	g = g_object_ref_sink (_tmp14_);
	gtk_container_add ((GtkContainer*) layout->current_row, (GtkWidget*) g);
	_tmp15_ = (GtkLabel*) gtk_label_new (NULL);
	l = g_object_ref_sink (_tmp15_);
	_tmp16_ = contacts_contact_get_display_name (contact);
	_tmp17_ = g_strconcat ("<big><b>", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "</b></big>", NULL);
	_tmp20_ = _tmp19_;
	gtk_label_set_markup (l, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	gtk_widget_set_hexpand ((GtkWidget*) l, TRUE);
	gtk_widget_set_halign ((GtkWidget*) l, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) l, GTK_ALIGN_START);
	gtk_grid_attach (g, (GtkWidget*) l, 0, 0, 1, 1);
	_tmp21_ = folks_name_details_get_nickname ((FolksNameDetails*) contact->individual);
	_tmp22_ = g_strdup (_tmp21_);
	nick = _tmp22_;
	if (nick != NULL) {
		gint _tmp24_;
		_tmp24_ = strlen (nick);
		_tmp23_ = _tmp24_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GtkLabel* _tmp29_ = NULL;
		_tmp25_ = g_strconcat ("\xE2\x80\x9C", nick, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp26_, "\xE2\x80\x9D", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = (GtkLabel*) gtk_label_new (_tmp28_);
		_g_object_unref0 (l);
		l = g_object_ref_sink (_tmp29_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		gtk_widget_set_halign ((GtkWidget*) l, GTK_ALIGN_START);
		gtk_widget_set_valign ((GtkWidget*) l, GTK_ALIGN_START);
		gtk_grid_attach (g, (GtkWidget*) l, 0, 1, 1, 1);
	}
	_tmp30_ = contacts_contact_create_merged_presence_widget (contact);
	merged_presence = _tmp30_;
	gtk_widget_set_halign (merged_presence, GTK_ALIGN_START);
	gtk_widget_set_valign (merged_presence, GTK_ALIGN_END);
	gtk_widget_set_vexpand (merged_presence, TRUE);
	gtk_grid_attach (g, merged_presence, 0, 3, 1, 1);
	_g_object_unref0 (merged_presence);
	_g_free0 (nick);
	_g_object_unref0 (l);
	_g_object_unref0 (g);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (image);
	_g_object_unref0 (image_frame);
}


static void contacts_contact_pane_display_notes (ContactsContactPane* self) {
	DetailsLayout* _tmp0_ = NULL;
	DetailsLayout* layout;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* scrolled;
	GtkTextView* _tmp2_ = NULL;
	GtkTextView* text;
	gboolean first;
	gint i;
	g_return_if_fail (self != NULL);
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_NOTES);
	_tmp0_ = details_layout_new (self->priv->fields_grid);
	layout = _tmp0_;
	contacts_contact_pane_display_card (self, layout, self->priv->selected_contact);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scrolled = g_object_ref_sink (_tmp1_);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_OUT);
	_tmp2_ = (GtkTextView*) gtk_text_view_new ();
	text = g_object_ref_sink (_tmp2_);
	gtk_widget_set_hexpand ((GtkWidget*) text, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) text, TRUE);
	gtk_scrolled_window_add_with_viewport (scrolled, (GtkWidget*) text);
	gtk_grid_attach (self->priv->fields_grid, (GtkWidget*) scrolled, 0, 1, 1, 1);
	first = TRUE;
	i = 2;
	{
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _note_it;
		_tmp3_ = folks_note_details_get_notes ((FolksNoteDetails*) self->priv->selected_contact->individual);
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_note_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			FolksNote* note;
			_tmp5_ = gee_iterator_next (_note_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_note_it);
			note = (FolksNote*) _tmp6_;
			if (first) {
				GtkTextBuffer* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp7_ = gtk_text_view_get_buffer (text);
				_tmp8_ = folks_note_get_content (note);
				gtk_text_buffer_set_text (_tmp7_, _tmp8_, -1);
				first = FALSE;
			} else {
				const gchar* _tmp9_ = NULL;
				GtkLabel* _tmp10_ = NULL;
				GtkLabel* label;
				gint _tmp11_;
				_tmp9_ = folks_note_get_content (note);
				_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
				label = g_object_ref_sink (_tmp10_);
				gtk_widget_show ((GtkWidget*) label);
				gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
				_tmp11_ = i;
				i = _tmp11_ + 1;
				gtk_grid_attach (self->priv->fields_grid, (GtkWidget*) label, 0, _tmp11_, 1, 1);
				_g_object_unref0 (label);
			}
			_g_object_unref0 (note);
		}
		_g_object_unref0 (_note_it);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_g_object_unref0 (text);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (layout);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->contact);
		g_slice_free (Block3Data, _data3_);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		_g_free0 (_data4_->email_addr);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda14_ (Block4Data* _data4_) {
	Block3Data* _data3_;
	ContactsContactPane * self;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	contacts_utils_compose_mail (_data4_->email_addr);
}


static void __lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda14_ (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block3_data_unref (_data5_->_data3_);
		_data5_->_data3_ = NULL;
		_g_free0 (_data5_->protocol);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		_g_free0 (_data6_->id);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda15_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	Block3Data* _data3_;
	ContactsContactPane * self;
	_data5_ = _data6_->_data5_;
	_data3_ = _data5_->_data3_;
	self = _data3_->self;
	contacts_utils_start_chat (_data3_->contact, _data5_->protocol, _data6_->id);
}


static void __lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda15_ (self);
}


static void contacts_contact_pane_display_contact (ContactsContactPane* self, ContactsContact* contact) {
	Block3Data* _data3_;
	DetailsLayout* _tmp0_ = NULL;
	DetailsLayout* layout;
	GeeSet* _tmp1_ = NULL;
	gboolean _tmp2_;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_;
	GeeSet* emails;
	gboolean _tmp5_;
	GeeMultiMap* _tmp13_ = NULL;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* ims;
	GeeSet* _tmp15_ = NULL;
	GeeSet* im_keys;
	gboolean _tmp16_;
	GeeSet* _tmp31_ = NULL;
	GeeSet* _tmp32_;
	GeeSet* phone_numbers;
	gboolean _tmp33_;
	GeeSet* _tmp38_ = NULL;
	GeeSet* _tmp39_;
	GeeSet* postals;
	gboolean _tmp40_;
	const gchar* _tmp55_ = NULL;
	GeeSet* _tmp56_ = NULL;
	GeeSet* _tmp57_;
	GeeSet* urls;
	gboolean _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->contact = _g_object_ref0 (contact);
	_tmp0_ = details_layout_new (self->priv->fields_grid);
	layout = _tmp0_;
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS);
	_tmp1_ = folks_note_details_get_notes ((FolksNoteDetails*) _data3_->contact->individual);
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	contacts_contact_pane_set_has_notes (self, !_tmp2_);
	contacts_contact_pane_display_card (self, layout, _data3_->contact);
	_tmp3_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _data3_->contact->individual);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	emails = _tmp4_;
	_tmp5_ = gee_collection_get_is_empty ((GeeCollection*) emails);
	if (!_tmp5_) {
		GList* _tmp6_ = NULL;
		_tmp6_ = contacts_contact_sort_fields (emails);
		{
			GList* email_collection = NULL;
			GList* email_it = NULL;
			email_collection = _tmp6_;
			for (email_it = email_collection; email_it != NULL; email_it = email_it->next) {
				FolksFieldDetails* _tmp7_;
				FolksFieldDetails* email = NULL;
				_tmp7_ = _g_object_ref0 ((FolksFieldDetails*) email_it->data);
				email = _tmp7_;
				{
					Block4Data* _data4_;
					gchar* _tmp8_ = NULL;
					gchar* type;
					const gchar* _tmp9_ = NULL;
					GtkButton* _tmp10_ = NULL;
					GtkButton* button;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					_data4_ = g_slice_new0 (Block4Data);
					_data4_->_ref_count_ = 1;
					_data4_->_data3_ = block3_data_ref (_data3_);
					_tmp8_ = contacts_contact_format_email_type (email);
					type = _tmp8_;
					_tmp9_ = folks_field_details_get_value (email);
					details_layout_add_label_detail (layout, type, _tmp9_);
					_tmp10_ = details_layout_add_button (layout, "mail-unread-symbolic");
					button = _tmp10_;
					_tmp11_ = folks_field_details_get_value (email);
					_tmp12_ = g_strdup (_tmp11_);
					_data4_->email_addr = _tmp12_;
					g_signal_connect_data (button, "clicked", (GCallback) __lambda14__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
					_g_object_unref0 (button);
					_g_free0 (type);
					_g_object_unref0 (email);
					block4_data_unref (_data4_);
					_data4_ = NULL;
				}
			}
			__g_list_free__g_object_unref0_0 (email_collection);
		}
	}
	_tmp13_ = folks_im_details_get_im_addresses ((FolksImDetails*) _data3_->contact->individual);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	ims = _tmp14_;
	_tmp15_ = gee_multi_map_get_keys (ims);
	im_keys = _tmp15_;
	_tmp16_ = gee_collection_get_is_empty ((GeeCollection*) im_keys);
	if (!_tmp16_) {
		{
			GeeIterator* _tmp17_ = NULL;
			GeeIterator* _protocol_it;
			_tmp17_ = gee_iterable_iterator ((GeeIterable*) im_keys);
			_protocol_it = _tmp17_;
			while (TRUE) {
				Block5Data* _data5_;
				gboolean _tmp18_;
				gpointer _tmp19_ = NULL;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_data5_->_data3_ = block3_data_ref (_data3_);
				_tmp18_ = gee_iterator_next (_protocol_it);
				if (!_tmp18_) {
					block5_data_unref (_data5_);
					_data5_ = NULL;
					break;
				}
				_tmp19_ = gee_iterator_get (_protocol_it);
				_data5_->protocol = (gchar*) _tmp19_;
				{
					GeeCollection* _tmp20_ = NULL;
					GeeCollection* _tmp21_;
					GeeIterator* _tmp22_ = NULL;
					GeeIterator* _tmp23_;
					GeeIterator* _id_it;
					_tmp20_ = gee_multi_map_get (ims, _data5_->protocol);
					_tmp21_ = _tmp20_;
					_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
					_tmp23_ = _tmp22_;
					_g_object_unref0 (_tmp21_);
					_id_it = _tmp23_;
					while (TRUE) {
						Block6Data* _data6_;
						gboolean _tmp24_;
						gpointer _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_;
						GtkButton* button;
						GtkWidget* _tmp29_ = NULL;
						GtkWidget* presence;
						_data6_ = g_slice_new0 (Block6Data);
						_data6_->_ref_count_ = 1;
						_data6_->_data5_ = block5_data_ref (_data5_);
						_tmp24_ = gee_iterator_next (_id_it);
						if (!_tmp24_) {
							block6_data_unref (_data6_);
							_data6_ = NULL;
							break;
						}
						_tmp25_ = gee_iterator_get (_id_it);
						_data6_->id = (gchar*) _tmp25_;
						_tmp26_ = _ ("Chat");
						_tmp27_ = contacts_contact_format_im_name (_data3_->contact, _data5_->protocol, _data6_->id);
						_tmp28_ = _tmp27_;
						details_layout_add_label_detail (layout, _tmp26_, _tmp28_);
						_g_free0 (_tmp28_);
						button = NULL;
						_tmp29_ = contacts_contact_create_presence_widget (_data3_->contact, _data5_->protocol, _data6_->id);
						presence = _tmp29_;
						if (presence != NULL) {
							GtkButton* _tmp30_ = NULL;
							_tmp30_ = details_layout_add_button (layout, NULL);
							_g_object_unref0 (button);
							button = _tmp30_;
							gtk_container_add ((GtkContainer*) button, presence);
						}
						if (button != NULL) {
							g_signal_connect_data (button, "clicked", (GCallback) __lambda15__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
						}
						_g_object_unref0 (presence);
						_g_object_unref0 (button);
						block6_data_unref (_data6_);
						_data6_ = NULL;
					}
					_g_object_unref0 (_id_it);
				}
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
			_g_object_unref0 (_protocol_it);
		}
	}
	_tmp31_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _data3_->contact->individual);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	phone_numbers = _tmp32_;
	_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) phone_numbers);
	if (!_tmp33_) {
		GList* _tmp34_ = NULL;
		_tmp34_ = contacts_contact_sort_fields (phone_numbers);
		{
			GList* p_collection = NULL;
			GList* p_it = NULL;
			p_collection = _tmp34_;
			for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
				FolksFieldDetails* _tmp35_;
				FolksFieldDetails* p = NULL;
				_tmp35_ = _g_object_ref0 ((FolksFieldDetails*) p_it->data);
				p = _tmp35_;
				{
					gchar* _tmp36_ = NULL;
					gchar* type;
					const gchar* _tmp37_ = NULL;
					_tmp36_ = contacts_contact_format_phone_type (p);
					type = _tmp36_;
					_tmp37_ = folks_field_details_get_value (p);
					details_layout_add_label_detail (layout, type, _tmp37_);
					_g_free0 (type);
					_g_object_unref0 (p);
				}
			}
			__g_list_free__g_object_unref0_0 (p_collection);
		}
	}
	_tmp38_ = folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) _data3_->contact->individual);
	_tmp39_ = _g_object_ref0 (_tmp38_);
	postals = _tmp39_;
	_tmp40_ = gee_collection_get_is_empty ((GeeCollection*) postals);
	if (!_tmp40_) {
		{
			GeeIterator* _tmp41_ = NULL;
			GeeIterator* _addr_it;
			_tmp41_ = gee_iterable_iterator ((GeeIterable*) postals);
			_addr_it = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_;
				gpointer _tmp43_ = NULL;
				FolksPostalAddress* addr;
				gchar* _tmp44_;
				gchar* type;
				GeeSet* _tmp45_ = NULL;
				GeeSet* _tmp46_;
				GeeSet* types;
				gint _tmp52_;
				gchar** _tmp53_ = NULL;
				gchar** strs;
				gint strs_length1;
				gint _strs_size_;
				_tmp42_ = gee_iterator_next (_addr_it);
				if (!_tmp42_) {
					break;
				}
				_tmp43_ = gee_iterator_get (_addr_it);
				addr = (FolksPostalAddress*) _tmp43_;
				_tmp44_ = g_strdup ("");
				type = _tmp44_;
				_tmp45_ = folks_postal_address_get_types (addr);
				_tmp46_ = _g_object_ref0 (_tmp45_);
				types = _tmp46_;
				if (types != NULL) {
					GeeIterator* _tmp47_ = NULL;
					GeeIterator* i;
					gboolean _tmp48_;
					_tmp47_ = gee_iterable_iterator ((GeeIterable*) types);
					i = _tmp47_;
					_tmp48_ = gee_iterator_next (i);
					if (_tmp48_) {
						gpointer _tmp49_ = NULL;
						gchar* _tmp50_;
						gchar* _tmp51_;
						_tmp49_ = gee_iterator_get (i);
						_tmp50_ = (gchar*) _tmp49_;
						_tmp51_ = g_strconcat (type, _tmp50_, NULL);
						_g_free0 (type);
						type = _tmp51_;
						_g_free0 (_tmp50_);
					}
					_g_object_unref0 (i);
				}
				_tmp53_ = contacts_contact_format_address (addr, &_tmp52_);
				strs = _tmp53_;
				strs_length1 = _tmp52_;
				_strs_size_ = strs_length1;
				if (strs_length1 > 0) {
					details_layout_add_label (layout, type);
					{
						gchar** s_collection = NULL;
						gint s_collection_length1 = 0;
						gint _s_collection_size_ = 0;
						gint s_it;
						s_collection = strs;
						s_collection_length1 = strs_length1;
						for (s_it = 0; s_it < strs_length1; s_it = s_it + 1) {
							gchar* _tmp54_;
							gchar* s = NULL;
							_tmp54_ = g_strdup (s_collection[s_it]);
							s = _tmp54_;
							{
								details_layout_add_detail (layout, s);
								_g_free0 (s);
							}
						}
					}
				}
				strs = (_vala_array_free (strs, strs_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (types);
				_g_free0 (type);
				_g_object_unref0 (addr);
			}
			_g_object_unref0 (_addr_it);
		}
	}
	_tmp55_ = _ ("Alias");
	details_layout_add_string_property (layout, _tmp55_, (GObject*) _data3_->contact->individual, "alias");
	_tmp56_ = folks_url_details_get_urls ((FolksUrlDetails*) _data3_->contact->individual);
	_tmp57_ = _g_object_ref0 (_tmp56_);
	urls = _tmp57_;
	_tmp58_ = gee_collection_get_is_empty ((GeeCollection*) urls);
	if (!_tmp58_) {
		details_layout_add_label (layout, "Links");
		{
			GeeIterator* _tmp59_ = NULL;
			GeeIterator* _url_details_it;
			_tmp59_ = gee_iterable_iterator ((GeeIterable*) urls);
			_url_details_it = _tmp59_;
			while (TRUE) {
				gboolean _tmp60_;
				gpointer _tmp61_ = NULL;
				FolksFieldDetails* url_details;
				const gchar* _tmp62_ = NULL;
				gchar* _tmp63_;
				gchar* url;
				_tmp60_ = gee_iterator_next (_url_details_it);
				if (!_tmp60_) {
					break;
				}
				_tmp61_ = gee_iterator_get (_url_details_it);
				url_details = (FolksFieldDetails*) _tmp61_;
				_tmp62_ = folks_field_details_get_value (url_details);
				_tmp63_ = g_strdup (_tmp62_);
				url = _tmp63_;
				details_layout_add_link (layout, url, url);
				_g_free0 (url);
				_g_object_unref0 (url_details);
			}
			_g_object_unref0 (_url_details_it);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->fields_grid);
	_g_object_unref0 (urls);
	_g_object_unref0 (postals);
	_g_object_unref0 (phone_numbers);
	_g_object_unref0 (im_keys);
	_g_object_unref0 (ims);
	_g_object_unref0 (emails);
	_g_object_unref0 (layout);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void contacts_contact_pane_set_has_notes (ContactsContactPane* self, gboolean has_notes) {
	g_return_if_fail (self != NULL);
	self->priv->has_notes = has_notes;
	gtk_widget_queue_draw (self->priv->notes_dot);
}


static void contacts_contact_pane_selected_contact_changed (ContactsContactPane* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->display_mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS) {
		contacts_contact_pane_display_contact (self, self->priv->selected_contact);
	}
}


static void contacts_contact_pane_set_display_mode (ContactsContactPane* self, ContactsContactPaneDisplayMode mode) {
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->display_mode == mode) {
		return;
	}
	self->priv->display_mode = mode;
	if (mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = mode == CONTACTS_CONTACT_PANE_DISPLAY_MODE_DETAILS;
	}
	if (_tmp0_) {
		gtk_widget_show ((GtkWidget*) self->priv->normal_buttons);
		gtk_widget_hide ((GtkWidget*) self->priv->editing_buttons);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->normal_buttons, mode != CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->normal_buttons);
		gtk_widget_show ((GtkWidget*) self->priv->editing_buttons);
	}
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self->priv->fields_grid);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				gtk_widget_destroy (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


static void _contacts_contact_pane_selected_contact_changed_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_contact_pane_selected_contact_changed (self);
}


void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact) {
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->selected_contact != NULL) {
		guint _tmp0_;
		g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->selected_contact, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _contacts_contact_pane_selected_contact_changed_contacts_contact_changed, self);
	}
	_tmp1_ = _g_object_ref0 (new_contact);
	_g_object_unref0 (self->priv->selected_contact);
	self->priv->selected_contact = _tmp1_;
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	contacts_contact_pane_set_has_notes (self, FALSE);
	if (self->priv->selected_contact != NULL) {
		contacts_contact_pane_display_contact (self, self->priv->selected_contact);
		g_signal_connect_object (self->priv->selected_contact, "changed", (GCallback) _contacts_contact_pane_selected_contact_changed_contacts_contact_changed, self, 0);
	}
}


static gboolean _lambda16_ (GtkWidget* widget, cairo_t* cr, ContactsContactPane* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	if (self->priv->has_notes) {
		GdkRGBA color = {0};
		GtkStyleContext* _tmp0_ = NULL;
		GdkRGBA _tmp1_ = {0};
		GdkRGBA _tmp2_ = {0};
		cairo_arc (cr, (gdouble) 3, (gdouble) (3 + 2), (gdouble) 3, (gdouble) 0, 2 * G_PI);
		_tmp0_ = gtk_widget_get_style_context (widget);
		gtk_style_context_get_color (_tmp0_, 0, &_tmp1_);
		_tmp2_ = _tmp1_;
		color = _tmp2_;
		gdk_cairo_set_source_rgba (cr, &color);
		cairo_fill (cr);
	}
	result = TRUE;
	return result;
}


static gboolean __lambda16__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = _lambda16_ (_sender, cr, self);
	return result;
}


static void _lambda17_ (GtkButton* button, ContactsContactPane* self) {
	g_return_if_fail (button != NULL);
	contacts_contact_pane_display_notes (self);
}


static void __lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda17_ (_sender, self);
}


static void _lambda18_ (GtkButton* button, ContactsContactPane* self) {
	g_return_if_fail (button != NULL);
	contacts_contact_pane_display_contact (self, self->priv->selected_contact);
}


static void __lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda18_ (_sender, self);
}


ContactsContactPane* contacts_contact_pane_construct (GType object_type) {
	ContactsContactPane * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* grid;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* fields_scrolled;
	GtkGrid* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkButtonBox* _tmp6_ = NULL;
	GtkButtonBox* bbox;
	GtkButtonBox* _tmp7_;
	GtkButton* _tmp8_ = NULL;
	GtkButton* notes_button;
	GtkGrid* _tmp9_ = NULL;
	GtkGrid* notes_grid;
	const gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* label;
	GtkDrawingArea* _tmp12_ = NULL;
	GtkDrawingArea* a;
	GtkDrawingArea* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* button;
	const gchar* _tmp16_ = NULL;
	ContactsMenuButton* _tmp17_ = NULL;
	ContactsMenuButton* menu_button;
	GtkButtonBox* _tmp18_ = NULL;
	GtkButtonBox* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkMenu* _tmp22_ = NULL;
	GtkMenu* menu;
	const gchar* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_ = NULL;
	GtkMenuItem* mi;
	const gchar* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	self = (ContactsContactPane*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "contact-pane");
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 10);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	fields_scrolled = g_object_ref_sink (_tmp2_);
	gtk_widget_set_hexpand ((GtkWidget*) fields_scrolled, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) fields_scrolled, TRUE);
	gtk_scrolled_window_set_policy (fields_scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (self->priv->fields_grid);
	self->priv->fields_grid = g_object_ref_sink (_tmp3_);
	gtk_grid_set_column_spacing (self->priv->fields_grid, (guint) 3);
	gtk_orientable_set_orientation ((GtkOrientable*) self->priv->fields_grid, GTK_ORIENTATION_VERTICAL);
	gtk_scrolled_window_add_with_viewport (fields_scrolled, (GtkWidget*) self->priv->fields_grid);
	_tmp4_ = gtk_bin_get_child ((GtkBin*) fields_scrolled);
	_tmp5_ = gtk_widget_get_style_context (_tmp4_);
	gtk_style_context_add_class (_tmp5_, "contact-pane");
	gtk_grid_attach (grid, (GtkWidget*) fields_scrolled, 0, 1, 1, 1);
	_tmp6_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	bbox = g_object_ref_sink (_tmp6_);
	_tmp7_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->normal_buttons);
	self->priv->normal_buttons = _tmp7_;
	gtk_box_set_spacing ((GtkBox*) bbox, 5);
	gtk_widget_set_margin_top ((GtkWidget*) bbox, 8);
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_START);
	gtk_grid_attach (grid, (GtkWidget*) bbox, 0, 2, 1, 1);
	_tmp8_ = (GtkButton*) gtk_button_new ();
	notes_button = g_object_ref_sink (_tmp8_);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	notes_grid = g_object_ref_sink (_tmp9_);
	_tmp10_ = _ ("Notes");
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	label = g_object_ref_sink (_tmp11_);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	_tmp12_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	a = g_object_ref_sink (_tmp12_);
	gtk_widget_set_size_request ((GtkWidget*) a, 6, -1);
	gtk_widget_set_has_window ((GtkWidget*) a, FALSE);
	gtk_container_add ((GtkContainer*) notes_grid, (GtkWidget*) a);
	gtk_container_add ((GtkContainer*) notes_grid, (GtkWidget*) label);
	_tmp13_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	_g_object_unref0 (self->priv->notes_dot);
	self->priv->notes_dot = (GtkWidget*) g_object_ref_sink (_tmp13_);
	gtk_widget_set_has_window (self->priv->notes_dot, FALSE);
	gtk_widget_set_size_request (self->priv->notes_dot, 6, -1);
	g_signal_connect_object (self->priv->notes_dot, "draw", (GCallback) __lambda16__gtk_widget_draw, self, 0);
	gtk_container_add ((GtkContainer*) notes_grid, self->priv->notes_dot);
	gtk_container_add ((GtkContainer*) notes_button, (GtkWidget*) notes_grid);
	g_signal_connect_object (notes_button, "clicked", (GCallback) __lambda17__gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) notes_button, FALSE, FALSE, (guint) 0);
	_tmp14_ = _ ("Edit");
	_tmp15_ = (GtkButton*) gtk_button_new_with_label (_tmp14_);
	button = g_object_ref_sink (_tmp15_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	_tmp16_ = _ ("More");
	_tmp17_ = contacts_menu_button_new (_tmp16_);
	menu_button = g_object_ref_sink (_tmp17_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) menu_button, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) bbox);
	gtk_widget_set_no_show_all ((GtkWidget*) bbox, TRUE);
	_tmp18_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	_g_object_unref0 (bbox);
	bbox = g_object_ref_sink (_tmp18_);
	_tmp19_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->editing_buttons);
	self->priv->editing_buttons = _tmp19_;
	gtk_box_set_spacing ((GtkBox*) bbox, 5);
	gtk_widget_set_margin_top ((GtkWidget*) bbox, 8);
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_END);
	gtk_grid_attach (grid, (GtkWidget*) bbox, 0, 3, 1, 1);
	_tmp20_ = _ ("Close");
	_tmp21_ = (GtkButton*) gtk_button_new_with_label (_tmp20_);
	_g_object_unref0 (button);
	button = g_object_ref_sink (_tmp21_);
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) __lambda18__gtk_button_clicked, self, 0);
	_tmp22_ = (GtkMenu*) gtk_menu_new ();
	menu = g_object_ref_sink (_tmp22_);
	_tmp23_ = _ ("Add/Remove linked contacts...");
	_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp23_);
	mi = g_object_ref_sink (_tmp24_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	_tmp25_ = _ ("Send...");
	_tmp26_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp25_);
	_g_object_unref0 (mi);
	mi = g_object_ref_sink (_tmp26_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	_tmp27_ = _ ("Delete");
	_tmp28_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp27_);
	_g_object_unref0 (mi);
	mi = g_object_ref_sink (_tmp28_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	contacts_menu_button_set_menu (menu_button, menu);
	gtk_widget_show_all ((GtkWidget*) bbox);
	gtk_widget_set_no_show_all ((GtkWidget*) bbox, TRUE);
	gtk_widget_show_all ((GtkWidget*) grid);
	contacts_contact_pane_set_display_mode (self, CONTACTS_CONTACT_PANE_DISPLAY_MODE_EMPTY);
	contacts_contact_pane_set_has_notes (self, FALSE);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
	_g_object_unref0 (menu_button);
	_g_object_unref0 (button);
	_g_object_unref0 (a);
	_g_object_unref0 (label);
	_g_object_unref0 (notes_grid);
	_g_object_unref0 (notes_button);
	_g_object_unref0 (bbox);
	_g_object_unref0 (fields_scrolled);
	_g_object_unref0 (grid);
	return self;
}


ContactsContactPane* contacts_contact_pane_new (void) {
	return contacts_contact_pane_construct (CONTACTS_TYPE_CONTACT_PANE);
}


static void contacts_contact_pane_class_init (ContactsContactPaneClass * klass) {
	contacts_contact_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPanePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_pane_finalize;
}


static void contacts_contact_pane_instance_init (ContactsContactPane * self) {
	self->priv = CONTACTS_CONTACT_PANE_GET_PRIVATE (self);
}


static void contacts_contact_pane_finalize (GObject* obj) {
	ContactsContactPane * self;
	self = CONTACTS_CONTACT_PANE (obj);
	_g_object_unref0 (self->priv->selected_contact);
	_g_object_unref0 (self->priv->fields_grid);
	_g_object_unref0 (self->priv->notes_dot);
	_g_object_unref0 (self->priv->normal_buttons);
	_g_object_unref0 (self->priv->editing_buttons);
	G_OBJECT_CLASS (contacts_contact_pane_parent_class)->finalize (obj);
}


GType contacts_contact_pane_get_type (void) {
	static volatile gsize contacts_contact_pane_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPane), 0, (GInstanceInitFunc) contacts_contact_pane_instance_init, NULL };
		GType contacts_contact_pane_type_id;
		contacts_contact_pane_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ContactsContactPane", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_pane_type_id__volatile, contacts_contact_pane_type_id);
	}
	return contacts_contact_pane_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



