/* contacts-contact.c generated by valac 0.12.0.305-a4eb, the Vala compiler
 * generated from contacts-contact.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <config.h>
#include <folks/folks-telepathy.h>
#include <telepathy-glib/telepathy-glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_CONTACT_TYPE_PHONE_DATA (contacts_contact_phone_data_get_type ())
typedef struct _ContactsContactPhoneData ContactsContactPhoneData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CONTACTS_CONTACT_TYPE_EMAIL_DATA (contacts_contact_email_data_get_type ())
typedef struct _ContactsContactEmailData ContactsContactEmailData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CONTACTS_CONTACT_TYPE_IM_DATA (contacts_contact_im_data_get_type ())
typedef struct _ContactsContactImData ContactsContactImData;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _ContactsContactPrivate {
	guint changed_id;
	GdkPixbuf* _avatar;
	gchar* filter_data;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _ContactsContactPhoneData {
	const gchar* display_name;
	const gchar* types[2];
};

struct _ContactsContactEmailData {
	const gchar* display_name;
	const gchar* types[2];
};

struct _ContactsContactImData {
	const gchar* service;
	const gchar* display_name;
	ContactsContactImDisplay display;
};

struct _Block1Data {
	int _ref_count_;
	ContactsContact * self;
	GtkImage* image;
	GtkLabel* label;
	gulong id1;
	gulong id2;
};

struct _Block2Data {
	int _ref_count_;
	ContactsContact * self;
	TpfPersona* tp;
	GtkImage* i;
	gulong id1;
	gulong id2;
};


static gpointer contacts_contact_parent_class = NULL;
static GdkPixbuf* contacts_contact_fallback_avatar;
static GdkPixbuf* contacts_contact_fallback_avatar = NULL;
static GHashTable* contacts_contact_phone_types_hash;
static GHashTable* contacts_contact_phone_types_hash = NULL;
static GHashTable* contacts_contact_email_types_hash;
static GHashTable* contacts_contact_email_types_hash = NULL;

GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT, ContactsContactPrivate))
enum  {
	CONTACTS_CONTACT_DUMMY_PROPERTY,
	CONTACTS_CONTACT_AVATAR,
	CONTACTS_CONTACT_DISPLAY_NAME
};
static GType contacts_contact_im_display_get_type (void) G_GNUC_UNUSED;
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
ContactsContact* contacts_contact_new (FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, FolksIndividual* i);
static void contacts_contact_update (ContactsContact* self);
static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void contacts_contact_remove (ContactsContact* self);
static void contacts_contact_unqueue_changed (ContactsContact* self);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
gchar* contacts_contact_presence_to_string (FolksPresenceType presence);
gchar* contacts_contact_presence_to_icon (FolksPresenceType presence);
gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence);
static gchar* contacts_contact_get_first_string (GeeCollection* collection);
static gint contacts_contact_get_first_string_as_int (GeeCollection* collection);
gchar* contacts_contact_format_phone_type (FolksFieldDetails* detail);
static GType contacts_contact_phone_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactPhoneData* contacts_contact_phone_data_dup (const ContactsContactPhoneData* self);
static void contacts_contact_phone_data_free (ContactsContactPhoneData* self);
static void _g_list_free0_ (gpointer var);
gchar* contacts_contact_format_email_type (FolksFieldDetails* detail);
static GType contacts_contact_email_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactEmailData* contacts_contact_email_data_dup (const ContactsContactEmailData* self);
static void contacts_contact_email_data_free (ContactsContactEmailData* self);
GList* contacts_contact_sort_fields (GeeSet* details);
static gint _lambda0_ (FolksFieldDetails* a, FolksFieldDetails* b);
static gint __lambda0__gcompare_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id);
static GType contacts_contact_im_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self);
static void contacts_contact_im_data_free (ContactsContactImData* self);
static void contacts_contact_update_presence_widgets (ContactsContact* self, GtkImage* image, GtkLabel* label);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda1_ (GParamSpec* pspec, Block1Data* _data1_);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda2_ (GParamSpec* pspec, Block1Data* _data1_);
static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda3_ (Block1Data* _data1_);
static void __lambda3__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda4_ (GParamSpec* pspec, Block2Data* _data2_);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda5_ (GParamSpec* pspec, Block2Data* _data2_);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda6_ (Block2Data* _data2_);
static void __lambda6__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean contacts_contact_changed_cb (ContactsContact* self);
static void contacts_contact_queue_changed (ContactsContact* self);
static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self);
static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GFile* file);
static void contacts_contact_round_rect (cairo_t* cr, gint x, gint y, gint w, gint h, gint r);
static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon);
static GdkPixbuf* contacts_contact_draw_fallback_avatar (void);
GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void contacts_contact_finalize (GObject* obj);
static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType contacts_contact_im_display_get_type (void) {
	static volatile gsize contacts_contact_im_display_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_display_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_IM_DISPLAY_DEFAULT, "CONTACTS_CONTACT_IM_DISPLAY_DEFAULT", "default"}, {CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE, "CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE", "alias-service"}, {0, NULL, NULL}};
		GType contacts_contact_im_display_type_id;
		contacts_contact_im_display_type_id = g_enum_register_static ("ContactsContactImDisplay", values);
		g_once_init_leave (&contacts_contact_im_display_type_id__volatile, contacts_contact_im_display_type_id);
	}
	return contacts_contact_im_display_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ContactsContact* contacts_contact_from_individual (FolksIndividual* i) {
	ContactsContact* result = NULL;
	gconstpointer _tmp0_ = NULL;
	ContactsContact* _tmp1_;
	g_return_val_if_fail (i != NULL, NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "contact");
	_tmp1_ = _g_object_ref0 ((ContactsContact*) _tmp0_);
	result = _tmp1_;
	return result;
}


static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_notify_cb (self, pspec);
}


ContactsContact* contacts_contact_construct (GType object_type, FolksIndividual* i) {
	ContactsContact * self = NULL;
	FolksIndividual* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_val_if_fail (i != NULL, NULL);
	self = (ContactsContact*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (i);
	_g_object_unref0 (self->individual);
	self->individual = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) self->individual, "contact", _tmp1_, g_object_unref);
	contacts_contact_update (self);
	g_signal_connect_object ((GObject*) self->individual, "notify", (GCallback) _contacts_contact_notify_cb_g_object_notify, self, 0);
	return self;
}


ContactsContact* contacts_contact_new (FolksIndividual* i) {
	return contacts_contact_construct (CONTACTS_TYPE_CONTACT, i);
}


void contacts_contact_remove (ContactsContact* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	contacts_contact_unqueue_changed (self);
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self->individual, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _contacts_contact_notify_cb_g_object_notify, self);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it;
		i_collection = strings;
		i_collection_length1 = strings_length1;
		for (i_it = 0; i_it < strings_length1; i_it = i_it + 1) {
			gchar* _tmp0_;
			gchar* i = NULL;
			_tmp0_ = g_strdup (i_collection[i_it]);
			i = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = string_contains (self->priv->filter_data, i);
				if (!_tmp1_) {
					result = FALSE;
					_g_free0 (i);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* contacts_contact_presence_to_string (FolksPresenceType presence) {
	gchar* result = NULL;
	switch (presence) {
		default:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("Unknown status");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("Offline");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_UNSET:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("Error");
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = _ ("Availible");
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("Away");
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("Extended away");
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = _ ("Busy");
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = _ ("Hidden");
			_tmp16_ = g_strdup (_tmp15_);
			result = _tmp16_;
			return result;
		}
	}
}


gchar* contacts_contact_presence_to_icon (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* iconname;
	iconname = NULL;
	switch (presence) {
		default:
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		case FOLKS_PRESENCE_TYPE_UNSET:
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			break;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("user-available-symbolic");
			_g_free0 (iconname);
			iconname = _tmp0_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("user-away-symbolic");
			_g_free0 (iconname);
			iconname = _tmp1_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("user-busy-symbolic");
			_g_free0 (iconname);
			iconname = _tmp2_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("user-invisible-symbolic");
			_g_free0 (iconname);
			iconname = _tmp3_;
			break;
		}
	}
	result = iconname;
	return result;
}


gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* iconname;
	gchar* _tmp1_;
	_tmp0_ = contacts_contact_presence_to_icon (presence);
	iconname = _tmp0_;
	if (iconname != NULL) {
		result = iconname;
		return result;
	}
	_tmp1_ = g_strdup ("user-offline-symbolic");
	result = _tmp1_;
	_g_free0 (iconname);
	return result;
}


static gchar* contacts_contact_get_first_string (GeeCollection* collection) {
	gchar* result = NULL;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* i;
	gboolean _tmp1_;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
	i = _tmp0_;
	_tmp1_ = gee_iterator_next (i);
	if (_tmp1_) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_iterator_get (i);
		result = (gchar*) _tmp2_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


static gint contacts_contact_get_first_string_as_int (GeeCollection* collection) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* s;
	gint _tmp1_;
	g_return_val_if_fail (collection != NULL, 0);
	_tmp0_ = contacts_contact_get_first_string (collection);
	s = _tmp0_;
	if (s == NULL) {
		result = G_MAXINT;
		_g_free0 (s);
		return result;
	}
	_tmp1_ = atoi (s);
	result = _tmp1_;
	_g_free0 (s);
	return result;
}


static void _g_list_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_list_free (var), NULL));
}


gchar* contacts_contact_format_phone_type (FolksFieldDetails* detail) {
	gchar* result = NULL;
	static const ContactsContactPhoneData data[] = {{"Assistant", {"X-EVOLUTION-ASSISTANT"}, 2}, {"Work", {"WORK", "VOICE"}, 2}, {"Work Fax", {"WORK", "FAX"}, 2}, {"Callback", {"X-EVOLUTION-CALLBACK"}, 2}, {"Car", {"CAR"}, 2}, {"Company", {"X-EVOLUTION-COMPANY"}, 2}, {"Home", {"HOME", "VOICE"}, 2}, {"Home Fax", {"HOME", "FAX"}, 2}, {"ISDN", {"ISDN"}, 2}, {"Mobile", {"CELL"}, 2}, {"Other", {"VOICE"}, 2}, {"Fax", {"FAX"}, 2}, {"Pager", {"PAGER"}, 2}, {"Radio", {"X-EVOLUTION-RADIO"}, 2}, {"Telex", {"X-EVOLUTION-TELEX"}, 2}, {"TTY", {"X-EVOLUTION-TTYTDD"}, 2}, {"Home", {"HOME"}, 2}, {"Work", {"WORK"}, 2}};
	GeeMultiMap* _tmp0_ = NULL;
	gboolean _tmp1_;
	GeeCollection* _tmp11_ = NULL;
	GeeCollection* i;
	gboolean _tmp12_ = FALSE;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* list;
	gboolean _tmp28_;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gconstpointer _tmp33_ = NULL;
	GList* _tmp34_;
	GList* l;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = folks_field_details_get_parameters (detail);
	_tmp1_ = gee_multi_map_contains (_tmp0_, "x-google-label");
	if (_tmp1_) {
		GeeMultiMap* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp2_ = folks_field_details_get_parameters (detail);
		_tmp3_ = gee_multi_map_get (_tmp2_, "x-google-label");
		_tmp4_ = _tmp3_;
		_tmp5_ = contacts_contact_get_first_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		result = _tmp6_;
		return result;
	}
	if (contacts_contact_phone_types_hash == NULL) {
		GHashTable* _tmp7_ = NULL;
		_tmp7_ = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, _g_list_free0_);
		_g_hash_table_unref0 (contacts_contact_phone_types_hash);
		contacts_contact_phone_types_hash = _tmp7_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					ContactsContactPhoneData* d;
					gconstpointer _tmp9_ = NULL;
					GList* l;
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i < G_N_ELEMENTS (data))) {
						break;
					}
					d = &data[i];
					_tmp9_ = g_hash_table_lookup (contacts_contact_phone_types_hash, (*d).types[0]);
					l = (GList*) _tmp9_;
					if (l != NULL) {
						l = g_list_append (l, d);
					} else {
						GList* l2;
						GList* _tmp10_;
						l2 = NULL;
						l2 = g_list_append (l2, d);
						_tmp10_ = l2;
						l2 = NULL;
						g_hash_table_insert (contacts_contact_phone_types_hash, (*d).types[0], _tmp10_);
						_g_list_free0 (l2);
					}
				}
			}
		}
	}
	_tmp11_ = folks_field_details_get_parameter_values (detail, "type");
	i = _tmp11_;
	if (i == NULL) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp13_;
		_tmp13_ = gee_collection_get_is_empty (i);
		_tmp12_ = _tmp13_;
	}
	if (_tmp12_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = _ ("Other");
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_object_unref0 (i);
		return result;
	}
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	list = _tmp16_;
	{
		GeeCollection* _tmp17_ = NULL;
		GeeCollection* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _s_it;
		_tmp17_ = folks_field_details_get_parameter_values (detail, "type");
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_s_it = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			gpointer _tmp22_ = NULL;
			gchar* s;
			gboolean _tmp23_ = FALSE;
			gint _tmp24_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp21_ = gee_iterator_next (_s_it);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = gee_iterator_get (_s_it);
			s = (gchar*) _tmp22_;
			_tmp24_ = g_ascii_strcasecmp (s, "OTHER");
			if (_tmp24_ == 0) {
				_tmp23_ = TRUE;
			} else {
				gint _tmp25_;
				_tmp25_ = g_ascii_strcasecmp (s, "PREF");
				_tmp23_ = _tmp25_ == 0;
			}
			if (_tmp23_) {
				_g_free0 (s);
				continue;
			}
			_tmp26_ = g_utf8_strup (s, (gssize) (-1));
			_tmp27_ = _tmp26_;
			gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_it);
	}
	_tmp28_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) list);
	if (_tmp28_) {
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_tmp29_ = _ ("Other");
		_tmp30_ = g_strdup (_tmp29_);
		result = _tmp30_;
		_g_object_unref0 (list);
		_g_object_unref0 (i);
		return result;
	}
	gee_list_sort ((GeeList*) list, NULL);
	_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) list, 0);
	_tmp32_ = (gchar*) _tmp31_;
	_tmp33_ = g_hash_table_lookup (contacts_contact_phone_types_hash, _tmp32_);
	_tmp34_ = (GList*) _tmp33_;
	_g_free0 (_tmp32_);
	l = _tmp34_;
	{
		GList* d_collection = NULL;
		GList* d_it = NULL;
		d_collection = l;
		for (d_it = d_collection; d_it != NULL; d_it = d_it->next) {
			ContactsContactPhoneData* d = NULL;
			d = d_it->data;
			{
				gboolean all_found;
				all_found = TRUE;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp35_;
						_tmp35_ = TRUE;
						while (TRUE) {
							gboolean _tmp36_ = FALSE;
							gboolean _tmp37_;
							if (!_tmp35_) {
								j++;
							}
							_tmp35_ = FALSE;
							if (j < 2) {
								_tmp36_ = (*d).types[j] != NULL;
							} else {
								_tmp36_ = FALSE;
							}
							if (!_tmp36_) {
								break;
							}
							_tmp37_ = gee_abstract_collection_contains ((GeeAbstractCollection*) list, (*d).types[j]);
							if (!_tmp37_) {
								all_found = FALSE;
								break;
							}
						}
					}
				}
				if (all_found) {
					const gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					_tmp38_ = g_dgettext (GETTEXT_PACKAGE, (*d).display_name);
					_tmp39_ = g_strdup (_tmp38_);
					result = _tmp39_;
					_g_object_unref0 (list);
					_g_object_unref0 (i);
					return result;
				}
			}
		}
	}
	_tmp40_ = _ ("Other");
	_tmp41_ = g_strdup (_tmp40_);
	result = _tmp41_;
	_g_object_unref0 (list);
	_g_object_unref0 (i);
	return result;
}


gchar* contacts_contact_format_email_type (FolksFieldDetails* detail) {
	gchar* result = NULL;
	static const ContactsContactEmailData data[] = {{"Home", {"HOME"}, 2}, {"Work", {"WORK"}, 2}};
	GeeMultiMap* _tmp0_ = NULL;
	gboolean _tmp1_;
	GeeCollection* _tmp11_ = NULL;
	GeeCollection* i;
	gboolean _tmp12_ = FALSE;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* list;
	gboolean _tmp30_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gconstpointer _tmp35_ = NULL;
	GList* _tmp36_;
	GList* l;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = folks_field_details_get_parameters (detail);
	_tmp1_ = gee_multi_map_contains (_tmp0_, "x-google-label");
	if (_tmp1_) {
		GeeMultiMap* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp2_ = folks_field_details_get_parameters (detail);
		_tmp3_ = gee_multi_map_get (_tmp2_, "x-google-label");
		_tmp4_ = _tmp3_;
		_tmp5_ = contacts_contact_get_first_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		result = _tmp6_;
		return result;
	}
	if (contacts_contact_email_types_hash == NULL) {
		GHashTable* _tmp7_ = NULL;
		_tmp7_ = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, _g_list_free0_);
		_g_hash_table_unref0 (contacts_contact_email_types_hash);
		contacts_contact_email_types_hash = _tmp7_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					ContactsContactEmailData* d;
					gconstpointer _tmp9_ = NULL;
					GList* l;
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i < G_N_ELEMENTS (data))) {
						break;
					}
					d = &data[i];
					_tmp9_ = g_hash_table_lookup (contacts_contact_email_types_hash, (*d).types[0]);
					l = (GList*) _tmp9_;
					if (l != NULL) {
						l = g_list_append (l, d);
					} else {
						GList* l2;
						GList* _tmp10_;
						l2 = NULL;
						l2 = g_list_append (l2, d);
						_tmp10_ = l2;
						l2 = NULL;
						g_hash_table_insert (contacts_contact_email_types_hash, (*d).types[0], _tmp10_);
						_g_list_free0 (l2);
					}
				}
			}
		}
	}
	_tmp11_ = folks_field_details_get_parameter_values (detail, "type");
	i = _tmp11_;
	if (i == NULL) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp13_;
		_tmp13_ = gee_collection_get_is_empty (i);
		_tmp12_ = _tmp13_;
	}
	if (_tmp12_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = _ ("Other");
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_object_unref0 (i);
		return result;
	}
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	list = _tmp16_;
	{
		GeeCollection* _tmp17_ = NULL;
		GeeCollection* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _s_it;
		_tmp17_ = folks_field_details_get_parameter_values (detail, "type");
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_s_it = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			gpointer _tmp22_ = NULL;
			gchar* s;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			gint _tmp25_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			_tmp21_ = gee_iterator_next (_s_it);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = gee_iterator_get (_s_it);
			s = (gchar*) _tmp22_;
			_tmp25_ = g_ascii_strcasecmp (s, "OTHER");
			if (_tmp25_ == 0) {
				_tmp24_ = TRUE;
			} else {
				gint _tmp26_;
				_tmp26_ = g_ascii_strcasecmp (s, "INTERNET");
				_tmp24_ = _tmp26_ == 0;
			}
			if (_tmp24_) {
				_tmp23_ = TRUE;
			} else {
				gint _tmp27_;
				_tmp27_ = g_ascii_strcasecmp (s, "PREF");
				_tmp23_ = _tmp27_ == 0;
			}
			if (_tmp23_) {
				_g_free0 (s);
				continue;
			}
			_tmp28_ = g_utf8_strup (s, (gssize) (-1));
			_tmp29_ = _tmp28_;
			gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp29_);
			_g_free0 (_tmp29_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_it);
	}
	_tmp30_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) list);
	if (_tmp30_) {
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		_tmp31_ = _ ("Other");
		_tmp32_ = g_strdup (_tmp31_);
		result = _tmp32_;
		_g_object_unref0 (list);
		_g_object_unref0 (i);
		return result;
	}
	gee_list_sort ((GeeList*) list, NULL);
	_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) list, 0);
	_tmp34_ = (gchar*) _tmp33_;
	_tmp35_ = g_hash_table_lookup (contacts_contact_email_types_hash, _tmp34_);
	_tmp36_ = (GList*) _tmp35_;
	_g_free0 (_tmp34_);
	l = _tmp36_;
	{
		GList* d_collection = NULL;
		GList* d_it = NULL;
		d_collection = l;
		for (d_it = d_collection; d_it != NULL; d_it = d_it->next) {
			ContactsContactEmailData* d = NULL;
			d = d_it->data;
			{
				gboolean all_found;
				all_found = TRUE;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp37_;
						_tmp37_ = TRUE;
						while (TRUE) {
							gboolean _tmp38_ = FALSE;
							gboolean _tmp39_;
							if (!_tmp37_) {
								j++;
							}
							_tmp37_ = FALSE;
							if (j < 2) {
								_tmp38_ = (*d).types[j] != NULL;
							} else {
								_tmp38_ = FALSE;
							}
							if (!_tmp38_) {
								break;
							}
							_tmp39_ = gee_abstract_collection_contains ((GeeAbstractCollection*) list, (*d).types[j]);
							if (!_tmp39_) {
								all_found = FALSE;
								break;
							}
						}
					}
				}
				if (all_found) {
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_;
					_tmp40_ = g_dgettext (GETTEXT_PACKAGE, (*d).display_name);
					_tmp41_ = g_strdup (_tmp40_);
					result = _tmp41_;
					_g_object_unref0 (list);
					_g_object_unref0 (i);
					return result;
				}
			}
		}
	}
	_tmp42_ = _ ("Other");
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_object_unref0 (list);
	_g_object_unref0 (i);
	return result;
}


static gint _lambda0_ (FolksFieldDetails* a, FolksFieldDetails* b) {
	gint result = 0;
	GeeMultiMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint aa;
	GeeMultiMap* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint bb;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = folks_field_details_get_parameters (a);
	_tmp1_ = gee_multi_map_get (_tmp0_, "x-evolution-ui-slot");
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_contact_get_first_string_as_int (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	aa = _tmp4_;
	_tmp5_ = folks_field_details_get_parameters (b);
	_tmp6_ = gee_multi_map_get (_tmp5_, "x-evolution-ui-slot");
	_tmp7_ = _tmp6_;
	_tmp8_ = contacts_contact_get_first_string_as_int (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	bb = _tmp9_;
	result = aa - bb;
	return result;
}


static gint __lambda0__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda0_ (a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* contacts_contact_sort_fields (GeeSet* details) {
	GList* result = NULL;
	GList* sorted;
	GList* pref;
	GList* rest;
	GList* _tmp16_;
	GList* _tmp17_;
	g_return_val_if_fail (details != NULL, NULL);
	sorted = NULL;
	pref = NULL;
	rest = NULL;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _detail_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) details);
		_detail_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* detail;
			GeeMultiMap* _tmp3_ = NULL;
			gboolean _tmp4_;
			_tmp1_ = gee_iterator_next (_detail_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_detail_it);
			detail = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameters (detail);
			_tmp4_ = gee_multi_map_contains (_tmp3_, "x-evolution-ui-slot");
			if (_tmp4_) {
				FolksFieldDetails* _tmp5_;
				_tmp5_ = _g_object_ref0 (detail);
				sorted = g_list_prepend (sorted, _tmp5_);
			} else {
				gboolean found;
				found = FALSE;
				{
					GeeMultiMap* _tmp6_ = NULL;
					GeeCollection* _tmp7_ = NULL;
					GeeCollection* _tmp8_;
					GeeIterator* _tmp9_ = NULL;
					GeeIterator* _tmp10_;
					GeeIterator* _param_it;
					_tmp6_ = folks_field_details_get_parameters (detail);
					_tmp7_ = gee_multi_map_get (_tmp6_, "type");
					_tmp8_ = _tmp7_;
					_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
					_tmp10_ = _tmp9_;
					_g_object_unref0 (_tmp8_);
					_param_it = _tmp10_;
					while (TRUE) {
						gboolean _tmp11_;
						gpointer _tmp12_ = NULL;
						gchar* param;
						gint _tmp13_;
						_tmp11_ = gee_iterator_next (_param_it);
						if (!_tmp11_) {
							break;
						}
						_tmp12_ = gee_iterator_get (_param_it);
						param = (gchar*) _tmp12_;
						_tmp13_ = g_ascii_strcasecmp (param, "PREF");
						if (_tmp13_ == 0) {
							found = TRUE;
							_g_free0 (param);
							break;
						}
						_g_free0 (param);
					}
					_g_object_unref0 (_param_it);
				}
				if (found) {
					FolksFieldDetails* _tmp14_;
					_tmp14_ = _g_object_ref0 (detail);
					pref = g_list_prepend (pref, _tmp14_);
				} else {
					FolksFieldDetails* _tmp15_;
					_tmp15_ = _g_object_ref0 (detail);
					rest = g_list_prepend (rest, _tmp15_);
				}
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	pref = g_list_reverse (pref);
	rest = g_list_reverse (rest);
	sorted = g_list_sort (sorted, __lambda0__gcompare_func);
	_tmp16_ = pref;
	pref = NULL;
	sorted = g_list_concat (sorted, _tmp16_);
	_tmp17_ = rest;
	rest = NULL;
	sorted = g_list_concat (sorted, _tmp17_);
	result = sorted;
	__g_list_free__g_object_unref0_0 (rest);
	__g_list_free__g_object_unref0_0 (pref);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* str = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	gchar** _tmp41_;
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = folks_postal_address_get_street (addr);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (str);
	str = _tmp2_;
	if (str != NULL) {
		gint _tmp4_;
		_tmp4_ = strlen (str);
		_tmp3_ = _tmp4_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (str);
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp5_);
	}
	_tmp6_ = folks_postal_address_get_extension (addr);
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (str);
	str = _tmp7_;
	if (str != NULL) {
		gint _tmp9_;
		_tmp9_ = strlen (str);
		_tmp8_ = _tmp9_ > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (str);
		_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp10_);
	}
	_tmp11_ = folks_postal_address_get_locality (addr);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (str);
	str = _tmp12_;
	if (str != NULL) {
		gint _tmp14_;
		_tmp14_ = strlen (str);
		_tmp13_ = _tmp14_ > 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (str);
		_vala_array_add3 (&lines, &lines_length1, &_lines_size_, _tmp15_);
	}
	_tmp16_ = folks_postal_address_get_region (addr);
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (str);
	str = _tmp17_;
	if (str != NULL) {
		gint _tmp19_;
		_tmp19_ = strlen (str);
		_tmp18_ = _tmp19_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup (str);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp20_);
	}
	_tmp21_ = folks_postal_address_get_postal_code (addr);
	_tmp22_ = g_strdup (_tmp21_);
	_g_free0 (str);
	str = _tmp22_;
	if (str != NULL) {
		gint _tmp24_;
		_tmp24_ = strlen (str);
		_tmp23_ = _tmp24_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup (str);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp25_);
	}
	_tmp26_ = folks_postal_address_get_po_box (addr);
	_tmp27_ = g_strdup (_tmp26_);
	_g_free0 (str);
	str = _tmp27_;
	if (str != NULL) {
		gint _tmp29_;
		_tmp29_ = strlen (str);
		_tmp28_ = _tmp29_ > 0;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup (str);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp30_);
	}
	_tmp31_ = folks_postal_address_get_country (addr);
	_tmp32_ = g_strdup (_tmp31_);
	_g_free0 (str);
	str = _tmp32_;
	if (str != NULL) {
		gint _tmp34_;
		_tmp34_ = strlen (str);
		_tmp33_ = _tmp34_ > 0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup (str);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp35_);
	}
	_tmp36_ = folks_postal_address_get_address_format (addr);
	_tmp37_ = g_strdup (_tmp36_);
	_g_free0 (str);
	str = _tmp37_;
	if (str != NULL) {
		gint _tmp39_;
		_tmp39_ = strlen (str);
		_tmp38_ = _tmp39_ > 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		gchar* _tmp40_;
		_tmp40_ = g_strdup (str);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp40_);
	}
	_tmp41_ = lines;
	if (result_length1) {
		*result_length1 = lines_length1;
	}
	result = _tmp41_;
	_g_free0 (str);
	return result;
}


TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	TpfPersona* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* iid;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_tmp0_ = g_strconcat (protocol, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, im_address, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	iid = _tmp3_;
	{
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _p_it;
		_tmp4_ = folks_individual_get_personas (self->individual);
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_p_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp8_;
			TpfPersona* _tmp9_;
			TpfPersona* tp;
			gboolean _tmp10_ = FALSE;
			_tmp6_ = gee_iterator_next (_p_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_p_it);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp8_) ? ((TpfPersona*) _tmp8_) : NULL);
			tp = _tmp9_;
			if (tp != NULL) {
				const gchar* _tmp11_ = NULL;
				_tmp11_ = folks_persona_get_iid ((FolksPersona*) tp);
				_tmp10_ = g_strcmp0 (_tmp11_, iid) == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = tp;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				_g_free0 (iid);
				return result;
			}
			_g_object_unref0 (tp);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	_g_free0 (iid);
	return result;
}


gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id) {
	gchar* result = NULL;
	gchar* service;
	TpfPersona* _tmp0_ = NULL;
	TpfPersona* persona;
	gboolean _tmp7_ = FALSE;
	static const ContactsContactImData data[] = {{"google-talk", "Google Talk"}, {"ovi-chat", "Ovi Chat"}, {"facebook", "Facebook", CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE}, {"lj-talk", "Livejournal"}, {"aim", "AOL Instant Messenger"}, {"gadugadu", "Gadu-Gadu"}, {"groupwise", "Novell Groupwise"}, {"icq", "ICQ"}, {"irc", "IRC"}, {"jabber", "Jabber"}, {"localxmpp", "Local network"}, {"msn", "Windows Live Messenger"}, {"myspace", "MySpace"}, {"mxit", "MXit"}, {"napster", "Napster"}, {"qq", "Tencent QQ"}, {"sametime", "IBM Lotus Sametime"}, {"silc", "SILC"}, {"sip", "sip"}, {"skype", "Skype"}, {"tel", "Telephony"}, {"trepia", "Trepia"}, {"yahoo", "Yahoo! Messenger"}, {"yahoojp", "Yahoo! Messenger"}, {"zephyr", "Zephyr"}};
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	service = NULL;
	_tmp0_ = contacts_contact_find_im_persona (self, protocol, id);
	persona = _tmp0_;
	if (persona != NULL) {
		FolksPersonaStore* _tmp1_ = NULL;
		FolksPersonaStore* _tmp2_;
		TpAccount* _tmp3_ = NULL;
		TpAccount* _tmp4_;
		TpAccount* account;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp1_ = folks_persona_get_store ((FolksPersona*) persona);
		_tmp2_ = _tmp1_;
		_tmp3_ = tpf_persona_store_get_account (TPF_IS_PERSONA_STORE (_tmp2_) ? ((TpfPersonaStore*) _tmp2_) : NULL);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		account = _tmp4_;
		_tmp5_ = tp_account_get_service (account);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (service);
		service = _tmp6_;
		_g_object_unref0 (account);
	}
	if (service == NULL) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = g_strcmp0 (service, "") == 0;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (protocol);
		_g_free0 (service);
		service = _tmp8_;
	}
	{
		ContactsContactImData* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it;
		d_collection = data;
		d_collection_length1 = G_N_ELEMENTS (data);
		for (d_it = 0; d_it < G_N_ELEMENTS (data); d_it = d_it + 1) {
			ContactsContactImData d = {0};
			d = d_collection[d_it];
			{
				if (g_strcmp0 (d.service, service) == 0) {
					switch (d.display) {
						default:
						case CONTACTS_CONTACT_IM_DISPLAY_DEFAULT:
						{
							gchar* _tmp9_;
							gchar* _tmp10_;
							const gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							_tmp9_ = g_strconcat (id, " (", NULL);
							_tmp10_ = _tmp9_;
							_tmp11_ = g_dgettext (GETTEXT_PACKAGE, d.display_name);
							_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_strconcat (_tmp13_, ")", NULL);
							_tmp15_ = _tmp14_;
							_g_free0 (_tmp13_);
							_g_free0 (_tmp10_);
							result = _tmp15_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
						case CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE:
						{
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							gchar* _tmp18_;
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							_tmp16_ = folks_alias_details_get_alias ((FolksAliasDetails*) persona);
							_tmp17_ = g_strconcat (_tmp16_, " (", NULL);
							_tmp18_ = _tmp17_;
							_tmp19_ = g_dgettext (GETTEXT_PACKAGE, d.display_name);
							_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
							_tmp23_ = _tmp22_;
							_g_free0 (_tmp21_);
							_g_free0 (_tmp18_);
							result = _tmp23_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
					}
				}
			}
		}
	}
	_tmp24_ = g_strconcat (id, " (", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, protocol, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, ")", NULL);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	result = _tmp29_;
	_g_object_unref0 (persona);
	_g_free0 (service);
	return result;
}


static void contacts_contact_update_presence_widgets (ContactsContact* self, GtkImage* image, GtkLabel* label) {
	FolksPresenceType _tmp0_;
	FolksPresenceType _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) self->individual);
	if (_tmp0_ == FOLKS_PRESENCE_TYPE_UNSET) {
		gtk_image_clear (image);
		gtk_widget_hide ((GtkWidget*) image);
		gtk_widget_hide ((GtkWidget*) label);
		gtk_label_set_text (label, "");
		return;
	}
	_tmp1_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) self->individual);
	_tmp2_ = contacts_contact_presence_to_icon_full (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_image_set_from_icon_name (image, _tmp3_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp3_);
	gtk_widget_show ((GtkWidget*) image);
	gtk_widget_show ((GtkWidget*) label);
	_tmp5_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) self->individual);
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		gint _tmp7_;
		_tmp6_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) self->individual);
		_tmp7_ = strlen (_tmp6_);
		_tmp4_ = _tmp7_ == 0;
	}
	if (_tmp4_) {
		FolksPresenceType _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp8_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) self->individual);
		_tmp9_ = contacts_contact_presence_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_label_set_text (label, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) self->individual);
		gtk_label_set_text (label, _tmp11_);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->label);
		_g_object_unref0 (_data1_->image);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda1_ (GParamSpec* pspec, Block1Data* _data1_) {
	ContactsContact * self;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	contacts_contact_update_presence_widgets (self, _data1_->image, _data1_->label);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (pspec, self);
}


static void _lambda2_ (GParamSpec* pspec, Block1Data* _data1_) {
	ContactsContact * self;
	self = _data1_->self;
	g_return_if_fail (pspec != NULL);
	contacts_contact_update_presence_widgets (self, _data1_->image, _data1_->label);
}


static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda2_ (pspec, self);
}


static void _lambda3_ (Block1Data* _data1_) {
	ContactsContact * self;
	self = _data1_->self;
	g_signal_handler_disconnect ((GObject*) self->individual, _data1_->id1);
	g_signal_handler_disconnect ((GObject*) self->individual, _data1_->id2);
}


static void __lambda3__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_lambda3_ (self);
}


GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self) {
	GtkWidget* result = NULL;
	Block1Data* _data1_;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* grid;
	GtkImage* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	gulong _tmp3_;
	gulong _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp0_);
	gtk_grid_set_row_spacing (grid, (guint) 4);
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_data1_->image = g_object_ref_sink (_tmp1_);
	gtk_widget_set_no_show_all ((GtkWidget*) _data1_->image, TRUE);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _data1_->image);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	_data1_->label = g_object_ref_sink (_tmp2_);
	gtk_widget_set_no_show_all ((GtkWidget*) _data1_->label, TRUE);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _data1_->label);
	contacts_contact_update_presence_widgets (self, _data1_->image, _data1_->label);
	_tmp3_ = g_signal_connect_data ((GObject*) self->individual, "notify::presence-type", (GCallback) __lambda1__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_data1_->id1 = _tmp3_;
	_tmp4_ = g_signal_connect_data ((GObject*) self->individual, "notify::presence-message", (GCallback) __lambda2__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_data1_->id2 = _tmp4_;
	g_signal_connect_data ((GtkWidget*) grid, "destroy", (GCallback) __lambda3__gtk_widget_destroy, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	result = (GtkWidget*) grid;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->i);
		_g_object_unref0 (_data2_->tp);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda4_ (GParamSpec* pspec, Block2Data* _data2_) {
	ContactsContact * self;
	FolksPresenceType _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp1_ = contacts_contact_presence_to_icon_full (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_icon_name (_data2_->i, _tmp2_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp2_);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (pspec, self);
}


static void _lambda5_ (GParamSpec* pspec, Block2Data* _data2_) {
	ContactsContact * self;
	const gchar* _tmp0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _data2_->tp);
	gtk_widget_set_tooltip_text ((GtkWidget*) _data2_->i, _tmp0_);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (pspec, self);
}


static void _lambda6_ (Block2Data* _data2_) {
	ContactsContact * self;
	self = _data2_->self;
	g_signal_handler_disconnect ((GObject*) _data2_->tp, _data2_->id1);
	g_signal_handler_disconnect ((GObject*) _data2_->tp, _data2_->id2);
}


static void __lambda6__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_lambda6_ (self);
}


GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	GtkWidget* result = NULL;
	Block2Data* _data2_;
	TpfPersona* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	FolksPresenceType _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gulong _tmp6_;
	gulong _tmp7_;
	GtkWidget* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_find_im_persona (self, protocol, im_address);
	_data2_->tp = _tmp0_;
	if (_data2_->tp == NULL) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_data2_->i = g_object_ref_sink (_tmp1_);
	_tmp2_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _data2_->tp);
	_tmp3_ = contacts_contact_presence_to_icon_full (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_image_set_from_icon_name (_data2_->i, _tmp4_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp4_);
	_tmp5_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _data2_->tp);
	gtk_widget_set_tooltip_text ((GtkWidget*) _data2_->i, _tmp5_);
	_tmp6_ = g_signal_connect_data ((GObject*) _data2_->tp, "notify::presence-type", (GCallback) __lambda4__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id1 = _tmp6_;
	_tmp7_ = g_signal_connect_data ((GObject*) _data2_->tp, "notify::presence-message", (GCallback) __lambda5__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id2 = _tmp7_;
	g_signal_connect_data ((GtkWidget*) _data2_->i, "destroy", (GCallback) __lambda6__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _data2_->i);
	result = _tmp8_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gboolean contacts_contact_changed_cb (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->changed_id = (guint) 0;
	contacts_contact_update (self);
	g_signal_emit_by_name (self, "changed");
	result = FALSE;
	return result;
}


static void contacts_contact_unqueue_changed (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->changed_id != 0) {
		g_source_remove (self->priv->changed_id);
		self->priv->changed_id = (guint) 0;
	}
}


static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_contact_changed_cb (self);
	return result;
}


static void contacts_contact_queue_changed (ContactsContact* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->changed_id != 0) {
		return;
	}
	_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _contacts_contact_changed_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->changed_id = _tmp0_;
}


static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = g_param_spec_get_name (pspec);
	if (g_strcmp0 (_tmp0_, "avatar") == 0) {
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = NULL;
	}
	contacts_contact_queue_changed (self);
}


static void contacts_contact_update (ContactsContact* self) {
	GString* _tmp0_ = NULL;
	GString* builder;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp9_ = NULL;
	GeeMultiMap* _tmp13_ = NULL;
	GeeMultiMap* _tmp14_;
	GeeMultiMap* im_addresses;
	GeeSet* _tmp23_ = NULL;
	GeeSet* _tmp24_;
	GeeSet* emails;
	gchar* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp2_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
		_tmp4_ = _tmp3_;
		g_string_append (builder, _tmp4_);
		_g_free0 (_tmp4_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp5_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
		_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		g_string_append (builder, _tmp8_);
		_g_free0 (_tmp8_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp9_ = folks_name_details_get_nickname ((FolksNameDetails*) self->individual);
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = folks_name_details_get_nickname ((FolksNameDetails*) self->individual);
		_tmp11_ = g_utf8_casefold (_tmp10_, (gssize) (-1));
		_tmp12_ = _tmp11_;
		g_string_append (builder, _tmp12_);
		_g_free0 (_tmp12_);
		g_string_append_unichar (builder, (gunichar) ' ');
	}
	_tmp13_ = folks_im_details_get_im_addresses ((FolksImDetails*) self->individual);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	im_addresses = _tmp14_;
	{
		GeeCollection* _tmp15_ = NULL;
		GeeCollection* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _tmp18_;
		GeeIterator* _addr_it;
		_tmp15_ = gee_multi_map_get_values (im_addresses);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_addr_it = _tmp18_;
		while (TRUE) {
			gboolean _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* addr;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp19_ = gee_iterator_next (_addr_it);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = gee_iterator_get (_addr_it);
			addr = (gchar*) _tmp20_;
			_tmp21_ = g_utf8_casefold (addr, (gssize) (-1));
			_tmp22_ = _tmp21_;
			g_string_append (builder, _tmp22_);
			_g_free0 (_tmp22_);
			g_string_append_unichar (builder, (gunichar) ' ');
			_g_free0 (addr);
		}
		_g_object_unref0 (_addr_it);
	}
	_tmp23_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) self->individual);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	emails = _tmp24_;
	{
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _email_it;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) emails);
		_email_it = _tmp25_;
		while (TRUE) {
			gboolean _tmp26_;
			gpointer _tmp27_ = NULL;
			FolksFieldDetails* email;
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			_tmp26_ = gee_iterator_next (_email_it);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = gee_iterator_get (_email_it);
			email = (FolksFieldDetails*) _tmp27_;
			_tmp28_ = folks_field_details_get_value (email);
			_tmp29_ = g_utf8_casefold (_tmp28_, (gssize) (-1));
			_tmp30_ = _tmp29_;
			g_string_append (builder, _tmp30_);
			_g_free0 (_tmp30_);
			g_string_append_unichar (builder, (gunichar) ' ');
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp31_ = g_strdup (builder->str);
	_g_free0 (self->priv->filter_data);
	self->priv->filter_data = _tmp31_;
	_g_object_unref0 (emails);
	_g_object_unref0 (im_addresses);
	_g_string_free0 (builder);
}


static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GFile* file) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* res;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (contacts_contact_fallback_avatar);
	res = _tmp0_;
	if (file != NULL) {
		{
			GFileInputStream* _tmp1_ = NULL;
			GFileInputStream* stream;
			GCancellable* _tmp2_ = NULL;
			GCancellable* c;
			GdkPixbuf* _tmp3_ = NULL;
			GdkPixbuf* _tmp4_;
			_tmp1_ = g_file_read (file, NULL, &_inner_error_);
			stream = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_tmp2_ = g_cancellable_new ();
			c = _tmp2_;
			_tmp3_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) stream, 48, 48, TRUE, c, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (c);
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
			_g_object_unref0 (res);
			res = _tmp4_;
			_g_object_unref0 (c);
			_g_object_unref0 (stream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = res;
	return result;
}


static void contacts_contact_round_rect (cairo_t* cr, gint x, gint y, gint w, gint h, gint r) {
	g_return_if_fail (cr != NULL);
	cairo_move_to (cr, (gdouble) (x + r), (gdouble) y);
	cairo_line_to (cr, (gdouble) ((x + w) - r), (gdouble) y);
	cairo_curve_to (cr, (gdouble) (x + w), (gdouble) y, (gdouble) (x + w), (gdouble) y, (gdouble) (x + w), (gdouble) (y + r));
	cairo_line_to (cr, (gdouble) (x + w), (gdouble) ((y + h) - r));
	cairo_curve_to (cr, (gdouble) (x + w), (gdouble) (y + h), (gdouble) (x + w), (gdouble) (y + h), (gdouble) ((x + w) - r), (gdouble) (y + h));
	cairo_line_to (cr, (gdouble) (x + r), (gdouble) (y + h));
	cairo_curve_to (cr, (gdouble) x, (gdouble) (y + h), (gdouble) x, (gdouble) (y + h), (gdouble) x, (gdouble) ((y + h) - r));
	cairo_line_to (cr, (gdouble) x, (gdouble) (y + r));
	cairo_curve_to (cr, (gdouble) x, (gdouble) y, (gdouble) x, (gdouble) y, (gdouble) (x + r), (gdouble) y);
}


static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon) {
	GdkPixbuf* result = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* cst;
	cairo_t* _tmp1_ = NULL;
	cairo_t* cr;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 52, 52);
	cst = _tmp0_;
	_tmp1_ = cairo_create (cst);
	cr = _tmp1_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) 52, (gdouble) 52);
	cairo_fill (cr);
	contacts_contact_round_rect (cr, 0, 0, 52, 52, 5);
	cairo_set_source_rgb (cr, 0.74117, 0.74117, 0.74117);
	cairo_fill (cr);
	contacts_contact_round_rect (cr, 1, 1, 50, 50, 5);
	cairo_set_source_rgb (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_fill (cr);
	gdk_cairo_set_source_pixbuf (cr, icon, (gdouble) 2, (gdouble) 2);
	cairo_paint (cr);
	_tmp2_ = gdk_pixbuf_get_from_surface (cst, 0, 0, 52, 52);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


static GdkPixbuf* contacts_contact_draw_fallback_avatar (void) {
	GdkPixbuf* result = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* cst;
	cairo_t* _tmp1_ = NULL;
	cairo_t* cr;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GError * _inner_error_ = NULL;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 48, 48);
	cst = _tmp0_;
	_tmp1_ = cairo_create (cst);
	cr = _tmp1_;
	{
		GtkIconTheme* _tmp2_ = NULL;
		GtkIconInfo* _tmp3_ = NULL;
		GtkIconInfo* icon_info;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* image;
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = gtk_icon_theme_lookup_icon (_tmp2_, "avatar-default", 48, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		icon_info = _tmp3_;
		_tmp4_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
		image = _tmp4_;
		if (_inner_error_ != NULL) {
			_gtk_icon_info_free0 (icon_info);
			goto __catch1_g_error;
		}
		if (image != NULL) {
			gdk_cairo_set_source_pixbuf (cr, image, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
		}
		_g_object_unref0 (image);
		_gtk_icon_info_free0 (icon_info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (cst);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = gdk_pixbuf_get_from_surface (cst, 0, 0, 48, 48);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_avatar == NULL) {
		GFile* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_ = NULL;
		_tmp0_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self->individual);
		_tmp1_ = contacts_contact_load_icon (self, _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = contacts_contact_frame_icon (_tmp2_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp3_;
		_g_object_unref0 (_tmp2_);
	}
	result = self->priv->_avatar;
	return result;
}


const gchar* contacts_contact_get_display_name (ContactsContact* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* name;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* alias;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) self->individual);
	name = _tmp0_;
	if (name != NULL) {
		gint _tmp2_;
		_tmp2_ = strlen (name);
		_tmp1_ = _tmp2_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = name;
		return result;
	}
	_tmp3_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
	alias = _tmp3_;
	if (alias != NULL) {
		gint _tmp5_;
		_tmp5_ = strlen (alias);
		_tmp4_ = _tmp5_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = folks_alias_details_get_alias ((FolksAliasDetails*) self->individual);
		result = _tmp6_;
		return result;
	}
	{
		GeeSet* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _email_it;
		_tmp7_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) self->individual);
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_email_it = _tmp8_;
		while (TRUE) {
			gboolean _tmp9_;
			gpointer _tmp10_ = NULL;
			FolksFieldDetails* email;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* e;
			gboolean _tmp13_ = FALSE;
			_tmp9_ = gee_iterator_next (_email_it);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = gee_iterator_get (_email_it);
			email = (FolksFieldDetails*) _tmp10_;
			_tmp11_ = folks_field_details_get_value (email);
			_tmp12_ = g_strdup (_tmp11_);
			e = _tmp12_;
			if (e != NULL) {
				gint _tmp14_;
				_tmp14_ = strlen (e);
				_tmp13_ = _tmp14_ > 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = folks_field_details_get_value (email);
				result = _tmp15_;
				_g_free0 (e);
				_g_object_unref0 (email);
				_g_object_unref0 (_email_it);
				return result;
			}
			_g_free0 (e);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	result = "";
	return result;
}


static ContactsContactPhoneData* contacts_contact_phone_data_dup (const ContactsContactPhoneData* self) {
	ContactsContactPhoneData* dup;
	dup = g_new0 (ContactsContactPhoneData, 1);
	memcpy (dup, self, sizeof (ContactsContactPhoneData));
	return dup;
}


static void contacts_contact_phone_data_free (ContactsContactPhoneData* self) {
	g_free (self);
}


static GType contacts_contact_phone_data_get_type (void) {
	static volatile gsize contacts_contact_phone_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_phone_data_type_id__volatile)) {
		GType contacts_contact_phone_data_type_id;
		contacts_contact_phone_data_type_id = g_boxed_type_register_static ("ContactsContactPhoneData", (GBoxedCopyFunc) contacts_contact_phone_data_dup, (GBoxedFreeFunc) contacts_contact_phone_data_free);
		g_once_init_leave (&contacts_contact_phone_data_type_id__volatile, contacts_contact_phone_data_type_id);
	}
	return contacts_contact_phone_data_type_id__volatile;
}


static ContactsContactEmailData* contacts_contact_email_data_dup (const ContactsContactEmailData* self) {
	ContactsContactEmailData* dup;
	dup = g_new0 (ContactsContactEmailData, 1);
	memcpy (dup, self, sizeof (ContactsContactEmailData));
	return dup;
}


static void contacts_contact_email_data_free (ContactsContactEmailData* self) {
	g_free (self);
}


static GType contacts_contact_email_data_get_type (void) {
	static volatile gsize contacts_contact_email_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_email_data_type_id__volatile)) {
		GType contacts_contact_email_data_type_id;
		contacts_contact_email_data_type_id = g_boxed_type_register_static ("ContactsContactEmailData", (GBoxedCopyFunc) contacts_contact_email_data_dup, (GBoxedFreeFunc) contacts_contact_email_data_free);
		g_once_init_leave (&contacts_contact_email_data_type_id__volatile, contacts_contact_email_data_type_id);
	}
	return contacts_contact_email_data_type_id__volatile;
}


static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self) {
	ContactsContactImData* dup;
	dup = g_new0 (ContactsContactImData, 1);
	memcpy (dup, self, sizeof (ContactsContactImData));
	return dup;
}


static void contacts_contact_im_data_free (ContactsContactImData* self) {
	g_free (self);
}


static GType contacts_contact_im_data_get_type (void) {
	static volatile gsize contacts_contact_im_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_data_type_id__volatile)) {
		GType contacts_contact_im_data_type_id;
		contacts_contact_im_data_type_id = g_boxed_type_register_static ("ContactsContactImData", (GBoxedCopyFunc) contacts_contact_im_data_dup, (GBoxedFreeFunc) contacts_contact_im_data_free);
		g_once_init_leave (&contacts_contact_im_data_type_id__volatile, contacts_contact_im_data_type_id);
	}
	return contacts_contact_im_data_type_id__volatile;
}


static void contacts_contact_class_init (ContactsContactClass * klass) {
	GdkPixbuf* _tmp0_ = NULL;
	contacts_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", CONTACTS_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = contacts_contact_draw_fallback_avatar ();
	_g_object_unref0 (contacts_contact_fallback_avatar);
	contacts_contact_fallback_avatar = _tmp0_;
}


static void contacts_contact_instance_init (ContactsContact * self) {
	self->priv = CONTACTS_CONTACT_GET_PRIVATE (self);
}


static void contacts_contact_finalize (GObject* obj) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (obj);
	_g_object_unref0 (self->individual);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->filter_data);
	G_OBJECT_CLASS (contacts_contact_parent_class)->finalize (obj);
}


GType contacts_contact_get_type (void) {
	static volatile gsize contacts_contact_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContact), 0, (GInstanceInitFunc) contacts_contact_instance_init, NULL };
		GType contacts_contact_type_id;
		contacts_contact_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsContact", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_type_id__volatile, contacts_contact_type_id);
	}
	return contacts_contact_type_id__volatile;
}


static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (object);
	switch (property_id) {
		case CONTACTS_CONTACT_AVATAR:
		g_value_set_object (value, contacts_contact_get_avatar (self));
		break;
		case CONTACTS_CONTACT_DISPLAY_NAME:
		g_value_set_string (value, contacts_contact_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



