/* contacts-utils.c generated by valac 0.14.0.1-60fb, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <folks/folks-telepathy.h>
#include <folks/folks.h>
#include <telepathy-glib/telepathy-glib.h>
#include <gee.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define CONTACTS_TYPE_UTILS (contacts_utils_get_type ())
#define CONTACTS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_UTILS, ContactsUtils))
#define CONTACTS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_UTILS, ContactsUtilsClass))
#define CONTACTS_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_UTILS))
#define CONTACTS_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_UTILS))
#define CONTACTS_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_UTILS, ContactsUtilsClass))

typedef struct _ContactsUtils ContactsUtils;
typedef struct _ContactsUtilsClass ContactsUtilsClass;
typedef struct _ContactsUtilsPrivate ContactsUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ContactsUtils {
	GObject parent_instance;
	ContactsUtilsPrivate * priv;
};

struct _ContactsUtilsClass {
	GObjectClass parent_class;
};


static gpointer contacts_utils_parent_class = NULL;

gboolean contacts_is_set (const gchar* str);
GType contacts_utils_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_UTILS_DUMMY_PROPERTY
};
void contacts_utils_compose_mail (const gchar* email);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label);
void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting);
void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
static gunichar contacts_utils_strip_char (gunichar ch);
gchar* contacts_utils_canonicalize_for_search (const gchar* str);
ContactsUtils* contacts_utils_new (void);
ContactsUtils* contacts_utils_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gboolean contacts_is_set (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	_tmp1_ = str;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = str;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


void contacts_utils_compose_mail (const gchar* email) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (email != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = email;
		_tmp1_ = g_uri_escape_string (_tmp0_, "@", FALSE);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("mailto:", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		gtk_show_uri (NULL, _tmp4_, (guint32) 0, &_inner_error_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id) {
	ContactsContact* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TpfPersona* _tmp3_ = NULL;
	TpfPersona* im_persona;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	TpAccount* _tmp6_;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpAccount* account;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* request_dict;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	const gchar* _tmp14_;
	GValue* _tmp15_ = NULL;
	gint64 _tmp16_;
	TpAccountChannelRequest* _tmp17_;
	TpAccountChannelRequest* request;
	g_return_if_fail (contact != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = contact;
	_tmp1_ = protocol;
	_tmp2_ = id;
	_tmp3_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, _tmp2_);
	im_persona = _tmp3_;
	_tmp4_ = folks_persona_get_store ((FolksPersona*) im_persona);
	_tmp5_ = _tmp4_;
	_tmp6_ = tpf_persona_store_get_account (TPF_IS_PERSONA_STORE (_tmp5_) ? ((TpfPersonaStore*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	account = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, NULL, __vala_GValue_free0_);
	request_dict = _tmp11_;
	_tmp12_ = g_new0 (GValue, 1);
	g_value_init (_tmp12_, G_TYPE_STRING);
	g_value_set_string (_tmp12_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp12_);
	_tmp13_ = g_new0 (GValue, 1);
	g_value_init (_tmp13_, G_TYPE_INT);
	g_value_set_int (_tmp13_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp13_);
	_tmp14_ = id;
	_tmp15_ = g_new0 (GValue, 1);
	g_value_init (_tmp15_, G_TYPE_STRING);
	g_value_set_string (_tmp15_, _tmp14_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp15_);
	_tmp16_ = G_MAXINT64;
	_tmp17_ = tp_account_channel_request_new (account, request_dict, _tmp16_);
	request = _tmp17_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Chat", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
	_g_object_unref0 (account);
	_g_object_unref0 (im_persona);
}


void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts) {
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_ = NULL;
	TpAccount** _tmp6_;
	gint _tmp6__length1;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpAccount* _tmp9_;
	TpAccount* account;
	const gchar* _tmp10_;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (accounts != NULL);
	_tmp0_ = accounts;
	_tmp1_ = gee_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp3_);
	account = _tmp9_;
	_tmp10_ = contact_id;
	contacts_utils_start_call_with_account (_tmp10_, account);
	_g_object_unref0 (account);
}


void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* request_dict;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	const gchar* _tmp5_;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	TpAccount* _tmp8_;
	gint64 _tmp9_;
	TpAccountChannelRequest* _tmp10_;
	TpAccountChannelRequest* request;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_GValue_free0_);
	request_dict = _tmp2_;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, TP_IFACE_CHANNEL_TYPE_STREAMED_MEDIA);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp3_);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp4_);
	_tmp5_ = contact_id;
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, _tmp5_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp6_);
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp7_, TRUE);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TYPE_STREAMED_MEDIA_INITIAL_AUDIO, _tmp7_);
	_tmp8_ = account;
	_tmp9_ = G_MAXINT64;
	_tmp10_ = tp_account_channel_request_new (_tmp8_, request_dict, _tmp9_);
	request = _tmp10_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Call", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
}


gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection) {
	gpointer result = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* i;
	GeeIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = collection;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	i = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = gee_iterator_next (_tmp2_);
	if (_tmp3_) {
		GeeIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		_tmp4_ = i;
		_tmp5_ = gee_iterator_get (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label) {
	GtkMenuItem* result = NULL;
	const gchar* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* mi;
	GtkMenu* _tmp3_;
	g_return_val_if_fail (menu != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = label;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	mi = _tmp2_;
	_tmp3_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	result = mi;
	return result;
}


void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting) {
	gint y = 0;
	gint h = 0;
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint start;
	GtkGrid* _tmp4_;
	GList* _tmp5_ = NULL;
	g_return_if_fail (grid != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = grid;
	_tmp1_ = widget;
	gtk_container_child_get ((GtkContainer*) _tmp0_, _tmp1_, "top-attach", &y, "height", &h, NULL);
	_tmp2_ = y;
	_tmp3_ = h;
	start = _tmp2_ + _tmp3_;
	_tmp4_ = grid;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkGrid* _tmp6_;
				GtkWidget* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				_tmp6_ = grid;
				_tmp7_ = child;
				gtk_container_child_get ((GtkContainer*) _tmp6_, _tmp7_, "top-attach", &y, "height", &h, NULL);
				_tmp8_ = y;
				_tmp9_ = start;
				if (_tmp8_ >= _tmp9_) {
					GtkGrid* _tmp10_;
					GtkWidget* _tmp11_;
					gint _tmp12_;
					_tmp10_ = grid;
					_tmp11_ = child;
					_tmp12_ = y;
					gtk_container_child_set ((GtkContainer*) _tmp10_, _tmp11_, "top-attach", _tmp12_ + 1, NULL);
				} else {
					gboolean _tmp13_ = FALSE;
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gboolean _tmp18_;
					_tmp14_ = y;
					_tmp15_ = h;
					_tmp16_ = start;
					if ((_tmp14_ + _tmp15_) > _tmp16_) {
						gboolean _tmp17_;
						_tmp17_ = expand_intersecting;
						_tmp13_ = _tmp17_;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp18_ = _tmp13_;
					if (_tmp18_) {
						GtkGrid* _tmp19_;
						GtkWidget* _tmp20_;
						gint _tmp21_;
						_tmp19_ = grid;
						_tmp20_ = child;
						_tmp21_ = h;
						gtk_container_child_set ((GtkContainer*) _tmp19_, _tmp20_, "height", _tmp21_ + 1, NULL);
					}
				}
			}
		}
		_g_list_free0 (child_collection);
	}
}


void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean _tmp3_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	cairo_t* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	cairo_t* _tmp17_;
	g_return_if_fail (cr != NULL);
	_tmp1_ = xradius;
	if (_tmp1_ <= 0.0) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp2_;
		_tmp2_ = yradius;
		_tmp0_ = _tmp2_ <= 0.0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		cairo_t* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = cr;
		_tmp5_ = xc;
		_tmp6_ = yc;
		cairo_line_to (_tmp4_, _tmp5_, _tmp6_);
		return;
	}
	_tmp7_ = cr;
	cairo_save (_tmp7_);
	_tmp8_ = cr;
	_tmp9_ = xc;
	_tmp10_ = yc;
	cairo_translate (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = cr;
	_tmp12_ = xradius;
	_tmp13_ = yradius;
	cairo_scale (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = cr;
	_tmp15_ = angle1;
	_tmp16_ = angle2;
	cairo_arc (_tmp14_, (gdouble) 0, (gdouble) 0, 1.0, _tmp15_, _tmp16_);
	_tmp17_ = cr;
	cairo_restore (_tmp17_);
}


void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	cairo_t* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_t* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_new_sub_path (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = x;
	_tmp3_ = radius;
	_tmp4_ = y;
	_tmp5_ = radius;
	_tmp6_ = radius;
	_tmp7_ = radius;
	contacts_utils_cairo_ellipsis (_tmp1_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) (_tmp4_ + _tmp5_), (gdouble) _tmp6_, (gdouble) _tmp7_, G_PI, (3 * G_PI) / 2);
	_tmp8_ = cr;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = radius;
	_tmp12_ = y;
	_tmp13_ = radius;
	_tmp14_ = radius;
	_tmp15_ = radius;
	contacts_utils_cairo_ellipsis (_tmp8_, (gdouble) ((_tmp9_ + _tmp10_) - _tmp11_), (gdouble) (_tmp12_ + _tmp13_), (gdouble) _tmp14_, (gdouble) _tmp15_, (-G_PI) / 2, (gdouble) 0);
	_tmp16_ = cr;
	_tmp17_ = x;
	_tmp18_ = width;
	_tmp19_ = radius;
	_tmp20_ = y;
	_tmp21_ = height;
	_tmp22_ = radius;
	_tmp23_ = radius;
	_tmp24_ = radius;
	contacts_utils_cairo_ellipsis (_tmp16_, (gdouble) ((_tmp17_ + _tmp18_) - _tmp19_), (gdouble) ((_tmp20_ + _tmp21_) - _tmp22_), (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) 0, G_PI / 2);
	_tmp25_ = cr;
	_tmp26_ = x;
	_tmp27_ = radius;
	_tmp28_ = y;
	_tmp29_ = height;
	_tmp30_ = radius;
	_tmp31_ = radius;
	_tmp32_ = radius;
	contacts_utils_cairo_ellipsis (_tmp25_, (gdouble) (_tmp26_ + _tmp27_), (gdouble) ((_tmp28_ + _tmp29_) - _tmp30_), (gdouble) _tmp31_, (gdouble) _tmp32_, G_PI / 2, G_PI);
}


static gunichar contacts_utils_strip_char (gunichar ch) {
	gunichar result = 0U;
	gunichar _tmp0_;
	GUnicodeType _tmp1_ = 0;
	_tmp0_ = ch;
	_tmp1_ = g_unichar_type (_tmp0_);
	switch (_tmp1_) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			result = (gunichar) 0;
			return result;
		}
		default:
		{
			gunichar _tmp2_;
			gunichar _tmp3_ = 0U;
			_tmp2_ = ch;
			_tmp3_ = g_unichar_tolower (_tmp2_);
			result = _tmp3_;
			return result;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* contacts_utils_canonicalize_for_search (const gchar* str) {
	gchar* result = NULL;
	const gchar* s = NULL;
	gunichar* _tmp0_ = NULL;
	gunichar* buf;
	gint buf_length1;
	gint _buf_size_;
	GString* _tmp1_;
	GString* res;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_new0 (gunichar, 18);
	buf = _tmp0_;
	buf_length1 = 18;
	_buf_size_ = buf_length1;
	_tmp1_ = g_string_new ("");
	res = _tmp1_;
	{
		const gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = str;
		s = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_;
			const gchar* _tmp7_;
			gchar _tmp8_ = '\0';
			const gchar* _tmp9_;
			gunichar _tmp10_ = 0U;
			gunichar _tmp11_ = 0U;
			gunichar c;
			gunichar _tmp12_;
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				const gchar* _tmp5_;
				const gchar* _tmp6_ = NULL;
				_tmp5_ = s;
				_tmp6_ = g_utf8_next_char (_tmp5_);
				s = _tmp6_;
			}
			_tmp3_ = FALSE;
			_tmp7_ = s;
			_tmp8_ = string_get (_tmp7_, (glong) 0);
			if (!(((gint) _tmp8_) != 0)) {
				break;
			}
			_tmp9_ = s;
			_tmp10_ = string_get_char (_tmp9_, (glong) 0);
			_tmp11_ = contacts_utils_strip_char (_tmp10_);
			c = _tmp11_;
			_tmp12_ = c;
			if (_tmp12_ != ((gunichar) 0)) {
				gunichar _tmp13_;
				gunichar* _tmp14_;
				gint _tmp14__length1;
				gsize _tmp15_ = 0UL;
				gsize size;
				gsize _tmp16_;
				_tmp13_ = c;
				_tmp14_ = buf;
				_tmp14__length1 = buf_length1;
				_tmp15_ = g_unichar_fully_decompose (_tmp13_, FALSE, _tmp14_, _tmp14__length1);
				size = _tmp15_;
				_tmp16_ = size;
				if (_tmp16_ > ((gsize) 0)) {
					GString* _tmp17_;
					gunichar* _tmp18_;
					gint _tmp18__length1;
					gunichar _tmp19_;
					_tmp17_ = res;
					_tmp18_ = buf;
					_tmp18__length1 = buf_length1;
					_tmp19_ = _tmp18_[0];
					g_string_append_unichar (_tmp17_, _tmp19_);
				}
			}
		}
	}
	_tmp20_ = res;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (res);
	buf = (g_free (buf), NULL);
	return result;
}


ContactsUtils* contacts_utils_construct (GType object_type) {
	ContactsUtils * self = NULL;
	self = (ContactsUtils*) g_object_new (object_type, NULL);
	return self;
}


ContactsUtils* contacts_utils_new (void) {
	return contacts_utils_construct (CONTACTS_TYPE_UTILS);
}


static void contacts_utils_class_init (ContactsUtilsClass * klass) {
	contacts_utils_parent_class = g_type_class_peek_parent (klass);
}


static void contacts_utils_instance_init (ContactsUtils * self) {
}


GType contacts_utils_get_type (void) {
	static volatile gsize contacts_utils_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUtils), 0, (GInstanceInitFunc) contacts_utils_instance_init, NULL };
		GType contacts_utils_type_id;
		contacts_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsUtils", &g_define_type_info, 0);
		g_once_init_leave (&contacts_utils_type_id__volatile, contacts_utils_type_id);
	}
	return contacts_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



