/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/transfer.h>
#include <libgnomevfsmm/private.h>
#include <libgnomevfs/gnome-vfs-xfer.h>



namespace Gnome
{

namespace Vfs
{

namespace
{

//SignalProxy_Progress:

//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_Progress
{
public:
  typedef Gnome::Vfs::Transfer::SlotProgress SlotType;

  SignalProxy_Progress(const SlotType& slot);
  ~SignalProxy_Progress();

  static gint c_callback(GnomeVFSXferProgressInfo *info, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_Progress::SignalProxy_Progress(const SlotType& slot)
:
  slot_ (slot)
{}

SignalProxy_Progress::~SignalProxy_Progress()
{}

gint SignalProxy_Progress::c_callback(GnomeVFSXferProgressInfo* info, gpointer data)
{
  SignalProxy_Progress *const self = static_cast<SignalProxy_Progress*>(data);
  Gnome::Vfs::Transfer::ProgressInfo progInfo(info);
  gint result = FALSE; //TODO: Use TRUE or FALSE instead?
  try
  {
    result = (self->slot_)(progInfo);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return result;
}

} //anonymous namespace

namespace Transfer
{

void transfer(const ListHandleUris& source_uri_list, const ListHandleUris& target_uri_list,
      TransferOptions options, 
      ErrorMode error_mode,
      OverwriteMode overwrite_mode,
      const SlotProgress& slot)
{
  SignalProxy_Progress proxy(slot);
  //TODO: Check the memory management with data() here.
  GnomeVFSResult result = gnome_vfs_xfer_uri_list(source_uri_list.data(), target_uri_list.data(),
    static_cast<GnomeVFSXferOptions>(options),
    static_cast<GnomeVFSXferErrorMode>(error_mode),
    static_cast<GnomeVFSXferOverwriteMode>(overwrite_mode),
    &SignalProxy_Progress::c_callback, &proxy);

  handle_result(result);
}

void transfer(const Glib::RefPtr<const Uri>& source_uri, const Glib::RefPtr<const Uri>& target_uri,
      TransferOptions options, 
      ErrorMode error_mode,
      OverwriteMode overwrite_mode,
      const SlotProgress& slot)
{
  SignalProxy_Progress proxy(slot);
  GnomeVFSResult result = gnome_vfs_xfer_uri(source_uri->gobj(), target_uri->gobj(),
    static_cast<GnomeVFSXferOptions>(options),
    static_cast<GnomeVFSXferErrorMode>(error_mode),
    static_cast<GnomeVFSXferOverwriteMode>(overwrite_mode),
    &SignalProxy_Progress::c_callback, &proxy);
    
  handle_result(result);
}

void remove(const Glib::RefPtr<const Uri>& source_uri,
      TransferOptions options,
      ErrorMode error_mode,
      const SlotProgress& slot)
{
  std::list< Glib::RefPtr<const Uri> > listUris;
  listUris.push_back(source_uri);
  remove(source_uri, options, error_mode, slot);
}


void remove(const ListHandleUris& source_uri_list,
      TransferOptions options,
      ErrorMode error_mode,
      const SlotProgress& slot)
{
  SignalProxy_Progress proxy(slot);
  GnomeVFSResult result = gnome_vfs_xfer_delete_list(source_uri_list.data(),
    static_cast<GnomeVFSXferErrorMode>(error_mode),
    static_cast<GnomeVFSXferOptions>(options),
    &SignalProxy_Progress::c_callback, &proxy);

  handle_result(result);
}


} // namespace Transfer
} // namespace Vfs
} // namespace Gnome
