/* Copyright 2007-2009 Matthew Barnes
 *
 * This file is part of GNOME Video Arcade.
 *
 * GNOME Video Arcade is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * GNOME Video Arcade is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * SECTION: gva-properties
 * @short_description: Properties Window
 *
 * These functions manipulate the Properties window.
 **/

#ifndef GVA_PROPERTIES_H
#define GVA_PROPERTIES_H

#include "gva-common.h"

G_BEGIN_DECLS

void            gva_properties_init             (void);
void            gva_properties_show_game        (const gchar *game);

/* Signal Handlers */

void            gva_properties_close_clicked_cb (GtkWindow *window,
                                                 GtkButton *button);
void            gva_properties_show_cb          (GtkWindow *window);

G_END_DECLS

#endif /* GVA_PROPERTIES_H */
