/* The CSS Theme Engine for Gtk+.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <ccss/ccss.h>

/* Need the ccss include above for the feature defs. */
#ifdef CCSS_WITH_SOUP
#include <libsoup/soup.h>
#endif

#include "gce-functions.h"

/*
 * TODO make this bullet proof wrt uri scheme.
 */
static char *
url (GSList const *args)
{
	char		*given_path;
	char		*resolved_path;
	char		*ret;
#ifdef CCSS_WITH_SOUP
	SoupURI		*uri;

	g_return_val_if_fail (args, NULL);

	given_path = g_strdup_printf ("file:///%s", (char const *) args->data);
	uri = soup_uri_new (given_path);
	g_free (given_path), given_path = NULL;

	resolved_path = gtk_rc_find_pixmap_in_path (gtk_settings_get_default (), NULL, uri->path);
	soup_uri_set_path (uri, resolved_path);
	g_free (resolved_path), resolved_path = NULL;

	ret = soup_uri_to_string (uri, FALSE);
	soup_uri_free (uri), uri = NULL;
#else
	g_return_val_if_fail (args, NULL);

	given_path = (char const *) args->data;
	resolved_path = gtk_rc_find_pixmap_in_path (gtk_settings_get_default (), NULL, given_path);
	ret = resolved_path;
#endif

	return ret;
}

static ccss_function_t const _functions[] = 
{
	{ "url", url },
	{ NULL }
};

ccss_function_t const *
gce_functions_get_vtable (void)
{
	return _functions;
}

