// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GL_WINDOW_H
#define _GDKMM_GL_WINDOW_H

#include <glibmm.h>

// -*- C++ -*-
/* gdkglextmm - C++ Wrapper for GdkGLExt
 * Copyright (C) 2002-2003  Naofumi Yasufuku
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 */

#include <gdkmm/gl/defs.h>

#include <gdkmm/drawable.h>
#include <gdkmm/window.h>

#include <gdkmm/gl/config.h>
#include <gdkmm/gl/drawable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGLWindow GdkGLWindow;
typedef struct _GdkGLWindowClass GdkGLWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{ class Window_Class; } // namespace GL

} // namespace Gdk
namespace Gdk
{
namespace GL
{

  /** OpenGL window which is located onscreen.
   *
   * @ingroup GLDrawables
   */


class Window : public Gdk::Drawable,
               public Gdk::GL::Drawable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GdkGLWindow BaseObjectType;
  typedef GdkGLWindowClass BaseClassType;

private:
  friend class Window_Class;
  static CppClassType window_class_;

  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GdkGLWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkGLWindow*       gobj()       { return reinterpret_cast<GdkGLWindow*>(gobject_); }
  const GdkGLWindow* gobj() const { return reinterpret_cast<GdkGLWindow*>(gobject_); }

  GdkGLWindow* gobj_copy();

private:


protected:
  Window(const Glib::RefPtr<const Config>& glconfig,
         const Glib::RefPtr<const Gdk::Window>& window,
         const int* attrib_list = 0);

public:
  
  static Glib::RefPtr<Window> create(const Glib::RefPtr<const Config>& glconfig, const Glib::RefPtr<const Gdk::Window>& window, const int* attrib_list);


public:

  
  /** Returns the Gdk::Window associated with @a glwindow .
   * 
   * Notice that Gdk::GLWindow is not Gdk::Window, but another
   * Gdk::Drawable which have an associated Gdk::Window.
   * @return The Gdk::Window associated with @a glwindow .
   */
  Glib::RefPtr<Gdk::Window> get_window();

  
  /** Returns the Gdk::Window associated with @a glwindow .
   * 
   * Notice that Gdk::GLWindow is not Gdk::Window, but another
   * Gdk::Drawable which have an associated Gdk::Window.
   * @return The Gdk::Window associated with @a glwindow .
   */
  Glib::RefPtr<const Gdk::Window> get_window() const;

public:

  
  /** Set the OpenGL-capability to the @a window .
   * The call creates a new Gdk::GLWindow.
   * attrib_list is currently unused. This must be set to <tt>0</tt> or empty
   * (first attribute of None).
   * @param glconfig A Gdk::GLConfig.
   * @param attrib_list This must be set to <tt>0</tt> or empty (first attribute of None).
   * @return The Gdk::GLWindow used by the @a window  if it is successful,
   * <tt>0</tt> otherwise.
   */
  static Glib::RefPtr<Window> set_gl_capability(const Glib::RefPtr<Gdk::Window>& window, const Glib::RefPtr<const Config>& glconfig, const int* attrib_list = 0);

  
  /** Unset the OpenGL-capability of the @a window .
   * This function destroys the Gdk::GLWindow held by the @a window .
   */
  static void unset_gl_capability(const Glib::RefPtr<Gdk::Window>& window);

  
  /** Returns whether the @a window  is OpenGL-capable.
   * @return <tt>true</tt> if the @a window  is OpenGL-capable, <tt>false</tt> otherwise.
   */
  static bool is_gl_capable(const Glib::RefPtr<const Gdk::Window>& window);

  
  /** Returns the Gdk::GLWindow held by the @a window .
   * @return The Gdk::GLWindow.
   */
  static Glib::RefPtr<Window> get_gl_window(const Glib::RefPtr<const Gdk::Window>& window);

  
  static Glib::RefPtr<Gdk::GL::Drawable> get_gl_drawable(const Glib::RefPtr<const Gdk::Window>& window);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GL
} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::GL::Window */
  Glib::RefPtr<Gdk::GL::Window> wrap(GdkGLWindow* object, bool take_copy = false);
}


#endif /* _GDKMM_GL_WINDOW_H */

