/* GDA common library
 * Copyright (C) 1998 - 2004 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *	Gonzalo Paniagua Javier <gonzalo@gnome-db.org>
 *      Vivien Malerba <malerba@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gda_data_model_hash_h__)
#  define __gda_data_model_hash_h__

#include <libgda/gda-data-model.h>
#include <libgda/gda-data-model-row.h>

G_BEGIN_DECLS

#define GDA_TYPE_DATA_MODEL_HASH            (gda_data_model_hash_get_type())
#define GDA_DATA_MODEL_HASH(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_TYPE_DATA_MODEL_HASH, GdaDataModelHash))
#define GDA_DATA_MODEL_HASH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GDA_TYPE_DATA_MODEL_HASH, GdaDataModelHashClass))
#define GDA_IS_DATA_MODEL_HASH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GDA_TYPE_DATA_MODEL_HASH))
#define GDA_IS_DATA_MODEL_HASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_TYPE_DATA_MODEL_HASH))

typedef struct _GdaDataModelHash        GdaDataModelHash;
typedef struct _GdaDataModelHashClass   GdaDataModelHashClass;
typedef struct _GdaDataModelHashPrivate GdaDataModelHashPrivate;

struct _GdaDataModelHash {
	GdaDataModelRow model;
	GdaDataModelHashPrivate *priv;
};

struct _GdaDataModelHashClass {
	GdaDataModelRowClass parent_class;
};

GType         gda_data_model_hash_get_type      (void);
GdaDataModel *gda_data_model_hash_new           (gint cols);

void	      gda_data_model_hash_clear         (GdaDataModelHash *model);
void	      gda_data_model_hash_set_n_columns (GdaDataModelHash *model,
						 gint cols);

void 	      gda_data_model_hash_insert_row    (GdaDataModelHash *model,
						 gint rownum, 
						 GdaRow *row);


G_END_DECLS

#endif

