/* GNOME DB library
 * Copyright (C) 1999-2001 The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <bonobo/bonobo-i18n.h>
#include <gtk/gtknotebook.h>
#include <libgnomedb/gnome-db-browser.h>

typedef struct {
	GtkWidget *container;
	GtkWidget *data_grid;
} GnomeDbBrowserTablesPrivate;

/*
 * Private functions
 */

static void
free_private_data (gpointer data)
{
	GnomeDbBrowserTablesPrivate *priv = (GnomeDbBrowserTablesPrivate *) data;

	g_return_if_fail (priv != NULL);

	g_free (priv);
}

/*
 * Public functions
 */

GtkWidget *
gnome_db_browser_tables_new (void)
{
	GtkWidget *box;
	GnomeDbBrowserTablesPrivate *priv;

	priv = g_new0 (GnomeDbBrowserTablesPrivate, 1);
	priv->container = gnome_db_new_notebook_widget ();
	g_object_set_data_full (G_OBJECT (priv->container), "GnomeDbBrowserTablesPrivate",
				priv, (GDestroyNotify) free_private_data);

	gtk_widget_show (priv->container);

	/* create 'Data' tab */
	box = gnome_db_new_vbox_widget ();
	priv->data_grid = gnome_db_new_grid_widget ();
	gtk_box_pack_start (GTK_BOX (box), priv->data_grid, TRUE, TRUE, 0);
	gtk_notebook_append_page (GTK_NOTEBOOK (priv->container),
				  box,
				  gtk_label_new (_("Data")));

	return priv->container;
}
