/* GNOME DB test program
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this Program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomedb/libgnomedb.h>
#include <libgnomeui/gnome-ui-init.h>

static void
window_closed_cb (GnomeDbWindow *window, gpointer user_data)
{
	gnome_db_main_quit ();
}

static void
create_window (gpointer user_data)
{
	GtkWidget *window;
	GtkWidget *selector;

	window = gnome_db_window_new ("test-dsn-selector", NULL, NULL, NULL, NULL);
	g_signal_connect (G_OBJECT (window), "close", G_CALLBACK (window_closed_cb), NULL);

	selector = gnome_db_data_source_selector_new (NULL);
	gtk_widget_show (selector);
	gnome_db_window_set_contents (GNOME_DB_WINDOW (window), selector);

	gnome_db_window_show (GNOME_DB_WINDOW (window));
}

int
main (int argc, char *argv[])
{
	gnome_db_init ("test-dsn-selector", VERSION, argc, argv);
	gnome_program_init ("test-dsn-selector", VERSION,
                            LIBGNOMEUI_MODULE,
                            argc, argv, NULL);

	gnome_db_main_run ((GdaInitFunc) create_window, NULL);
	return 0;
}
