/* gnome-db-graph.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_GRAPH_H_
#define __GNOME_DB_GRAPH_H_

#include <libgnomedb/gnome-db-base.h>
#include <libgnomedb/gnome-db-decl.h>

/* Implements the GnomeDbXmlStorage interface */

G_BEGIN_DECLS

#define GNOME_DB_GRAPH_TYPE          (gnome_db_graph_get_type())
#define GNOME_DB_GRAPH(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_graph_get_type(), GnomeDbGraph)
#define GNOME_DB_GRAPH_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_graph_get_type (), GnomeDbGraphClass)
#define IS_GNOME_DB_GRAPH(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_graph_get_type ())

/* error reporting */
extern GQuark gnome_db_graph_error_quark (void);
#define GNOME_DB_GRAPH_ERROR gnome_db_graph_error_quark ()

enum
{
	GNOME_DB_GRAPH_XML_LOAD_ERROR
};

/* struct for the object's data */
struct _GnomeDbGraph
{
	GnomeDbBase           object;
	GnomeDbGraphPrivate  *priv;
};

/* struct for the object's class */
struct _GnomeDbGraphClass
{
	GnomeDbBaseClass   class;
	
	/* signals */
	void        (*item_added)   (GnomeDbGraph *graph, GnomeDbGraphItem *item);
	void        (*item_dropped) (GnomeDbGraph *graph, GnomeDbGraphItem *item);
	void        (*item_moved)   (GnomeDbGraph *graph, GnomeDbGraphItem *item);
};

guint            gnome_db_graph_get_type            (void);

GObject         *gnome_db_graph_new                 (GnomeDbDict *dict, GnomeDbGraphType type);
GnomeDbGraphType      gnome_db_graph_get_graph_type      (GnomeDbGraph *graph);

void             gnome_db_graph_add_item            (GnomeDbGraph *graph, GnomeDbGraphItem *item);
void             gnome_db_graph_del_item            (GnomeDbGraph *graph, GnomeDbGraphItem *item);
GnomeDbGraphItem     *gnome_db_graph_get_item_from_obj   (GnomeDbGraph *graph, GnomeDbBase *ref_obj, gboolean create_if_needed);
GSList          *gnome_db_graph_get_items           (GnomeDbGraph *graph);

G_END_DECLS

#endif
