/* gnome-db-condition.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_CONDITION_H_
#define __GNOME_DB_CONDITION_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

/* Implements the GnomeDbXmlStorage, GnomeDbReferer and GnomeDbRenderer interfaces */

G_BEGIN_DECLS

#define GNOME_DB_CONDITION_TYPE          (gnome_db_condition_get_type())
#define GNOME_DB_CONDITION(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_condition_get_type(), GnomeDbCondition)
#define GNOME_DB_CONDITION_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_condition_get_type (), GnomeDbConditionClass)
#define IS_GNOME_DB_CONDITION(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_condition_get_type ())

/* error reporting */
extern GQuark gnome_db_condition_error_quark (void);
#define GNOME_DB_CONDITION_ERROR gnome_db_condition_error_quark ()

/* different possible types for a query */
typedef enum {
        GNOME_DB_CONDITION_NODE_AND,
        GNOME_DB_CONDITION_NODE_OR,
        GNOME_DB_CONDITION_NODE_NOT,
	GNOME_DB_CONDITION_LEAF_EQUAL,
        GNOME_DB_CONDITION_LEAF_DIFF,
        GNOME_DB_CONDITION_LEAF_SUP,
        GNOME_DB_CONDITION_LEAF_SUPEQUAL,
        GNOME_DB_CONDITION_LEAF_INF,
        GNOME_DB_CONDITION_LEAF_INFEQUAL,
        GNOME_DB_CONDITION_LEAF_LIKE,
	GNOME_DB_CONDITION_LEAF_SIMILAR,
        GNOME_DB_CONDITION_LEAF_REGEX,
        GNOME_DB_CONDITION_LEAF_REGEX_NOCASE,
        GNOME_DB_CONDITION_LEAF_NOT_REGEX,
        GNOME_DB_CONDITION_LEAF_NOT_REGEX_NOCASE,
        GNOME_DB_CONDITION_LEAF_IN,
        GNOME_DB_CONDITION_LEAF_BETWEEN,
        GNOME_DB_CONDITION_TYPE_UNKNOWN
} GnomeDbConditionType;

typedef enum {
	GNOME_DB_CONDITION_OP_LEFT   = 0,
	GNOME_DB_CONDITION_OP_RIGHT  = 1,
	GNOME_DB_CONDITION_OP_RIGHT2 = 2
} GnomeDbConditionOperator;

enum
{
	GNOME_DB_CONDITION_XML_LOAD_ERROR,
	GNOME_DB_CONDITION_RENDERER_ERROR,
	GNOME_DB_CONDITION_PARENT_ERROR
};


/* struct for the object's data */
struct _GnomeDbCondition
{
	GnomeDbBase               object;
	GnomeDbConditionPrivate  *priv;
};

/* struct for the object's class */
struct _GnomeDbConditionClass
{
	GnomeDbBaseClass                    class;
};

guint            gnome_db_condition_get_type                (void);
GObject         *gnome_db_condition_new                     (GnomeDbQuery *query, GnomeDbConditionType type);
GObject         *gnome_db_condition_new_copy                (GnomeDbCondition *orig, GHashTable *replacements);
GObject         *gnome_db_condition_new_from_sql            (GnomeDbQuery *query, const gchar *sql_cond, 
						       GSList **targets, GError **error);

void             gnome_db_condition_set_cond_type           (GnomeDbCondition *condition, GnomeDbConditionType type);
GnomeDbConditionType  gnome_db_condition_get_cond_type           (GnomeDbCondition *condition);

GSList          *gnome_db_condition_get_children            (GnomeDbCondition *condition);
GnomeDbCondition     *gnome_db_condition_get_parent              (GnomeDbCondition *condition);
GnomeDbCondition     *gnome_db_condition_get_child_by_xml_id     (GnomeDbCondition *condition, const gchar *xml_id);
gboolean         gnome_db_condition_is_ancestor             (GnomeDbCondition *condition, GnomeDbCondition *ancestor);
gboolean         gnome_db_condition_is_leaf                 (GnomeDbCondition *condition);

/* Node conditions */    
gboolean         gnome_db_condition_node_add_child          (GnomeDbCondition *condition, GnomeDbCondition *child, GError **error);
void             gnome_db_condition_node_del_child          (GnomeDbCondition *condition, GnomeDbCondition *child);


/* Leaf conditions */
void             gnome_db_condition_leaf_set_operator      (GnomeDbCondition *condition, 
						      GnomeDbConditionOperator op, GnomeDbQfield *field);
GnomeDbQfield        *gnome_db_condition_leaf_get_operator      (GnomeDbCondition *condition, GnomeDbConditionOperator op);

GSList          *gnome_db_condition_get_ref_objects_all    (GnomeDbCondition *condition);

gboolean         gnome_db_condition_represents_join        (GnomeDbCondition *condition,
						      GnomeDbTarget **target1, GnomeDbTarget **target2,
						      gboolean *is_equi_join);
gboolean         gnome_db_condition_represents_join_strict (GnomeDbCondition *condition,
						      GnomeDbTarget **target1, GnomeDbTarget **target2);
GSList          *gnome_db_condition_get_main_conditions    (GnomeDbCondition *condition);
G_END_DECLS

#endif
