/* gnome-db-entry-string.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_ENTRY_STRING_H_
#define __GNOME_DB_ENTRY_STRING_H_

#include "gnome-db-entry-wrapper.h"

G_BEGIN_DECLS

#define GNOME_DB_ENTRY_STRING_TYPE          (gnome_db_entry_string_get_type())
#define GNOME_DB_ENTRY_STRING(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_entry_string_get_type(), GnomeDbEntryString)
#define GNOME_DB_ENTRY_STRING_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_entry_string_get_type (), GnomeDbEntryStringClass)
#define IS_GNOME_DB_ENTRY_STRING(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_entry_string_get_type ())


typedef struct _GnomeDbEntryString GnomeDbEntryString;
typedef struct _GnomeDbEntryStringClass GnomeDbEntryStringClass;
typedef struct _GnomeDbEntryStringPrivate GnomeDbEntryStringPrivate;


/* struct for the object's data */
struct _GnomeDbEntryString
{
	GnomeDbEntryWrapper              object;
	GnomeDbEntryStringPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbEntryStringClass
{
	GnomeDbEntryWrapperClass         class;
};

guint        gnome_db_entry_string_get_type        (void);
GtkWidget   *gnome_db_entry_string_new             (GnomeDbDataHandler *dh, GdaValueType type);


G_END_DECLS

#endif
