/* gnome-db-parameter.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_PARAMETER_H_
#define __GNOME_DB_PARAMETER_H_

#include "gnome-db-decl.h"
#include "gnome-db-base.h"
#include <libgda/libgda.h>


G_BEGIN_DECLS

#define GNOME_DB_PARAMETER_TYPE          (gnome_db_parameter_get_type())
#define GNOME_DB_PARAMETER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_parameter_get_type(), GnomeDbParameter)
#define GNOME_DB_PARAMETER_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_parameter_get_type (), GnomeDbParameterClass)
#define IS_GNOME_DB_PARAMETER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_parameter_get_type ())

/* error reporting */
extern GQuark gnome_db_parameter_error_quark (void);
#define GNOME_DB_PARAMETER_ERROR gnome_db_parameter_error_quark ()

enum {
	GNOME_DB_PARAMETER_QUERY_LIMIT_ERROR
};

/* struct for the object's data */
struct _GnomeDbParameter
{
	GnomeDbBase                    object;
	GnomeDbParameterPrivate       *priv;
};


/* struct for the object's class */
struct _GnomeDbParameterClass
{
	GnomeDbBaseClass                    class;
};

GType                  gnome_db_parameter_get_type                (void);
GObject               *gnome_db_parameter_new                     (GnomeDbDict *dict, GnomeDbServerDataType *type);
GObject               *gnome_db_parameter_new_copy                (GnomeDbParameter *orig);
GObject               *gnome_db_parameter_new_with_dest_field     (GnomeDbField *field, GnomeDbServerDataType *type);

void                   gnome_db_parameter_add_dest_field          (GnomeDbParameter *param, GnomeDbField *field);
GSList                *gnome_db_parameter_get_dest_fields         (GnomeDbParameter *param);
GnomeDbServerDataType *gnome_db_parameter_get_data_type           (GnomeDbParameter *param);

const GdaValue        *gnome_db_parameter_get_value               (GnomeDbParameter *param);
void                   gnome_db_parameter_set_value               (GnomeDbParameter *param, const GdaValue *value);
gboolean               gnome_db_parameter_set_value_str           (GnomeDbParameter *param, const gchar *value);

void                   gnome_db_parameter_declare_invalid         (GnomeDbParameter *param);
gboolean               gnome_db_parameter_is_valid                (GnomeDbParameter *param);

const GdaValue        *gnome_db_parameter_get_default_value       (GnomeDbParameter *param);
void                   gnome_db_parameter_set_default_value       (GnomeDbParameter *param, const GdaValue *value);

void                   gnome_db_parameter_set_not_null            (GnomeDbParameter *param, gboolean not_null);
gboolean               gnome_db_parameter_get_not_null            (GnomeDbParameter *param);

gboolean               gnome_db_parameter_set_source_field        (GnomeDbParameter *param, GnomeDbField *field, GError **error);
GnomeDbField          *gnome_db_parameter_get_source_field        (GnomeDbParameter *param);

void                   gnome_db_parameter_add_dependency          (GnomeDbParameter *param, GnomeDbParameter *depend_on);
void                   gnome_db_parameter_del_dependency          (GnomeDbParameter *param, GnomeDbParameter *depend_on);
GSList                *gnome_db_parameter_get_dependencies        (GnomeDbParameter *param);

void                   gnome_db_parameter_replace_ref             (GnomeDbParameter *param, GHashTable *replacements);

void                   gnome_db_parameter_bind_to_param           (GnomeDbParameter *param, GnomeDbParameter *bind_to);
GnomeDbParameter      *gnome_db_parameter_get_bind_param          (GnomeDbParameter *param);

gboolean               gnome_db_parameter_requires_user_input     (GnomeDbParameter *param);
void                   gnome_db_parameter_set_user_input_required (GnomeDbParameter *param, gboolean input_required);


G_END_DECLS

#endif
