/* gnome-db-decl.h
 *
 * Copyright (C) 2003 - 2006 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_DECL_H_
#define __GNOME_DB_DECL_H_

/* Define how the SQL functions and aggregates are
 * tested for their arguments.
 * DO_TEST: only test the number of arguments (if 0) and apply STRICT test or not
 */
#define GNOME_DB_FUNCTIONS_TEST_PARAMS_DO_TEST 0

typedef struct _GnomeDbDataStore      GnomeDbDataStore;
typedef struct _GnomeDbDataStoreClass GnomeDbDataStoreClass;
typedef struct _GnomeDbDataStorePriv  GnomeDbDataStorePriv;

typedef struct _GnomeDbSelector      GnomeDbSelector;
typedef struct _GnomeDbSelectorClass GnomeDbSelectorClass;
typedef struct _GnomeDbSelectorPriv  GnomeDbSelectorPriv;

/* 
 * Interfaces 
 */
typedef struct _GnomeDbDataEntry        GnomeDbDataEntry;
typedef struct _GnomeDbDataEntryIface   GnomeDbDataEntryIface;

typedef struct _GnomeDbDataWidget       GnomeDbDataWidget;
typedef struct _GnomeDbDataWidgetIface  GnomeDbDataWidgetIface;


/*
 * Graphing part
 */
typedef struct _GnomeDbCanvas        GnomeDbCanvas;
typedef struct _GnomeDbCanvasClass   GnomeDbCanvasClass;
typedef struct _GnomeDbCanvasPrivate GnomeDbCanvasPrivate;

typedef struct _GnomeDbCanvasItem        GnomeDbCanvasItem;
typedef struct _GnomeDbCanvasItemClass   GnomeDbCanvasItemClass;
typedef struct _GnomeDbCanvasItemPrivate GnomeDbCanvasItemPrivate;

typedef struct _GnomeDbCanvasEntity        GnomeDbCanvasEntity;
typedef struct _GnomeDbCanvasEntityClass   GnomeDbCanvasEntityClass;
typedef struct _GnomeDbCanvasEntityPrivate GnomeDbCanvasEntityPrivate;

typedef struct _GnomeDbCanvasField        GnomeDbCanvasField;
typedef struct _GnomeDbCanvasFieldClass   GnomeDbCanvasFieldClass;
typedef struct _GnomeDbCanvasFieldPrivate GnomeDbCanvasFieldPrivate;


/* 
 * Colors
 */
#define GNOME_DB_COLOR_NORMAL_NULL "#00cd66"
#define GNOME_DB_COLOR_PRELIGHT_NULL "#00ef77"

#define GNOME_DB_COLOR_NORMAL_DEFAULT "#6495ed"
#define GNOME_DB_COLOR_PRELIGHT_DEFAULT "#75a6fe"

#define GNOME_DB_COLOR_NORMAL_MODIF "#cacaee"
#define GNOME_DB_COLOR_PRELIGHT_MODIF "#cfcffe"

#define GNOME_DB_COLOR_NORMAL_INVALID "#ff6a6a"
#define GNOME_DB_COLOR_PRELIGHT_INVALID "#ff7b7b"

#define GNOME_DB_REFERER_ACTIVE   "#e0ffe0"
#define GNOME_DB_REFERER_INACTIVE "#ffe0e0"
#define GNOME_DB_REFERER_UNKNOWN  "#e0e0ff"

/*
 * Variou macros
 */
#ifdef debug
#define D_COL_NOR "\033[0m"
#define D_COL_H0 "\033[;34;7m"
#define D_COL_H1 "\033[;36;7m"
#define D_COL_H2 "\033[;36;4m"
#define D_COL_OK "\033[;32m"
#define D_COL_ERR "\033[;31;1m"
#define AAA(X) (g_print (D_COL_H1 "DEBUG MARK %d\n" D_COL_NOR, X))
#define DEBUG_HEADER (g_print (D_COL_H0 "====================== %s %s():%d ======================\n" D_COL_NOR, __FILE__, __FUNCTION__, __LINE__))
#define DEBUG_HEADER_STR(str) (g_print (D_COL_H0 "====================== %s %s %s():%d ======================\n" D_COL_NOR, (str), __FILE__, __FUNCTION__, __LINE__))
#endif

#ifndef TO_IMPLEMENT
  #ifdef debug
    #define TO_IMPLEMENT g_print (D_COL_ERR "Implementation missing:" D_COL_NOR " %s() in %s line %d\n", __FUNCTION__, __FILE__,__LINE__)
  #else
    #define TO_IMPLEMENT g_print ("Implementation missing: %s() in %s line %d\n", __FUNCTION__, __FILE__,__LINE__)
  #endif
#endif

#endif
