/*Class for communicating with the rz program*/

#include <src/Rzwrapper.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include "src/MoUtils.h"




struct _moserialRzwrapperPrivate {
	moserialRzwrapperProtocol _protocol;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	char* _path;
	char* _filename;
};

#define MOSERIAL_RZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperPrivate))
enum  {
	MOSERIAL_RZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_RZWRAPPER_PROTOCOL,
	MOSERIAL_RZWRAPPER_PATH,
	MOSERIAL_RZWRAPPER_FILENAME
};
static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self);
static void moserial_rzwrapper_shutdown (moserialRzwrapper* self);
static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value);
static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const char* value);
static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const char* value);
static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_rzwrapper_parent_class = NULL;
static void moserial_rzwrapper_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType moserial_rzwrapper_protocol_get_type (void) {
	static GType moserial_rzwrapper_protocol_type_id = 0;
	if (G_UNLIKELY (moserial_rzwrapper_protocol_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_NULL, "MOSERIAL_RZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		moserial_rzwrapper_protocol_type_id = g_enum_register_static ("moserialRzwrapperProtocol", values);
	}
	return moserial_rzwrapper_protocol_type_id;
}


moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename) {
	GParameter * __params;
	GParameter * __params_it;
	moserialRzwrapper * self;
	moserialSerialConnection* _tmp1;
	moserialSerialConnection* _tmp0;
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "protocol";
	g_value_init (&__params_it->value, MOSERIAL_RZWRAPPER_TYPE_PROTOCOL);
	g_value_set_enum (&__params_it->value, *protocol);
	__params_it++;
	__params_it->name = "path";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, p);
	__params_it++;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, filename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->sc = (_tmp1 = (_tmp0 = sc, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->sc == NULL) ? NULL : (self->sc = (g_object_unref (self->sc), NULL)), _tmp1);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename) {
	return moserial_rzwrapper_construct (MOSERIAL_TYPE_RZWRAPPER, protocol, sc, p, filename);
}


void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->running) {
		gsize bytesWritten;
		gchar* _tmp0;
		gint b_size;
		gint b_length1;
		gchar* b;
		bytesWritten = 0UL;
		_tmp0 = NULL;
		b = (_tmp0 = g_new0 (gchar, 1), b_length1 = 1, b_size = b_length1, _tmp0);
		b[0] = (gchar) byte;
		{
			if (self->running) {
				g_io_channel_write_chars (self->priv->IOChannelInput, b, b_length1, &bytesWritten, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_IO_CHANNEL_ERROR) {
						goto __catch12_g_io_channel_error;
					}
					if (inner_error->domain == G_CONVERT_ERROR) {
						goto __catch12_g_convert_error;
					}
					goto __finally12;
				}
			}
		}
		goto __finally12;
		__catch12_g_io_channel_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				/*if(running)
				IOChannelInput.flush();*/
				moserial_rzwrapper_shutdown (self);
				fprintf (stdout, "writeChar() %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		goto __finally12;
		__catch12_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "%s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally12:
		if (inner_error != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		b = (g_free (b), NULL);
	}
}


void moserial_rzwrapper_flush (moserialRzwrapper* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->running) {
		{
			if (self->running) {
				g_io_channel_flush (self->priv->IOChannelInput, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_IO_CHANNEL_ERROR) {
						goto __catch13_g_io_channel_error;
					}
					goto __finally13;
				}
			}
		}
		goto __finally13;
		__catch13_g_io_channel_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				moserial_rzwrapper_shutdown (self);
				fprintf (stdout, "flush() %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally13:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
}


static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	inner_error = NULL;
	if (self->running) {
		gchar* _tmp0;
		gint m_buf_size;
		gint m_buf_length1;
		gchar* m_buf;
		char* message;
		char* messages;
		gsize bytesRead;
		char* _tmp5;
		gboolean _tmp6;
		_tmp0 = NULL;
		m_buf = (_tmp0 = g_new0 (gchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp0);
		message = g_strdup ("");
		messages = g_strdup ("");
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, m_buf = (g_free (m_buf), NULL), message = (g_free (message), NULL), messages = (g_free (messages), NULL), _tmp1);
		}
		{
			g_io_channel_read_chars (source, m_buf, m_buf_length1, &bytesRead, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_CONVERT_ERROR) {
					goto __catch14_g_convert_error;
				}
				goto __finally14;
			}
		}
		goto __finally14;
		__catch14_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "readError() %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally14:
		if (inner_error != NULL) {
			m_buf = (g_free (m_buf), NULL);
			message = (g_free (message), NULL);
			messages = (g_free (messages), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			for (; x < bytesRead; x++) {
				gunichar c;
				gboolean _tmp2;
				c = (gunichar) m_buf[x];
				_tmp2 = FALSE;
				if (g_unichar_isprint (c)) {
					_tmp2 = TRUE;
				} else {
					_tmp2 = g_unichar_isspace (c);
				}
				if (_tmp2) {
					char* _tmp4;
					char* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					messages = (_tmp4 = g_strconcat (messages, _tmp3 = g_strdup_printf ("%c", (gint) m_buf[x]), NULL), messages = (g_free (messages), NULL), _tmp4);
					_tmp3 = (g_free (_tmp3), NULL);
				}
			}
		}
		_tmp5 = NULL;
		message = (_tmp5 = mo_utils_getLastMessage (messages), message = (g_free (message), NULL), _tmp5);
		if (!(_vala_strcmp0 (message, "") == 0)) {
			g_signal_emit_by_name (self, "update-status", message);
		}
		if (!(strstr (messages, "Transfer complete") == NULL)) {
			moserial_rzwrapper_shutdown (self);
		}
		if (!(strstr (messages, "Transfer incomplete") == NULL)) {
			moserial_rzwrapper_shutdown (self);
		}
		return (_tmp6 = TRUE, m_buf = (g_free (m_buf), NULL), message = (g_free (message), NULL), messages = (g_free (messages), NULL), _tmp6);
	} else {
		return FALSE;
	}
}


static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self) {
	return moserial_rzwrapper_shutdown_timeout (self);
}


void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	/*send cancel string to remote client and rz*/
	if (self->running) {
		g_signal_emit_by_name (self, "update-status", "canceled");
		{
			gint x;
			x = 0;
			for (; x < 20; x++) {
				if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM) {
					moserial_serial_connection_sendByte (self->sc, (guchar) ('X' & 037));
					moserial_rzwrapper_writeChar (self, (guchar) ('X' & 037));
				} else {
					moserial_serial_connection_sendByte (self->sc, (guchar) 0x18);
				}
			}
		}
		g_timeout_add ((guint) 2000, _moserial_rzwrapper_shutdown_timeout_gsource_func, self);
	}
}


static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_rzwrapper_shutdown (self);
	return FALSE;
}


static void moserial_rzwrapper_shutdown (moserialRzwrapper* self) {
	g_return_if_fail (self != NULL);
	if (self->running) {
		self->running = FALSE;
		g_source_remove (self->priv->outputChannelId);
		g_source_remove (self->priv->errorChannelId);
		g_spawn_close_pid (self->priv->pid);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	inner_error = NULL;
	if (self->running) {
		gchar* _tmp0;
		gint m_buf_size;
		gint m_buf_length1;
		gchar* m_buf;
		gsize bytesRead;
		gboolean _tmp2;
		_tmp0 = NULL;
		m_buf = (_tmp0 = g_new0 (gchar, 1000), m_buf_length1 = 1000, m_buf_size = m_buf_length1, _tmp0);
		bytesRead = (gsize) 0;
		if (!(condition == G_IO_IN)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, m_buf = (g_free (m_buf), NULL), _tmp1);
		}
		{
			g_io_channel_read_chars (source, m_buf, m_buf_length1, &bytesRead, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == G_CONVERT_ERROR) {
					goto __catch15_g_convert_error;
				}
				goto __finally15;
			}
		}
		goto __finally15;
		__catch15_g_convert_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, "readBytes() %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally15:
		if (inner_error != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			for (; x < bytesRead; x++) {
				moserial_serial_connection_sendByte (self->sc, (guchar) m_buf[x]);
			}
		}
		/*sendByte(m_buf[x]);
		outgoingHexTextBuffer.add(m_buf[x]);*/
		return (_tmp2 = TRUE, m_buf = (g_free (m_buf), NULL), _tmp2);
	} else {
		return FALSE;
	}
}


moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_protocol;
}


static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value) {
	g_return_if_fail (self != NULL);
	self->priv->_protocol = value;
	g_object_notify ((GObject *) self, "protocol");
}


const char* moserial_rzwrapper_get_path (moserialRzwrapper* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_path;
}


static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_path = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_path = (g_free (self->priv->_path), NULL), _tmp2);
	g_object_notify ((GObject *) self, "path");
}


const char* moserial_rzwrapper_get_filename (moserialRzwrapper* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_filename;
}


static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_filename = (g_free (self->priv->_filename), NULL), _tmp2);
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_rzwrapper_readBytes (self, source, condition);
}


static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return moserial_rzwrapper_readError (self, source, condition);
}


static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialRzwrapperClass * klass;
	GObjectClass * parent_class;
	moserialRzwrapper * self;
	GError * inner_error;
	klass = MOSERIAL_RZWRAPPER_CLASS (g_type_class_peek (MOSERIAL_TYPE_RZWRAPPER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RZWRAPPER (obj);
	inner_error = NULL;
	{
		gboolean _tmp0;
		_tmp0 = FALSE;
		if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_NULL) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = self->priv->_path == NULL;
		}
		if (_tmp0) {
			self->running = FALSE;
		} else {
			gint argv_size;
			gint argv_length1;
			char** argv;
			char* _tmp3;
			char* _tmp7;
			gint output;
			gint error;
			gint input;
			argv = (argv_length1 = 0, NULL);
			if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
				char** _tmp1;
				_tmp1 = NULL;
				argv = (_tmp1 = g_new0 (char*, 4 + 1), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 4, argv_size = argv_length1, _tmp1);
			} else {
				char** _tmp2;
				_tmp2 = NULL;
				argv = (_tmp2 = g_new0 (char*, 3 + 1), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 3, argv_size = argv_length1, _tmp2);
			}
			_tmp3 = NULL;
			argv[0] = (_tmp3 = g_strdup ("rz"), argv[0] = (g_free (argv[0]), NULL), _tmp3);
			switch (self->priv->_protocol) {
				case MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM:
				{
					char* _tmp4;
					_tmp4 = NULL;
					argv[1] = (_tmp4 = g_strdup ("--xmodem"), argv[1] = (g_free (argv[1]), NULL), _tmp4);
					break;
				}
				case MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM:
				{
					char* _tmp5;
					_tmp5 = NULL;
					argv[1] = (_tmp5 = g_strdup ("--ymodem"), argv[1] = (g_free (argv[1]), NULL), _tmp5);
					break;
				}
				default:
				{
					char* _tmp6;
					_tmp6 = NULL;
					argv[1] = (_tmp6 = g_strdup ("--zmodem"), argv[1] = (g_free (argv[1]), NULL), _tmp6);
					break;
				}
			}
			_tmp7 = NULL;
			argv[2] = (_tmp7 = g_strdup ("-vv"), argv[2] = (g_free (argv[2]), NULL), _tmp7);
			if (self->priv->_protocol == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
				char* _tmp9;
				const char* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				argv[3] = (_tmp9 = (_tmp8 = self->priv->_filename, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), argv[3] = (g_free (argv[3]), NULL), _tmp9);
			}
			output = 0;
			error = 0;
			input = 0;
			{
				GIOChannel* _tmp10;
				GIOChannel* _tmp11;
				GIOChannel* _tmp12;
				g_spawn_async_with_pipes (self->priv->_path, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &self->priv->pid, &input, &output, &error, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				_tmp10 = NULL;
				self->priv->IOChannelOutput = (_tmp10 = g_io_channel_unix_new (output), (self->priv->IOChannelOutput == NULL) ? NULL : (self->priv->IOChannelOutput = (g_io_channel_unref (self->priv->IOChannelOutput), NULL)), _tmp10);
				_tmp11 = NULL;
				self->priv->IOChannelInput = (_tmp11 = g_io_channel_unix_new (input), (self->priv->IOChannelInput == NULL) ? NULL : (self->priv->IOChannelInput = (g_io_channel_unref (self->priv->IOChannelInput), NULL)), _tmp11);
				_tmp12 = NULL;
				self->priv->IOChannelError = (_tmp12 = g_io_channel_unix_new (error), (self->priv->IOChannelError == NULL) ? NULL : (self->priv->IOChannelError = (g_io_channel_unref (self->priv->IOChannelError), NULL)), _tmp12);
				g_io_channel_set_encoding (self->priv->IOChannelOutput, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				g_io_channel_set_flags (self->priv->IOChannelOutput, G_IO_FLAG_NONBLOCK, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				g_io_channel_set_encoding (self->priv->IOChannelError, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				g_io_channel_set_flags (self->priv->IOChannelError, G_IO_FLAG_NONBLOCK, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				g_io_channel_set_encoding (self->priv->IOChannelInput, NULL, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_SPAWN_ERROR) {
						goto __catch16_g_spawn_error;
					}
					goto __finally16;
				}
				/*IOChannelInput.set_flags(GLib.IOFlags.NONBLOCK);*/
				self->priv->outputChannelId = g_io_add_watch (self->priv->IOChannelOutput, G_IO_IN, _moserial_rzwrapper_readBytes_gio_func, self);
				self->priv->errorChannelId = g_io_add_watch (self->priv->IOChannelError, G_IO_IN, _moserial_rzwrapper_readError_gio_func, self);
				self->running = TRUE;
			}
			goto __finally16;
			__catch16_g_spawn_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					char* _tmp13;
					GtkMessageDialog* _tmp14;
					GtkMessageDialog* errorDialog;
					self->running = FALSE;
					fprintf (stdout, "spawn error: %s\n", e->message);
					_tmp13 = NULL;
					_tmp14 = NULL;
					errorDialog = (_tmp14 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp13 = g_strdup_printf ("%s", e->message), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
					gtk_dialog_run ((GtkDialog*) errorDialog);
					gtk_object_destroy ((GtkObject*) errorDialog);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
					(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
				}
			}
			__finally16:
			if (inner_error != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	return obj;
}


static void moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	gpointer boxed;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_rzwrapper_get_protocol (self));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		g_value_set_string (value, moserial_rzwrapper_get_path (self));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_rzwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		moserial_rzwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		moserial_rzwrapper_set_path (self, g_value_get_string (value));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		moserial_rzwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_rzwrapper_class_init (moserialRzwrapperClass * klass) {
	moserial_rzwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_rzwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_rzwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_rzwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_rzwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_RZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_rzwrapper_instance_init (moserialRzwrapper * self) {
	self->priv = MOSERIAL_RZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_rzwrapper_finalize (GObject* obj) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (obj);
	(self->sc == NULL) ? NULL : (self->sc = (g_object_unref (self->sc), NULL));
	(self->priv->IOChannelInput == NULL) ? NULL : (self->priv->IOChannelInput = (g_io_channel_unref (self->priv->IOChannelInput), NULL));
	(self->priv->IOChannelOutput == NULL) ? NULL : (self->priv->IOChannelOutput = (g_io_channel_unref (self->priv->IOChannelOutput), NULL));
	(self->priv->IOChannelError == NULL) ? NULL : (self->priv->IOChannelError = (g_io_channel_unref (self->priv->IOChannelError), NULL));
	self->priv->_path = (g_free (self->priv->_path), NULL);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	G_OBJECT_CLASS (moserial_rzwrapper_parent_class)->finalize (obj);
}


GType moserial_rzwrapper_get_type (void) {
	static GType moserial_rzwrapper_type_id = 0;
	if (moserial_rzwrapper_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_rzwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRzwrapper), 0, (GInstanceInitFunc) moserial_rzwrapper_instance_init, NULL };
		moserial_rzwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRzwrapper", &g_define_type_info, 0);
	}
	return moserial_rzwrapper_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




