# Orca
#
# Copyright 2006 Sun Microsystems Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""A script to do nothing.  This is for self-voicing apps."""

__id__        = "$Id: self_voicing.py 2171 2007-03-13 16:14:46Z richb $"
__version__   = "$Revision: 2171 $"
__date__      = "$Date: 2007-03-13 12:14:46 -0400 (Tue, 13 Mar 2007) $"
__copyright__ = "Copyright (c) 2005-2006 Sun Microsystems Inc."
__license__   = "LGPL"

import orca.default as default

class Script(default.Script):
    """A script to do nothing.  This is for self-voicing apps."""
    
    def __init__(self, app):
        """Creates a script for the given application, if necessary.
        This method should not be called by anyone except the
        focus_tracking_presenter.

        Arguments:
        - app: the Python Accessible application to create a script for
        """

        default.Script.__init__(self, app)

    def getBrailleGenerator(self):
        """Returns the braille generator for this script.
        """
        return None

    def getSpeechGenerator(self):
        """Returns the speech generator for this script.
        """
        return None

    def processObjectEvent(self, event):
        """Does nothing.

        Arguments:
        - event: the Event
        """
        pass

    def processKeyboardEvent(self, keyboardEvent):
        """Does nothing.

        Arguments:
        - keyboardEvent: an instance of input_event.KeyboardEvent

        Returns False to indicate the event was not consumed.
        """
        return False

    def processBrailleEvent(self, brailleEvent):
        """Does nothing.

        Arguments:
        - brailleEvent: an instance of input_event.BrailleEvent

        Returns False to indicate the event was not consumed.
        """
        return False
