/*
 * rarian-language.c
 * This file is part of Rarian
 *
 * Copyright (C)  2006  - Don Scorgie
 *
 * Rarian is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rarian is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Rarian; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <rarian-language.h>
#include "rarian-utils.h"

typedef struct _Lang Lang;


struct _Lang
{
	char *base;
    Lang *next;
    Lang *prev;
};

static Lang *lang_list;
static int nlangs = 0 ;

void
rrn_language_init (char *lang)
{
	char *loc = NULL;
	char *current = NULL;
    char *tmp = NULL;

    if (lang == NULL) {
      loc = getenv ("LANGUAGE");
    } else {
      loc = strdup (lang);
    }
	nlangs = 0;

    if (!loc || !strcmp (loc, "")) {
        loc = strdup("C");
   }

	current = loc;
    do {
		Lang *lang;
		tmp = strchr (current, ':');

		lang = malloc (sizeof (Lang));
		if (tmp)
		  lang->base = rrn_strndup (current, tmp-current);
		else
		  lang->base = strdup (current);
		lang->prev = NULL;
		if (lang_list) {
			lang->next = lang_list;
			lang_list->prev = lang;
		} else {
			lang->next = NULL;
		}
		lang_list = lang;
		if (tmp)
			current = tmp+1;
		else
			current = NULL;
	} while (current);
	Lang *iter = lang_list;

	while (iter) {
		Lang *tmp = iter->next;
		nlangs += 1;

		iter->next = iter->prev;
		iter->prev = tmp;
		if (iter->prev == NULL) {
			lang_list = iter;
		}
		iter = iter->prev;
	}
	iter = lang_list;
}

int
rrn_language_use (char *current_language, char *proposed)
{
	Lang *iter = lang_list;

	if (!lang_list)
	  rrn_language_init(NULL);

	iter = lang_list;

	while (iter) {
		if (current_language && !strcmp (current_language, iter->base)) {
			return 0;
		}
		if (!strcmp (proposed, iter->base)) {
			return 1;
		}
		iter = iter->next;
	}
	return 0;
}

char **
rrn_language_get_langs (void)
{
	char **ret = NULL;
	Lang *iter;
	int i = 0;
	
	if (!lang_list)
	  rrn_language_init(NULL);

	iter =  lang_list;
	ret = malloc (sizeof (char*) * (nlangs+1));

	while (iter) {
	  ret[i] = iter->base;
	  i++;
	  iter = iter->next;
	}
	ret[i] = NULL;
	return ret;


}

char **
rrn_language_get_dirs (char *base)
{
	char **ret = NULL;
	Lang *iter;
	int i = 0;

	if (!lang_list)
	  rrn_language_init(NULL);
	
	iter = lang_list;

	ret = malloc (sizeof (char*) * (nlangs+1));

	while (iter) {
		char *new_path = NULL;

		new_path = malloc (sizeof (char) *(strlen(base)+9+strlen (iter->base)));
		sprintf (new_path, "%s/LOCALE/%s", base, iter->base);
		ret[i] = new_path;
		i++;
		iter = iter->next;
	}
	ret[i] = NULL;
	return ret;
}


void
rrn_language_shutdown (void)
{
	Lang *iter = lang_list;

	while (iter) {
		Lang *next = iter->next;
		free (iter->base);
		free (iter);
		iter = next;

	}
	lang_list = NULL;
}
