<?xml version='1.0' encoding='UTF-8'?><!-- -*- indent-tabs-mode: nil -*- -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:yelp="http://www.gnome.org/yelp/ns"
                xmlns="http://www.w3.org/1999/xhtml"
                extension-element-prefixes="yelp"
                version="1.0">

<xsl:import href="/usr/share/yelp-xsl/xslt/gettext/gettext.xsl"/>
<xsl:import href="/usr/share/yelp-xsl/xslt/theme/theme-colors.xsl"/>
<xsl:import href="/usr/share/yelp-xsl/xslt/theme/theme-icons.xsl"/>
<xsl:import href="/usr/share/yelp-xsl/xslt/theme/theme-html.xsl"/>
<xsl:include href="yelp-common.xsl"/>

<xsl:template name="linktrails">
  <xsl:param name="up" select="@up"/>
  <xsl:variable name="upnode" select="/Info//Section[@id = $up]"/>
  <xsl:if test="$upnode/@up">
    <xsl:call-template name="linktrails">
      <xsl:with-param name="up" select="$upnode/@up"/>
    </xsl:call-template>
  </xsl:if>
  <a href="xref:{$upnode/@id}">
    <xsl:value-of select="$upnode/@name"/>
  </a>
  <xsl:text>&#x00A0;» </xsl:text>
</xsl:template>

<xsl:template match="/Info">
  <xsl:apply-templates select="Section"/>
</xsl:template>

<xsl:template match="Section">
  <yelp:document href="{@id}">
    <html>
      <head>
        <title>
          <xsl:value-of select="@name"/>
        </title>
        <style type="text/css">
          <xsl:call-template name="html.css"/>
        </style>
      </head>
      <body>
        <div class="head">
          <xsl:if test="@up">
            <div class="trails">
              <div class="trail">
                <xsl:call-template name="linktrails"/>
              </div>
            </div>
          </xsl:if>
        </div>
        <div class="body">
          <div class="navbar">
            <xsl:variable name="preceding" select="preceding::Section[1]"/>
            <xsl:variable name="following" select="(Section[1] | following::Section[1])[1]"/>
            <xsl:if test="$preceding">
              <a class="navbar-prev" href="xref:{$preceding/@id}">
                <xsl:value-of select="$preceding/@name"/>
              </a>
            </xsl:if>
            <xsl:if test="$preceding and $following">
              <xsl:text>&#x00A0;&#x00A0;|&#x00A0;&#x00A0;</xsl:text>
            </xsl:if>
            <xsl:if test="$following">
              <a class="navbar-next" href="xref:{$following/@id}">
                <xsl:value-of select="$following/@name"/>
              </a>
            </xsl:if>
          </div>
          <xsl:apply-templates select="node()[not(self::Section)]"/>
        </div>
        <div class="foot"/>
      </body>
    </html>
  </yelp:document>
  <xsl:apply-templates select="Section"/>
</xsl:template>

<xsl:template match="para">
  <xsl:value-of select="node()"/>
  <xsl:text>
  </xsl:text>
</xsl:template>

<xsl:template match="para1">
  <xsl:value-of select="node()"/>
</xsl:template>

<xsl:template match="spacing">
  <xsl:value-of select="node()"/>
</xsl:template>

<xsl:template match="a">
  <xsl:element name="a">
    <xsl:attribute name="href">
      <xsl:value-of select="@href"/>
    </xsl:attribute>
    <xsl:value-of select="node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="img">
  <xsl:element name="a">
    <xsl:attribute name="href">
      <xsl:value-of select="@src"/>
    </xsl:attribute>
    <xsl:element name="img">
      <xsl:attribute name="src"> <xsl:value-of select="@src"/></xsl:attribute>
    </xsl:element>
  </xsl:element>
</xsl:template>

<xsl:template match="menuholder">
  <xsl:apply-templates select="node()[not(self::menuholder)]"/>
</xsl:template>

<xsl:template match="noteholder">
  <xsl:apply-templates select="node()[not(self::noteholder)]"/>
</xsl:template>

<xsl:template name="html.css">
  <xsl:param name="direction">
    <xsl:call-template name="l10n.direction"/>
  </xsl:param>
  <xsl:param name="left">
    <xsl:call-template name="l10n.align.start">
      <xsl:with-param name="direction" select="$direction"/>
    </xsl:call-template>
  </xsl:param>
  <xsl:param name="right">
    <xsl:call-template name="l10n.align.end">
      <xsl:with-param name="direction" select="$direction"/>
    </xsl:call-template>
  </xsl:param>
  <xsl:call-template name="theme.html.css">
    <xsl:with-param name="direction" select="$direction"/>
    <xsl:with-param name="left" select="$left"/>
    <xsl:with-param name="right" select="$right"/>
  </xsl:call-template>
  <xsl:text>
div.body { white-space: pre; font-family: monospace; }
<!-- navbar from mal2html, possibly move to theme-html -->
div.navbar {
  margin: 0;
  float: right;
  font-family: sans-serif;
}
a.navbar-prev::before {
  content: '</xsl:text><xsl:choose>
  <xsl:when test="$left = 'left'"><xsl:text>&#x25C0;&#x00A0;&#x00A0;</xsl:text></xsl:when>
  <xsl:otherwise><xsl:text>&#x25B6;&#x00A0;&#x00A0;</xsl:text></xsl:otherwise>
  </xsl:choose><xsl:text>';
  color: </xsl:text><xsl:value-of select="$theme.color.text_light"/><xsl:text>;
}
a.navbar-next::after {
  content: '</xsl:text><xsl:choose>
  <xsl:when test="$left = 'left'"><xsl:text>&#x00A0;&#x00A0;&#x25B6;</xsl:text></xsl:when>
  <xsl:otherwise><xsl:text>&#x00A0;&#x00A0;&#x25C0;</xsl:text></xsl:otherwise>
  </xsl:choose><xsl:text>';
  color: </xsl:text><xsl:value-of select="$theme.color.text_light"/><xsl:text>;
}
</xsl:text>
</xsl:template>

</xsl:stylesheet>
