/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;

public class Artwork
extends Technology {
    public static final Variable.Key ART_DEGREES = ElectricObject.newKey("ART_degrees");
    public static final Variable.Key ART_MESSAGE = ElectricObject.newKey("ART_message");
    public static final Variable.Key ART_COLOR = ElectricObject.newKey("ART_color");
    public static final Variable.Key ART_PATTERN = ElectricObject.newKey("ART_pattern");
    public static final Artwork tech = new Artwork();
    private static final int ELLIPSEPOINTS = 30;
    private static final int SPLINEGRAIN = 20;
    public PrimitiveNode pinNode;
    public PrimitiveNode boxNode;
    public PrimitiveNode crossedBoxNode;
    public PrimitiveNode filledBoxNode;
    public PrimitiveNode circleNode;
    public PrimitiveNode filledCircleNode;
    public PrimitiveNode splineNode;
    public PrimitiveNode triangleNode;
    public PrimitiveNode filledTriangleNode;
    public PrimitiveNode arrowNode;
    public PrimitiveNode openedPolygonNode;
    public PrimitiveNode openedDottedPolygonNode;
    public PrimitiveNode openedDashedPolygonNode;
    public PrimitiveNode openedThickerPolygonNode;
    public PrimitiveNode closedPolygonNode;
    public PrimitiveNode filledPolygonNode;
    public PrimitiveNode thickCircleNode;
    public ArcProto solidArc;
    public ArcProto dottedArc;
    public ArcProto dashedArc;
    public ArcProto thickerArc;
    private Layer G_lay;
    private static Pref cacheFillArrows = Pref.makeBooleanPref("ArtworkFillArrows", Artwork.getTechnologyPreferences(), false);

    private Artwork() {
        super("artwork");
        this.setTechShortName("Artwork");
        this.setTechDesc("General-purpose artwork components");
        this.setFactoryScale(2000.0, false);
        this.setNonStandard();
        this.setNonElectrical();
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.G_lay = Layer.newInstance(this, "Graphics", new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535}));
        this.G_lay.setFunction(Layer.Function.ART, 8192);
        this.G_lay.setFactoryDXFLayer("OBJECT");
        this.G_lay.setFactoryGDSLayer("1");
        this.solidArc = ArcProto.newInstance(this, "Solid", 0.0, new Technology.ArcLayer[]{new Technology.ArcLayer(this.G_lay, 0.0, Poly.Type.FILLED)});
        this.solidArc.setFunction(ArcProto.Function.NONELEC);
        this.solidArc.setFactoryFixedAngle(false);
        this.solidArc.setCurvable();
        this.solidArc.setWipable();
        this.solidArc.setFactoryAngleIncrement(0);
        this.dottedArc = ArcProto.newInstance(this, "Dotted", 0.0, new Technology.ArcLayer[]{new Technology.ArcLayer(this.G_lay, 0.0, Poly.Type.OPENEDT1)});
        this.dottedArc.setFunction(ArcProto.Function.NONELEC);
        this.dottedArc.setFactoryFixedAngle(false);
        this.dottedArc.setCurvable();
        this.dottedArc.setWipable();
        this.dottedArc.setFactoryAngleIncrement(0);
        this.dashedArc = ArcProto.newInstance(this, "Dashed", 0.0, new Technology.ArcLayer[]{new Technology.ArcLayer(this.G_lay, 0.0, Poly.Type.OPENEDT2)});
        this.dashedArc.setFunction(ArcProto.Function.NONELEC);
        this.dashedArc.setFactoryFixedAngle(false);
        this.dashedArc.setCurvable();
        this.dashedArc.setWipable();
        this.dashedArc.setFactoryAngleIncrement(0);
        this.thickerArc = ArcProto.newInstance(this, "Thicker", 0.0, new Technology.ArcLayer[]{new Technology.ArcLayer(this.G_lay, 0.0, Poly.Type.OPENEDT3)});
        this.thickerArc.setFunction(ArcProto.Function.NONELEC);
        this.thickerArc.setFactoryFixedAngle(false);
        this.thickerArc.setCurvable();
        this.thickerArc.setWipable();
        this.thickerArc.setFactoryAngleIncrement(0);
        Technology.TechPoint[] box_1 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeTopEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeBottomEdge())};
        Technology.TechPoint[] box_2 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(new EdgeH(-0.125, 0.0), EdgeV.makeTopEdge()), new Technology.TechPoint(new EdgeH(0.125, 0.0), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())};
        Technology.TechPoint[] box_4 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeTopEdge())};
        Technology.TechPoint[] box_6 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())};
        this.pinNode = PrimitiveNode.newInstance("Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.DISC, 0, box_6)});
        this.pinNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.pinNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.pinNode.setFunction(PrimitiveNode.Function.PIN);
        this.pinNode.setArcsWipe();
        this.pinNode.setArcsShrink();
        this.boxNode = PrimitiveNode.newInstance("Box", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.CLOSED, 1, Technology.TechPoint.makeFullBox())});
        this.boxNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.boxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "box", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.boxNode.setFunction(PrimitiveNode.Function.ART);
        this.boxNode.setEdgeSelect();
        this.crossedBoxNode = PrimitiveNode.newInstance("Crossed-Box", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.CROSSED, 1, Technology.TechPoint.makeFullBox())});
        this.crossedBoxNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.crossedBoxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "fbox", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.crossedBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode = PrimitiveNode.newInstance("Filled-Box", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        this.filledBoxNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledBoxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "fbox", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode.setEdgeSelect();
        this.circleNode = PrimitiveNode.newInstance("Circle", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.CIRCLE, 0, box_6)});
        this.circleNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.circleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.circleNode.setFunction(PrimitiveNode.Function.ART);
        this.circleNode.setEdgeSelect();
        this.filledCircleNode = PrimitiveNode.newInstance("Filled-Circle", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.DISC, 0, box_6)});
        this.filledCircleNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledCircleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledCircleNode.setSquare();
        this.filledCircleNode.setEdgeSelect();
        this.splineNode = PrimitiveNode.newInstance("Spline", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENED, 0, box_2)});
        this.splineNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.splineNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.splineNode.setFunction(PrimitiveNode.Function.ART);
        this.splineNode.setHoldsOutline();
        this.splineNode.setEdgeSelect();
        this.triangleNode = PrimitiveNode.newInstance("Triangle", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.CLOSED, 0, box_4)});
        this.triangleNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.triangleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "triangle", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.triangleNode.setFunction(PrimitiveNode.Function.ART);
        this.triangleNode.setEdgeSelect();
        this.filledTriangleNode = PrimitiveNode.newInstance("Filled-Triangle", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.FILLED, 0, box_4)});
        this.filledTriangleNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledTriangleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "ftriangle", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledTriangleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledTriangleNode.setEdgeSelect();
        this.arrowNode = PrimitiveNode.newInstance("Arrow", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeTopEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge())})});
        this.arrowNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.arrowNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "arrow", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeRightEdge(), EdgeV.makeCenter(), EdgeH.makeRightEdge(), EdgeV.makeCenter())});
        this.arrowNode.setFunction(PrimitiveNode.Function.ART);
        this.arrowNode.setEdgeSelect();
        this.openedPolygonNode = PrimitiveNode.newInstance("Opened-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENED, 0, box_2)});
        this.openedPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedPolygonNode.setHoldsOutline();
        this.openedPolygonNode.setEdgeSelect();
        this.openedDottedPolygonNode = PrimitiveNode.newInstance("Opened-Dotted-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENEDT1, 0, box_2)});
        this.openedDottedPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedDottedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedDottedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDottedPolygonNode.setHoldsOutline();
        this.openedDottedPolygonNode.setEdgeSelect();
        this.openedDashedPolygonNode = PrimitiveNode.newInstance("Opened-Dashed-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENEDT2, 0, box_2)});
        this.openedDashedPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedDashedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedDashedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDashedPolygonNode.setHoldsOutline();
        this.openedDashedPolygonNode.setEdgeSelect();
        this.openedThickerPolygonNode = PrimitiveNode.newInstance("Opened-Thicker-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.OPENEDT3, 0, box_2)});
        this.openedThickerPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedThickerPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedThickerPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedThickerPolygonNode.setHoldsOutline();
        this.openedThickerPolygonNode.setEdgeSelect();
        this.closedPolygonNode = PrimitiveNode.newInstance("Closed-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.CLOSED, 2, box_1)});
        this.closedPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.closedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.closedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.closedPolygonNode.setHoldsOutline();
        this.closedPolygonNode.setEdgeSelect();
        this.filledPolygonNode = PrimitiveNode.newInstance("Filled-Polygon", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.FILLED, 2, box_1)});
        this.filledPolygonNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.filledPolygonNode.setHoldsOutline();
        this.filledPolygonNode.setEdgeSelect();
        this.thickCircleNode = PrimitiveNode.newInstance("Thick-Circle", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.THICKCIRCLE, 0, box_6)});
        this.thickCircleNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.thickCircleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.thickCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.thickCircleNode.setEdgeSelect();
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow wnd, VarContext context, boolean electrical, boolean reasonable, Technology.NodeLayer[] primLayers, Layer layerOverride) {
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        layerOverride = this.getProperLayer(ni);
        if (np == this.circleNode || np == this.thickCircleNode) {
            double[] angles = ni.getArcDegrees();
            if (ni.getXSize() != ni.getYSize()) {
                Point2D[] pointList = Artwork.fillEllipse(ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), angles[0], angles[1]);
                Poly[] polys = new Poly[]{new Poly(pointList)};
                if (np == this.circleNode) {
                    polys[0].setStyle(Poly.Type.OPENED);
                } else {
                    polys[0].setStyle(Poly.Type.OPENEDT3);
                }
                Technology.NodeLayer primLayer = primLayers[0];
                polys[0].setLayer(layerOverride);
                return polys;
            }
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                Poly[] polys = new Poly[1];
                Point2D[] pointList = new Point2D.Double[3];
                double cX = ni.getAnchorCenterX();
                double cY = ni.getAnchorCenterY();
                double dist = ni.getXSize() / 2.0;
                pointList[0] = new Point2D.Double(cX, cY);
                pointList[1] = new Point2D.Double(cX + Math.cos(angles[0] + angles[1]) * dist, cY + Math.sin(angles[0] + angles[1]) * dist);
                pointList[2] = new Point2D.Double(cX + Math.cos(angles[0]) * dist, cY + Math.sin(angles[0]) * dist);
                polys[0] = new Poly(pointList);
                if (np == this.circleNode) {
                    polys[0].setStyle(Poly.Type.CIRCLEARC);
                } else {
                    polys[0].setStyle(Poly.Type.THICKCIRCLEARC);
                }
                Technology.NodeLayer primLayer = primLayers[0];
                polys[0].setLayer(layerOverride);
                return polys;
            }
        } else if (np == this.splineNode) {
            Point2D[] tracePoints = ni.getTrace();
            if (tracePoints != null) {
                double cX = ni.getAnchorCenterX();
                double cY = ni.getAnchorCenterY();
                Point2D[] pointList = this.fillSpline(cX, cY, tracePoints);
                Poly[] polys = new Poly[]{new Poly(pointList)};
                polys[0].setStyle(Poly.Type.OPENED);
                Technology.NodeLayer primLayer = primLayers[0];
                polys[0].setLayer(layerOverride);
                return polys;
            }
        } else if (np == this.arrowNode && Artwork.isFilledArrowHeads()) {
            primLayers = new Technology.NodeLayer[]{new Technology.NodeLayer(this.G_lay, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeTopEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter())}), new Technology.NodeLayer(this.G_lay, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter())})};
        }
        return super.getShapeOfNode(ni, wnd, context, electrical, reasonable, primLayers, layerOverride);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp, Point2D selectPt) {
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np == this.pinNode || np == this.arrowNode || np == this.circleNode || np == this.thickCircleNode || np == this.filledCircleNode) {
            return super.getShapeOfPort(ni, pp, selectPt);
        }
        Poly[] polys = this.getShapeOfNode(ni);
        return polys[0];
    }

    public Poly[] getShapeOfArc(ArcInst ai, EditWindow wnd, Layer layerOverride, List onlyTheseLayers) {
        layerOverride = this.getProperLayer(ai);
        return super.getShapeOfArc(ai, wnd, layerOverride, onlyTheseLayers);
    }

    public static Point2D[] fillEllipse(Point2D center, double sX, double sY, double startoffset, double endangle) {
        boolean closed = true;
        if (startoffset == 0.0 && endangle == 0.0) {
            endangle = Math.PI * 2;
        } else {
            closed = false;
        }
        int pts = (int)(endangle * 30.0 / (Math.PI * 2));
        if (pts < 3) {
            pts = 3;
        }
        if (closed) {
            ++pts;
        }
        Point2D[] points = new Point2D.Double[pts];
        double a = sX / 2.0;
        double b = sY / 2.0;
        if (closed) {
            double p = 0.21666156231653746;
            double c2 = Math.cos(p);
            double s2 = Math.sin(p);
            double c3 = 1.0;
            double s3 = 0.0;
            for (int m = 0; m < 30; ++m) {
                points[m] = new Point2D.Double(center.getX() + a * c3, center.getY() + b * s3);
                double t1 = c3 * c2 - s3 * s2;
                s3 = s3 * c2 + c3 * s2;
                c3 = t1;
            }
        } else {
            for (int m = 0; m < pts; ++m) {
                double p = startoffset + (double)m * endangle / (double)(pts - 1);
                double c2 = Math.cos(p);
                double s2 = Math.sin(p);
                points[m] = new Point2D.Double(center.getX() + a * c2, center.getY() + b * s2);
            }
        }
        return points;
    }

    private double getTracePointX(Point2D[] tracePoints, int index, double cX) {
        double v = tracePoints[index].getX();
        return v + cX;
    }

    private double getTracePointY(Point2D[] tracePoints, int index, double cY) {
        double v = tracePoints[index].getY();
        return v + cY;
    }

    public void setDefaultOutline(NodeInst ni) {
        Point2D[] outline;
        if (!(ni.getProto() instanceof PrimitiveNode)) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np == this.openedPolygonNode || np == this.openedDottedPolygonNode || np == this.openedDashedPolygonNode || np == this.openedThickerPolygonNode || np == this.splineNode) {
            outline = new Point2D[]{new Point2D.Double(-3.0, -3.0), new Point2D.Double(-1.0, 3.0), new Point2D.Double(1.0, -3.0), new Point2D.Double(3.0, 3.0)};
            ni.newVar(NodeInst.TRACE, (Object)outline);
        }
        if (np == this.closedPolygonNode || np == this.filledPolygonNode) {
            outline = new Point2D[]{new Point2D.Double(0.0, -3.0), new Point2D.Double(-3.0, 0.0), new Point2D.Double(0.0, 3.0), new Point2D.Double(3.0, -3.0)};
            ni.newVar(NodeInst.TRACE, (Object)outline);
        }
    }

    private Point2D[] fillSpline(double cX, double cY, Point2D[] tracePoints) {
        int steps = 20;
        int count = tracePoints.length;
        int outPoints = (count - 1) * steps + 1;
        Point2D[] points = new Point2D.Double[outPoints];
        int out = 0;
        double splineStep = 1.0 / (double)steps;
        double x2 = this.getTracePointX(tracePoints, 0, cX) * 2.0 - this.getTracePointX(tracePoints, 1, cX);
        double y2 = this.getTracePointY(tracePoints, 0, cY) * 2.0 - this.getTracePointY(tracePoints, 1, cY);
        double x3 = this.getTracePointX(tracePoints, 0, cX);
        double y3 = this.getTracePointY(tracePoints, 0, cY);
        double x4 = this.getTracePointX(tracePoints, 1, cX);
        double y4 = this.getTracePointY(tracePoints, 1, cY);
        for (int k = 2; k <= count; ++k) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            double y1 = y2;
            y2 = y3;
            y3 = y4;
            if (k == count) {
                x4 = this.getTracePointX(tracePoints, k - 1, cX) * 2.0 - this.getTracePointX(tracePoints, k - 2, cX);
                y4 = this.getTracePointY(tracePoints, k - 1, cY) * 2.0 - this.getTracePointY(tracePoints, k - 2, cY);
            } else {
                x4 = this.getTracePointX(tracePoints, k, cX);
                y4 = this.getTracePointY(tracePoints, k, cY);
            }
            int i = 0;
            double t = 0.0;
            while (i < steps) {
                double tsq = t * t;
                double t4 = tsq * t;
                double t3 = -3.0 * t4 + 3.0 * tsq + 3.0 * t + 1.0;
                double t2 = 3.0 * t4 - 6.0 * tsq + 4.0;
                double t1 = -t4 + 3.0 * tsq - 3.0 * t + 1.0;
                double x = (x1 * t1 + x2 * t2 + x3 * t3 + x4 * t4) / 6.0;
                double y = (y1 * t1 + y2 * t2 + y3 * t3 + y4 * t4) / 6.0;
                points[out++] = new Point2D.Double(x, y);
                ++i;
                t += splineStep;
            }
        }
        points[out++] = new Point2D.Double(this.getTracePointX(tracePoints, count - 1, cX), this.getTracePointY(tracePoints, count - 1, cY));
        return points;
    }

    private Layer getProperLayer(ElectricObject eObj) {
        EGraphics graphics = Artwork.makeGraphics(eObj);
        if (graphics == null) {
            return this.G_lay;
        }
        Layer thisLayer = Layer.newInstance(null, "Graphics", graphics);
        return thisLayer;
    }

    public static EGraphics makeGraphics(ElectricObject eObj) {
        Variable colorVar = eObj.getVar(ART_COLOR, Integer.class);
        Variable patternVar = eObj.getVar(ART_PATTERN);
        if (colorVar == null && patternVar == null) {
            return null;
        }
        EGraphics graphics = new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535});
        if (colorVar != null) {
            Integer color = (Integer)colorVar.getObject();
            graphics.setColorIndex(color);
        }
        if (patternVar != null) {
            int i;
            Number[] pat;
            int len = patternVar.getLength();
            if (len != 8 && len != 16) {
                System.out.println("'ART_pattern' must be a 8 or 16-entries long");
                return null;
            }
            graphics.setPatternedOnDisplay(true);
            graphics.setPatternedOnPrinter(true);
            int[] pattern = graphics.getPattern();
            Object obj = patternVar.getObject();
            if (obj instanceof Integer[]) {
                pat = (Integer[])obj;
                for (i = 0; i < len; ++i) {
                    pattern[i] = (Integer)pat[i];
                }
            } else if (obj instanceof Short[]) {
                pat = (Short[])obj;
                for (i = 0; i < len; ++i) {
                    pattern[i] = ((Short)pat[i]).shortValue();
                }
                graphics.setOutlinedOnDisplay(true);
                graphics.setOutlinedOnPrinter(true);
            }
            if (len == 8) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    pattern[i2 + 8] = pattern[i2];
                }
            }
        }
        return graphics;
    }

    public static void setGraphics(EGraphics graphics, ElectricObject eObj) {
        Variable colorVar = eObj.getVar(ART_COLOR, Integer.class);
        Variable patternVar = eObj.getVar(ART_PATTERN);
        int transparent = graphics.getTransparentLayer();
        Color newColor = graphics.getColor();
        if (transparent == 0 && newColor == Color.BLACK) {
            if (colorVar != null) {
                eObj.delVar(ART_COLOR);
            }
        } else {
            int index = 0;
            index = transparent > 0 ? EGraphics.makeIndex(transparent) : EGraphics.makeIndex(newColor);
            eObj.newVar(ART_COLOR, (Object)new Integer(index));
        }
        if (graphics.isPatternedOnDisplay()) {
            int[] pattern = graphics.getPattern();
            if (graphics.isOutlinedOnDisplay()) {
                Short[] pat = new Short[16];
                for (int i = 0; i < 16; ++i) {
                    pat[i] = new Short((short)pattern[i]);
                }
                eObj.newVar(ART_PATTERN, (Object)pat);
            } else {
                Integer[] pat = new Integer[16];
                for (int i = 0; i < 16; ++i) {
                    pat[i] = new Integer(pattern[i]);
                }
                eObj.newVar(ART_PATTERN, (Object)pat);
            }
        } else if (patternVar != null) {
            eObj.delVar(ART_PATTERN);
        }
    }

    public PrimitiveNode convertOldNodeName(String name) {
        if (name.equals("Message") || name.equals("Centered-Message") || name.equals("Left-Message") || name.equals("Right-Message")) {
            return Generic.tech.invisiblePinNode;
        }
        if (name.equals("Opened-FarDotted-Polygon")) {
            return this.openedThickerPolygonNode;
        }
        return null;
    }

    public ArcProto convertOldArcName(String name) {
        if (name.equals("Dash-1")) {
            return this.dottedArc;
        }
        if (name.equals("Dash-2")) {
            return this.dashedArc;
        }
        if (name.equals("Dash-3")) {
            return this.thickerArc;
        }
        return null;
    }

    public static boolean isFilledArrowHeads() {
        return cacheFillArrows.getBoolean();
    }

    public static void setFilledArrowHeads(boolean f) {
        cacheFillArrows.setBoolean(f);
    }
}

