/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config;

import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.config.Configuration;
import com.sun.electric.util.config.InitStrategy;
import com.sun.electric.util.config.XmlInitSax;
import com.sun.electric.util.config.model.ConfigEntry;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EConfigContainer
extends Configuration {
    private Map<String, ConfigEntry<?>> lookupMapClass = CollectionFactory.createHashMap();

    EConfigContainer() {
        this(new InitStrategy.StaticInit());
    }

    EConfigContainer(String configFile) {
        File file = new File(configFile);
        if (file.exists()) {
            new XmlInitSax(configFile).init(this);
        } else {
            URL fileName = EConfigContainer.class.getResource("/" + configFile);
            new XmlInitSax(fileName).init(this);
        }
    }

    EConfigContainer(InitStrategy initMethod) {
        initMethod.init(this);
    }

    @Override
    protected Object lookupImpl(String name, Object ... runtimeParameters) {
        Object result2 = null;
        ConfigEntry<?> entry = this.lookupMapClass.get(name);
        if (entry != null) {
            try {
                result2 = entry.getInstance();
            }
            catch (Throwable e) {
                logger.log(Level.CONFIG, "Implementation of " + name + " not found", e);
            }
        }
        return result2;
    }

    @Override
    protected <T> T lookupImpl(Class<T> clazz, Object ... runtimeParamters) {
        try {
            return (T)this.lookupImpl(clazz.getName(), new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    void addConfigEntry(String name, ConfigEntry<?> entry) {
        this.lookupMapClass.put(name, entry);
        logger.log(Level.FINE, "Add " + name + " to lookup map");
    }

    void removeConfigEntry(String name) {
        this.lookupMapClass.remove(name);
        logger.log(Level.FINE, "Remove " + name + " from lookup map");
    }
}

