/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.BatchChanges;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.CantEditException;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.SizeListener;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class CircuitChangeJobs {
    CircuitChangeJobs() {
    }

    public static void rotateArcText(ArcInst ai, Orientation dOrient, boolean mirror) {
        CircuitChangeJobs.rotateText(ai, ArcInst.ARC_NAME, dOrient, !mirror);
        Iterator<Variable> it = ai.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            CircuitChangeJobs.rotateText(ai, var.getKey(), dOrient, true);
        }
    }

    public static void rotateNodeText(NodeInst ni, Orientation dOrient, boolean wasMirroredInX, boolean wasMirroredInY) {
        CircuitChangeJobs.rotateText(ni, NodeInst.NODE_NAME, dOrient, wasMirroredInX == wasMirroredInY);
        Iterator<Serializable> it = ni.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            CircuitChangeJobs.rotateText(ni, var.getKey(), dOrient, wasMirroredInX == wasMirroredInY);
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            CircuitChangeJobs.rotateText(e, Export.EXPORT_NAME, dOrient, wasMirroredInX == wasMirroredInY);
        }
    }

    private static void rotateText(ElectricObject eObj, Variable.Key key, Orientation dOrient, boolean wasSameMirror) {
        Point2D.Double pt;
        TextDescriptor td = eObj.getTextDescriptor(key);
        Poly.Type oldType = td.getPos().getPolyType();
        if (oldType == Poly.Type.TEXTCENT || oldType == Poly.Type.TEXTBOX) {
            return;
        }
        FixpTransform dTrans = dOrient.pureRotate();
        Poly.Type newType = oldType;
        if (dOrient == Orientation.X) {
            if ((oldType = oldType.rotateTextAnchorIn(td.getRotation())) == Poly.Type.TEXTLEFT) {
                oldType = Poly.Type.TEXTRIGHT;
            } else if (oldType == Poly.Type.TEXTRIGHT) {
                oldType = Poly.Type.TEXTLEFT;
            } else if (oldType == Poly.Type.TEXTBOTLEFT) {
                oldType = Poly.Type.TEXTBOTRIGHT;
            } else if (oldType == Poly.Type.TEXTBOTRIGHT) {
                oldType = Poly.Type.TEXTBOTLEFT;
            } else if (oldType == Poly.Type.TEXTTOPLEFT) {
                oldType = Poly.Type.TEXTTOPRIGHT;
            } else if (oldType == Poly.Type.TEXTTOPRIGHT) {
                oldType = Poly.Type.TEXTTOPLEFT;
            }
            newType = oldType = oldType.rotateTextAnchorOut(td.getRotation());
        } else if (dOrient == Orientation.Y) {
            if ((oldType = oldType.rotateTextAnchorIn(td.getRotation())) == Poly.Type.TEXTBOT) {
                oldType = Poly.Type.TEXTTOP;
            } else if (oldType == Poly.Type.TEXTTOP) {
                oldType = Poly.Type.TEXTBOT;
            } else if (oldType == Poly.Type.TEXTBOTLEFT) {
                oldType = Poly.Type.TEXTTOPLEFT;
            } else if (oldType == Poly.Type.TEXTTOPLEFT) {
                oldType = Poly.Type.TEXTBOTLEFT;
            } else if (oldType == Poly.Type.TEXTBOTRIGHT) {
                oldType = Poly.Type.TEXTTOPRIGHT;
            } else if (oldType == Poly.Type.TEXTTOPRIGHT) {
                oldType = Poly.Type.TEXTBOTRIGHT;
            }
            newType = oldType = oldType.rotateTextAnchorOut(td.getRotation());
        } else {
            int origAngle = oldType.getTextAngle();
            pt = new Point2D.Double(100.0, 0.0);
            dTrans.transform(pt, pt);
            int xAngle = GenMath.figureAngle(new Point2D.Double(0.0, 0.0), pt);
            int angle = (origAngle + xAngle) % 3600;
            newType = Poly.Type.getTextTypeFromAngle(angle);
        }
        AbstractTextDescriptor.Position newPos = AbstractTextDescriptor.Position.getPosition(newType);
        td = td.withPos(newPos);
        eObj.setTextDescriptor(key, td);
        if (eObj instanceof ArcInst) {
            pt = new Point2D.Double(td.getXOff(), td.getYOff());
            dTrans.transform(pt, pt);
            eObj.setTextDescriptor(key, td.withOff(((Point2D)pt).getX(), ((Point2D)pt).getY()));
        }
    }

    private static void spreadRotateConnection(NodeInst theNi, Set<Geometric> markObj) {
        if (markObj.contains(theNi)) {
            return;
        }
        markObj.add(theNi);
        Iterator<Connection> it = theNi.getConnections();
        while (it.hasNext()) {
            int otherEnd;
            NodeInst ni;
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (!markObj.contains(ai) || markObj.contains(ni = ai.getPortInst(otherEnd = 1 - con.getEndIndex()).getNodeInst())) continue;
            markObj.add(ni);
            CircuitChangeJobs.spreadRotateConnection(ni, markObj);
        }
    }

    public static void eraseObjectsInList(Cell cell, List<Geometric> list2, boolean reconstructArcsAndExports, Set<ElectricObject> stuffToHighlight, EditingPreferences ep) {
        HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
        HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, true) != 0) {
            return;
        }
        for (Geometric geom : list2) {
            NodeInst ni;
            if (geom instanceof ArcInst) {
                ArcInst ai = (ArcInst)geom;
                arcsToDelete.add(ai);
                continue;
            }
            if (!(geom instanceof NodeInst) || CircuitChangeJobs.cantEdit(cell, ni = (NodeInst)geom, true, false, true) != 0) continue;
            nodesToDelete.add(ni);
        }
        HashSet<NodeInst> alsoDeleteTheseNodes = new HashSet<NodeInst>();
        for (ArcInst ai : arcsToDelete) {
            alsoDeleteTheseNodes.add(ai.getHeadPortInst().getNodeInst());
            alsoDeleteTheseNodes.add(ai.getTailPortInst().getNodeInst());
        }
        for (NodeInst ni : nodesToDelete) {
            Iterator<Connection> sit = ni.getConnections();
            while (sit.hasNext()) {
                Connection con = sit.next();
                ArcInst ai = con.getArc();
                int otherEnd = 1 - con.getEndIndex();
                NodeInst oNi = ai.getPortInst(otherEnd).getNodeInst();
                alsoDeleteTheseNodes.add(oNi);
            }
        }
        if (reconstructArcsAndExports) {
            for (NodeInst ni : nodesToDelete) {
                if (!ni.isCellInstance()) continue;
                HashMap<PortInst, PortInst> reassigned = new HashMap<PortInst, PortInst>();
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    PortProto subPP;
                    NodeInst subNi;
                    Export e = eIt.next();
                    FixpTransform trans = new FixpTransform();
                    Orientation orient = Orientation.IDENT;
                    PortInst pi = e.getOriginalPort();
                    while (true) {
                        subNi = pi.getNodeInst();
                        subPP = pi.getPortProto();
                        trans = subNi.rotateOut(trans);
                        orient = orient.concatenate(subNi.getOrient());
                        if (!subNi.isCellInstance()) break;
                        trans = subNi.translateOut(trans);
                        pi = ((Export)subPP).getOriginalPort();
                    }
                    NodeProto subNp = subNi.getProto();
                    Point2D.Double ctr = new Point2D.Double(subNi.getTrueCenter().getX(), subNi.getTrueCenter().getY());
                    trans.transform(ctr, ctr);
                    NodeInst eNi = NodeInst.makeInstance(subNp, ep, ctr, subNi.getXSize(), subNi.getYSize(), cell, orient, null);
                    pi = eNi.findPortInstFromEquivalentProto(subPP);
                    reassigned.put(e.getOriginalPort(), pi);
                    e.move(pi);
                    if (stuffToHighlight == null) continue;
                    stuffToHighlight.add(e);
                }
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst ai = con.getArc();
                    if (arcsToDelete.contains(ai)) continue;
                    int thisEnd = con.getEndIndex();
                    int otherEnd = 1 - thisEnd;
                    PortInst thisPi = ai.getPortInst(thisEnd);
                    PortInst otherPi = ai.getPortInst(otherEnd);
                    NodeInst otherNi = otherPi.getNodeInst();
                    if (otherNi == ni || nodesToDelete.contains(otherNi)) continue;
                    PortInst alreadyPI = (PortInst)reassigned.get(thisPi);
                    if (alreadyPI == null) {
                        PrimitiveNode pinNp = ai.getProto().findPinProto();
                        NodeInst pin = NodeInst.makeInstance(pinNp, ep, con.getLocation(), pinNp.getDefWidth(ep), pinNp.getDefHeight(ep), cell);
                        alreadyPI = pin.getOnlyPortInst();
                        reassigned.put(thisPi, alreadyPI);
                    }
                    ArcInst newAI = ArcInst.makeInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), otherPi, alreadyPI, ai.getConnection(otherEnd).getLocation(), con.getLocation(), ai.getName());
                    if (stuffToHighlight != null) {
                        stuffToHighlight.add(newAI);
                    }
                    alsoDeleteTheseNodes.remove(otherNi);
                }
            }
        }
        for (ArcInst ai : arcsToDelete) {
            ai.kill();
        }
        for (NodeInst ni : nodesToDelete) {
            Reconnect re = Reconnect.erasePassThru(ni, false, false, ep);
            if (re == null) continue;
            re.reconnectArcs(ep);
        }
        cell.killNodes(nodesToDelete);
        HashSet<NodeInst> deleteTheseNodes = new HashSet<NodeInst>();
        for (NodeInst ni : alsoDeleteTheseNodes) {
            if (!ni.isLinked() || ni.isCellInstance() || !ni.getProto().getFunction().isPin() || ni.hasConnections() || ni.hasExports()) continue;
            deleteTheseNodes.add(ni);
        }
        cell.killNodes(deleteTheseNodes);
        ArrayList<NodeInst> nodesToPassThru = new ArrayList<NodeInst>();
        for (NodeInst ni : alsoDeleteTheseNodes) {
            if (!ni.isLinked() || ni.isCellInstance() || !ni.getProto().getFunction().isPin() || ni.hasExports() || !ni.isInlinePin()) continue;
            nodesToPassThru.add(ni);
        }
        for (NodeInst ni : nodesToPassThru) {
            Reconnect re = Reconnect.erasePassThru(ni, false, false, ep);
            if (re == null) continue;
            re.reconnectArcs(ep);
            ni.kill();
        }
        int numArcsDeleted = arcsToDelete.size();
        int numNodesDeleted = nodesToDelete.size();
        if (numArcsDeleted != 0 || numNodesDeleted != 0) {
            String msg = "Deleted";
            if (numNodesDeleted == 1) {
                msg = msg + " 1 node";
            } else if (numNodesDeleted > 1) {
                msg = msg + " " + numNodesDeleted + " nodes";
            }
            if (numNodesDeleted > 0 && numArcsDeleted > 0) {
                msg = msg + " and";
            }
            if (numArcsDeleted == 1) {
                msg = msg + " 1 arc";
            } else if (numArcsDeleted > 1) {
                msg = msg + " " + numArcsDeleted + " arcs";
            }
            System.out.println(msg);
        }
    }

    public static List<Reconnect> getPinsToPassThrough(Cell cell, EditingPreferences ep) {
        ArrayList<Reconnect> pinsToPassThrough = new ArrayList<Reconnect>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Reconnect re;
            NodeInst ni = it.next();
            if (!ni.getFunction().isPin() || ni.hasExports() || !ni.isInlinePin() || (re = Reconnect.erasePassThru(ni, false, true, ep)) == null) continue;
            pinsToPassThrough.add(re);
        }
        return pinsToPassThrough;
    }

    public static void spreadCircuitry(Cell cell, NodeInst ni, char direction, double amount, double lX, double hX, double lY, double hY) {
        double yC1;
        double xC1;
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, true) != 0) {
            return;
        }
        HashSet<Geometric> geomSeen = new HashSet<Geometric>();
        boolean mustBeHor = true;
        if (direction == 'l' || direction == 'r') {
            mustBeHor = false;
        }
        if (ni != null) {
            CircuitChangeJobs.manhattanTravel(ni, mustBeHor, geomSeen);
        }
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst oNi = it.next();
            FixpRectangle r = oNi.getBaseShape().getBounds2D();
            if (direction == 'l' || direction == 'r') {
                if (((RectangularShape)r).getMinX() < lX && ((RectangularShape)r).getMaxX() > hX) {
                    geomSeen.add(oNi);
                }
                if (oNi.getTrueCenterX() != (lX + hX) / 2.0) continue;
                geomSeen.add(oNi);
                continue;
            }
            if (((RectangularShape)r).getMinY() < lY && ((RectangularShape)r).getMaxY() > hY) {
                geomSeen.add(oNi);
            }
            if (oNi.getTrueCenterY() != (lY + hY) / 2.0) continue;
            geomSeen.add(oNi);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            NodeInst no1 = ai.getTailPortInst().getNodeInst();
            NodeInst no2 = ai.getHeadPortInst().getNodeInst();
            xC1 = no1.getTrueCenterX();
            yC1 = no1.getTrueCenterY();
            double xC2 = no2.getTrueCenterX();
            double yC2 = no2.getTrueCenterY();
            if (geomSeen.contains(no2)) {
                NodeInst swapNi = no1;
                no1 = no2;
                no2 = swapNi;
                double swap = xC1;
                xC1 = xC2;
                xC2 = swap;
                swap = yC1;
                yC1 = yC2;
                yC2 = swap;
            }
            if (geomSeen.contains(no2)) continue;
            boolean i = true;
            if (geomSeen.contains(no1)) {
                switch (direction) {
                    case 'l': {
                        if (!(xC2 <= lX)) break;
                        i = false;
                        break;
                    }
                    case 'r': {
                        if (!(xC2 >= hX)) break;
                        i = false;
                        break;
                    }
                    case 'u': {
                        if (!(yC2 >= hY)) break;
                        i = false;
                        break;
                    }
                    case 'd': {
                        if (!(yC2 <= lY)) break;
                        i = false;
                    }
                }
            } else {
                switch (direction) {
                    case 'l': {
                        if (xC1 > lX && xC2 <= lX) {
                            i = false;
                            break;
                        }
                        if (!(xC2 > lX) || !(xC1 <= lX)) break;
                        i = false;
                        break;
                    }
                    case 'r': {
                        if (xC1 < hX && xC2 >= hX) {
                            i = false;
                            break;
                        }
                        if (!(xC2 < hX) || !(xC1 >= hX)) break;
                        i = false;
                        break;
                    }
                    case 'u': {
                        if (yC1 > hY && yC2 <= hY) {
                            i = false;
                            break;
                        }
                        if (!(yC2 > hY) || !(yC1 <= hY)) break;
                        i = false;
                        break;
                    }
                    case 'd': {
                        if (yC1 < lY && yC2 >= lY) {
                            i = false;
                            break;
                        }
                        if (!(yC2 < lY) || !(yC1 >= lY)) break;
                        i = false;
                    }
                }
            }
            if (i) continue;
            geomSeen.add(ai);
        }
        boolean moved = false;
        boolean again = true;
        block26: while (again) {
            again = false;
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst oNi = it2.next();
                if (geomSeen.contains(oNi)) continue;
                xC1 = oNi.getTrueCenterX();
                yC1 = oNi.getTrueCenterY();
                boolean doIt = false;
                switch (direction) {
                    case 'l': {
                        if (!(xC1 < lX)) break;
                        doIt = true;
                        break;
                    }
                    case 'r': {
                        if (!(xC1 > hX)) break;
                        doIt = true;
                        break;
                    }
                    case 'u': {
                        if (!(yC1 > hY)) break;
                        doIt = true;
                        break;
                    }
                    case 'd': {
                        if (!(yC1 < lY)) break;
                        doIt = true;
                    }
                }
                if (!doIt) continue;
                Iterator<ArcInst> aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = aIt.next();
                    if (geomSeen.contains(ai)) {
                        Layout.setTempRigid(ai, false);
                        continue;
                    }
                    Layout.setTempRigid(ai, true);
                }
                CircuitChangeJobs.netTravel(oNi, geomSeen);
                switch (direction) {
                    case 'l': {
                        oNi.move(-amount, 0.0);
                        break;
                    }
                    case 'r': {
                        oNi.move(amount, 0.0);
                        break;
                    }
                    case 'u': {
                        oNi.move(0.0, amount);
                        break;
                    }
                    case 'd': {
                        oNi.move(0.0, -amount);
                    }
                }
                moved = true;
                again = true;
                continue block26;
            }
        }
        if (!moved) {
            System.out.println("Nothing changed");
        }
    }

    private static void netTravel(NodeInst ni, Set<Geometric> geomSeen) {
        if (geomSeen.contains(ni)) {
            return;
        }
        geomSeen.add(ni);
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            if (geomSeen.contains(ai)) continue;
            CircuitChangeJobs.netTravel(ai.getHeadPortInst().getNodeInst(), geomSeen);
            CircuitChangeJobs.netTravel(ai.getTailPortInst().getNodeInst(), geomSeen);
        }
    }

    private static void manhattanTravel(NodeInst ni, boolean hor, Set<Geometric> geomSeen) {
        geomSeen.add(ni);
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            int angle = ai.getDefinedAngle();
            if (!hor ? angle != 900 && angle != 2700 : angle != 0 && angle != 1800) continue;
            int otherEnd = 1 - con.getEndIndex();
            NodeInst other = ai.getPortInst(otherEnd).getNodeInst();
            if (geomSeen.contains(other)) continue;
            CircuitChangeJobs.manhattanTravel(other, hor, geomSeen);
        }
    }

    public static NodeInst replaceNodeInst(NodeInst oldNi, NodeProto newNp, PrimitiveNode.Function newFunc, boolean ignorePortNames, boolean allowMissingPorts, EditingPreferences ep) {
        BatchChanges.NodeReplacement replacement = new BatchChanges.NodeReplacement(oldNi, newNp, newFunc);
        if (!oldNi.checkReplacement(replacement, ep, ignorePortNames, allowMissingPorts)) {
            return null;
        }
        NodeInst newNi = oldNi.doReplace(replacement, ep, allowMissingPorts);
        CircuitChangeJobs.postReplace(newNi, ep);
        return newNi;
    }

    public static void replaceNodeInsts(Collection<BatchChanges.NodeReplacement> replacements, boolean allowMissingPorts, EditingPreferences ep) throws JobException {
        EDatabase database = EDatabase.currentDatabase();
        BatchChanges.getInstance().replaceNodeInsts(database, replacements, allowMissingPorts, ep);
        for (BatchChanges.NodeReplacement nr : replacements) {
            CircuitChangeJobs.postReplace(database.getCell(nr.cellId).getNodeById(nr.nodeId), ep);
        }
    }

    private static void postReplace(NodeInst newNi, EditingPreferences ep) {
        if (!newNi.isCellInstance()) {
            Iterator<Variable> it = newNi.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                Variable.Key key = var.getKey();
                if (key == NodeInst.TRACE || PossibleVariables.validKey(key, (PrimitiveNode)newNi.getProto())) continue;
                newNi.delVar(var.getKey());
            }
        }
        CircuitChangeJobs.inheritAttributes(newNi, ep);
    }

    public static void inheritAttributes(NodeInst ni, EditingPreferences ep) {
        Variable var;
        if (!ni.isCellInstance()) {
            return;
        }
        Cell cell = (Cell)ni.getProto();
        if (cell.isIcon()) {
            Iterator<Variable> vIt = cell.getParameters();
            while (vIt.hasNext()) {
                var = vIt.next();
                CircuitChangeJobs.inheritCellParameter(var, ni, ep);
            }
        }
        Iterator<Serializable> it = cell.getVariables();
        while (it.hasNext()) {
            var = it.next();
            if (!var.getTextDescriptor().isInherit()) continue;
            CircuitChangeJobs.inheritCellAttribute(var, ni);
        }
        it = cell.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            CircuitChangeJobs.inheritExportAttributes(pp, ni, ep);
        }
    }

    private static void inheritExportAttributes(Export pp, NodeInst ni, EditingPreferences ep) {
        Iterator<Variable> it = pp.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (!var.getTextDescriptor().isInherit()) continue;
            Variable.Key attrKey = var.getKey();
            PortInst pi = ni.findPortInstFromEquivalentProto(pp);
            Variable newVar = pi.getVar(attrKey);
            if (newVar != null) continue;
            TextDescriptor td = ep.getPortInstTextDescriptor().withDisplay(false);
            Object value2 = CircuitChangeJobs.inheritAddress(pp, var, ep);
            value2 = Variable.withCode(value2, CodeExpression.Code.NONE);
            pi.newVar(attrKey, value2, td);
        }
    }

    private static void inheritCellAttribute(Variable var, NodeInst ni) {
        Variable.Key key = var.getKey();
        Variable newVar = ni.getVar(key);
        if (newVar != null) {
            if (!var.getTextDescriptor().isInterior()) {
                if (!newVar.isDisplay()) {
                    ni.addVar(newVar.withDisplay(true));
                }
            } else if (newVar.isDisplay() && var.describe(-1).equals(newVar.describe(-1))) {
                ni.addVar(newVar.withDisplay(false));
            }
        } else {
            ni.addVar(var);
        }
    }

    public static void inheritCellParameter(Variable var, NodeInst ni, EditingPreferences ep) {
        Variable.Key key = var.getKey();
        if (ni.isDefinedParameter(key)) {
            Variable param2 = ni.getParameter(key);
            if (!var.isInterior()) {
                if (!param2.isDisplay()) {
                    ni.addParameter(param2.withDisplay(true));
                }
            } else if (param2.isDisplay() && var.describe(-1).equals(param2.describe(-1))) {
                ni.addParameter(param2.withDisplay(false));
            }
        } else {
            Cell cell = (Cell)ni.getProto();
            Variable iconVar = cell.getParameter(var.getKey());
            TextDescriptor td = iconVar.getTextDescriptor();
            ERectangle bounds = cell.getBounds();
            double xd = td.getXOff() - ((RectangularShape)bounds).getCenterX();
            double yd = td.getYOff() - ((RectangularShape)bounds).getCenterY();
            td = td.withOff(xd, yd);
            Object value2 = CircuitChangeJobs.inheritAddress(cell, var, ep);
            ni.addParameter(Variable.newInstance(var.getKey(), value2, td));
        }
    }

    private static Object inheritAddress(ElectricObject addr, Variable var, EditingPreferences ep) {
        int i;
        Object obj = var.getObject();
        if (!(obj instanceof String)) {
            return obj;
        }
        if (var.isCode()) {
            return obj;
        }
        String str = (String)obj;
        int plusPlusPos = str.indexOf("++");
        int minusMinusPos = str.indexOf("--");
        if (plusPlusPos < 0 && minusMinusPos < 0) {
            return obj;
        }
        int incrPoint = Math.max(plusPlusPos, minusMinusPos);
        String retVal = str.substring(0, incrPoint) + str.substring(incrPoint + 2);
        for (i = incrPoint - 1; i >= 0 && TextUtils.isDigit(str.charAt(i)); --i) {
        }
        int curVal = TextUtils.atoi(str.substring(++i));
        curVal = str.charAt(incrPoint) == '+' ? ++curVal : --curVal;
        String newIncrString = str.substring(0, i) + curVal + str.substring(incrPoint);
        if (addr instanceof Cell) {
            Cell.CellGroup cg = ((Cell)addr).getCellGroup();
            cg.updateParam((Variable.AttrKey)var.getKey(), newIncrString, var.getUnit());
        } else {
            addr.newVar(var.getKey(), (Object)newIncrString, ep);
        }
        return retVal;
    }

    public static void markAllLibrariesForSavingCommand() {
        new MarkAllLibraries();
    }

    public static void markCurrentLibForSavingCommand() {
        new MarkCurrentLibForSaving();
    }

    public static void testEditable(Cell cell, NodeInst item, boolean giveError, boolean allowInstanceChange) throws CantEditException {
        if (item != null) {
            if (item.isLocked()) {
                CantEditException e = new CantEditException();
                e.lockedNode = item;
                throw e;
            }
            boolean complexNode = false;
            if (!item.isCellInstance()) {
                if (((PrimitiveNode)item.getProto()).isLockedPrim() && User.isDisallowModificationLockedPrims()) {
                    CantEditException e = new CantEditException();
                    e.lockedPrim = item;
                    throw e;
                }
                PrimitiveNode.Function fun = item.getFunction();
                if (!fun.isPin() && !fun.isContact() && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.CONNECT) {
                    complexNode = true;
                }
            } else {
                complexNode = true;
                if (!allowInstanceChange && cell.isInstancesLocked()) {
                    CantEditException e = new CantEditException();
                    e.lockedInstances = cell;
                    e.lockedExample = item;
                    throw e;
                }
            }
            if (complexNode && User.isDisallowModificationComplexNodes()) {
                CantEditException e = new CantEditException();
                e.lockedComplex = item;
                throw e;
            }
        }
        if (cell.isAllLocked()) {
            CantEditException e = new CantEditException();
            e.lockedAll = cell;
            e.lockedExample = item;
            throw e;
        }
    }

    public static int cantEdit(Cell cell, NodeInst item, boolean giveError, boolean allowInstanceChange, boolean insideJob) {
        int ret;
        Object[] options = new String[]{"Yes", "No", "Always", "Cancel"};
        if (item != null) {
            if (item.isLocked()) {
                if (!giveError) {
                    return 1;
                }
                ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked " + item + " are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret == 1) {
                    return 1;
                }
                if (ret == 2) {
                    if (insideJob) {
                        item.clearLocked();
                    } else {
                        new ClearNodeLocked(item);
                    }
                }
                if (ret == 3 || ret == -1) {
                    return -1;
                }
            }
            boolean complexNode = false;
            if (!item.isCellInstance()) {
                PrimitiveNode.Function fun;
                if (((PrimitiveNode)item.getProto()).isLockedPrim() && User.isDisallowModificationLockedPrims()) {
                    if (!giveError) {
                        return 1;
                    }
                    int ret2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked primitives (such as " + item + ") are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                    if (ret2 == 1) {
                        return 1;
                    }
                    if (ret2 == 2) {
                        User.setDisallowModificationLockedPrims(false);
                    }
                    if (ret2 == 3) {
                        return -1;
                    }
                }
                if (!(fun = item.getFunction()).isPin() && !fun.isContact() && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.CONNECT) {
                    complexNode = true;
                }
            } else {
                complexNode = true;
                if (!allowInstanceChange && cell.isInstancesLocked()) {
                    if (!giveError) {
                        return 1;
                    }
                    int ret3 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Modification of instances in " + cell + " is disallowed.  You cannot move " + item + ".  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                    if (ret3 == 1) {
                        return 1;
                    }
                    if (ret3 == 2) {
                        if (insideJob) {
                            cell.clearInstancesLocked();
                        } else {
                            new ClearCellLocked(cell, false);
                        }
                    }
                    if (ret3 == 3) {
                        return -1;
                    }
                }
            }
            if (complexNode && User.isDisallowModificationComplexNodes()) {
                if (!giveError) {
                    return 1;
                }
                int ret4 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to complex nodes (such as " + item + ") are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret4 == 1) {
                    return 1;
                }
                if (ret4 == 2) {
                    User.setDisallowModificationComplexNodes(false);
                }
                if (ret4 == 3) {
                    return -1;
                }
            }
        }
        if (cell == null) {
            return -1;
        }
        if (cell.isAllLocked()) {
            if (!giveError) {
                return 1;
            }
            ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Modification of " + cell + " is disallowed.  Change " + (item == null ? "" : item.toString()) + " anyway?", "Allow changes", -1, 2, null, options, options[1]);
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                if (insideJob) {
                    cell.clearAllLocked();
                } else {
                    new ClearCellLocked(cell, true);
                }
            }
            if (ret == 3) {
                return -1;
            }
        }
        return 0;
    }

    public static class MakeCellAnnotationJob
    extends Job {
        static final long serialVersionUID = 0L;
        private transient EditWindow_ wnd;
        private Cell cell;
        private String newAnnotation;
        private Variable.Key key;

        public static void makeAnnotationMenuCommand(Tool tool, Variable.Key key, String newAnnotation) {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.needCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            Cell cell = ui.needCurrentCell();
            if (cell == null) {
                return;
            }
            new MakeCellAnnotationJob(wnd, cell, tool, key, newAnnotation);
        }

        private MakeCellAnnotationJob(EditWindow_ wnd, Cell cell, Tool tool, Variable.Key k, String annotation) {
            super("Make Cell Annotation", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.cell = cell;
            this.newAnnotation = annotation;
            this.key = k;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            MakeCellAnnotationJob.addAnnotation(this.cell, this.key, this.newAnnotation, null, null, this.getEditingPreferences());
            return true;
        }

        @Override
        public void terminateOK() {
            this.wnd.clearHighlighting();
            this.wnd.addHighlightText(this.cell, this.cell, this.key);
            this.wnd.finishedHighlighting();
        }

        public static void addAnnotation(Cell c, Variable.Key k, String annotation, EditingPreferences ep) {
            MakeCellAnnotationJob.addAnnotation(c, k, annotation, null, null, ep);
        }

        public static void addAnnotation(Cell c, Variable.Key k, String annotation, ERectangle rect, AbstractTextDescriptor.Position pos, EditingPreferences ep) {
            Variable var = c.getVar(k);
            if (var == null) {
                String[] initial = new String[]{annotation};
                TextDescriptor td = ep.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                if (rect != null) {
                    td = td.withOff(rect.getCenterX(), -rect.getCoordMaxY().getLambda()).withPos(AbstractTextDescriptor.Position.DOWN);
                }
                if (pos != null) {
                    td = td.withPos(pos);
                }
                Job.error((var = c.newVar(k, (Object)initial, td)) == null, "couldn't create" + k + " annotation");
            } else {
                String[] oldObj = var.getObject();
                if (oldObj instanceof String) {
                    oldObj = new String[]{(String)oldObj};
                }
                Job.error(!(oldObj instanceof String[]), k + " annotation not String[]");
                String[] oldVal = oldObj;
                TextDescriptor td = var.getTextDescriptor();
                int newLen = oldVal.length + 1;
                String[] newVal = new String[newLen];
                for (int i = 0; i < newLen - 1; ++i) {
                    newVal[i] = oldVal[i];
                }
                newVal[newLen - 1] = annotation;
                var = c.newVar(k, (Object)newVal, td);
            }
        }
    }

    public static class ClearCellLocked
    extends Job {
        private Cell cell;
        private boolean all;

        public ClearCellLocked(Cell cell, boolean all) {
            super("Clear locked state of " + cell.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.all = all;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            if (this.all) {
                this.cell.clearAllLocked();
            } else {
                this.cell.clearInstancesLocked();
            }
            return true;
        }
    }

    public static class ClearNodeLocked
    extends Job {
        private NodeInst ni;

        public ClearNodeLocked(NodeInst ni) {
            super("Clear locked state of " + ni.describe(false), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            this.ni.clearLocked();
            return true;
        }
    }

    public static class ReloadLibraryJob
    extends Job {
        private Library lib;

        public ReloadLibraryJob(Library lib) {
            super("Reload Library " + lib.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            LibraryFiles.reloadLibrary(this.getEditingPreferences(), this.lib);
            return true;
        }
    }

    public static class CheckAndRepairJob
    extends Job {
        private boolean repair;

        public CheckAndRepairJob(boolean repair) {
            super(repair ? "Repair Libraries" : "Check Libraries", User.getUserTool(), repair ? Job.Type.CHANGE : Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.repair = repair;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (EDatabase.serverDatabase().checkInvariants()) {
                ErrorLogger errorLogger = ErrorLogger.newInstance(this.repair ? "Repair Libraries" : "Check Libraries");
                int errorCount = 0;
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext()) {
                    Library lib = it.next();
                    errorCount += lib.checkAndRepair(this.repair, errorLogger, this.getEditingPreferences());
                }
                if (errorCount > 0) {
                    System.out.println("Found " + errorCount + " errors");
                } else {
                    System.out.println("No errors found");
                }
                errorLogger.termLogging(true);
            }
            return true;
        }
    }

    private static class MarkCurrentLibForSaving
    extends Job {
        MarkCurrentLibForSaving() {
            super("Making Current Lib", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Library lib = Library.getCurrent();
            if (lib.isHidden()) {
                return true;
            }
            String ext = TextUtils.getExtension(lib.getLibFile());
            if (ext.equals("txt")) {
                return true;
            }
            lib.setChanged();
            if (lib.getLibFile() != null && OpenFile.getOpenFileType(lib.getLibFile().getFile(), FileType.JELIB) == FileType.DELIB) {
                Iterator<Cell> it2 = lib.getCells();
                while (it2.hasNext()) {
                    it2.next().lowLevelSetRevisionDate(new Date());
                }
            }
            System.out.println("Library " + lib.getName() + " now needs to be saved");
            return true;
        }
    }

    private static class MarkAllLibraries
    extends Job {
        MarkAllLibraries() {
            super("Making all libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                String ext;
                Library lib = it.next();
                if (lib.isHidden() || (ext = TextUtils.getExtension(lib.getLibFile())).equals("txt")) continue;
                lib.setChanged();
                if (lib.getLibFile() == null || OpenFile.getOpenFileType(lib.getLibFile().getFile(), FileType.JELIB) != FileType.DELIB) continue;
                Iterator<Cell> it2 = lib.getCells();
                while (it2.hasNext()) {
                    it2.next().lowLevelSetRevisionDate(new Date());
                }
            }
            System.out.println("All libraries now need to be saved");
            return true;
        }
    }

    public static class RenameLibrary
    extends Job {
        private Library lib;
        private String newName;
        private IdMapper idMapper;

        public RenameLibrary(Library lib, String newName) {
            super("Renaming " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            String oldName = this.lib.getName();
            this.idMapper = this.lib.setName(this.newName);
            if (this.idMapper == null) {
                return false;
            }
            this.fieldVariableChanged("idMapper");
            System.out.println("Library '" + oldName + "' renamed to '" + this.newName + "'");
            return true;
        }

        @Override
        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    public static class RenameTechnology
    extends Job {
        private Technology tech;
        private String newName;

        public RenameTechnology(Technology tech, String newName) {
            super("Renaming " + tech, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.newName = newName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            String oldName = this.tech.getTechName();
            this.tech.setTechName(this.newName);
            System.out.println("Technology '" + oldName + "' renamed to '" + this.newName + "'");
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library oLib = it.next();
                if (oLib.isHidden()) continue;
                oLib.setChanged();
            }
            return true;
        }
    }

    private static class PossibleVariables {
        private static Map<PrimitiveNode, List<Variable.Key>> posVarsMap = new HashMap<PrimitiveNode, List<Variable.Key>>();

        private PossibleVariables() {
        }

        private static void add(String varName, PrimitiveNode pn) {
            Variable.Key key;
            List<Variable.Key> varKeys = posVarsMap.get(pn);
            if (varKeys == null) {
                varKeys = new ArrayList<Variable.Key>();
                posVarsMap.put(pn, varKeys);
            }
            if (!varKeys.contains(key = Variable.newKey(varName))) {
                varKeys.add(key);
            }
        }

        public Iterator<Variable.Key> getPossibleVarKeys(PrimitiveNode pn) {
            List<Variable.Key> varKeys = posVarsMap.get(pn);
            if (varKeys == null) {
                varKeys = new ArrayList<Variable.Key>();
            }
            return varKeys.iterator();
        }

        public static boolean validKey(Variable.Key key, PrimitiveNode pn) {
            List<Variable.Key> varKeys = posVarsMap.get(pn);
            if (varKeys == null) {
                return false;
            }
            return varKeys.contains(key);
        }

        static {
            PossibleVariables.add("ATTR_length", Schematics.tech().transistorNode);
            PossibleVariables.add("ATTR_length", Schematics.tech().transistor4Node);
            PossibleVariables.add("ATTR_width", Schematics.tech().transistorNode);
            PossibleVariables.add("ATTR_width", Schematics.tech().transistor4Node);
            PossibleVariables.add("ATTR_area", Schematics.tech().transistorNode);
            PossibleVariables.add("ATTR_area", Schematics.tech().transistor4Node);
            PossibleVariables.add("SIM_spice_model", Schematics.tech().sourceNode);
            PossibleVariables.add("SIM_spice_model", Schematics.tech().transistorNode);
            PossibleVariables.add("SIM_spice_model", Schematics.tech().transistor4Node);
            PossibleVariables.add("SCHEM_meter_type", Schematics.tech().meterNode);
            PossibleVariables.add("SCHEM_diode", Schematics.tech().diodeNode);
            PossibleVariables.add("SCHEM_capacitance", Schematics.tech().capacitorNode);
            PossibleVariables.add("SCHEM_resistance", Schematics.tech().resistorNode);
            PossibleVariables.add("SCHEM_inductance", Schematics.tech().inductorNode);
            PossibleVariables.add("SCHEM_function", Schematics.tech().bboxNode);
            PossibleVariables.add("ART_degrees", Artwork.tech().circleNode);
            PossibleVariables.add("ART_degrees", Artwork.tech().thickCircleNode);
        }
    }

    public static class Reconnect
    implements Serializable {
        private NodeInst ni;
        private ArrayList<ReconnectedArc> reconnectedArcs;

        public static Reconnect erasePassThru(NodeInst ni, boolean allowdiffs, boolean checkPermission, EditingPreferences ep) {
            if (!ni.hasConnections()) {
                return null;
            }
            Cell cell = ni.getParent();
            if (checkPermission && CircuitChangeJobs.cantEdit(cell, ni, true, false, true) != 0) {
                return null;
            }
            Reconnect recon = new Reconnect();
            recon.ni = ni;
            recon.reconnectedArcs = new ArrayList();
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
                Iterator<Connection> it2 = pi.getConnections();
                while (it2.hasNext()) {
                    Connection conn = it2.next();
                    ArcInst ai = conn.getArc();
                    if (ai.getHeadPortInst().getNodeInst() == ai.getTailPortInst().getNodeInst()) continue;
                    arcs.add(ai);
                }
                while (arcs.size() > 1) {
                    ArcInst ai1 = (ArcInst)arcs.remove(0);
                    for (ArcInst ai2 : arcs) {
                        ReconnectedArc ra = Reconnect.reconnectArcs(pi, ai1, ai2, allowdiffs);
                        if (ra == null) continue;
                        recon.reconnectedArcs.add(ra);
                    }
                }
            }
            if (recon.reconnectedArcs.isEmpty()) {
                return null;
            }
            return recon;
        }

        private static ReconnectedArc reconnectArcs(PortInst pi, ArcInst ai1, ArcInst ai2, boolean allowdiffs) {
            if (ai1.getProto() != ai2.getProto()) {
                return null;
            }
            ReconnectedArc ra = new ReconnectedArc();
            ra.ap = ai1.getProto();
            ReconnectedArc.access$402(ra, new PortInst[2]);
            ReconnectedArc.access$502(ra, new EPoint[2]);
            ReconnectedArc.access$602(ra, new ArcInst[2]);
            ((ReconnectedArc)ra).reconAr[0] = ai1;
            ((ReconnectedArc)ra).reconAr[1] = ai2;
            Point2D[] orig = new Point2D[2];
            Point2D[] delta = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                if (ai1.getPortInst(i) != pi) {
                    ((ReconnectedArc)ra).reconPi[0] = ai1.getPortInst(i);
                    ((ReconnectedArc)ra).recon[0] = ai1.getLocation(i);
                } else {
                    orig[0] = ai1.getLocation(i);
                }
                if (ai2.getPortInst(i) != pi) {
                    ((ReconnectedArc)ra).reconPi[1] = ai2.getPortInst(i);
                    ((ReconnectedArc)ra).recon[1] = ai2.getLocation(i);
                    continue;
                }
                orig[1] = ai2.getLocation(i);
            }
            delta[0] = new Point2D.Double(ra.recon[0].getX() - orig[0].getX(), ra.recon[0].getY() - orig[0].getY());
            delta[1] = new Point2D.Double(ra.recon[1].getX() - orig[1].getX(), ra.recon[1].getY() - orig[1].getY());
            if (!allowdiffs) {
                if (ai1.getLambdaBaseWidth() != ai2.getLambdaBaseWidth()) {
                    return null;
                }
                if (delta[1].getX() * delta[0].getY() != delta[0].getX() * delta[1].getY()) {
                    return null;
                }
                boolean zeroLength = false;
                if (delta[0].getX() == 0.0 && delta[0].getY() == 0.0) {
                    zeroLength = true;
                }
                if (delta[1].getX() == 0.0 && delta[1].getY() == 0.0) {
                    zeroLength = true;
                }
                if (!zeroLength && delta[0].getX() * delta[1].getX() + delta[0].getY() * delta[1].getY() >= 0.0) {
                    return null;
                }
                if (orig[0].getX() != orig[1].getX() || orig[0].getY() != orig[1].getY()) {
                    if (delta[0].getX() != 0.0 || delta[0].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[0].getY() != delta[0].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else if (delta[1].getX() != 0.0 || delta[1].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[1].getY() != delta[1].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
            ra.wid = ai1.getLambdaBaseWidth();
            ra.directionalHead = ai1.isHeadArrowed();
            ra.directionalTail = ai1.isTailArrowed();
            ra.directionalBody = ai1.isBodyArrowed();
            ra.extendHead = ai1.isHeadExtended();
            ra.extendTail = ai2.isTailExtended();
            ra.negateHead = ai1.isHeadNegated();
            ra.negateTail = ai2.isTailNegated();
            if (ai1.getName() != null && !ai1.getNameKey().isTempname()) {
                ra.arcName = ai1.getName();
                ra.arcNameTD = ai1.getTextDescriptor(ArcInst.ARC_NAME);
            }
            if (ai2.getName() != null && !ai2.getNameKey().isTempname()) {
                ra.arcName = ai2.getName();
                ra.arcNameTD = ai2.getTextDescriptor(ArcInst.ARC_NAME);
            }
            return ra;
        }

        public List<ArcInst> reconnectArcs(EditingPreferences ep) {
            ArrayList<ArcInst> newArcs = new ArrayList<ArcInst>();
            for (ReconnectedArc ra : this.reconnectedArcs) {
                ArcInst newAi;
                if (!ra.reconPi[0].getNodeInst().isLinked() || !ra.reconPi[1].getNodeInst().isLinked() || (newAi = ArcInst.makeInstanceBase(ra.ap, ep, ra.wid, ra.reconPi[0], ra.reconPi[1], ra.recon[0], ra.recon[1], null)) == null) continue;
                newAi.setHeadArrowed(ra.directionalHead);
                newAi.setTailArrowed(ra.directionalTail);
                newAi.setBodyArrowed(ra.directionalBody);
                newAi.setHeadExtended(ra.extendHead);
                newAi.setTailExtended(ra.extendTail);
                newAi.setHeadNegated(ra.negateHead);
                newAi.setTailNegated(ra.negateTail);
                if (ra.arcName != null) {
                    newAi.setName(ra.arcName, ep);
                    newAi.setTextDescriptor(ArcInst.ARC_NAME, ra.arcNameTD);
                }
                newAi.copyVarsFrom(ra.reconAr[0]);
                newAi.copyVarsFrom(ra.reconAr[1]);
                newArcs.add(newAi);
            }
            return newArcs;
        }
    }

    private static class ReconnectedArc
    implements Serializable {
        private PortInst[] reconPi;
        private EPoint[] recon;
        private ArcInst[] reconAr;
        private ArcProto ap;
        private double wid;
        private boolean directionalHead;
        private boolean directionalTail;
        private boolean directionalBody;
        private boolean extendHead;
        private boolean extendTail;
        private boolean negateHead;
        private boolean negateTail;
        private String arcName;
        private TextDescriptor arcNameTD;

        private ReconnectedArc() {
        }

        static /* synthetic */ PortInst[] access$402(ReconnectedArc x0, PortInst[] x1) {
            x0.reconPi = x1;
            return x1;
        }

        static /* synthetic */ EPoint[] access$502(ReconnectedArc x0, EPoint[] x1) {
            x0.recon = x1;
            return x1;
        }

        static /* synthetic */ ArcInst[] access$602(ReconnectedArc x0, ArcInst[] x1) {
            x0.reconAr = x1;
            return x1;
        }
    }

    public static class CellCenterToCenterOfSelection
    extends Job {
        private Cell cell;
        private EPoint ctr;

        public CellCenterToCenterOfSelection(Cell cell, EPoint ctr) {
            super("Cell center to center of selection", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.ctr = ctr;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst center = null;
            for (NodeInst ni : ArrayIterator.i2i(this.cell.getNodes())) {
                if (!Generic.isCellCenter(ni)) continue;
                center = ni;
            }
            if (center == null) {
                System.out.println("No cell center; please add one.");
                return false;
            }
            center.move(this.ctr.getX(), this.ctr.getY());
            return true;
        }
    }

    public static class ManyMove
    extends Job {
        private static final boolean verbose = true;
        private Cell cell;
        private List<ElectricObject> highlightedObjs;
        private List<DisplayedText> highlightedText;
        private double dX;
        private double dY;
        private boolean updateStatusBar;
        private boolean moveNodeWithExport;

        public ManyMove(Cell cell, List<ElectricObject> highlightedObjs, List<DisplayedText> highlightedText, double dX, double dY) {
            super("Move", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlightedObjs = highlightedObjs;
            this.highlightedText = highlightedText;
            this.dX = dX;
            this.dY = dY;
            this.moveNodeWithExport = User.isMoveNodeWithExport();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst ni;
            ArcInst ai;
            ArcInst ai2;
            ElectricObject firstEObj;
            if (this.highlightedObjs.size() + this.highlightedText.size() == 0) {
                return false;
            }
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            if (this.highlightedObjs.size() == 1 && this.highlightedText.size() == 0 && ((firstEObj = this.highlightedObjs.get(0)) instanceof NodeInst || firstEObj instanceof PortInst)) {
                NodeInst ni2 = firstEObj instanceof PortInst ? ((PortInst)firstEObj).getNodeInst() : (NodeInst)firstEObj;
                if (CircuitChangeJobs.cantEdit(this.cell, ni2, true, false, true) != 0) {
                    return false;
                }
                ni2.move(this.dX, this.dY);
                System.out.println("Moved node " + ni2.describe(false) + " by (" + this.dX + "," + this.dY + ")");
                this.updateStatusBar = true;
                this.fieldVariableChanged("updateStatusBar");
                return true;
            }
            boolean found = false;
            for (ElectricObject eobj : this.highlightedObjs) {
                int j;
                if (!(eobj instanceof ArcInst) || (ai2 = (ArcInst)eobj).getHeadLocation().getX() == ai2.getTailLocation().getX() || ai2.getHeadLocation().getY() == ai2.getTailLocation().getY() || !ai2.isFixedAngle() || ai2.isRigid()) continue;
                for (j = 0; j < 2; ++j) {
                    NodeInst ni3 = ai2.getPortInst(j).getNodeInst();
                    ArcInst oai = null;
                    Iterator<Connection> pIt = ni3.getConnections();
                    while (pIt.hasNext()) {
                        Connection con = pIt.next();
                        if (con.getArc() == ai2) continue;
                        if (oai == null) {
                            oai = con.getArc();
                            continue;
                        }
                        oai = null;
                        break;
                    }
                    if (oai == null || oai.getHeadLocation().getX() != oai.getTailLocation().getX() && oai.getHeadLocation().getY() != oai.getTailLocation().getY() || this.highlightedObjs.contains(oai)) break;
                }
                if (j < 2) continue;
                found = true;
                break;
            }
            if (found) {
                for (ElectricObject eobj : this.highlightedObjs) {
                    int j;
                    if (!(eobj instanceof ArcInst)) continue;
                    ai2 = (ArcInst)eobj;
                    double[] deltaXs = new double[2];
                    double[] deltaYs = new double[2];
                    NodeInst[] niList = new NodeInst[2];
                    deltaYs[1] = 0.0;
                    deltaXs[1] = 0.0;
                    deltaYs[0] = 0.0;
                    deltaXs[0] = 0.0;
                    int arcangle = ai2.getDefinedAngle();
                    for (j = 0; j < 2; ++j) {
                        Point2D iPt;
                        NodeInst ni4;
                        niList[j] = ni4 = ai2.getPortInst(j).getNodeInst();
                        ArcInst oai = null;
                        Iterator<Connection> pIt = ni4.getConnections();
                        while (pIt.hasNext()) {
                            Connection con = pIt.next();
                            if (con.getArc() == ai2) continue;
                            oai = con.getArc();
                            break;
                        }
                        if (oai == null) break;
                        if (DBMath.doublesEqual(oai.getHeadLocation().getX(), oai.getTailLocation().getX())) {
                            iPt = DBMath.intersect(oai.getHeadLocation(), 900, new Point2D.Double(ai2.getHeadLocation().getX() + this.dX, ai2.getHeadLocation().getY() + this.dY), arcangle);
                            if (iPt == null) continue;
                            deltaXs[j] = iPt.getX() - ai2.getLocation(j).getX();
                            deltaYs[j] = iPt.getY() - ai2.getLocation(j).getY();
                            continue;
                        }
                        if (!DBMath.doublesEqual(oai.getHeadLocation().getY(), oai.getTailLocation().getY()) || (iPt = DBMath.intersect(oai.getHeadLocation(), 0, new Point2D.Double(ai2.getHeadLocation().getX() + this.dX, ai2.getHeadLocation().getY() + this.dY), arcangle)) == null) continue;
                        deltaXs[j] = iPt.getX() - ai2.getLocation(j).getX();
                        deltaYs[j] = iPt.getY() - ai2.getLocation(j).getY();
                    }
                    if (j < 2) continue;
                    NodeInst.modifyInstances(niList, deltaXs, deltaYs, null, null);
                }
                System.out.println("Moved multiple objects by (" + TextUtils.formatDouble(this.dX) + "," + TextUtils.formatDouble(this.dY) + ")");
                this.updateStatusBar = true;
                this.fieldVariableChanged("updateStatusBar");
                return true;
            }
            boolean onlySlidable = true;
            boolean foundArc = false;
            for (ElectricObject eobj : this.highlightedObjs) {
                if (eobj instanceof ArcInst) {
                    ai = (ArcInst)eobj;
                    foundArc = true;
                    if (ai.isSlidable()) {
                        Point2D.Double newHead = new Point2D.Double(ai.getHeadLocation().getX() + this.dX, ai.getHeadLocation().getY() + this.dY);
                        Point2D.Double newTail = new Point2D.Double(ai.getTailLocation().getX() + this.dX, ai.getTailLocation().getY() + this.dY);
                        if (ai.headStillInPort(newHead, true) && ai.tailStillInPort(newTail, true)) continue;
                    }
                }
                onlySlidable = false;
            }
            if (foundArc && onlySlidable) {
                for (ElectricObject eobj : this.highlightedObjs) {
                    if (!(eobj instanceof ArcInst)) continue;
                    ai = (ArcInst)eobj;
                    ai.modify(this.dX, this.dY, this.dX, this.dY);
                    System.out.println("Moved arc " + ai.describe(false) + " by (" + this.dX + "," + this.dY + ")");
                }
                this.updateStatusBar = true;
                this.fieldVariableChanged("updateStatusBar");
                return true;
            }
            for (int i = 0; i < this.highlightedObjs.size(); ++i) {
                ElectricObject eobj = this.highlightedObjs.get(i);
                if (!(eobj instanceof ArcInst)) continue;
                ai = (ArcInst)eobj;
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, ai.getHeadPortInst().getNodeInst(), true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode > 0) {
                    this.highlightedObjs.remove(i);
                    --i;
                    continue;
                }
                errorCode = CircuitChangeJobs.cantEdit(this.cell, ai.getTailPortInst().getNodeInst(), true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode <= 0) continue;
                this.highlightedObjs.remove(i);
                --i;
            }
            HashSet<NodeInst> flag = new HashSet<NodeInst>();
            HashMap<NodeInst, Point2D.Double> nodeLocation = new HashMap<NodeInst, Point2D.Double>();
            Iterator<NodeInst> it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni5 = it.next();
                nodeLocation.put(ni5, new Point2D.Double(ni5.getAnchorCenterX(), ni5.getAnchorCenterY()));
            }
            HashMap<ArcInst, Point2D.Double> arcLocation = new HashMap<ArcInst, Point2D.Double>();
            Iterator<ArcInst> it2 = this.cell.getArcs();
            while (it2.hasNext()) {
                ArcInst ai3 = it2.next();
                arcLocation.put(ai3, new Point2D.Double(ai3.getTrueCenterX(), ai3.getTrueCenterY()));
            }
            for (ElectricObject eobj : this.highlightedObjs) {
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof NodeInst) {
                    ni = (NodeInst)eobj;
                    if (Generic.isCellCenter(ni)) continue;
                    flag.add(ni);
                    continue;
                }
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai4 = (ArcInst)eobj;
                NodeInst ni1 = ai4.getHeadPortInst().getNodeInst();
                Point2D.Double newHead = new Point2D.Double(ai4.getHeadLocation().getX() + this.dX, ai4.getHeadLocation().getY() + this.dY);
                if (!ai4.isSlidable() || !ai4.headStillInPort(newHead, true)) {
                    flag.add(ni1);
                }
                NodeInst ni2 = ai4.getTailPortInst().getNodeInst();
                Point2D.Double newTail = new Point2D.Double(ai4.getTailLocation().getX() + this.dX, ai4.getTailLocation().getY() + this.dY);
                if (!ai4.isSlidable() || !ai4.tailStillInPort(newTail, true)) {
                    flag.add(ni2);
                }
                Layout.setTempRigid(ai4, true);
            }
            int numNodes = 0;
            Iterator<NodeInst> it3 = this.cell.getNodes();
            while (it3.hasNext()) {
                ni = it3.next();
                if (!flag.contains(ni)) continue;
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, ni, true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode > 0) {
                    flag.remove(ni);
                    continue;
                }
                ++numNodes;
            }
            if (numNodes > 0) {
                NodeInst[] nis = new NodeInst[numNodes];
                double[] dXs = new double[numNodes];
                double[] dYs = new double[numNodes];
                numNodes = 0;
                Iterator<NodeInst> it4 = this.cell.getNodes();
                while (it4.hasNext()) {
                    NodeInst ni6 = it4.next();
                    if (!flag.contains(ni6)) continue;
                    nis[numNodes] = ni6;
                    dXs[numNodes] = this.dX;
                    dYs[numNodes] = this.dY;
                    ++numNodes;
                }
                NodeInst.modifyInstances(nis, dXs, dYs, null, null);
            }
            flag = null;
            for (ElectricObject eobj : this.highlightedObjs) {
                ArcInst ai5;
                Point2D pt;
                if (!(eobj instanceof ArcInst) || (pt = (Point2D)arcLocation.get(ai5 = (ArcInst)eobj)).getX() != ai5.getTrueCenterX() || pt.getY() != ai5.getTrueCenterY()) continue;
                boolean headInPort = false;
                boolean tailInPort = false;
                if (!ai5.isRigid() && ai5.isSlidable()) {
                    headInPort = ai5.headStillInPort(new Point2D.Double(ai5.getHeadLocation().getX() + this.dX, ai5.getHeadLocation().getY() + this.dY), true);
                    tailInPort = ai5.tailStillInPort(new Point2D.Double(ai5.getTailLocation().getX() + this.dX, ai5.getTailLocation().getY() + this.dY), true);
                }
                if (headInPort && tailInPort) {
                    ai5.modify(this.dX, this.dY, this.dX, this.dY);
                    continue;
                }
                if (headInPort || tailInPort) continue;
                for (int k = 0; k < 2; ++k) {
                    NodeInst ni7 = k == 0 ? ai5.getHeadPortInst().getNodeInst() : ai5.getTailPortInst().getNodeInst();
                    Point2D nPt = (Point2D)nodeLocation.get(ni7);
                    if (ni7.getAnchorCenterX() != nPt.getX() || ni7.getAnchorCenterY() != nPt.getY()) continue;
                    for (ElectricObject oEObj : this.highlightedObjs) {
                        ArcInst oai;
                        Point2D aPt;
                        if (!(oEObj instanceof ArcInst) || (aPt = (Point2D)arcLocation.get(oai = (ArcInst)oEObj)).getX() != oai.getTrueCenterX() || aPt.getY() != oai.getTrueCenterY() || oai.headStillInPort(new Point2D.Double(ai5.getHeadLocation().getX() + this.dX, ai5.getHeadLocation().getY() + this.dY), true) || oai.tailStillInPort(new Point2D.Double(ai5.getTailLocation().getX() + this.dX, ai5.getTailLocation().getY() + this.dY), true)) continue;
                        Layout.setTempRigid(oai, true);
                    }
                    ni7.move(this.dX - (ni7.getAnchorCenterX() - nPt.getX()), this.dY - (ni7.getAnchorCenterY() - nPt.getY()));
                }
            }
            this.moveSelectedText(this.cell, this.highlightedText, this.moveNodeWithExport);
            System.out.println("Moved multiple objects by (" + TextUtils.formatDouble(this.dX) + "," + TextUtils.formatDouble(this.dY) + ")");
            this.updateStatusBar = true;
            this.fieldVariableChanged("updateStatusBar");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.updateStatusBar) {
                StatusBar.updateStatusBar();
            }
        }

        private void moveSelectedText(Cell cell, List<DisplayedText> highlightedText, boolean moveNodeWithExport) {
            for (DisplayedText dt : highlightedText) {
                Variable.Key varKey;
                TextDescriptor td;
                if (cell != null) {
                    int errorCode = CircuitChangeJobs.cantEdit(cell, null, true, true, true);
                    if (errorCode < 0) {
                        return;
                    }
                    if (errorCode > 0) continue;
                }
                ElectricObject eobj = dt.getElectricObject();
                if (dt.movesWithText(moveNodeWithExport)) {
                    NodeInst ni = null;
                    if (eobj instanceof NodeInst) {
                        ni = (NodeInst)eobj;
                    }
                    if (eobj instanceof Export) {
                        ni = ((Export)eobj).getOriginalPort().getNodeInst();
                    }
                    if (ni != null) {
                        ni.move(this.dX, this.dY);
                        continue;
                    }
                }
                if ((td = eobj.getTextDescriptor(varKey = dt.getVariableKey())) == null) continue;
                NodeInst ni = null;
                if (eobj instanceof NodeInst) {
                    ni = (NodeInst)eobj;
                } else if (eobj instanceof PortInst) {
                    ni = ((PortInst)eobj).getNodeInst();
                } else if (eobj instanceof Export && varKey == Export.EXPORT_NAME) {
                    ni = ((Export)eobj).getOriginalPort().getNodeInst();
                }
                if (ni != null) {
                    Point2D.Double curLoc = new Point2D.Double(ni.getAnchorCenterX() + td.getXOff(), ni.getAnchorCenterY() + td.getYOff());
                    FixpTransform rotateOut = ni.rotateOut();
                    rotateOut.transform(curLoc, curLoc);
                    ((Point2D)curLoc).setLocation(((Point2D)curLoc).getX() + this.dX, ((Point2D)curLoc).getY() + this.dY);
                    FixpTransform rotateIn = ni.rotateIn();
                    rotateIn.transform(curLoc, curLoc);
                    eobj.setOff(varKey, ((Point2D)curLoc).getX() - ni.getAnchorCenterX(), ((Point2D)curLoc).getY() - ni.getAnchorCenterY());
                    continue;
                }
                eobj.setOff(varKey, td.getXOff() + this.dX, td.getYOff() + this.dY);
            }
        }
    }

    public static class ShortenArcs
    extends Job {
        private Cell cell;
        private List<ArcInst> selected;

        public ShortenArcs(Cell cell, List<ArcInst> selected) {
            super("Shorten selected arcs", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.selected = selected;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            int l = 0;
            double[] dX = new double[2];
            double[] dY = new double[2];
            for (ArcInst ai : this.selected) {
                for (int j = 0; j < 2; ++j) {
                    Poly portPoly = ai.getPortInst(j).getPoly();
                    double wid = ai.getLambdaBaseWidth();
                    portPoly.reducePortPoly(ai.getPortInst(j), wid, ai.getAngle());
                    Point2D closest = portPoly.closestPoint(ai.getLocation(1 - j));
                    dX[j] = closest.getX() - ai.getLocation(j).getX();
                    dY[j] = closest.getY() - ai.getLocation(j).getY();
                }
                if (dX[0] == 0.0 && dY[0] == 0.0 && dX[1] == 0.0 && dY[1] == 0.0) continue;
                ai.modify(dX[1], dY[1], dX[0], dY[0]);
                ++l;
            }
            System.out.println("Shortened " + l + " arcs");
            return true;
        }
    }

    public static class CleanupChanges
    extends Job {
        private Cell cell;
        private boolean justThis;
        private Set<NodeInst> pinsToRemove;
        private List<Reconnect> pinsToPassThrough;
        private Map<NodeInst, EPoint> pinsToScale;
        private List<NodeInst> textToMove;
        private Set<ArcInst> arcsToKill;
        private int zeroSize;
        private int negSize;
        private int overSizePins;

        public CleanupChanges(Cell cell, boolean justThis, Set<NodeInst> pinsToRemove, List<Reconnect> pinsToPassThrough, Map<NodeInst, EPoint> pinsToScale, List<NodeInst> textToMove, Set<ArcInst> arcsToKill, int zeroSize, int negSize, int overSizePins) {
            super("Cleanup " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.justThis = justThis;
            this.pinsToRemove = pinsToRemove;
            this.pinsToPassThrough = pinsToPassThrough;
            this.pinsToScale = pinsToScale;
            this.textToMove = textToMove;
            this.arcsToKill = arcsToKill;
            this.zeroSize = zeroSize;
            this.negSize = negSize;
            this.overSizePins = overSizePins;
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            this.cell.killNodes(this.pinsToRemove);
            int pinsPassedThrough = 0;
            while (true) {
                boolean found = false;
                for (Reconnect re : this.pinsToPassThrough) {
                    List<ArcInst> created;
                    if (!re.ni.isLinked() || (created = re.reconnectArcs(ep)).size() <= 0) continue;
                    re.ni.kill();
                    ++pinsPassedThrough;
                    found = true;
                }
                if (!found) break;
                this.pinsToPassThrough = CircuitChangeJobs.getPinsToPassThrough(this.cell, ep);
            }
            for (NodeInst ni : this.pinsToScale.keySet()) {
                EPoint scale = this.pinsToScale.get(ni);
                ni.resize(scale.getX(), scale.getY());
            }
            for (NodeInst ni : this.textToMove) {
                ni.invisiblePinWithOffsetText(true);
            }
            this.cell.killArcs(this.arcsToKill);
            StringBuffer infstr = new StringBuffer();
            if (!this.justThis) {
                infstr.append("Cell " + this.cell.describe(true) + ":");
            }
            boolean spoke = false;
            if (this.pinsToRemove.size() + pinsPassedThrough != 0) {
                int removed = this.pinsToRemove.size() + pinsPassedThrough;
                infstr.append("Removed " + removed + " pins");
                spoke = true;
            }
            if (this.arcsToKill.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Removed " + this.arcsToKill.size() + " duplicate arcs");
                spoke = true;
            }
            if (this.pinsToScale.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Shrunk " + this.pinsToScale.size() + " pins");
                spoke = true;
            }
            if (this.zeroSize != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.zeroSize + " zero-size pins");
                } else {
                    infstr.append("Found " + this.zeroSize + " zero-size pins");
                }
                spoke = true;
            }
            if (this.negSize != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.negSize + " negative-size pins");
                } else {
                    infstr.append("Found " + this.negSize + " negative-size pins");
                }
                spoke = true;
            }
            if (this.overSizePins != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.overSizePins + " oversize pins with arcs that don't touch");
                } else {
                    infstr.append("Found " + this.overSizePins + " oversize pins with arcs that don't touch");
                }
                spoke = true;
            }
            if (this.textToMove.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Moved text on " + this.textToMove.size() + " pins with offset text");
            }
            System.out.println(infstr.toString());
            return true;
        }
    }

    public static class DeleteArcs
    extends Job {
        private Set<ArcInst> arcsToDelete;

        public DeleteArcs(Set<ArcInst> arcsToDelete) {
            super("Delete arcs", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.arcsToDelete = arcsToDelete;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (ArcInst ai : this.arcsToDelete) {
                NodeInst h = ai.getHeadPortInst().getNodeInst();
                NodeInst t = ai.getTailPortInst().getNodeInst();
                ai.kill();
                if (h.getProto().getFunction().isPin() && !h.hasConnections() && !h.hasExports()) {
                    h.kill();
                }
                if (!t.getProto().getFunction().isPin() || t.hasConnections() || t.hasExports()) continue;
                t.kill();
            }
            System.out.println("Deleted " + this.arcsToDelete.size() + " arcs");
            return true;
        }
    }

    public static class DeleteSelectedGeometry
    extends Job {
        private Cell cell;
        private ERectangle bounds;

        public DeleteSelectedGeometry(Cell cell, Rectangle2D bounds) {
            super("Delete selected geometry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = ERectangle.fromLambda(bounds);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            double lX = Math.floor(this.bounds.getMinX());
            double hX = Math.ceil(this.bounds.getMaxX());
            double lY = Math.floor(this.bounds.getMinY());
            double hY = Math.ceil(this.bounds.getMaxY());
            ArrayList<ArcInst> arcsInCell = new ArrayList<ArcInst>();
            Iterator<ArcInst> aIt = this.cell.getArcs();
            while (aIt.hasNext()) {
                arcsInCell.add(aIt.next());
            }
            for (ArcInst ai : arcsInCell) {
                ArcInst ai1;
                NodeInst ni;
                PrimitiveNode pin;
                Point2D.Double headPtAdj;
                EPoint headPt = ai.getHeadLocation();
                EPoint tailPt = ai.getTailLocation();
                if (((Point2D)tailPt).getX() == ((Point2D)headPt).getX() && ((Point2D)tailPt).getY() == ((Point2D)headPt).getY()) continue;
                double halfWidth = ai.getLambdaBaseWidth() / 2.0;
                double lXExt = lX - halfWidth;
                double hXExt = hX + halfWidth;
                double lYExt = lY - halfWidth;
                double hYExt = hY + halfWidth;
                Point2D.Double tailPtAdj = new Point2D.Double(((Point2D)tailPt).getX(), ((Point2D)tailPt).getY());
                if (DBMath.clipLine(tailPtAdj, headPtAdj = new Point2D.Double(((Point2D)headPt).getX(), ((Point2D)headPt).getY()), lXExt, hXExt, lYExt, hYExt)) continue;
                if (tailPtAdj.distance(headPt) + headPtAdj.distance(tailPt) < headPtAdj.distance(headPt) + tailPtAdj.distance(tailPt)) {
                    Point2D.Double swap = headPtAdj;
                    headPtAdj = tailPtAdj;
                    tailPtAdj = swap;
                }
                Name name = ai.getNameKey();
                String newName = null;
                if (!name.isTempname()) {
                    newName = name.toString();
                }
                if (!((Point2D)tailPt).equals(tailPtAdj)) {
                    pin = ai.getProto().findPinProto();
                    ni = NodeInst.makeInstance(pin, ep, tailPtAdj, pin.getDefWidth(ep), pin.getDefHeight(ep), this.cell);
                    if (ni == null) {
                        System.out.println("Error creating pin for shortening of " + ai);
                        continue;
                    }
                    ai1 = ArcInst.makeInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), ai.getTailPortInst(), ni.getOnlyPortInst(), ai.getTailLocation(), tailPtAdj, newName);
                    if (ai1 == null) {
                        System.out.println("Error shortening " + ai);
                        continue;
                    }
                    newName = null;
                    ai1.copyPropertiesFrom(ai);
                }
                if (!((Point2D)headPt).equals(headPtAdj)) {
                    pin = ai.getProto().findPinProto();
                    ni = NodeInst.makeInstance(pin, ep, headPtAdj, pin.getDefWidth(ep), pin.getDefHeight(ep), this.cell);
                    if (ni == null) {
                        System.out.println("Error creating pin for shortening of " + ai);
                        continue;
                    }
                    ai1 = ArcInst.makeInstanceBase(ai.getProto(), ep, ai.getLambdaBaseWidth(), ni.getOnlyPortInst(), ai.getHeadPortInst(), headPtAdj, ai.getHeadLocation(), newName);
                    if (ai1 == null) {
                        System.out.println("Error shortening " + ai);
                        continue;
                    }
                    ai1.copyPropertiesFrom(ai);
                }
                SizeListener.restorePreviousListener(ai);
                ai.kill();
            }
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            Iterator<NodeInst> nIt = this.cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni = nIt.next();
                if (!ni.isCellInstance() && ni.getProto().getFunction() == PrimitiveNode.Function.NODE) {
                    PolyBase poly;
                    ERectangle pointBounds = ni.getBounds();
                    if (((RectangularShape)pointBounds).getMinX() > hX || ((RectangularShape)pointBounds).getMaxX() < lX || ((RectangularShape)pointBounds).getMinY() > hY || ((RectangularShape)pointBounds).getMaxY() < lY) continue;
                    int errorCode = CircuitChangeJobs.cantEdit(this.cell, ni, true, false, true);
                    if (errorCode < 0) {
                        return false;
                    }
                    if (errorCode > 0) continue;
                    if (((RectangularShape)pointBounds).getMinX() >= lX && ((RectangularShape)pointBounds).getMaxX() <= hX && ((RectangularShape)pointBounds).getMinY() >= lY && ((RectangularShape)pointBounds).getMaxY() <= hY) {
                        nodesToDelete.add(ni);
                        continue;
                    }
                    Layer lay = ni.getProto().getTechnology().getLayer(0);
                    PolyMerge merge = new PolyMerge();
                    EPoint[] points = ni.getTrace();
                    if (points == null) {
                        poly = new PolyBase(pointBounds);
                    } else {
                        double cX = ((RectangularShape)pointBounds).getCenterX();
                        double cY = ((RectangularShape)pointBounds).getCenterY();
                        PolyBase.Point[] newPoints = new PolyBase.Point[points.length];
                        for (int i = 0; i < points.length; ++i) {
                            if (points[i] == null) continue;
                            newPoints[i] = PolyBase.fromLambda(((Point2D)points[i]).getX() + cX, ((Point2D)points[i]).getY() + cY);
                        }
                        poly = new PolyBase(newPoints);
                        poly.transform(ni.rotateOut());
                    }
                    merge.addPolygon(lay, poly);
                    PolyBase polySub = new PolyBase((lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY);
                    merge.subtract(lay, polySub);
                    List<PolyBase> resultingPolys = merge.getMergedPoints(lay, true);
                    if (resultingPolys != null) {
                        PolyBase largest = null;
                        double largestSize = 0.0;
                        for (PolyBase pb : resultingPolys) {
                            double sz = pb.getArea();
                            if (!(sz >= largestSize)) continue;
                            largestSize = sz;
                            largest = pb;
                        }
                        if (largest == null) continue;
                        ni.setTrace(largest.getPoints());
                        continue;
                    }
                }
                double cX = ni.getTrueCenterX();
                double cY = ni.getTrueCenterY();
                if (cX >= hX || cX <= lX || cY >= hY || cY <= lY) continue;
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, ni, true, false, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode > 0) continue;
                nodesToDelete.add(ni);
                SizeListener.restorePreviousListener(ni);
            }
            this.cell.killNodes(nodesToDelete);
            return true;
        }
    }

    public static class DeleteSelected
    extends Job {
        private Cell cell;
        private List<DisplayedText> highlightedText;
        private List<Geometric> highlighted;
        private boolean reconstructArcsAndExports;
        private List<Geometric> thingsToHighlight;

        public DeleteSelected(Cell cell, List<DisplayedText> highlightedText, List<Geometric> highlighted, boolean reconstructArcsAndExports) {
            super("Delete selected objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlightedText = highlightedText;
            this.highlighted = highlighted;
            this.reconstructArcsAndExports = reconstructArcsAndExports;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            int numNodeTextDeleted = 0;
            int numArcTextDeleted = 0;
            int numExportsDeleted = 0;
            int numVariablesDeleted = 0;
            for (DisplayedText dt : this.highlightedText) {
                Variable.Key key = dt.getVariableKey();
                ElectricObject eobj = dt.getElectricObject();
                SizeListener.restorePreviousListener(eobj);
                if (key == NodeInst.NODE_NAME) {
                    NodeInst ni = (NodeInst)eobj;
                    ni.setName(null);
                    ni.move(0.0, 0.0);
                    ++numNodeTextDeleted;
                    continue;
                }
                if (key == ArcInst.ARC_NAME) {
                    ArcInst ai = (ArcInst)eobj;
                    ai.setName(null, ep);
                    ai.modify(0.0, 0.0, 0.0, 0.0);
                    ++numArcTextDeleted;
                    continue;
                }
                if (key == Export.EXPORT_NAME) {
                    Export pp = (Export)eobj;
                    int errCode = CircuitChangeJobs.cantEdit(this.cell, pp.getOriginalPort().getNodeInst(), true, true, true);
                    if (errCode < 0) {
                        return false;
                    }
                    if (errCode > 0) continue;
                    pp.kill();
                    ++numExportsDeleted;
                    continue;
                }
                if (eobj.isParam(key)) {
                    if (eobj instanceof Cell) {
                        Cell.CellGroup cg = ((Cell)eobj).getCellGroup();
                        if (cg != null) {
                            cg.delParam((Variable.AttrKey)key);
                        }
                    } else if (eobj instanceof NodeInst) {
                        ((NodeInst)eobj).delParameter(key);
                    }
                } else {
                    eobj.delVar(key);
                }
                ++numVariablesDeleted;
            }
            if (numNodeTextDeleted != 0 || numArcTextDeleted != 0 || numExportsDeleted != 0 || numVariablesDeleted != 0) {
                String msg = "";
                if (numArcTextDeleted != 0) {
                    msg = "Deleted";
                    if (numNodeTextDeleted == 1) {
                        msg = msg + " text on 1 Node";
                    } else if (numNodeTextDeleted > 1) {
                        msg = msg + " text on " + numNodeTextDeleted + " Nodes";
                    }
                }
                if (numArcTextDeleted != 0) {
                    msg = msg.length() == 0 ? "Deleted" : msg + ",";
                    if (numArcTextDeleted == 1) {
                        msg = msg + " text on 1 Arc";
                    } else if (numArcTextDeleted > 1) {
                        msg = msg + " text on " + numArcTextDeleted + " Arcs";
                    }
                }
                if (numExportsDeleted != 0) {
                    msg = msg.length() == 0 ? "Deleted" : msg + ",";
                    if (numExportsDeleted == 1) {
                        msg = msg + " 1 Export";
                    } else if (numExportsDeleted > 1) {
                        msg = msg + " " + numExportsDeleted + " Exports";
                    }
                }
                if (numVariablesDeleted != 0) {
                    msg = msg.length() == 0 ? "Deleted" : msg + ",";
                    if (numVariablesDeleted == 1) {
                        msg = msg + " 1 Variable";
                    } else if (numVariablesDeleted > 1) {
                        msg = msg + " " + numVariablesDeleted + " Variables";
                    }
                }
                System.out.println(msg);
            }
            if (this.cell != null) {
                this.thingsToHighlight = new ArrayList<Geometric>();
                HashSet<ElectricObject> stuffToHighlight = new HashSet<ElectricObject>();
                CircuitChangeJobs.eraseObjectsInList(this.cell, this.highlighted, this.reconstructArcsAndExports, stuffToHighlight, ep);
                for (ElectricObject eObj : stuffToHighlight) {
                    if (eObj instanceof ArcInst) {
                        ArcInst ai = (ArcInst)eObj;
                        this.thingsToHighlight.add(ai);
                        continue;
                    }
                    if (!(eObj instanceof Export)) continue;
                    Export e = (Export)eObj;
                    this.thingsToHighlight.add(e.getOriginalPort().getNodeInst());
                }
                this.fieldVariableChanged("thingsToHighlight");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null) {
                wnd.clearHighlighting();
                if (this.thingsToHighlight != null) {
                    for (Geometric geom : this.thingsToHighlight) {
                        wnd.addElectricObject(geom, this.cell);
                    }
                }
                wnd.finishedHighlighting();
            }
        }
    }

    public static class RipTheBus
    extends Job {
        private Cell cell;
        private List<ArcInst> list;

        public RipTheBus(Cell cell, List<ArcInst> list2) {
            super("Rip Bus", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.list = list2;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            for (ArcInst ai : this.list) {
                PortInst tail;
                PortInst head2;
                ArcInst aiw;
                PortInst tail2;
                PortInst head3;
                ArcInst aiw2;
                NodeInst nib;
                NodeInst niw;
                if (ai.getProto() != Schematics.tech().bus_arc) continue;
                Netlist netList = ai.getParent().getNetlist();
                if (netList == null) {
                    System.out.println("Sorry, a deadlock aborted bus ripping (network information unavailable).  Please try again");
                    break;
                }
                int busWidth = netList.getBusWidth(ai);
                String netName = netList.getNetworkName(ai);
                if (netName.length() == 0) {
                    System.out.println("Bus " + ai.describe(true) + " has no name");
                    continue;
                }
                double stublen = (int)(ai.getLambdaLength() / 3.0 + 0.5);
                double lowXBus = 0.0;
                double lowYBus = 0.0;
                int lowEnd = 1;
                double sepX = 0.0;
                double sepY = 0.0;
                double lowX = 0.0;
                double lowY = 0.0;
                if (ai.getHeadLocation().getX() == ai.getTailLocation().getX()) {
                    lowX = ai.getHeadLocation().getX();
                    lowX = lowX < ai.getParent().getBounds().getCenterX() ? (lowX += stublen) : (lowX -= stublen);
                    if (ai.getLocation(0).getY() < ai.getLocation(1).getY()) {
                        lowEnd = 0;
                    }
                    lowY = (int)ai.getLocation(lowEnd).getY();
                    double highy = (int)ai.getLocation(1 - lowEnd).getY();
                    if (highy - lowY >= (double)(busWidth - 1)) {
                        sepY = (int)((highy - lowY) / (double)(busWidth - 1));
                        lowY = (int)((highy - lowY - sepY * (double)(busWidth - 1)) / 2.0 + lowY);
                    } else {
                        lowY = ai.getLocation(lowEnd).getY();
                        highy = ai.getLocation(1 - lowEnd).getY();
                        sepY = (highy - lowY) / (double)(busWidth - 1);
                    }
                    lowXBus = ai.getTailLocation().getX();
                    lowYBus = lowY;
                } else if (ai.getTailLocation().getY() == ai.getHeadLocation().getY()) {
                    lowY = ai.getTailLocation().getY();
                    lowY = lowY < ai.getParent().getBounds().getCenterY() ? (lowY += stublen) : (lowY -= stublen);
                    if (ai.getLocation(0).getX() < ai.getLocation(1).getX()) {
                        lowEnd = 0;
                    }
                    lowX = (int)ai.getLocation(lowEnd).getX();
                    double highx = (int)ai.getLocation(1 - lowEnd).getX();
                    if (highx - lowX >= (double)(busWidth - 1)) {
                        sepX = (int)((highx - lowX) / (double)(busWidth - 1));
                        lowX = (int)((highx - lowX - sepX * (double)(busWidth - 1)) / 2.0 + lowX);
                    } else {
                        lowX = ai.getLocation(lowEnd).getX();
                        highx = ai.getLocation(1 - lowEnd).getX();
                        sepX = (highx - lowX) / (double)(busWidth - 1);
                    }
                    lowXBus = lowX;
                    lowYBus = ai.getTailLocation().getY();
                } else {
                    System.out.println("Bus " + ai.describe(true) + " must be horizontal or vertical to be ripped out");
                    continue;
                }
                String[] localStrings = new String[busWidth];
                for (int i = 0; i < busWidth; ++i) {
                    Network subNet = netList.getNetwork(ai, i);
                    localStrings[i] = subNet.getName();
                }
                double sxw = Schematics.tech().wirePinNode.getDefWidth(ep);
                double syw = Schematics.tech().wirePinNode.getDefHeight(ep);
                double sxb = Schematics.tech().busPinNode.getDefWidth(ep);
                double syb = Schematics.tech().busPinNode.getDefHeight(ep);
                ArcProto apW = Schematics.tech().wire_arc;
                ArcProto apB = Schematics.tech().bus_arc;
                NodeInst niBLast = null;
                for (int i = 0; i < busWidth && (niw = NodeInst.makeInstance(Schematics.tech().wirePinNode, ep, new Point2D.Double(lowX, lowY), sxw, syw, ai.getParent())) != null && (nib = NodeInst.makeInstance(Schematics.tech().busPinNode, ep, new Point2D.Double(lowXBus, lowYBus), sxb, syb, ai.getParent())) != null && (aiw2 = ArcInst.makeInstance(apW, ep, head3 = niw.getOnlyPortInst(), tail2 = nib.getOnlyPortInst())) != null; ++i) {
                    PortInst first;
                    aiw2.setName(localStrings[i], ep);
                    if (i == 0) {
                        first = ai.getPortInst(lowEnd);
                        aiw2 = ArcInst.makeInstance(apB, ep, first, tail2);
                    } else {
                        first = niBLast.getOnlyPortInst();
                        aiw2 = ArcInst.makeInstance(apB, ep, first, tail2);
                    }
                    if (aiw2 == null) break;
                    niBLast = nib;
                    lowX += sepX;
                    lowY += sepY;
                    lowXBus += sepX;
                    lowYBus += sepY;
                }
                if ((aiw = ArcInst.makeInstance(apB, ep, head2 = niBLast.getOnlyPortInst(), tail = ai.getPortInst(1 - lowEnd))) == null) {
                    return false;
                }
                aiw.setName(netName, ep);
                ai.kill();
            }
            return true;
        }
    }

    public static class ToggleNegationJob
    extends Job {
        private Cell cell;
        private List<ElectricObject> highlighted;
        private int numSet;

        public ToggleNegationJob(Cell cell, List<Highlight> highlighted) {
            super("Toggle negation", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlighted = new ArrayList<ElectricObject>();
            for (Highlight h : highlighted) {
                if (!h.isHighlightEOBJ()) continue;
                this.highlighted.add(h.getElectricObject());
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            this.numSet = 0;
            for (ElectricObject eobj : this.highlighted) {
                if (eobj instanceof PortInst) {
                    PortInst pi = (PortInst)eobj;
                    Iterator<Connection> cIt = pi.getConnections();
                    while (cIt.hasNext()) {
                        Connection con;
                        con.setNegated(!(con = cIt.next()).isNegated());
                    }
                }
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                for (int i = 0; i < 2; ++i) {
                    ai.setNegated(i, !ai.isNegated(i));
                }
            }
            this.fieldVariableChanged("numSet");
            if (this.numSet == 0) {
                System.out.println("No ports negated");
            } else {
                System.out.println("Negated " + this.numSet + " ports");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.numSet != 0) {
                EditWindow.repaintAllContents();
            }
        }
    }

    public static class ChangeArcProperties
    extends Job {
        private Cell cell;
        private ChangeArcEnum how;
        private List<ElectricObject> objList;
        private boolean repaintContents;
        private boolean repaintAny;

        public ChangeArcProperties(Cell cell, ChangeArcEnum how, List<Highlight> highlighted) {
            super("Align objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.how = how;
            this.objList = new ArrayList<ElectricObject>();
            for (Highlight h : highlighted) {
                if (!h.isHighlightEOBJ()) continue;
                this.objList.add(h.getElectricObject());
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            int numSet = 0;
            int numUnset = 0;
            for (ElectricObject eobj : this.objList) {
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                switch (this.how) {
                    case RIGID: {
                        if (ai.isRigid()) break;
                        ai.setRigid(true);
                        ++numSet;
                        break;
                    }
                    case NONRIGID: {
                        if (!ai.isRigid()) break;
                        ai.setRigid(false);
                        ++numSet;
                        break;
                    }
                    case FIXEDANGLE: {
                        if (ai.isFixedAngle()) break;
                        ai.setFixedAngle(true);
                        ++numSet;
                        break;
                    }
                    case NONFIXEDANGLE: {
                        if (!ai.isFixedAngle()) break;
                        ai.setFixedAngle(false);
                        ++numSet;
                        break;
                    }
                    case DIRECTIONAL: {
                        if (ai.isHeadArrowed()) {
                            ai.setHeadArrowed(false);
                            ai.setBodyArrowed(false);
                            ++numUnset;
                            break;
                        }
                        ai.setHeadArrowed(true);
                        ai.setBodyArrowed(true);
                        ++numSet;
                        break;
                    }
                    case HEADEXTEND: {
                        if (ai.isHeadExtended()) {
                            ai.setHeadExtended(false);
                            ++numUnset;
                            break;
                        }
                        ai.setHeadExtended(true);
                        ++numSet;
                        break;
                    }
                    case TAILEXTEND: {
                        if (ai.isTailExtended()) {
                            ai.setTailExtended(false);
                            ++numUnset;
                            break;
                        }
                        ai.setTailExtended(true);
                        ++numSet;
                    }
                }
            }
            this.repaintAny = false;
            if (numSet == 0 && numUnset == 0) {
                System.out.println("No changes were made");
            } else {
                String action = "";
                this.repaintAny = true;
                this.repaintContents = false;
                action = this.how.toString();
                switch (this.how) {
                    case DIRECTIONAL: 
                    case HEADEXTEND: 
                    case TAILEXTEND: {
                        this.repaintContents = true;
                    }
                }
                if (numUnset == 0) {
                    System.out.println("Made " + numSet + " arcs " + action);
                } else if (numSet == 0) {
                    System.out.println("Made " + numUnset + " arcs not " + action);
                } else {
                    System.out.println("Made " + numSet + " arcs " + action + "; and " + numUnset + " arcs not " + action);
                }
            }
            this.fieldVariableChanged("repaintAny");
            this.fieldVariableChanged("repaintContents");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.repaintAny) {
                if (this.repaintContents) {
                    EditWindow.repaintAllContents();
                } else {
                    EditWindow.repaintAll();
                }
            }
        }
    }

    public static enum ChangeArcEnum {
        RIGID("Rigid"),
        NONRIGID("Non-Rigid"),
        FIXEDANGLE("Fixed-Angle"),
        NONFIXEDANGLE("Not-Fixed-Angle"),
        DIRECTIONAL("Directional"),
        HEADEXTEND("extend the head end"),
        TAILEXTEND("extend the tail end");

        private String name;

        private ChangeArcEnum(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AlignNodes
    extends Job {
        private NodeInst[] nis;
        private double[] dCX;
        private double[] dCY;

        public AlignNodes(NodeInst[] nis, double[] dCX, double[] dCY) {
            super("Align objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nis = nis;
            this.dCX = dCX;
            this.dCY = dCY;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int numRemoved = 0;
            for (int i = 0; i < this.nis.length; ++i) {
                NodeInst ni = this.nis[i];
                int res = CircuitChangeJobs.cantEdit(ni.getParent(), ni, true, false, true);
                if (res < 0) {
                    return false;
                }
                if (res <= 0) continue;
                ++numRemoved;
                this.nis[i] = null;
            }
            if (numRemoved > 0) {
                int newSize = this.nis.length - numRemoved;
                if (newSize == 0) {
                    return true;
                }
                NodeInst[] nnis = new NodeInst[newSize];
                double[] nCX = new double[newSize];
                double[] nCY = new double[newSize];
                int fill2 = 0;
                for (int i = 0; i < this.nis.length; ++i) {
                    if (this.nis[i] == null) continue;
                    nnis[fill2] = this.nis[i];
                    nCX[fill2] = this.dCX[i];
                    nCY[fill2] = this.dCY[i];
                    ++fill2;
                }
                this.nis = nnis;
                this.dCX = nCX;
                this.dCY = nCY;
            }
            NodeInst.modifyInstances(this.nis, this.dCX, this.dCY, null, null);
            return true;
        }
    }

    public static class AlignObjects
    extends Job {
        private List<Geometric> list;
        private EDimension alignment;

        public AlignObjects(List<Geometric> highs, EDimension alignment) {
            super("Align Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = highs;
            this.alignment = alignment;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            int adjustedNodes = 0;
            for (Geometric geom : this.list) {
                Connection con;
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                EPoint[] points = ni.getTrace();
                if (points != null) {
                    FixpTransform transOut = ni.pureRotateOut();
                    Point2D[] newPoints = new Point2D[points.length];
                    boolean changed = false;
                    for (int i = 0; i < points.length; ++i) {
                        if (points[i] == null) continue;
                        Point2D.Double newPoint = new Point2D.Double(((Point2D)points[i]).getX() + ni.getAnchorCenterX(), ((Point2D)points[i]).getY() + ni.getAnchorCenterY());
                        transOut.transform(newPoint, newPoint);
                        double oldX = ((Point2D)newPoint).getX();
                        double oldY = ((Point2D)newPoint).getY();
                        DBMath.gridAlign(newPoint, this.alignment);
                        if (oldX != ((Point2D)newPoint).getX() || oldY != ((Point2D)newPoint).getY()) {
                            changed = true;
                        }
                        newPoints[i] = newPoint;
                    }
                    if (!changed) continue;
                    ++adjustedNodes;
                    ni.setTrace(newPoints);
                    continue;
                }
                Point2D.Double center = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                DBMath.gridAlign(center, this.alignment);
                double bodyXOffset = ((Point2D)center).getX() - ni.getAnchorCenterX();
                double bodyYOffset = ((Point2D)center).getY() - ni.getAnchorCenterY();
                double portXOffset = bodyXOffset;
                double portYOffset = bodyYOffset;
                boolean mixedportpos = false;
                boolean firstPort = true;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    Poly poly = pi.getPoly();
                    Point2D.Double portCenter = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    DBMath.gridAlign(portCenter, this.alignment);
                    double pXO = ((Point2D)portCenter).getX() - poly.getCenterX();
                    double pYO = ((Point2D)portCenter).getY() - poly.getCenterY();
                    if (firstPort) {
                        firstPort = false;
                        portXOffset = pXO;
                        portYOffset = pYO;
                        continue;
                    }
                    if (portXOffset == pXO && portYOffset == pYO) continue;
                    mixedportpos = true;
                }
                if (!mixedportpos) {
                    bodyXOffset = portXOffset;
                    bodyYOffset = portYOffset;
                }
                if (!(bodyXOffset == 0.0 && bodyYOffset == 0.0 || ni.isCellInstance())) {
                    FixpTransform transr = ni.rotateOut();
                    Technology tech = ni.getProto().getTechnology();
                    Poly[] polyList = tech.getShapeOfNode(ni);
                    for (int j = 0; j < polyList.length; ++j) {
                        Poly poly = polyList[j];
                        poly.transform(transr);
                        FixpRectangle bounds = poly.getBox();
                        if (bounds == null) continue;
                        Point2D.Double polyPoint1 = new Point2D.Double(((RectangularShape)bounds).getMinX(), ((RectangularShape)bounds).getMinY());
                        Point2D.Double polyPoint2 = new Point2D.Double(((RectangularShape)bounds).getMaxX(), ((RectangularShape)bounds).getMaxY());
                        DBMath.gridAlign(polyPoint1, this.alignment);
                        DBMath.gridAlign(polyPoint2, this.alignment);
                        if (((Point2D)polyPoint1).getX() == ((RectangularShape)bounds).getMinX() && ((Point2D)polyPoint2).getX() == ((RectangularShape)bounds).getMaxX()) {
                            bodyXOffset = 0.0;
                        }
                        if (((Point2D)polyPoint1).getY() == ((RectangularShape)bounds).getMinY() && ((Point2D)polyPoint2).getY() == ((RectangularShape)bounds).getMaxY()) {
                            bodyYOffset = 0.0;
                        }
                        if (bodyXOffset == 0.0 && bodyYOffset == 0.0) break;
                    }
                }
                if (bodyXOffset == 0.0 && bodyYOffset == 0.0) continue;
                HashMap<ArcInst, Integer> constraints = new HashMap<ArcInst, Integer>();
                Iterator<Connection> aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = aIt.next();
                    ArcInst ai = con.getArc();
                    int constr = 0;
                    if (ai.isRigid()) {
                        constr |= 1;
                    }
                    if (ai.isFixedAngle()) {
                        constr |= 2;
                    }
                    constraints.put(ai, new Integer(constr));
                }
                ni.move(bodyXOffset, bodyYOffset);
                ++adjustedNodes;
                aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = aIt.next();
                    ArcInst ai = con.getArc();
                    Integer constr = (Integer)constraints.get(ai);
                    if (constr == null) continue;
                    if ((constr & 1) != 0) {
                        ai.setRigid(true);
                    }
                    if ((constr & 2) == 0) continue;
                    ai.setFixedAngle(true);
                }
            }
            int adjustedArcs = 0;
            for (Geometric geom : this.list) {
                int ang;
                int ang2;
                ArcInst ai;
                if (!(geom instanceof ArcInst) || !(ai = (ArcInst)geom).isLinked()) continue;
                EPoint origHead = ai.getHeadLocation();
                EPoint origTail = ai.getTailLocation();
                Point2D.Double arcHead = new Point2D.Double(((Point2D)origHead).getX(), ((Point2D)origHead).getY());
                Point2D.Double arcTail = new Point2D.Double(((Point2D)origTail).getX(), ((Point2D)origTail).getY());
                DBMath.gridAlign(arcHead, this.alignment);
                DBMath.gridAlign(arcTail, this.alignment);
                if (((Point2D)arcHead).getX() == ((Point2D)arcTail).getX() && ((Point2D)arcHead).getY() == ((Point2D)arcTail).getY() && (ang2 = ai.getDefinedAngle()) != 0 && ang2 != 900 && ang2 != 1800 && ang2 != 2700) {
                    ai.setAngle(0);
                    ++adjustedArcs;
                }
                double headXOff = ((Point2D)arcHead).getX() - ((Point2D)origHead).getX();
                double headYOff = ((Point2D)arcHead).getY() - ((Point2D)origHead).getY();
                double tailXOff = ((Point2D)arcTail).getX() - ((Point2D)origTail).getX();
                double tailYOff = ((Point2D)arcTail).getY() - ((Point2D)origTail).getY();
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                if (!ai.headStillInPort(arcHead, false)) {
                    if (!ai.headStillInPort(origHead, false)) continue;
                    headYOff = 0.0;
                    headXOff = 0.0;
                }
                if (!ai.tailStillInPort(arcTail, false)) {
                    if (!ai.tailStillInPort(origTail, false)) continue;
                    tailYOff = 0.0;
                    tailXOff = 0.0;
                }
                if ((ang = ai.getDefinedAngle()) == 0 || ang == 1800) {
                    if (headYOff != tailYOff) {
                        tailYOff = 0.0;
                        headYOff = 0.0;
                    }
                } else if ((ang == 900 || ang == 2700) && headXOff != tailXOff) {
                    tailXOff = 0.0;
                    headXOff = 0.0;
                }
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                int constr = 0;
                if (ai.isRigid()) {
                    constr |= 1;
                }
                if (ai.isFixedAngle()) {
                    constr |= 2;
                }
                ai.setRigid(false);
                ai.setFixedAngle(false);
                ai.modify(headXOff, headYOff, tailXOff, tailYOff);
                ++adjustedArcs;
                if ((constr & 1) != 0) {
                    ai.setRigid(true);
                }
                if ((constr & 2) == 0) continue;
                ai.setFixedAngle(true);
            }
            if (adjustedNodes == 0 && adjustedArcs == 0) {
                System.out.println("No adjustments necessary");
            } else {
                System.out.println("Adjusted " + adjustedNodes + " nodes and " + adjustedArcs + " arcs");
            }
            return true;
        }
    }

    public static class RotateText
    extends Job {
        private Cell cell;
        private int amount;
        private boolean mirror;
        private boolean mirrorH;
        private List<ElectricObject> objs;
        private List<Variable.Key> keys;

        public RotateText(Cell cell, List<ElectricObject> objs, List<Variable.Key> keys, int amount, boolean mirror, boolean mirrorH) {
            super("Rotate selected text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.objs = objs;
            this.keys = keys;
            this.amount = amount;
            this.mirror = mirror;
            this.mirrorH = mirrorH;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            for (int i = 0; i < this.objs.size(); ++i) {
                ElectricObject obj = this.objs.get(i);
                Variable.Key key = this.keys.get(i);
                TextDescriptor td = obj.getTextDescriptor(key);
                AbstractTextDescriptor.Rotation oldR = td.getRotation();
                if (this.amount != 0) {
                    oldR = oldR == AbstractTextDescriptor.Rotation.ROT0 ? AbstractTextDescriptor.Rotation.ROT90 : (oldR == AbstractTextDescriptor.Rotation.ROT90 ? AbstractTextDescriptor.Rotation.ROT180 : (oldR == AbstractTextDescriptor.Rotation.ROT180 ? AbstractTextDescriptor.Rotation.ROT270 : AbstractTextDescriptor.Rotation.ROT0));
                }
                td = td.withRotation(oldR);
                Poly.Type oldType = td.getPos().getPolyType();
                if (this.mirror && !this.mirrorH) {
                    td = td.withPos(AbstractTextDescriptor.Position.getPosition(oldType.cycleTextAnchorHoriz()));
                } else if (this.mirror && this.mirrorH) {
                    td = td.withPos(AbstractTextDescriptor.Position.getPosition(oldType.cycleTextAnchorVert()));
                }
                obj.setTextDescriptor(key, td);
            }
            return true;
        }
    }

    public static class RotateSelected
    extends Job {
        private Cell cell;
        private int amount;
        private boolean mirror;
        private boolean mirrorH;
        private List<Geometric> highs;

        public RotateSelected(Cell cell, List<Geometric> highs, int amount, boolean mirror, boolean mirrorH) {
            super("Rotate selected objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.amount = amount;
            this.mirror = mirror;
            this.mirrorH = mirrorH;
            this.highs = highs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            NodeInst ni;
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, false, true) != 0) {
                return false;
            }
            if (this.highs.size() > 1) {
                for (Geometric geom : this.highs) {
                    if (!(geom instanceof NodeInst) || !Generic.isCellCenter((NodeInst)geom)) continue;
                    this.highs.remove(geom);
                    break;
                }
            }
            HashSet<Geometric> markObj = new HashSet<Geometric>();
            int nicount = 0;
            NodeInst theNi = null;
            Rectangle2D.Double selectedBounds = new Rectangle2D.Double();
            Iterator<ArcInst> it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                PortInst tail = ai.getTailPortInst();
                PortInst head2 = ai.getHeadPortInst();
                if (!this.highs.contains(head2) || !this.highs.contains(tail)) continue;
                this.highs.add(ai);
            }
            for (Geometric geom : this.highs) {
                if (!(geom instanceof NodeInst) || Generic.isCellCenter(ni = (NodeInst)geom)) continue;
                if (CircuitChangeJobs.cantEdit(this.cell, ni, true, false, true) != 0) {
                    return false;
                }
                markObj.add(ni);
                if (nicount == 0) {
                    ((Rectangle2D)selectedBounds).setRect(ni.getBounds());
                } else {
                    Rectangle2D.union(selectedBounds, ni.getBounds(), selectedBounds);
                }
                theNi = ni;
                ++nicount;
            }
            if (nicount <= 0) {
                System.out.println("Must select at least 1 node for rotation");
                return false;
            }
            if (nicount > 1) {
                Point2D.Double center = new Point2D.Double(selectedBounds.getCenterX(), selectedBounds.getCenterY());
                theNi = null;
                double bestdist = 2.147483647E9;
                Iterator<NodeInst> it2 = this.cell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni2 = it2.next();
                    if (!markObj.contains(ni2)) continue;
                    double dist = center.distance(ni2.getTrueCenter());
                    if (theNi != null && !(dist < bestdist)) continue;
                    theNi = ni2;
                    bestdist = dist;
                }
            }
            markObj.clear();
            for (Geometric geom : this.highs) {
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                markObj.add(ai);
            }
            CircuitChangeJobs.spreadRotateConnection(theNi, markObj);
            for (Geometric geom : this.highs) {
                if (!(geom instanceof NodeInst)) continue;
                ni = (NodeInst)geom;
                CircuitChangeJobs.spreadRotateConnection(ni, markObj);
            }
            Orientation dOrient = this.mirror ? (this.mirrorH ? Orientation.Y : Orientation.X) : Orientation.fromAngle(this.amount);
            FixpTransform trans = dOrient.rotateAbout(theNi.getAnchorCenter());
            Point2D.Double tmpPt1 = new Point2D.Double();
            Point2D.Double tmpPt2 = new Point2D.Double();
            for (Geometric geom : markObj) {
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni3 = (NodeInst)geom;
                boolean wasMirroredInX = ni3.isMirroredAboutXAxis();
                boolean wasMirroredInY = ni3.isMirroredAboutYAxis();
                trans.transform(ni3.getAnchorCenter(), tmpPt1);
                ni3.rotate(dOrient);
                ni3.move(tmpPt1.getX() - ni3.getAnchorCenterX(), tmpPt1.getY() - ni3.getAnchorCenterY());
                CircuitChangeJobs.rotateNodeText(ni3, dOrient, wasMirroredInX, wasMirroredInY);
            }
            for (Geometric geom : markObj) {
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                if (markObj.contains(ai.getHeadPortInst().getNodeInst())) {
                    trans.transform(ai.getHeadLocation(), tmpPt1);
                } else {
                    tmpPt1.setLocation(ai.getHeadLocation());
                }
                if (markObj.contains(ai.getTailPortInst().getNodeInst())) {
                    trans.transform(ai.getTailLocation(), tmpPt2);
                } else {
                    tmpPt2.setLocation(ai.getTailLocation());
                }
                ai.modify(tmpPt1.getX() - ai.getHeadLocation().getX(), tmpPt1.getY() - ai.getHeadLocation().getY(), tmpPt2.getX() - ai.getTailLocation().getX(), tmpPt2.getY() - ai.getTailLocation().getY());
                CircuitChangeJobs.rotateArcText(ai, dOrient, this.mirror);
            }
            return true;
        }
    }
}

