/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpointProcessor
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpointProcessor.class);
    private final InterceptSendToEndpoint endpoint;
    private final Endpoint delegate;
    private final AsyncProducer producer;
    private final boolean skip;
    private final Predicate onWhen;
    private AsyncProcessor pipeline;
    private AsyncProcessor after;

    public InterceptSendToEndpointProcessor(InterceptSendToEndpoint endpoint, Endpoint delegate, AsyncProducer producer, boolean skip, Predicate onWhen) {
        super(delegate);
        this.endpoint = endpoint;
        this.delegate = delegate;
        this.producer = producer;
        this.skip = skip;
        this.onWhen = onWhen != null ? onWhen : p -> true;
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), this.endpoint.getBefore(), exchange});
        }
        exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ENDPOINT, (Object)this.delegate.getEndpointUri());
        return this.pipeline.process(exchange, doneSync -> this.callback(exchange, callback, doneSync));
    }

    private boolean callback(Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + String.valueOf(this.getEndpoint()), LOG)) {
            callback.done(doneSync);
            return doneSync;
        }
        boolean shouldSkip = this.skip;
        Boolean whenMatches = (Boolean)exchange.getProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
        if (whenMatches != null) {
            boolean bl = shouldSkip = this.skip && whenMatches != false;
        }
        if (!shouldSkip) {
            ExchangeHelper.prepareOutToIn((Exchange)exchange);
            AsyncCallback ac1 = doneSync1 -> {
                exchange.removeProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
                callback.done(doneSync1);
            };
            AsyncCallback ac2 = null;
            if (this.after != null && (whenMatches == null || whenMatches.booleanValue())) {
                ac2 = doneSync2 -> this.after.process(exchange, ac1);
            }
            boolean s = this.producer.process(exchange, ac2 != null ? ac2 : ac1);
            return doneSync && s;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange);
        }
        callback.done(doneSync);
        return doneSync;
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    protected void doBuild() throws Exception {
        CamelContextAware.trySetCamelContext((Object)this.producer, (CamelContext)this.endpoint.getCamelContext());
        this.pipeline = new FilterProcessor(this.getEndpoint().getCamelContext(), this.onWhen, this.endpoint.getBefore());
        if (this.endpoint.getAfter() != null) {
            this.after = AsyncProcessorConverterHelper.convert((Processor)this.endpoint.getAfter());
        }
        ServiceHelper.buildService((Object[])new Object[]{this.producer, this.pipeline, this.after});
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])new Object[]{this.producer, this.pipeline, this.after});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.producer, this.pipeline, this.after});
    }

    public void doStop() {
        ServiceHelper.stopService((Service)this.producer);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producer, this.pipeline});
    }
}

