/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.Console;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.tools.CommandShell;
import org.apache.hadoop.util.ToolRunner;

public class CredentialShell
extends CommandShell {
    private static final String USAGE_PREFIX = "Usage: hadoop credential [generic options]\n";
    private static final String COMMANDS = "   [-help]\n   [create <alias> [-value alias-value] [-provider provider-path] [-strict]]\n   [delete <alias> [-f] [-provider provider-path] [-strict]]\n   [list [-provider provider-path] [-strict]]\n   [check <alias> [-value alias-value] [-provider provider-path] [-strict]]\n";
    @VisibleForTesting
    public static final String NO_VALID_PROVIDERS = "There are no valid (non-transient) providers configured.\nNo action has been taken. Use the -provider option to specify\na provider. If you want to use a transient provider then you\nMUST use the -provider argument.";
    private boolean interactive = true;
    private boolean strict = false;
    private boolean userSuppliedProvider = false;
    private String value = null;
    private PasswordReader passwordReader;

    @Override
    protected int init(String[] args) throws IOException {
        if (0 == args.length) {
            ToolRunner.printGenericCommandUsage(this.getErr());
            return 1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("create")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.setSubCommand(new CreateCommand(args[++i]));
                continue;
            }
            if (args[i].equals("check")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.setSubCommand(new CheckCommand(args[++i]));
                continue;
            }
            if (args[i].equals("delete")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.setSubCommand(new DeleteCommand(args[++i]));
                continue;
            }
            if (args[i].equals("list")) {
                this.setSubCommand(new ListCommand());
                continue;
            }
            if (args[i].equals("-provider")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.userSuppliedProvider = true;
                this.getConf().set("hadoop.security.credential.provider.path", args[++i]);
                continue;
            }
            if (args[i].equals("-f") || args[i].equals("-force")) {
                this.interactive = false;
                continue;
            }
            if (args[i].equals("-strict")) {
                this.strict = true;
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("-value")) {
                this.value = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                this.printShellUsage();
                return 0;
            }
            ToolRunner.printGenericCommandUsage(this.getErr());
            return 1;
        }
        return 0;
    }

    @Override
    public String getCommandUsage() {
        StringBuffer sbuf = new StringBuffer("Usage: hadoop credential [generic options]\n   [-help]\n   [create <alias> [-value alias-value] [-provider provider-path] [-strict]]\n   [delete <alias> [-f] [-provider provider-path] [-strict]]\n   [list [-provider provider-path] [-strict]]\n   [check <alias> [-value alias-value] [-provider provider-path] [-strict]]\n");
        String banner = StringUtils.repeat("=", 66);
        sbuf.append(banner + "\n").append("create <alias> [-value alias-value] [-provider provider-path] [-strict]:\n\nThe create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.\n").append(banner + "\n").append("delete <alias> [-f] [-provider provider-path] [-strict]:\n\nThe delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.\n").append(banner + "\n").append("list [-provider provider-path] [-strict]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.\n");
        return sbuf.toString();
    }

    protected char[] promptForCredential() throws IOException {
        boolean noMatch;
        PasswordReader c = this.getPasswordReader();
        if (c == null) {
            throw new IOException("No console available for prompting user.");
        }
        char[] cred = null;
        do {
            char[] newPassword2;
            char[] newPassword1;
            boolean bl = noMatch = !Arrays.equals(newPassword1 = c.readPassword("Enter alias password: "), newPassword2 = c.readPassword("Enter alias password again: "));
            if (noMatch) {
                if (newPassword1 != null) {
                    Arrays.fill(newPassword1, ' ');
                }
                c.format("Passwords don't match. Try again.%n");
            } else {
                cred = newPassword1;
            }
            if (newPassword2 == null) continue;
            Arrays.fill(newPassword2, ' ');
        } while (noMatch);
        return cred;
    }

    public PasswordReader getPasswordReader() {
        if (this.passwordReader == null) {
            this.passwordReader = new PasswordReader();
        }
        return this.passwordReader;
    }

    public void setPasswordReader(PasswordReader reader) {
        this.passwordReader = reader;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new Configuration(), new CredentialShell(), args);
        System.exit(res);
    }

    public static class PasswordReader {
        public char[] readPassword(String prompt) {
            Console console = System.console();
            char[] pass = console.readPassword(prompt, new Object[0]);
            return pass;
        }

        public void format(String message) {
            Console console = System.console();
            console.format(message, new Object[0]);
        }
    }

    private class CreateCommand
    extends Command {
        public static final String USAGE = "create <alias> [-value alias-value] [-provider provider-path] [-strict]";
        public static final String DESC = "The create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        private String alias;

        public CreateCommand(String alias) {
            this.alias = null;
            this.alias = alias;
        }

        @Override
        public boolean validate() {
            if (this.alias == null) {
                CredentialShell.this.getOut().println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                return false;
            }
            if (this.alias.equals("-help")) {
                return true;
            }
            try {
                this.provider = this.getCredentialProvider();
                if (this.provider == null) {
                    return false;
                }
                if (this.provider.needsPassword()) {
                    if (CredentialShell.this.strict) {
                        CredentialShell.this.getOut().println(this.provider.noPasswordError());
                        return false;
                    }
                    CredentialShell.this.getOut().println(this.provider.noPasswordWarning());
                }
            }
            catch (IOException e) {
                e.printStackTrace(CredentialShell.this.getErr());
            }
            return true;
        }

        @Override
        public void execute() throws IOException, NoSuchAlgorithmException {
            if (this.alias.equals("-help")) {
                this.doHelp();
                return;
            }
            this.warnIfTransientProvider();
            try {
                char[] credential = null;
                credential = CredentialShell.this.value != null ? CredentialShell.this.value.toCharArray() : CredentialShell.this.promptForCredential();
                this.provider.createCredentialEntry(this.alias, credential);
                this.provider.flush();
                CredentialShell.this.getOut().println(this.alias + " has been successfully created.");
                this.printProviderWritten();
            }
            catch (InvalidParameterException e) {
                CredentialShell.this.getOut().println("Credential " + this.alias + " has NOT been created. " + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                CredentialShell.this.getOut().println("Credential " + this.alias + " has NOT been created. " + e.getMessage());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "create <alias> [-value alias-value] [-provider provider-path] [-strict]:\n\nThe create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        }
    }

    private class CheckCommand
    extends Command {
        public static final String USAGE = "check <alias> [-value alias-value] [-provider provider-path] [-strict]";
        public static final String DESC = "The check subcommand check a password for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        private String alias;

        CheckCommand(String alias) {
            this.alias = null;
            this.alias = alias;
        }

        @Override
        public boolean validate() {
            if (this.alias == null) {
                CredentialShell.this.getOut().println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                return false;
            }
            if (this.alias.equals("-help")) {
                return true;
            }
            try {
                this.provider = this.getCredentialProvider();
                if (this.provider == null) {
                    return false;
                }
                if (this.provider.needsPassword()) {
                    if (CredentialShell.this.strict) {
                        CredentialShell.this.getOut().println(this.provider.noPasswordError());
                        return false;
                    }
                    CredentialShell.this.getOut().println(this.provider.noPasswordWarning());
                }
            }
            catch (IOException e) {
                e.printStackTrace(CredentialShell.this.getErr());
            }
            return true;
        }

        @Override
        public void execute() throws IOException, NoSuchAlgorithmException {
            if (this.alias.equals("-help")) {
                this.doHelp();
                return;
            }
            this.warnIfTransientProvider();
            CredentialShell.this.getOut().println("Checking aliases for CredentialProvider: " + this.provider.toString());
            try {
                PasswordReader c = CredentialShell.this.getPasswordReader();
                if (c == null) {
                    throw new IOException("No console available for checking user.");
                }
                char[] password = null;
                password = CredentialShell.this.value != null ? CredentialShell.this.value.toCharArray() : c.readPassword("Enter alias password: ");
                char[] storePassword = this.provider.getCredentialEntry(this.alias).getCredential();
                String beMatch = Arrays.equals(storePassword, password) ? "success" : "failed";
                CredentialShell.this.getOut().println("Password match " + beMatch + " for " + this.alias + ".");
            }
            catch (IOException e) {
                CredentialShell.this.getOut().println("Cannot check aliases for CredentialProvider: " + this.provider.toString() + ": " + e.getMessage());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "check <alias> [-value alias-value] [-provider provider-path] [-strict]:\n\nThe check subcommand check a password for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        }
    }

    private class DeleteCommand
    extends Command {
        public static final String USAGE = "delete <alias> [-f] [-provider provider-path] [-strict]";
        public static final String DESC = "The delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.";
        private String alias;
        private boolean cont;

        public DeleteCommand(String alias) {
            this.alias = null;
            this.cont = true;
            this.alias = alias;
        }

        @Override
        public boolean validate() {
            if (this.alias == null) {
                CredentialShell.this.getOut().println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                return false;
            }
            if (this.alias.equals("-help")) {
                return true;
            }
            this.provider = this.getCredentialProvider();
            if (this.provider == null) {
                return false;
            }
            if (CredentialShell.this.interactive) {
                try {
                    this.cont = ToolRunner.confirmPrompt("You are about to DELETE the credential " + this.alias + " from CredentialProvider " + this.provider.toString() + ". Continue? ");
                    if (!this.cont) {
                        CredentialShell.this.getOut().println("Nothing has been deleted.");
                    }
                    return this.cont;
                }
                catch (IOException e) {
                    CredentialShell.this.getOut().println(this.alias + " will not be deleted.");
                    e.printStackTrace(CredentialShell.this.getErr());
                }
            }
            return true;
        }

        @Override
        public void execute() throws IOException {
            if (this.alias.equals("-help")) {
                this.doHelp();
                return;
            }
            this.warnIfTransientProvider();
            CredentialShell.this.getOut().println("Deleting credential: " + this.alias + " from CredentialProvider: " + this.provider.toString());
            if (this.cont) {
                try {
                    this.provider.deleteCredentialEntry(this.alias);
                    CredentialShell.this.getOut().println("Credential " + this.alias + " has been successfully deleted.");
                    this.provider.flush();
                    this.printProviderWritten();
                }
                catch (IOException e) {
                    CredentialShell.this.getOut().println("Credential " + this.alias + " has NOT been deleted.");
                    throw e;
                }
            }
        }

        @Override
        public String getUsage() {
            return "delete <alias> [-f] [-provider provider-path] [-strict]:\n\nThe delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.";
        }
    }

    private class ListCommand
    extends Command {
        public static final String USAGE = "list [-provider provider-path] [-strict]";
        public static final String DESC = "The list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.";

        private ListCommand() {
        }

        @Override
        public boolean validate() {
            this.provider = this.getCredentialProvider();
            return this.provider != null;
        }

        @Override
        public void execute() throws IOException {
            try {
                List<String> aliases = this.provider.getAliases();
                CredentialShell.this.getOut().println("Listing aliases for CredentialProvider: " + this.provider.toString());
                for (String alias : aliases) {
                    CredentialShell.this.getOut().println(alias);
                }
            }
            catch (IOException e) {
                CredentialShell.this.getOut().println("Cannot list aliases for CredentialProvider: " + this.provider.toString() + ": " + e.getMessage());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "list [-provider provider-path] [-strict]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.";
        }
    }

    private abstract class Command
    extends CommandShell.SubCommand {
        protected CredentialProvider provider = null;

        private Command() {
        }

        protected CredentialProvider getCredentialProvider() {
            CredentialProvider prov;
            block5: {
                prov = null;
                try {
                    List<CredentialProvider> providers = CredentialProviderFactory.getProviders(CredentialShell.this.getConf());
                    if (CredentialShell.this.userSuppliedProvider) {
                        prov = providers.get(0);
                        break block5;
                    }
                    for (CredentialProvider p : providers) {
                        if (p.isTransient()) continue;
                        prov = p;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(CredentialShell.this.getErr());
                }
            }
            if (prov == null) {
                CredentialShell.this.getOut().println(CredentialShell.NO_VALID_PROVIDERS);
            }
            return prov;
        }

        protected void printProviderWritten() {
            CredentialShell.this.getOut().println("Provider " + this.provider.toString() + " was updated.");
        }

        protected void warnIfTransientProvider() {
            if (this.provider.isTransient()) {
                CredentialShell.this.getOut().println("WARNING: you are modifying a transient provider.");
            }
        }

        protected void doHelp() {
            CredentialShell.this.getOut().println("Usage: hadoop credential [generic options]\n   [-help]\n   [create <alias> [-value alias-value] [-provider provider-path] [-strict]]\n   [delete <alias> [-f] [-provider provider-path] [-strict]]\n   [list [-provider provider-path] [-strict]]\n   [check <alias> [-value alias-value] [-provider provider-path] [-strict]]\n");
            CredentialShell.this.printShellUsage();
        }

        @Override
        public abstract void execute() throws Exception;

        @Override
        public abstract String getUsage();
    }
}

